/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.mercury.server.mapper;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.gateway.route.RouteDefinition;
import org.springframework.cloud.gateway.route.RouteDefinitionRepository;
import org.springframework.cloud.gateway.support.NotFoundException;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Component
public class RedisRouteDefinitionRepository
implements RouteDefinitionRepository {
    public static final String GATEWAY_ROUTES = "gateway:routes";
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    public Flux<RouteDefinition> getRouteDefinitions() {
        ArrayList routeDefinitions = new ArrayList();
        this.redisTemplate.opsForHash().values((Object)GATEWAY_ROUTES).stream().forEach(routeDefinition -> routeDefinitions.add(JSON.parseObject((String)routeDefinition.toString(), RouteDefinition.class)));
        return Flux.fromIterable(routeDefinitions);
    }

    public Mono<Void> save(Mono<RouteDefinition> route) {
        return route.flatMap(routeDefinition -> {
            this.redisTemplate.opsForHash().put((Object)GATEWAY_ROUTES, (Object)routeDefinition.getId(), (Object)JSON.toJSONString((Object)routeDefinition));
            return Mono.empty();
        });
    }

    public Mono<Void> delete(Mono<String> routeId) {
        return routeId.flatMap(id -> {
            if (this.redisTemplate.opsForHash().hasKey((Object)GATEWAY_ROUTES, id).booleanValue()) {
                this.redisTemplate.opsForHash().delete((Object)GATEWAY_ROUTES, new Object[]{id});
                return Mono.empty();
            }
            return Mono.defer(() -> Mono.error((Throwable)new NotFoundException("\u8def\u7531\u6587\u4ef6\u6ca1\u6709\u627e\u5230: " + routeId)));
        });
    }
}

