/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.mercury.server.service.impl;

import com.ebaiyihui.mercury.server.common.ApplicationInfoMap;
import com.ebaiyihui.mercury.server.common.MercuryConstant;
import com.ebaiyihui.mercury.server.handler.CustomerRouteHandler;
import com.ebaiyihui.mercury.server.mapper.ApplicationInfoMapper;
import com.ebaiyihui.mercury.server.model.ApplicationInfoEntity;
import com.ebaiyihui.mercury.server.model.PageResult;
import com.ebaiyihui.mercury.server.service.ApplicationInfoService;
import com.ebaiyihui.mercury.server.vo.BaseReqVo;
import com.ebaiyihui.mercury.server.vo.LoginReqVo;
import com.ebaiyihui.mercury.server.vo.LoginResVo;
import com.ebaiyihui.mercury.server.vo.SaveAppInfoRequestVo;
import com.ebaiyihui.mercury.server.vo.SearchAppInfoParamVo;
import com.ebaiyihui.mercury.server.vo.UpdateAppInfoRequestVo;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ApplicationInfoServiceImpl
implements ApplicationInfoService {
    private static final Logger log = LoggerFactory.getLogger(ApplicationInfoServiceImpl.class);
    @Autowired
    private ApplicationInfoMapper applicationInfoMapper;
    @Autowired
    private ApplicationInfoMap applicationInfoMap;
    @Autowired
    private CustomerRouteHandler customerRouteHandler;
    @Autowired
    private RedisTemplate redisTemplate;

    public List<ApplicationInfoEntity> getAllApplicationServerInfoEntityList() {
        return this.applicationInfoMapper.selectAllApplicationServerInfoList();
    }

    public PageResult<List<ApplicationInfoEntity>> getPageApplicationServerInfoList(SearchAppInfoParamVo searchAppInfoParamVo) {
        PageResult pageResult = new PageResult();
        PageHelper.startPage((int)searchAppInfoParamVo.getPageNum(), (int)searchAppInfoParamVo.getPageSize());
        Page page = this.applicationInfoMapper.selectPageApplicationServerInfoList(searchAppInfoParamVo);
        pageResult.setPageData((Object)page.getResult());
        pageResult.setTotal(page.getTotal());
        return pageResult;
    }

    public void save(SaveAppInfoRequestVo saveAppInfoRequestVo) {
        ApplicationInfoEntity applicationServerInfoEntity = new ApplicationInfoEntity();
        applicationServerInfoEntity.setStatus(MercuryConstant.NORMAL_STATUS);
        applicationServerInfoEntity.setViewId(String.valueOf(System.currentTimeMillis()));
        BeanUtils.copyProperties((Object)saveAppInfoRequestVo, (Object)applicationServerInfoEntity);
        this.applicationInfoMapper.insertSelective(applicationServerInfoEntity);
        this.customerRouteHandler.saveRoute(applicationServerInfoEntity);
        this.refreshApplicationMap();
    }

    public void delete(Long id) {
        ApplicationInfoEntity applicationInfoEntity = this.applicationInfoMapper.selectByPrimaryKey(id);
        this.applicationInfoMapper.deleteById(id);
        List applicationInfoEntityList = this.applicationInfoMap.get(applicationInfoEntity.getAppCode());
        if (CollectionUtils.isEmpty((Collection)applicationInfoEntityList)) {
            this.customerRouteHandler.deleteRoute(applicationInfoEntity.getApplicationName() + ":" + applicationInfoEntity.getAppCode());
        }
        this.refreshApplicationMap();
    }

    public void updateById(UpdateAppInfoRequestVo updateAppInfoRequestVo) {
        ApplicationInfoEntity applicationServerInfoEntity = new ApplicationInfoEntity();
        applicationServerInfoEntity.setUpdateTime(new Date());
        BeanUtils.copyProperties((Object)updateAppInfoRequestVo, (Object)applicationServerInfoEntity);
        this.applicationInfoMapper.updateByPrimaryKeySelective(applicationServerInfoEntity);
        this.refresh();
    }

    public ApplicationInfoEntity getById(Long id) {
        return this.applicationInfoMapper.selectByPrimaryKey(id);
    }

    public List<String> getAllAppCode() {
        return this.applicationInfoMapper.getAllAppCode();
    }

    public void updateStatusById(Long id, Integer status) {
        this.applicationInfoMapper.updateStatusById(id, status);
        this.refresh();
    }

    public LoginResVo login(LoginReqVo loginReqVo) throws Exception {
        if (!Objects.equals("byh", loginReqVo.getUserName()) && Objects.equals("byh12@2019...", loginReqVo.getUserName())) {
            throw new Exception("\u7528\u6237\u540d\u6216\u8005\u5bc6\u7801\u9519\u8bef");
        }
        String token = String.valueOf(System.currentTimeMillis());
        LoginResVo loginResVo = new LoginResVo();
        loginResVo.setToken(token);
        loginResVo.setUserName("byh");
        this.redisTemplate.opsForValue().set((Object)"byh", (Object)token, 4L, TimeUnit.HOURS);
        return loginResVo;
    }

    public void upOrDownService(BaseReqVo baseReqVo) {
        ApplicationInfoEntity applicationInfoEntity = this.getById(baseReqVo.getId());
        if (applicationInfoEntity.getStatus().intValue() == MercuryConstant.NORMAL_STATUS.intValue()) {
            this.applicationInfoMapper.updateStatusById(baseReqVo.getId(), MercuryConstant.DOWN_STATUS);
        } else {
            this.applicationInfoMapper.updateStatusById(baseReqVo.getId(), MercuryConstant.NORMAL_STATUS);
        }
        this.refresh();
    }

    public void checkHealth() {
        this.applicationInfoMapper.getAllAppCode();
    }

    public void initAppServerMap() {
        log.info("start to init app server list map");
        List applicationServerInfoEntityList = this.applicationInfoMapper.selectAllApplicationServerInfoList();
        log.info("app server list: " + applicationServerInfoEntityList.toString());
        if (CollectionUtils.isEmpty((Collection)applicationServerInfoEntityList)) {
            return;
        }
        Map<String, List<ApplicationInfoEntity>> map = applicationServerInfoEntityList.stream().collect(Collectors.groupingBy(ApplicationInfoEntity::getAppCode));
        if (this.applicationInfoMap == null) {
            log.info("applicationInfoMap is null");
            this.applicationInfoMap = new ApplicationInfoMap();
        }
        map.forEach((appCode, applicationServerInfoList) -> this.applicationInfoMap.put(appCode, applicationServerInfoList));
    }

    public void refresh() {
        this.refreshApplicationMap();
        this.customerRouteHandler.loadRouteConfig();
    }

    private void refreshApplicationMap() {
        List applicationServerInfoEntityList = this.applicationInfoMapper.selectAllApplicationServerInfoList();
        if (CollectionUtils.isEmpty((Collection)applicationServerInfoEntityList)) {
            this.applicationInfoMap.clear();
            return;
        }
        Map<String, List<ApplicationInfoEntity>> map = applicationServerInfoEntityList.stream().collect(Collectors.groupingBy(ApplicationInfoEntity::getAppCode));
        map.forEach((appCode, applicationServerInfoList) -> this.applicationInfoMap.put(appCode, applicationServerInfoList));
        this.removeInvalidAppCode(map);
    }

    private void removeInvalidAppCode(Map<String, List<ApplicationInfoEntity>> map) {
        Set<String> invalidAppCodeSet = this.applicationInfoMap.keySet().stream().filter(appCode -> !map.containsKey(appCode)).collect(Collectors.toSet());
        invalidAppCodeSet.forEach(appCode -> this.applicationInfoMap.del(appCode));
        log.info("fetch app code after refreshing ->{}", (Object)this.applicationInfoMap.keySet().toString());
    }
}

