/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.mercury.server.service.impl;

import com.ebaiyihui.mercury.server.dao.SystemParamConfigMapper;
import com.ebaiyihui.mercury.server.service.SystemInfoService;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SystemInfoServiceImpl
implements SystemInfoService {
    private static final Logger log = LoggerFactory.getLogger(SystemInfoServiceImpl.class);
    @Autowired
    private SystemParamConfigMapper systemParamConfigMapper;
    @Autowired
    private RedisTemplate redisTemplate;

    @PostConstruct
    public void initSystemParam() {
        this.updateRateLimiterInfo();
    }

    public void updateRateLimiterInfo() {
        List systemParamConfigEntityList = this.systemParamConfigMapper.selectAll();
        log.info("systemParamConfigEntityList->{}", (Object)systemParamConfigEntityList.toString());
        if (!CollectionUtils.isEmpty((Collection)systemParamConfigEntityList)) {
            systemParamConfigEntityList.stream().forEach(systemParamConfigEntity -> this.redisTemplate.opsForValue().set((Object)systemParamConfigEntity.getParamKey(), (Object)systemParamConfigEntity.getParamValue()));
        }
    }
}

