/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.hisfront.service.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.ebaiyihui.hisfront.common.enums.EntityKeyEnum;
import com.ebaiyihui.hisfront.common.enums.MethodNameEnum;
import com.ebaiyihui.hisfront.pojo.dto.CancelRegisterReqDTO;
import com.ebaiyihui.hisfront.pojo.dto.CancelRegisterResDTO;
import com.ebaiyihui.hisfront.pojo.dto.LockOrderReqDTO;
import com.ebaiyihui.hisfront.pojo.dto.LockOrderResDTO;
import com.ebaiyihui.hisfront.pojo.dto.PayRegistrationReqDTO;
import com.ebaiyihui.hisfront.pojo.dto.PayRegistrationResDTO;
import com.ebaiyihui.hisfront.pojo.dto.ReturnRegistraReqDTO;
import com.ebaiyihui.hisfront.pojo.dto.ReturnRegistraResDTO;
import com.ebaiyihui.hisfront.service.AppointService;
import com.ebaiyihui.hisfront.service.impl.CardServiceImpl;
import com.ebaiyihui.hisfront.utils.XmlTemplateKit;
import com.ebaiyihui.hisfront.utils.XmlUtil;
import his.pojo.vo.appoint.CancelRegisterReq;
import his.pojo.vo.appoint.CancelRegisterRes;
import his.pojo.vo.appoint.LockOrderReq;
import his.pojo.vo.appoint.LockOrderRes;
import his.pojo.vo.appoint.PayRegistrationReq;
import his.pojo.vo.appoint.PayRegistrationRes;
import his.pojo.vo.appoint.ReturnRegisterReq;
import his.pojo.vo.appoint.ReturnRegisterRes;
import his.pojo.vo.base.FrontRequest;
import his.pojo.vo.base.FrontResponse;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppointServiceImpl
implements AppointService {
    private static final Logger log = LoggerFactory.getLogger(AppointServiceImpl.class);
    @Autowired
    private CardServiceImpl cardServiceImpl;
    public static final String SUCCESS_FLAG = "0";

    public FrontResponse<LockOrderRes> lockOrder(FrontRequest<LockOrderReq> param) {
        log.info("\u6302\u53f7\u9501\u53f7\u8bf7\u6c42\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            LockOrderReq body = (LockOrderReq)param.getBody();
            LockOrderReqDTO lockOrderReqDTO = new LockOrderReqDTO();
            lockOrderReqDTO.setOrderId(body.getOrderId());
            lockOrderReqDTO.setMethod("3205");
            lockOrderReqDTO.setSchedualNo(body.getScheduleCode());
            lockOrderReqDTO.setRegFee(body.getRegFee());
            lockOrderReqDTO.setMedicalFee(body.getMedicalFee());
            lockOrderReqDTO.setTimeFlag(body.getTimeFlag());
            lockOrderReqDTO.setCardNo(body.getCardNo());
            HashMap<String, LockOrderReqDTO> map = new HashMap<String, LockOrderReqDTO>();
            map.put(EntityKeyEnum.REGISTERED_NOWDAY.getValue(), lockOrderReqDTO);
            String requestHisXml = XmlTemplateKit.process((String)MethodNameEnum.REGISTERED_NOWDAY.getValue(), map);
            log.info("\u6302\u53f7\u9501\u53f7\u8bf7\u6c42\u5165\u53c2\uff1a" + requestHisXml);
            String hisRes = HttpUtil.post((String)"http://202.120.174.37:8090/Service.asmx/BaiYiInterface", (String)requestHisXml);
            log.info("his\u51fa\u53c2\uff1a" + hisRes);
            LockOrderResDTO response = (LockOrderResDTO)XmlUtil.convertToJavaBean((String)hisRes, LockOrderResDTO.class);
            log.info("JAXB\u6267\u884c\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)response));
            if (null == response) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"JAXB\u6267\u884c\u5931\u8d25");
            }
            log.info("his \u6ce8\u518c\u5c31\u8bca\u5361\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)response));
            if (!SUCCESS_FLAG.equals(response.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getResultMsg());
            }
            LockOrderRes lockOrderRes = new LockOrderRes();
            lockOrderRes.setLockQueueNo(response.getClinicNo());
            return FrontResponse.success((String)param.getTransactionId(), (Object)lockOrderRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u6302\u53f7\u9501\u53f7\u8bf7\u6c42\u5f02\u5e38", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u6302\u53f7\u9501\u53f7\u8bf7\u6c42\u5f02\u5e38");
        }
    }

    public FrontResponse<CancelRegisterRes> cancelRegister(FrontRequest<CancelRegisterReq> param) {
        log.info("\u53d6\u6d88\u6302\u53f7\u8bf7\u6c42\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            CancelRegisterReq body = (CancelRegisterReq)param.getBody();
            CancelRegisterReqDTO cancelRegisterReqDTO = new CancelRegisterReqDTO();
            cancelRegisterReqDTO.setMethod("3208");
            cancelRegisterReqDTO.setClinicNo(body.getLockQueueNo());
            cancelRegisterReqDTO.setCardNo(body.getCardNo());
            HashMap<String, CancelRegisterReqDTO> map = new HashMap<String, CancelRegisterReqDTO>();
            map.put(EntityKeyEnum.APPOINTMENT_REGISTRATION_NOPAY.getValue(), cancelRegisterReqDTO);
            String requestHisXml = XmlTemplateKit.process((String)MethodNameEnum.CANCEL_LOCK_ORDER.getValue(), map);
            log.info("\u6302\u53f7\u9501\u53f7\u8bf7\u6c42\u5165\u53c2\uff1a" + requestHisXml);
            String hisRes = HttpUtil.post((String)"http://202.120.174.37:8090/Service.asmx/BaiYiInterface", (String)requestHisXml);
            log.info("his\u51fa\u53c2\uff1a" + hisRes);
            CancelRegisterResDTO response = (CancelRegisterResDTO)XmlUtil.convertToJavaBean((String)hisRes, CancelRegisterResDTO.class);
            log.info("JAXB\u6267\u884c\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)response));
            if (null == response) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"JAXB\u6267\u884c\u5931\u8d25");
            }
            if (!SUCCESS_FLAG.equals(response.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getResultMsg());
            }
            CancelRegisterRes cancelRegisterRes = new CancelRegisterRes();
            return FrontResponse.success((String)param.getTransactionId(), (Object)cancelRegisterRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u53d6\u6d88\u6302\u53f7\u8bf7\u6c42\u5f02\u5e38", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u53d6\u6d88\u6302\u53f7\u8bf7\u6c42\u5f02\u5e38");
        }
    }

    public FrontResponse<PayRegistrationRes> payRegistration(FrontRequest<PayRegistrationReq> param) {
        log.info("\u6302\u53f7\u652f\u4ed8\u8bf7\u6c42\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            PayRegistrationReq body = (PayRegistrationReq)param.getBody();
            PayRegistrationReqDTO payRegistrationReqDTO = new PayRegistrationReqDTO();
            payRegistrationReqDTO.setPayChannel(body.getPayChannel());
            payRegistrationReqDTO.setPayTime(body.getRespMsg().getAccdate());
            payRegistrationReqDTO.setMethod("3206");
            payRegistrationReqDTO.setTradNo(body.getFlowNo());
            payRegistrationReqDTO.setClinicNo(body.getAppointId());
            payRegistrationReqDTO.setCardNo(body.getCardNo());
            payRegistrationReqDTO.setPayAmount(body.getRegFee());
            HashMap<String, PayRegistrationReqDTO> map = new HashMap<String, PayRegistrationReqDTO>();
            map.put(EntityKeyEnum.APPOINTMENT_REGISTRATION.getValue(), payRegistrationReqDTO);
            String requestHisXml = XmlTemplateKit.process((String)MethodNameEnum.APPOINTMENT_REGISTRATION.getValue(), map);
            log.info("\u6302\u53f7\u9501\u53f7\u8bf7\u6c42\u5165\u53c2\uff1a" + requestHisXml);
            String hisRes = HttpUtil.post((String)"http://202.120.174.37:8090/Service.asmx/BaiYiInterface", (String)requestHisXml);
            log.info("his\u51fa\u53c2\uff1a" + hisRes);
            PayRegistrationResDTO response = (PayRegistrationResDTO)XmlUtil.convertToJavaBean((String)hisRes, PayRegistrationResDTO.class);
            log.info("JAXB\u6267\u884c\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)response));
            if (null == response) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"JAXB\u6267\u884c\u5931\u8d25");
            }
            if (!SUCCESS_FLAG.equals(response.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getResultMsg());
            }
            PayRegistrationRes payRegistrationRes = new PayRegistrationRes();
            payRegistrationRes.setAdmId(response.getClinicNo());
            return FrontResponse.success((String)param.getTransactionId(), (Object)payRegistrationRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u6302\u53f7\u652f\u4ed8\u8bf7\u6c42\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u6302\u53f7\u652f\u4ed8\u8bf7\u6c42\u5f02\u5e38");
        }
    }

    public FrontResponse<ReturnRegisterRes> returnRegister(FrontRequest<ReturnRegisterReq> param) {
        log.info("\u9000\u53f7\u9000\u8d39\u8bf7\u6c42\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            ReturnRegisterReq body = (ReturnRegisterReq)param.getBody();
            ReturnRegistraReqDTO request = new ReturnRegistraReqDTO();
            request.setMethod("3209");
            request.setCardNo(body.getCardNo());
            request.setClinicNo(body.getAppointId());
            HashMap<String, ReturnRegistraReqDTO> map = new HashMap<String, ReturnRegistraReqDTO>();
            map.put(EntityKeyEnum.RETURN_REGISTER.getValue(), request);
            String requestHisXml = XmlTemplateKit.process((String)MethodNameEnum.RETURN_REGISTERED.getValue(), map);
            log.info("\u6302\u53f7\u9501\u53f7\u8bf7\u6c42\u5165\u53c2\uff1a" + requestHisXml);
            String hisRes = HttpUtil.post((String)"http://202.120.174.37:8090/Service.asmx/BaiYiInterface", (String)requestHisXml);
            log.info("his\u51fa\u53c2\uff1a" + hisRes);
            ReturnRegistraResDTO response = (ReturnRegistraResDTO)XmlUtil.convertToJavaBean((String)hisRes, ReturnRegistraResDTO.class);
            log.info("JAXB\u6267\u884c\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)response));
            if (null == response) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"JAXB\u6267\u884c\u5931\u8d25");
            }
            if (!SUCCESS_FLAG.equals(response.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getResultMsg());
            }
            ReturnRegisterRes returnRegisterRes = new ReturnRegisterRes();
            returnRegisterRes.setSerialNo(response.getClinicNo());
            return FrontResponse.success((String)param.getTransactionId(), (Object)returnRegisterRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u9000\u53f7\u9000\u8d39\u8bf7\u6c42\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u9000\u53f7\u9000\u8d39\u8bf7\u6c42\u5f02\u5e38");
        }
    }
}

