/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.hisfront.service.impl;

import cn.hutool.core.util.IdcardUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.ebaiyihui.hisfront.common.enums.EntityKeyEnum;
import com.ebaiyihui.hisfront.common.enums.MethodCodeEnum;
import com.ebaiyihui.hisfront.common.enums.MethodNameEnum;
import com.ebaiyihui.hisfront.pojo.dto.PatInfosDTO;
import com.ebaiyihui.hisfront.pojo.dto.QueryCardInfoReqDTO;
import com.ebaiyihui.hisfront.pojo.dto.QueryCardInfoResDTO;
import com.ebaiyihui.hisfront.pojo.dto.RegisterReqDTO;
import com.ebaiyihui.hisfront.pojo.dto.RegisterResDTO;
import com.ebaiyihui.hisfront.service.ICardService;
import com.ebaiyihui.hisfront.utils.DobUtils;
import com.ebaiyihui.hisfront.utils.XmlTemplateKit;
import com.ebaiyihui.hisfront.utils.XmlUtil;
import his.pojo.vo.base.FrontRequest;
import his.pojo.vo.base.FrontResponse;
import his.pojo.vo.card.QueryCardInfoReqVO;
import his.pojo.vo.card.QueryCardInfoResVO;
import his.pojo.vo.card.RegisteredCardReqVO;
import his.pojo.vo.card.RegisteredCardResVO;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CardServiceImpl
implements ICardService {
    private static final Logger log = LoggerFactory.getLogger(CardServiceImpl.class);

    public FrontResponse<QueryCardInfoResVO> queryCardInfo(FrontRequest<QueryCardInfoReqVO> param) {
        log.info("\u67e5\u8be2\u5c31\u8bca\u5361\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            QueryCardInfoReqVO body = (QueryCardInfoReqVO)param.getBody();
            QueryCardInfoReqDTO queryCardInfoReqDTO = new QueryCardInfoReqDTO();
            queryCardInfoReqDTO.setMethod("2102");
            queryCardInfoReqDTO.setIdNo(body.getCredNo());
            queryCardInfoReqDTO.setPatientName(body.getName());
            HashMap<String, QueryCardInfoReqDTO> map = new HashMap<String, QueryCardInfoReqDTO>();
            map.put(EntityKeyEnum.QUERY_CARD_INFO.getValue(), queryCardInfoReqDTO);
            String requestHisXml = XmlTemplateKit.process((String)MethodNameEnum.QUERY_INFO.getValue(), map);
            log.info("\u67e5\u8be2\u5c31\u8bca\u5361\u5165\u53c2\uff1a" + requestHisXml);
            String hisRes = HttpUtil.post((String)"http://202.120.174.37:8090/Service.asmx/BaiYiInterface", (String)requestHisXml);
            log.info("his\u51fa\u53c2\uff1a" + hisRes);
            QueryCardInfoResDTO response = (QueryCardInfoResDTO)XmlUtil.convertToJavaBean((String)hisRes, QueryCardInfoResDTO.class);
            log.info("JAXB\u6267\u884c\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)response));
            if (null == response) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"JAXB\u6267\u884c\u5931\u8d25");
            }
            if (null == response) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)response.getResultMsg());
            }
            if (!"0".equals(response.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)response.getResultMsg());
            }
            PatInfosDTO patInfosDTO = (PatInfosDTO)response.getPatInfos().get(0);
            QueryCardInfoResVO queryCardInfoResVO = new QueryCardInfoResVO();
            queryCardInfoResVO.setTelephone(patInfosDTO.getPhone());
            queryCardInfoResVO.setCardNo(patInfosDTO.getCardNo());
            queryCardInfoResVO.setPatientId(patInfosDTO.getPatientId());
            queryCardInfoResVO.setDob(patInfosDTO.getBirthday());
            queryCardInfoResVO.setAddress(patInfosDTO.getAddress());
            queryCardInfoResVO.setName(patInfosDTO.getPatientName());
            queryCardInfoResVO.setSex(patInfosDTO.getSex().equals("1") ? "\u7537" : "\u5973");
            queryCardInfoResVO.setCredNo(patInfosDTO.getIdNo());
            queryCardInfoResVO.setCredType("01");
            queryCardInfoResVO.setCardType("1702");
            return FrontResponse.success((String)param.getTransactionId(), (Object)queryCardInfoResVO);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u67e5\u8be2\u5c31\u8bca\u5361\u5f02\u5e38 {}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u67e5\u8be2\u5c31\u8bca\u5361\u5f02\u5e38");
        }
    }

    public FrontResponse<RegisteredCardResVO> registerCard(FrontRequest<RegisteredCardReqVO> param) {
        log.info("\u6ce8\u518c\u5c31\u8bca\u5361\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            RegisteredCardReqVO body = (RegisteredCardReqVO)param.getBody();
            RegisterReqDTO createPatientInfoReqDTO = new RegisterReqDTO();
            createPatientInfoReqDTO.setMethod(MethodCodeEnum.SAVE_PATIENT_CARD.getValue());
            createPatientInfoReqDTO.setPatientName(body.getName());
            createPatientInfoReqDTO.setSex(body.getSex().equals("M") ? "1" : "2");
            createPatientInfoReqDTO.setBirthday(DobUtils.format((String)body.getCredNo().substring(6, 14)));
            createPatientInfoReqDTO.setIdNo(body.getCredNo());
            createPatientInfoReqDTO.setAddress(IdcardUtil.getProvinceByIdCard((String)body.getCredNo()));
            HashMap<String, RegisterReqDTO> map = new HashMap<String, RegisterReqDTO>();
            map.put(EntityKeyEnum.CREATE_PATIENT_INFO.getValue(), createPatientInfoReqDTO);
            String requestHisXml = XmlTemplateKit.process((String)MethodNameEnum.PAT_INFO_CREATE.getValue(), map);
            log.info("\u6ce8\u518c\u5c31\u8bca\u5361\u5165\u53c2\uff1a" + requestHisXml);
            String hisRes = HttpUtil.post((String)"http://202.120.174.37:8090/Service.asmx/BaiYiInterface", (String)requestHisXml);
            log.info("his\u51fa\u53c2\uff1a" + hisRes);
            RegisterResDTO response = (RegisterResDTO)XmlUtil.convertToJavaBean((String)hisRes, RegisterResDTO.class);
            log.info("JAXB\u6267\u884c\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)response));
            if (null == response) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"JAXB\u6267\u884c\u5931\u8d25");
            }
            log.info("his \u6ce8\u518c\u5c31\u8bca\u5361\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)response));
            if (null == response) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u6ce8\u518c\u5c31\u8bca\u5361\u5f02\u5e38");
            }
            if (!"0".equals(response.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)response.getResultMsg());
            }
            RegisteredCardResVO registeredCardResVO = new RegisteredCardResVO();
            registeredCardResVO.setCardNo(response.getCardNo());
            registeredCardResVO.setPatientId(response.getPatientId());
            registeredCardResVO.setCardType("01");
            registeredCardResVO.setName(body.getName());
            registeredCardResVO.setTelephone(body.getTelephone());
            registeredCardResVO.setCredNo(body.getCredNo());
            registeredCardResVO.setAddress(IdcardUtil.getProvinceByIdCard((String)body.getCredNo()));
            registeredCardResVO.setDob(DobUtils.format((String)body.getCredNo().substring(6, 14)));
            registeredCardResVO.setSex(String.valueOf(IdcardUtil.getGenderByIdCard((String)body.getCredNo())).equals("1") ? "M" : "F");
            return FrontResponse.success((String)param.getTransactionId(), (Object)registeredCardResVO);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u6ce8\u518c\u5c31\u8bca\u5361\u5f02\u5e38", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u6ce8\u518c\u5c31\u8bca\u5361\u5f02\u5e38");
        }
    }
}

