/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.hisfront.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.hisfront.pojo.dto.GetReportLists;
import com.ebaiyihui.hisfront.pojo.dto.GetReportListsResDTO;
import com.ebaiyihui.hisfront.pojo.dto.LisReportListResDTO;
import com.ebaiyihui.hisfront.pojo.dto.PacsReportListDTO;
import com.ebaiyihui.hisfront.pojo.dto.PacsReportListResDTO;
import com.ebaiyihui.hisfront.service.ElectronicReportService;
import com.ebaiyihui.hisfront.utils.DataUtils;
import com.ebaiyihui.hisfront.utils.HttpUtils;
import his.pojo.vo.base.FrontRequest;
import his.pojo.vo.base.FrontResponse;
import his.pojo.vo.report.GetReportListsReq;
import his.pojo.vo.report.GetReportListsRes;
import his.pojo.vo.report.LisReportListReq;
import his.pojo.vo.report.LisReportListRes;
import his.pojo.vo.report.PacsReportListReq;
import his.pojo.vo.report.PacsReportListRes;
import his.pojo.vo.report.datas.GetReportListsData;
import his.pojo.vo.report.datas.LisReportListResData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ElectronicReportServiceImpl
implements ElectronicReportService {
    private static final Logger log = LoggerFactory.getLogger(ElectronicReportServiceImpl.class);
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final int MAP_SIZE = 1;
    public static final String SUCCESS_FLAG = "0";

    public FrontResponse<GetReportListsRes> getJYReportLists(FrontRequest<GetReportListsReq> param) {
        log.info("\u67e5\u8be2\u7535\u5b50\u62a5\u544aJY\u5217\u8868\u8bf7\u6c42\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            GetReportListsReq body = (GetReportListsReq)param.getBody();
            HashMap<String, Object> JYListMapReq = new HashMap<String, Object>();
            JYListMapReq.put("endDate", body.getEndTime() + " 23:59:59");
            JYListMapReq.put("page", 0);
            JYListMapReq.put("patientId", body.getCardNo());
            JYListMapReq.put("size", 999);
            JYListMapReq.put("startDate", body.getBeginTime() + " 00:00:00");
            JYListMapReq.put("type", "1");
            log.info("\u30100401\u3011-\u67e5\u8be2\u68c0\u9a8c\u7ed3\u679c\u5217\u8868 IN====>>> " + JSONObject.toJSONString(JYListMapReq));
            String JYListMapRes = HttpUtils.postNew((String)"https://hlw.cacah.com/sync//v1/lis/report/list", (String)JSONObject.toJSONString(JYListMapReq));
            log.info("\u30100401\u3011-\u67e5\u8be2\u68c0\u9a8c\u7ed3\u679c\u5217\u8868 OUT====>>> " + JYListMapRes);
            GetReportListsResDTO response = (GetReportListsResDTO)JSON.parseObject((String)JYListMapRes, GetReportListsResDTO.class);
            log.info("\u67e5\u8be2\u68c0\u9a8c\u7ed3\u679c\u5217\u8868 parseObject\u8f6c\u6362\u540e\u51fa\u53c2====>>> " + JSONObject.toJSONString((Object)response));
            if (!SUCCESS_FLAG.equals(response.getCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getMessage());
            }
            List getReportLists = response.getData();
            GetReportListsRes getReportListsRes = new GetReportListsRes();
            ArrayList<GetReportListsData> datas = new ArrayList<GetReportListsData>();
            for (GetReportLists reportInfoDTO : getReportLists) {
                GetReportListsData getReportListsData = new GetReportListsData();
                getReportListsData.setReportNo(reportInfoDTO.getInspectCode());
                getReportListsData.setReportName(reportInfoDTO.getInspectName());
                getReportListsData.setReportType(reportInfoDTO.getReportType());
                getReportListsData.setReportDate(DataUtils.dealDateFormat((String)reportInfoDTO.getReportTime()));
                getReportListsData.setRecTime(DataUtils.dealDateFormat((String)reportInfoDTO.getInspectTime()));
                getReportListsData.setAuthTime(DataUtils.dealDateFormat((String)reportInfoDTO.getReportTime()));
                getReportListsData.setAuthUser(reportInfoDTO.getCheckPerson());
                getReportListsData.setRecUser(reportInfoDTO.getInspectPerson());
                getReportListsData.setDoctorName(reportInfoDTO.getRequisitionPerson());
                getReportListsData.setDeptName(reportInfoDTO.getDeptName());
                getReportListsData.setColTime(DataUtils.dealDateFormat((String)reportInfoDTO.getSampleTime()));
                getReportListsData.setRelevantClinicDiag(reportInfoDTO.getClinicDiagName());
                datas.add(getReportListsData);
            }
            getReportListsRes.setDatas(datas);
            return FrontResponse.success((String)param.getTransactionId(), (Object)getReportListsRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u67e5\u8be2\u7535\u5b50\u62a5\u544aJY\u5217\u8868\u5f02\u5e38", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u67e5\u8be2\u7535\u5b50\u62a5\u544aJY\u5217\u8868\u5f02\u5e38");
        }
    }

    public FrontResponse<GetReportListsRes> getJCReportLists(FrontRequest<GetReportListsReq> param) {
        log.info("JC\u67e5\u8be2\u7535\u5b50\u62a5\u544a\u5217\u8868\u8bf7\u6c42\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            GetReportListsReq body = (GetReportListsReq)param.getBody();
            HashMap<String, Object> JCListMapReq = new HashMap<String, Object>();
            JCListMapReq.put("endDate", body.getEndTime() + " 23:59:59");
            JCListMapReq.put("page", 0);
            JCListMapReq.put("patientId", body.getCardNo());
            JCListMapReq.put("size", 999);
            JCListMapReq.put("startDate", body.getBeginTime() + " 00:00:00");
            JCListMapReq.put("type", "1");
            log.info("\u30100501\u3011-\u67e5\u8be2\u68c0\u67e5\u7ed3\u679c\u5217\u8868 IN====>>> " + JSONObject.toJSONString(JCListMapReq));
            String JCListMapRes = HttpUtils.postNew((String)"https://hlw.cacah.com/sync//v1/pacs/report/list", (String)JSONObject.toJSONString(JCListMapReq));
            log.info("\u30100501\u3011-\u67e5\u8be2\u68c0\u67e5\u7ed3\u679c\u5217\u8868 OUT====>>> " + JCListMapRes);
            GetReportListsResDTO response = (GetReportListsResDTO)JSON.parseObject((String)JCListMapRes, GetReportListsResDTO.class);
            if (!SUCCESS_FLAG.equals(response.getCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getMessage());
            }
            List getReportLists = response.getData();
            GetReportListsRes getReportListsRes = new GetReportListsRes();
            ArrayList<GetReportListsData> datas = new ArrayList<GetReportListsData>();
            for (GetReportLists reportInfoDTO : getReportLists) {
                GetReportListsData getReportListsData = new GetReportListsData();
                getReportListsData.setReportNo(reportInfoDTO.getCheckSerialNo());
                getReportListsData.setReportName(reportInfoDTO.getItemName());
                getReportListsData.setReportType(reportInfoDTO.getReportType());
                getReportListsData.setReportDate(DataUtils.dealDateFormat((String)reportInfoDTO.getReportTime()));
                getReportListsData.setDeptName(reportInfoDTO.getChkDeptName());
                datas.add(getReportListsData);
            }
            getReportListsRes.setDatas(datas);
            return FrontResponse.success((String)param.getTransactionId(), (Object)getReportListsRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u67e5\u8be2\u7535\u5b50\u62a5\u544aJC\u5217\u8868\u5f02\u5e38", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u67e5\u8be2\u7535\u5b50\u62a5\u544aJC\u5217\u8868\u5f02\u5e38");
        }
    }

    public FrontResponse<LisReportListRes> lisReportList(FrontRequest<LisReportListReq> param) {
        log.info("\u67e5\u8be2\u68c0\u9a8c\u62a5\u544a\u8be6\u60c5\u6c42\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            HashMap<String, String> headersMap = new HashMap<String, String>();
            headersMap.put("X-Api-Key", "gc8U4S37ZhhoQZNeZZ0CfcWgIBfkgFEEPIWvpJaBY6DQiWWh9seq/2EckpsvVJ5saoB0PfAMEuWKrf+LGcfHkvMTcHaDc6mr7BpR+PHJF9WkZEqdMTwIY8X4O5kZiWm3qGbpjnZcwwS1ljQRuOFtSg==");
            headersMap.put("X-Api-Ver", "2.0");
            LisReportListReq body = (LisReportListReq)param.getBody();
            HashMap<String, String> JCDetialMapReq = new HashMap<String, String>();
            JCDetialMapReq.put("hosId", "");
            JCDetialMapReq.put("inspectionId", body.getReportNo());
            JCDetialMapReq.put("type", "");
            log.info("\u30100402\u3011-\u67e5\u8be2\u68c0\u9a8c\u7ed3\u679c\u8be6\u60c5 IN====>>> " + JSONObject.toJSONString(JCDetialMapReq));
            String JCDetialMapRes = HttpUtils.get((String)"https://hlw.cacah.com/sync//v1/lis/report/detail", JCDetialMapReq, headersMap);
            log.info("\u30100402\u3011-\u67e5\u8be2\u68c0\u9a8c\u7ed3\u679c\u8be6\u60c5 OUT====>>> " + JCDetialMapRes);
            LisReportListResDTO response = (LisReportListResDTO)JSON.parseObject((String)JCDetialMapRes, LisReportListResDTO.class);
            if (!SUCCESS_FLAG.equals(response.getCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getMessage());
            }
            List lisReportList = response.getData();
            LisReportListRes lisReportListRes = new LisReportListRes();
            ArrayList datas = new ArrayList();
            lisReportList.stream().forEach(date -> {
                LisReportListResData lisReportListResData = new LisReportListResData();
                lisReportListResData.setItmCode(date.getInspectItemId());
                lisReportListResData.setItmName(date.getChineseName());
                lisReportListResData.setItmUnit(date.getItemUnit());
                lisReportListResData.setItmRanges(date.getItemReference());
                lisReportListResData.setItmRes(date.getOriginalResult());
                switch (date.getQualitativeResult()) {
                    case "h": {
                        lisReportListResData.setItmCrises("\u504f\u9ad8");
                        break;
                    }
                    case "l": {
                        lisReportListResData.setItmCrises("\u504f\u4f4e");
                        break;
                    }
                    default: {
                        lisReportListResData.setItmCrises("\u6b63\u5e38");
                    }
                }
                datas.add(lisReportListResData);
            });
            lisReportListRes.setDatas(datas);
            return FrontResponse.success((String)param.getTransactionId(), (Object)lisReportListRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u67e5\u8be2\u68c0\u9a8c\u62a5\u544a\u8be6\u60c5\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u67e5\u8be2\u68c0\u9a8c\u62a5\u544a\u8be6\u60c5\u5f02\u5e38");
        }
    }

    public FrontResponse<PacsReportListRes> pacsReportList(FrontRequest<PacsReportListReq> param) {
        log.info("\u67e5\u8be2\u68c0\u67e5\u62a5\u544a\u8be6\u60c5\u6c42\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            PacsReportListReq body = (PacsReportListReq)param.getBody();
            HashMap<String, String> JYDetialMapReq = new HashMap<String, String>();
            JYDetialMapReq.put("checkserialnums", body.getReportNo());
            JYDetialMapReq.put("hosId", "");
            log.info("\u30100502\u3011-\u67e5\u8be2\u68c0\u67e5\u7ed3\u679c\u8be6\u60c5 IN====>>> " + JSONObject.toJSONString(JYDetialMapReq));
            String JYDetialMapRes = HttpUtils.postNew((String)("https://hlw.cacah.com/sync//v1/pacs/report/detail?checkserialnums=" + JYDetialMapReq.get("checkserialnums") + "&hosId=" + JYDetialMapReq.get("hosId")), (String)JSONObject.toJSONString(JYDetialMapReq));
            log.info("\u30100502\u3011-\u67e5\u8be2\u68c0\u67e5\u7ed3\u679c\u8be6\u60c5 OUT====>>> " + JYDetialMapRes);
            PacsReportListResDTO response = (PacsReportListResDTO)JSON.parseObject((String)JYDetialMapRes, PacsReportListResDTO.class);
            if (!SUCCESS_FLAG.equals(response.getCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getMessage());
            }
            PacsReportListDTO pacsReportListDTO = (PacsReportListDTO)response.getData().get(0);
            PacsReportListRes pacsReportListRes = new PacsReportListRes();
            pacsReportListRes.setDoctorName(pacsReportListDTO.getCheckDocName());
            pacsReportListRes.setAuthTime(DataUtils.dealDateFormat((String)pacsReportListDTO.getStudyTime()));
            pacsReportListRes.setCheckResult(pacsReportListDTO.getReportDiagnose());
            pacsReportListRes.setAuthUser(pacsReportListDTO.getCheckDocName());
            pacsReportListRes.setCheckDesc(pacsReportListDTO.getReportDescribe());
            return FrontResponse.success((String)param.getTransactionId(), (Object)pacsReportListRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u67e5\u8be2\u68c0\u67e5\u62a5\u544a\u8be6\u60c5\u5f02\u5e38", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u67e5\u8be2\u68c0\u67e5\u62a5\u544a\u8be6\u60c5\u5f02\u5e38");
        }
    }
}

