/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.hisfront.service.impl;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import com.alibaba.fastjson.JSON;
import com.ebaiyihui.hisfront.pojo.dto.GetOutPatientAdmResDTO;
import com.ebaiyihui.hisfront.pojo.dto.GetOutPatientAdmResItemDTO;
import com.ebaiyihui.hisfront.service.OutpatientPaymentService;
import com.ebaiyihui.hisfront.utils.HttpUtils;
import his.pojo.vo.base.FrontRequest;
import his.pojo.vo.base.FrontResponse;
import his.pojo.vo.outpatient.ComfirmPayNewReq;
import his.pojo.vo.outpatient.ComfirmPayNewRes;
import his.pojo.vo.outpatient.GetAdmissionReq;
import his.pojo.vo.outpatient.GetAdmissionRes;
import his.pojo.vo.outpatient.PayItemReq;
import his.pojo.vo.outpatient.PayItemRes;
import his.pojo.vo.outpatient.datas.PayItemResDatas;
import his.pojo.vo.outpatient.items.GetAdmissionItems;
import his.pojo.vo.outpatient.items.PayItemResItems;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OutpatientPaymentServiceImpl
implements OutpatientPaymentService {
    private static final Logger log = LoggerFactory.getLogger(OutpatientPaymentServiceImpl.class);
    public static final String SUCCESS_FLAG = "0";

    public FrontResponse<GetAdmissionRes> getAdmission(FrontRequest<GetAdmissionReq> param) {
        log.info("\u5c31\u8bca\u8bb0\u5f55\u67e5\u8be2\u8bf7\u6c42\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            GetAdmissionReq body = (GetAdmissionReq)param.getBody();
            HashMap<String, String> outPatientInfoMapReq = new HashMap<String, String>();
            outPatientInfoMapReq.put("beginTime", body.getBgDate());
            outPatientInfoMapReq.put("cardNo", body.getCardNo());
            outPatientInfoMapReq.put("chargeFlag", SUCCESS_FLAG);
            outPatientInfoMapReq.put("endTime", body.getEdDate());
            outPatientInfoMapReq.put("clinicCode", "");
            String url = null;
            if ("130215".equals(param.getOrganCode())) {
                url = "https://hlw.cacah.com/sync//v1/sync/advice/unpay";
            } else if ("130214".equals(param.getOrganCode())) {
                url = "http://gateway.sxszlyy-prod.swifthealth.cn:8081/sync//v1/sync/query/orderInfo";
            } else {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u672a\u5b9a\u4f4d\u5230\u533b\u9662");
            }
            log.info("\u30100601\u3011-\u67e5\u8be2\u95e8\u8bca\u533b\u5631 IN====>>> " + com.alibaba.fastjson.JSONObject.toJSONString(outPatientInfoMapReq));
            String outPatientInfoMapRes = HttpUtils.postNew((String)url, (String)com.alibaba.fastjson.JSONObject.toJSONString(outPatientInfoMapReq));
            log.info("\u30100601\u3011-\u67e5\u8be2\u95e8\u8bca\u533b\u5631 OUT====>>> " + outPatientInfoMapRes);
            GetOutPatientAdmResDTO response = (GetOutPatientAdmResDTO)JSON.parseObject((String)outPatientInfoMapRes, GetOutPatientAdmResDTO.class);
            log.info("\u67e5\u8be2\u95e8\u8bca\u533b\u5631 parseObject\u8f6c\u6362\u540e\u51fa\u53c2====>>> " + outPatientInfoMapRes);
            if (!SUCCESS_FLAG.equals(response.getCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getMessage());
            }
            GetAdmissionRes getAdmissionRes = new GetAdmissionRes();
            List getOutPatientAdmResItemDTOList = response.getData();
            getOutPatientAdmResItemDTOList = getOutPatientAdmResItemDTOList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<GetOutPatientAdmResItemDTO>(Comparator.comparing(GetOutPatientAdmResItemDTO::getRecipeNo))), ArrayList::new));
            log.info("\u67e5\u8be2\u95e8\u8bca\u533b\u5631 parseObject\u8f6c\u6362\u540e\u51fa\u53c2-\u53bb\u91cd\u540e====>>> " + getOutPatientAdmResItemDTOList);
            ArrayList items = new ArrayList();
            getOutPatientAdmResItemDTOList.stream().forEach(date -> {
                GetAdmissionItems getAdmissionItems = new GetAdmissionItems();
                getAdmissionItems.setAdmDate(date.getOperTime());
                getAdmissionItems.setDeptCode(date.getDeptCode());
                getAdmissionItems.setDeptName(date.getDeptName());
                getAdmissionItems.setDocName(date.getDocName());
                getAdmissionItems.setDocCode(date.getDocCode());
                getAdmissionItems.setAdmId(date.getRecipeNo());
                items.add(getAdmissionItems);
            });
            getAdmissionRes.setItems(items);
            return FrontResponse.success((String)param.getTransactionId(), (Object)getAdmissionRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u5c31\u8bca\u8bb0\u5f55\u67e5\u8be2\u8bf7\u6c42\u5f02\u5e38", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u5c31\u8bca\u8bb0\u5f55\u67e5\u8be2\u8bf7\u6c42\u5f02\u5e38");
        }
    }

    public FrontResponse<PayItemRes> payItem(FrontRequest<PayItemReq> param) {
        log.info("\u5c31\u8bca\u5904\u65b9\u8be6\u60c5\u67e5\u8be2\u8bf7\u6c42\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            PayItemReq body = (PayItemReq)param.getBody();
            HashMap<String, String> outPatientInfoMapReq = new HashMap<String, String>();
            outPatientInfoMapReq.put("beginTime", body.getAdmDate());
            outPatientInfoMapReq.put("cardNo", body.getCardNo());
            outPatientInfoMapReq.put("chargeFlag", SUCCESS_FLAG);
            outPatientInfoMapReq.put("endTime", body.getAdmDate());
            outPatientInfoMapReq.put("clinicCode", "");
            String url = null;
            if ("130215".equals(param.getOrganCode())) {
                url = "https://hlw.cacah.com/sync//v1/sync/advice/unpay";
            } else if ("130214".equals(param.getOrganCode())) {
                url = "http://gateway.sxszlyy-prod.swifthealth.cn:8081/sync//v1/sync/query/orderInfo";
            } else {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u672a\u5b9a\u4f4d\u5230\u533b\u9662");
            }
            log.info("\u30100601\u3011-\u67e5\u8be2\u95e8\u8bca\u533b\u5631-\u8be6\u60c5 IN====>>> " + com.alibaba.fastjson.JSONObject.toJSONString(outPatientInfoMapReq));
            String outPatientInfoMapRes = HttpUtils.postNew((String)url, (String)com.alibaba.fastjson.JSONObject.toJSONString(outPatientInfoMapReq));
            log.info("\u30100601\u3011-\u67e5\u8be2\u95e8\u8bca\u533b\u5631-\u8be6\u60c5 OUT====>>> " + outPatientInfoMapRes);
            GetOutPatientAdmResDTO response = (GetOutPatientAdmResDTO)JSON.parseObject((String)outPatientInfoMapRes, GetOutPatientAdmResDTO.class);
            log.info("\u67e5\u8be2\u95e8\u8bca\u533b\u5631-\u8be6\u60c5 parseObject\u8f6c\u6362\u540e\u51fa\u53c2====>>> " + com.alibaba.fastjson.JSONObject.toJSONString((Object)response));
            if (!SUCCESS_FLAG.equals(response.getCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getMessage());
            }
            List getOutPatientAdmResItemDTOList = response.getData();
            getOutPatientAdmResItemDTOList.removeIf(o -> !o.getRecipeNo().equals(body.getAdmId()));
            log.info("\u67e5\u8be2\u95e8\u8bca\u533b\u5631-\u8be6\u60c5 parseObject\u8f6c\u6362\u540e\u51fa\u53c2-\u53bb\u9664\u975e\u9009\u4e2d\u5904\u65b9====>>> " + com.alibaba.fastjson.JSONObject.toJSONString((Object)getOutPatientAdmResItemDTOList));
            PayItemRes payItemRes = new PayItemRes();
            ArrayList PayItemResDatas2 = new ArrayList();
            getOutPatientAdmResItemDTOList.stream().forEach(date -> {
                PayItemResDatas payItemResData = new PayItemResDatas();
                payItemResData.setAmount(String.valueOf(date.getTotalCost().setScale(2, 4)));
                payItemResData.setItemType(date.getTradeName());
                payItemResData.setAdmId(date.getClinicCode());
                ArrayList<PayItemResItems> items = new ArrayList<PayItemResItems>();
                PayItemResItems payItemResItems = new PayItemResItems();
                payItemResItems.setId(date.getItemCode());
                payItemResItems.setPrice(String.valueOf(date.getUnitPrice().setScale(2, 4)));
                payItemResItems.setDesc(date.getTradeName());
                payItemResItems.setQty(date.getQty());
                payItemResItems.setUnit(date.getUnit());
                payItemResItems.setSum(String.valueOf(date.getTotalCost().setScale(2, 4)));
                payItemResItems.setPrescriptionNo(date.getRecipeNo());
                payItemResItems.setItemType(date.getTradeName());
                items.add(payItemResItems);
                payItemResData.setItems(items);
                PayItemResDatas2.add(payItemResData);
            });
            payItemRes.setDatas(PayItemResDatas2);
            return FrontResponse.success((String)param.getTransactionId(), (Object)payItemRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u5c31\u8bca\u5904\u65b9\u8be6\u60c5\u67e5\u8be2\u8bf7\u6c42\u5f02\u5e38", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u5c31\u8bca\u5904\u65b9\u8be6\u60c5\u67e5\u8be2\u8bf7\u6c42\u5f02\u5e38");
        }
    }

    public FrontResponse<ComfirmPayNewRes> comfirmPay(FrontRequest<ComfirmPayNewReq> param) {
        log.info("\u95e8\u8bca\u7f34\u8d39\u652f\u4ed8\u8bf7\u6c42\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            HashMap<String, Object> recipes;
            ArrayList recipeslst;
            HashMap<String, Object> params;
            ComfirmPayNewReq body = (ComfirmPayNewReq)param.getBody();
            HashMap<String, Object> outPatientChargeMapReq = new HashMap<String, Object>();
            outPatientChargeMapReq.put("agtOrderNo", body.getRespmsg().getOrderid());
            outPatientChargeMapReq.put("cardNo", body.getCardNo());
            outPatientChargeMapReq.put("clinicCode", body.getId());
            outPatientChargeMapReq.put("operType", "6");
            outPatientChargeMapReq.put("orderNo", body.getRespmsg().getPosid());
            outPatientChargeMapReq.put("payWay", body.getPaychannel());
            outPatientChargeMapReq.put("totalCost", new BigDecimal(body.getRespmsg().getPayment()));
            String url = null;
            if ("130215".equals(param.getOrganCode())) {
                outPatientChargeMapReq.put("operCode", "4356");
                params = new HashMap<String, Object>();
                params.put("payAmount", new BigDecimal(body.getRespmsg().getPayment()));
                params.put("disAmount", 0);
                outPatientChargeMapReq.put("params", params);
                recipeslst = new ArrayList();
                recipes = new HashMap<String, Object>();
                recipes.put("recipeNo", body.getPrescriptionNos());
                recipes.put("totalCost", new BigDecimal(body.getRespmsg().getPayment()));
                recipeslst.add(recipes);
                outPatientChargeMapReq.put("recipes", recipeslst);
                url = "https://hlw.cacah.com/sync/";
            } else if ("130214".equals(param.getOrganCode())) {
                outPatientChargeMapReq.put("operCode", "HLWYY");
                params = new HashMap();
                params.put("payTime", body.getRespmsg().getAccdate());
                params.put("userId", "");
                outPatientChargeMapReq.put("params", params);
                recipeslst = new ArrayList();
                recipes = new HashMap();
                recipes.put("clinicCode", body.getId());
                recipes.put("recipeNo", body.getPrescriptionNos());
                recipes.put("totalCost", new BigDecimal(body.getRespmsg().getPayment()));
                ArrayList orders = new ArrayList();
                recipes.put("orders", orders);
                recipeslst.add(recipes);
                outPatientChargeMapReq.put("recipes", recipeslst);
                outPatientChargeMapReq.put("visitSeq", "");
                url = "http://gateway.sxszlyy-prod.swifthealth.cn:8081/sync/";
            } else {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u672a\u5b9a\u4f4d\u5230\u533b\u9662");
            }
            log.info("\u30100304\u3011 \u533b\u5631\u6536\u8d39 IN====>>> " + com.alibaba.fastjson.JSONObject.toJSONString(outPatientChargeMapReq));
            String outPatientChargeMapRes = HttpUtils.postNew((String)(url + "/v1/treat/recipe/charge"), (String)com.alibaba.fastjson.JSONObject.toJSONString(outPatientChargeMapReq));
            log.info("\u30100304\u3011 \u533b\u5631\u6536\u8d39 OUT====>>> " + outPatientChargeMapRes);
            JSONObject json = new JSONObject((Object)outPatientChargeMapRes);
            if (!SUCCESS_FLAG.equals(json.getStr((Object)"code"))) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)json.getStr((Object)"message"));
            }
            ComfirmPayNewRes comfirmPayNewRes = new ComfirmPayNewRes();
            JSONArray dataJsonArray = json.getJSONArray((Object)"data");
            JSONObject dataObject = (JSONObject)dataJsonArray.get(0);
            comfirmPayNewRes.setReceiptId(dataObject.getStr((Object)"invoiceNo"));
            return FrontResponse.success((String)param.getTransactionId(), (Object)comfirmPayNewRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u95e8\u8bca\u7f34\u8d39\u652f\u4ed8\u8bf7\u6c42\u5f02\u5e38", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u95e8\u8bca\u7f34\u8d39\u652f\u4ed8\u8bf7\u6c42\u5f02\u5e38");
        }
    }
}

