/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.hisfront.service.impl;

import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONObject;
import com.alibaba.fastjson.JSON;
import com.ebaiyihui.hisfront.common.enums.EntityKeyEnum;
import com.ebaiyihui.hisfront.common.enums.MethodNameEnum;
import com.ebaiyihui.hisfront.pojo.dto.GetDeptDoctorInfoResDTO;
import com.ebaiyihui.hisfront.pojo.dto.GetDeptScheduleResDTO;
import com.ebaiyihui.hisfront.pojo.dto.GetScheduleReqDTO;
import com.ebaiyihui.hisfront.pojo.dto.GetScheduleResDTO;
import com.ebaiyihui.hisfront.service.ScheduleService;
import com.ebaiyihui.hisfront.utils.DataUtils;
import com.ebaiyihui.hisfront.utils.HttpUtils;
import com.ebaiyihui.hisfront.utils.XmlTemplateKit;
import com.ebaiyihui.hisfront.utils.XmlUtil;
import his.pojo.vo.base.FrontRequest;
import his.pojo.vo.base.FrontResponse;
import his.pojo.vo.schedule.GetDeptDoctorInfoReqVO;
import his.pojo.vo.schedule.GetDeptDoctorInfoResVO;
import his.pojo.vo.schedule.GetDeptScheduleReqVO;
import his.pojo.vo.schedule.GetDeptScheduleResVO;
import his.pojo.vo.schedule.GetScheduleReqVO;
import his.pojo.vo.schedule.GetScheduleResVO;
import his.pojo.vo.schedule.items.GetDeptDoctorInfoResItems;
import his.pojo.vo.schedule.items.GetDeptScheduleResItems;
import his.pojo.vo.schedule.items.GetScheduleResItems;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ScheduleServiceImpl
implements ScheduleService {
    private static final Logger log = LoggerFactory.getLogger(ScheduleServiceImpl.class);
    public static final String SUCCESS_FLAG = "0";

    public FrontResponse<GetDeptScheduleResVO> getDeptSchedule(FrontRequest<GetDeptScheduleReqVO> param) {
        log.info("\u67e5\u8be2\u79d1\u5ba4\u4fe1\u606f\u63a5\u53e3\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            GetDeptScheduleReqVO body = (GetDeptScheduleReqVO)param.getBody();
            HashMap<String, String> queryPaibanDeptMapReq = new HashMap<String, String>();
            queryPaibanDeptMapReq.put("hosId", "61011900");
            String url = null;
            if ("130215".equals(param.getOrganCode())) {
                url = "https://hlw.cacah.com/sync//v1/offclinic/schema/query/dept?hosId=61011900";
            } else if ("130214".equals(param.getOrganCode())) {
                url = "http://gateway.sxszlyy-prod.swifthealth.cn:8081/sync//v1/offclinic/schema/query/dept?hosId=61010800";
            } else {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u672a\u5b9a\u4f4d\u5230\u533b\u9662");
            }
            log.info("0101-\u6839\u636e\u8eab\u4efd\u8bc1\u67e5\u8be2\u5c31\u8bca\u5361his\u5165\u53c2====>>> {} ", queryPaibanDeptMapReq);
            String queryPaibanDept = HttpUtils.postNew((String)url, (String)com.alibaba.fastjson.JSONObject.toJSONString(queryPaibanDeptMapReq));
            log.info("\u6839\u636e\u533b\u9662id\u67e5\u8be2\u4e00\u5468\u5185\u53ef\u6392\u73ed\u7684\u79d1\u5ba4his\u51fa\u53c2====>>> " + queryPaibanDept);
            JSONObject json = new JSONObject((Object)queryPaibanDept);
            if (!SUCCESS_FLAG.equals(json.getStr((Object)"code"))) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)json.getStr((Object)"message"));
            }
            GetDeptScheduleResDTO response = (GetDeptScheduleResDTO)JSON.parseObject((String)queryPaibanDept, GetDeptScheduleResDTO.class);
            List getDeptItemsResDTOList = response.getData();
            log.info("\u6839\u636e\u533b\u9662id\u67e5\u8be2\u4e00\u5468\u5185\u53ef\u6392\u73ed\u7684\u79d1\u5ba4-\u8f6c\u6362\u540e====>>> " + response);
            GetDeptScheduleResVO getDeptScheduleResVO = new GetDeptScheduleResVO();
            ArrayList getDeptScheduleResItems = new ArrayList();
            getDeptItemsResDTOList.stream().forEach(date -> {
                GetDeptScheduleResItems getDeptScheduleRes = new GetDeptScheduleResItems();
                getDeptScheduleRes.setDeptCode(date.getDeptCode());
                getDeptScheduleRes.setDeptName(date.getDeptName());
                getDeptScheduleRes.setDeptAddress(date.getHosId());
                getDeptScheduleResItems.add(getDeptScheduleRes);
            });
            getDeptScheduleResVO.setItems(getDeptScheduleResItems);
            return FrontResponse.success((String)param.getTransactionId(), (Object)getDeptScheduleResVO);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u67e5\u8be2\u79d1\u5ba4\u4fe1\u606f\u5f02\u5e38", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u67e5\u8be2\u79d1\u5ba4\u4fe1\u606f\u5f02\u5e38");
        }
    }

    public FrontResponse<GetDeptDoctorInfoResVO> getDeptDoctorInfo(FrontRequest<GetDeptDoctorInfoReqVO> param) {
        log.info("\u67e5\u8be2\u79d1\u5ba4\u6392\u73ed\u533b\u751f\u63a5\u53e3\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            GetDeptDoctorInfoReqVO body = (GetDeptDoctorInfoReqVO)param.getBody();
            GetDeptDoctorInfoResVO getDeptDoctorInfoResVO = new GetDeptDoctorInfoResVO();
            ArrayList getDeptDoctorInfoResItems = new ArrayList();
            getDeptDoctorInfoResVO.setItems(getDeptDoctorInfoResItems);
            HashMap<String, Object> queryPaibanDeptdetailMapReq = new HashMap<String, Object>();
            HashMap params = new HashMap();
            queryPaibanDeptdetailMapReq.put("deptCode", body.getDeptCode());
            queryPaibanDeptdetailMapReq.put("endTime", body.getEndTime());
            queryPaibanDeptdetailMapReq.put("startTime", body.getStartTime());
            queryPaibanDeptdetailMapReq.put("size", 999);
            queryPaibanDeptdetailMapReq.put("params", params);
            queryPaibanDeptdetailMapReq.put("page", 0);
            String url = null;
            if ("130215".equals(param.getOrganCode())) {
                queryPaibanDeptdetailMapReq.put("hosId", "61011900");
                url = "https://hlw.cacah.com/sync/";
            } else if ("130214".equals(param.getOrganCode())) {
                queryPaibanDeptdetailMapReq.put("hosId", "61010800");
                url = "http://gateway.sxszlyy-prod.swifthealth.cn:8081/sync/";
            } else {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u672a\u5b9a\u4f4d\u5230\u533b\u9662");
            }
            log.info("0202-\u67e5\u8be2\u67d0\u4e2a\u79d1\u5ba4\u7684\u53ef\u6302\u53f7\u533b\u751f,\u6302\u53f7\u8d39,\u4ee5\u53ca\u53f7\u6e90\u60c5\u51b5 IN====>>> " + com.alibaba.fastjson.JSONObject.toJSONString(queryPaibanDeptdetailMapReq));
            String queryPaibandetailDept = HttpUtils.postNew((String)(url + "/v1/offclinic/schema/dept/detail"), (String)com.alibaba.fastjson.JSONObject.toJSONString(queryPaibanDeptdetailMapReq));
            log.info("0202-\u67e5\u8be2\u67d0\u4e2a\u79d1\u5ba4\u7684\u53ef\u6302\u53f7\u533b\u751f,\u6302\u53f7\u8d39,\u4ee5\u53ca\u53f7\u6e90\u60c5\u51b5 OUT====>>> " + queryPaibandetailDept);
            JSONObject json = new JSONObject((Object)queryPaibandetailDept);
            if (!SUCCESS_FLAG.equals(json.getStr((Object)"code"))) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)json.getStr((Object)"message"));
            }
            GetDeptDoctorInfoResDTO response = (GetDeptDoctorInfoResDTO)JSON.parseObject((String)queryPaibandetailDept, GetDeptDoctorInfoResDTO.class);
            List models = response.getData().getModels();
            if (models.size() <= 0) {
                return FrontResponse.success((String)param.getTransactionId(), (Object)getDeptDoctorInfoResVO);
            }
            log.info("\u67e5\u8be2\u79d1\u5ba4\u6392\u73ed\u533b\u751f\u63a5\u53e3-\u8f6c\u6362\u540e====>>> " + response);
            models.stream().forEach(date -> {
                GetDeptDoctorInfoResItems getDeptDoctorInfoRes = new GetDeptDoctorInfoResItems();
                getDeptDoctorInfoRes.setDoctorTitle(date.getTitleDc());
                getDeptDoctorInfoRes.setDeptCode(date.getDeptCode());
                getDeptDoctorInfoRes.setDeptName(date.getDeptName());
                getDeptDoctorInfoRes.setDoctorDesc(date.getSpecial());
                getDeptDoctorInfoRes.setImage(date.getImage());
                getDeptDoctorInfoRes.setRegFee(date.getRegFee().toString());
                getDeptDoctorInfoRes.setDoctorCode(date.getDocCode());
                getDeptDoctorInfoRes.setDoctorName(date.getDocName());
                getDeptDoctorInfoRes.setScheduleDate(date.getScheduleDate().substring(0, 10));
                getDeptDoctorInfoResItems.add(getDeptDoctorInfoRes);
            });
            getDeptDoctorInfoResVO.setItems(getDeptDoctorInfoResItems);
            return FrontResponse.success((String)param.getTransactionId(), (Object)getDeptDoctorInfoResVO);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u67e5\u8be2\u79d1\u5ba4\u6392\u73ed\u533b\u751f\u4fe1\u606f\u5f02\u5e38 {}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u67e5\u8be2\u79d1\u5ba4\u6392\u73ed\u533b\u751f\u4fe1\u606f\u5f02\u5e38");
        }
    }

    public FrontResponse<GetScheduleResVO> getSchedule(FrontRequest<GetScheduleReqVO> param) {
        log.info("\u67e5\u8be2\u533b\u751f\u6392\u73ed\u63a5\u53e3\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            GetScheduleReqVO body = (GetScheduleReqVO)param.getBody();
            HashMap<String, GetScheduleReqDTO> map = new HashMap<String, GetScheduleReqDTO>();
            GetScheduleReqDTO getScheduleReqDTO = new GetScheduleReqDTO();
            getScheduleReqDTO.setMethod("3203");
            getScheduleReqDTO.setEndDate(body.getEdDate());
            getScheduleReqDTO.setStartDate(body.getBgDate());
            getScheduleReqDTO.setDeptCode(body.getLocCode());
            map.put(EntityKeyEnum.SCHEDULE_SOURCE.getValue(), getScheduleReqDTO);
            String requestHisXml = XmlTemplateKit.process((String)MethodNameEnum.SCHEDULE_SOURCE.getValue(), map);
            log.info("\u6ce8\u518c\u5c31\u8bca\u5361\u5165\u53c2\uff1a" + requestHisXml);
            String hisRes = HttpUtil.post((String)"http://202.120.174.37:8090/Service.asmx/BaiYiInterface", (String)requestHisXml);
            log.info("his\u51fa\u53c2\uff1a" + hisRes);
            GetScheduleResDTO response = (GetScheduleResDTO)XmlUtil.convertToJavaBean((String)hisRes, GetScheduleResDTO.class);
            log.info("JAXB\u6267\u884c\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)response));
            if (null == response) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"JAXB\u6267\u884c\u5931\u8d25");
            }
            if (!SUCCESS_FLAG.equals(response.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getResultMsg());
            }
            GetScheduleResVO getScheduleResVO = new GetScheduleResVO();
            ArrayList GetScheduleItems = new ArrayList();
            if (null == response.getData()) {
                return FrontResponse.success((String)param.getTransactionId(), (Object)getScheduleResVO);
            }
            log.info("his\u67e5\u8be2\u6392\u73ed\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)response));
            List getScheduleItemsResDTOList = response.getData();
            getScheduleItemsResDTOList.stream().forEach(date -> {
                GetScheduleResItems getScheduleResItems = new GetScheduleResItems();
                getScheduleResItems.setScheduleId(date.getSchedualId());
                getScheduleResItems.setAdmDate(DataUtils.dealDateFormatNew((String)date.getScheduleDate()));
                getScheduleResItems.setLocCode(date.getDeptCode());
                getScheduleResItems.setLocName(date.getDeptName());
                getScheduleResItems.setDocCode(date.getDoctorCode());
                getScheduleResItems.setDocName(date.getDoctorName());
                if (date.getDoctorCode().equals("None")) {
                    getScheduleResItems.setDocCode(date.getDeptCode());
                    getScheduleResItems.setDocName(date.getDeptName());
                }
                getScheduleResItems.setRegTitleCode(date.getDoctorTitleCode());
                getScheduleResItems.setRegTitleName(date.getDoctorTitle());
                getScheduleResItems.setDiagFee(date.getMedicalFee());
                getScheduleResItems.setRegFee(date.getRegFee());
                getScheduleResItems.setRegAvailable(Integer.valueOf(date.getRegAvailable()));
                getScheduleResItems.setRegTitleCode(date.getDoctorTitleCode());
                getScheduleResItems.setRegTitleName(date.getDoctorTitle());
                getScheduleResItems.setAdmTimeRange(date.getTimeFlag());
                getScheduleResItems.setScheduleLevelCode(date.getScheduleLevelCode());
                getScheduleResItems.setScheduleLevelName(date.getScheduleLevelName());
                getScheduleResItems.setRegTotal(Integer.valueOf(date.getRegTotal()));
                getScheduleResItems.setIsTimeArrange(Integer.valueOf(1));
                getScheduleResItems.setScheduleStatus(date.getScheduleStatus());
                getScheduleResItems.setStartTime(DataUtils.dealDateFormatForTime((String)date.getBeginTime()));
                getScheduleResItems.setEndTime(DataUtils.dealDateFormatForTime((String)date.getEndTime()));
                GetScheduleItems.add(getScheduleResItems);
            });
            getScheduleResVO.setItems(GetScheduleItems);
            log.info("\u67e5\u8be2\u6392\u73ed\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)getScheduleResVO));
            return FrontResponse.success((String)param.getTransactionId(), (Object)getScheduleResVO);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u67e5\u8be2\u6392\u73ed\u4fe1\u606f\u5f02\u5e38 {}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u67e5\u8be2\u6392\u73ed\u4fe1\u606f\u5f02\u5e38");
        }
    }
}

