/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.hisfront.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.springframework.stereotype.Component;

@Component
public class DataUtils {
    public static final String FULL_FORMAT = "yyyy-MM-dd HH:mm:ss";

    public static String dealDateFormat(String oldDate) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        Date date = null;
        try {
            date = df.parse(oldDate);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        SimpleDateFormat df2 = new SimpleDateFormat(FULL_FORMAT);
        return df2.format(date);
    }

    public static String dealDateFormatNew(String oldDate) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd H:mm:ss");
        Date date = null;
        try {
            date = df.parse(oldDate);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        SimpleDateFormat df2 = new SimpleDateFormat("yyyy-MM-dd");
        return df2.format(date);
    }

    public static String dealDateFormatForTime(String timeDate) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        Date date = null;
        try {
            date = df.parse(timeDate);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        SimpleDateFormat df2 = new SimpleDateFormat("HH:mm");
        return df2.format(date);
    }

    public static Date getDateBefore(Date d, int day) {
        Calendar now = Calendar.getInstance();
        now.setTime(d);
        now.set(5, now.get(5) - day);
        return now.getTime();
    }

    public static Date getDateAfter(Date d, int day) {
        Calendar now = Calendar.getInstance();
        now.setTime(d);
        now.set(5, now.get(5) + day);
        return now.getTime();
    }

    public static String dateToSimpleString(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat(FULL_FORMAT);
        return df.format(date);
    }

    public static boolean judgeTime(String startStr, String endStr) {
        SimpleDateFormat df = new SimpleDateFormat(FULL_FORMAT);
        try {
            Date dt1 = df.parse(startStr);
            Date dt2 = df.parse(endStr);
            if (dt1.before(dt2)) {
                return true;
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return false;
    }
}

