/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.common.annotations;

import com.ebaiyihui.common.annotations.DesensitionType;
import com.ebaiyihui.common.annotations.DesensitizationFiled;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class})})
public class DesensitizationInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(DesensitizationInterceptor.class);
    private boolean desensitization = true;

    public Object intercept(Invocation invocation) throws Throwable {
        Object result = invocation.proceed();
        if (this.desensitization) {
            if (result instanceof ArrayList) {
                ArrayList list = (ArrayList)result;
                return this.desensitization(list);
            }
            return this.desensitization(result);
        }
        return result;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    private List desensitization(List list) {
        Class<?> cls = null;
        Field[] objFields = null;
        if (list != null && list.size() > 0) {
            for (Object o : list) {
                if (cls == null) {
                    cls = o.getClass();
                    objFields = cls.getDeclaredFields();
                }
                if (objFields == null) continue;
                for (Field field : objFields) {
                    List<String> regular;
                    DesensitizationFiled desensitization;
                    if ("serialVersionUID".equals(field.getName()) || String.class != field.getType() || (desensitization = field.getAnnotation(DesensitizationFiled.class)) == null) continue;
                    field.setAccessible(true);
                    String value = null;
                    try {
                        value = field.get(o) != null ? field.get(o).toString() : null;
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    if (value == null) continue;
                    DesensitionType type = desensitization.type();
                    switch (type) {
                        case CUSTOM: {
                            regular = Arrays.asList(desensitization.attach());
                            break;
                        }
                        case TRUNCATE: {
                            regular = this.truncateRender(desensitization.attach());
                            break;
                        }
                        default: {
                            regular = Arrays.asList(type.getRegular());
                        }
                    }
                    if (regular.size() <= 1) continue;
                    String match = regular.get(0);
                    String result = regular.get(1);
                    if (null == match || result == null || match.length() <= 0) continue;
                    value = value.replaceAll(match, result);
                    try {
                        field.set(o, value);
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return list;
    }

    private Object desensitization(Object obj) {
        Class<?> cls = null;
        Field[] objFields = null;
        if (obj != null && cls == null && (objFields = (cls = obj.getClass()).getDeclaredFields()) != null) {
            for (Field field : objFields) {
                List<String> regular;
                DesensitizationFiled desensitization;
                if ("serialVersionUID".equals(field.getName()) || String.class != field.getType() || (desensitization = field.getAnnotation(DesensitizationFiled.class)) == null) continue;
                field.setAccessible(true);
                String value = null;
                try {
                    value = field.get(obj) != null ? field.get(obj).toString() : null;
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                if (value == null) continue;
                DesensitionType type = desensitization.type();
                switch (type) {
                    case CUSTOM: {
                        regular = Arrays.asList(desensitization.attach());
                        break;
                    }
                    case TRUNCATE: {
                        regular = this.truncateRender(desensitization.attach());
                        break;
                    }
                    default: {
                        regular = Arrays.asList(type.getRegular());
                    }
                }
                if (regular.size() <= 1) continue;
                String match = regular.get(0);
                String result = regular.get(1);
                if (null == match || result == null || match.length() <= 0) continue;
                value = value.replaceAll(match, result);
                try {
                    field.set(obj, value);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
        return obj;
    }

    private List<String> truncateRender(String[] attachs) {
        ArrayList<String> regular = new ArrayList<String>();
        if (null != attachs && attachs.length > 1) {
            String result;
            String template;
            String rule = attachs[0];
            String size = attachs[1];
            if ("0".equals(rule)) {
                template = "^(\\S{%s})(\\S+)$";
                result = "$1";
            } else if ("1".equals(rule)) {
                template = "^(\\S+)(\\S{%s})$";
                result = "$2";
            } else {
                return regular;
            }
            try {
                if (Integer.parseInt(size) > 0) {
                    regular.add(0, String.format(template, size));
                    regular.add(1, result);
                }
            }
            catch (Exception e) {
                log.warn("ValueDesensitizeFilter truncateRender size:{} ", (Object)size);
            }
        }
        return regular;
    }

    public boolean isDesensitization() {
        return this.desensitization;
    }

    public void setDesensitization(boolean desensitization) {
        this.desensitization = desensitization;
    }
}

