/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.common.serializer;

import com.ebaiyihui.common.annotations.DesensitionType;
import com.ebaiyihui.common.annotations.DesensitizationFiled;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DesensitizationSerializer
extends JsonSerializer<String>
implements ContextualSerializer {
    private static final Logger log = LoggerFactory.getLogger(DesensitizationSerializer.class);
    private DesensitionType type;
    private String[] attach;

    public DesensitizationSerializer() {
    }

    public DesensitizationSerializer(DesensitionType type, String[] attach) {
        this.type = type;
        this.attach = attach;
    }

    public void serialize(String value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (value == null) {
            gen.writeNull();
            return;
        }
        String desensitizedValue = this.desensitizeValue(value, this.type, this.attach);
        gen.writeString(desensitizedValue);
    }

    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        DesensitizationFiled annotation;
        if (property != null && (annotation = (DesensitizationFiled)property.getAnnotation(DesensitizationFiled.class)) != null) {
            return new DesensitizationSerializer(annotation.type(), annotation.attach());
        }
        return this;
    }

    private String desensitizeValue(String value, DesensitionType type, String[] attach) {
        if (value == null || value.isEmpty() || type == null) {
            return value;
        }
        try {
            String[] regular = type.getRegular();
            switch (type) {
                case CUSTOM: {
                    if (attach != null && attach.length >= 2) {
                        return value.replaceAll(attach[0], attach[1]);
                    }
                    break;
                }
                case TRUNCATE: {
                    if (attach != null && attach.length > 0) {
                        try {
                            int length = Integer.parseInt(attach[0]);
                            return value.length() > length ? value.substring(0, length) + "..." : value;
                        }
                        catch (NumberFormatException e) {
                            log.warn("\u622a\u53d6\u957f\u5ea6\u53c2\u6570\u65e0\u6548: {}", (Object)attach[0]);
                        }
                    }
                    break;
                }
                default: {
                    if (regular != null && regular.length >= 2) {
                        return value.replaceAll(regular[0], regular[1]);
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error("\u8131\u654f\u503c\u5904\u7406\u5931\u8d25, value: {}, type: {}", new Object[]{value, type, e});
        }
        return value;
    }
}

