/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.alipay.api.internal.util.AlipayEncrypt;
import com.alipay.api.response.AlipayUserInfoShareResponse;
import com.ebaiyihui.common.enums.ErrorEnum;
import com.ebaiyihui.common.pojo.login.AlipayLoginReqVO;
import com.ebaiyihui.common.pojo.login.AlipayLoginRespVO;
import com.ebaiyihui.common.pojo.login.AlipayUserInfoReqVo;
import com.ebaiyihui.common.pojo.vo.AccountRegisterReqVO;
import com.ebaiyihui.common.pojo.vo.BaseIdRespVO;
import com.ebaiyihui.common.pojo.vo.CloudAccountLoginReqVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import com.ebaiyihui.server.enums.AccountEnums;
import com.ebaiyihui.server.enums.UserEnums;
import com.ebaiyihui.server.enums.WxAuthEnums;
import com.ebaiyihui.server.pojo.entity.UcAccountEntity;
import com.ebaiyihui.server.pojo.entity.UcAlipayAuthEntity;
import com.ebaiyihui.server.pojo.entity.UcAlipayConfigEntity;
import com.ebaiyihui.server.pojo.entity.UcPatientUserEntity;
import com.ebaiyihui.server.pojo.entity.UserEntity;
import com.ebaiyihui.server.pojo.vo.AlipayAuthReqVO;
import com.ebaiyihui.server.repository.AlipayAuthMapper;
import com.ebaiyihui.server.repository.UcAccountMapper;
import com.ebaiyihui.server.repository.UcPatientUserMapper;
import com.ebaiyihui.server.service.AlipayAuthService;
import com.ebaiyihui.server.service.AlipayConfigService;
import com.ebaiyihui.server.service.AlipayLoginService;
import com.ebaiyihui.server.service.IAccountService;
import com.ebaiyihui.server.service.impl.AccountServiceImpl;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AlipayLoginServiceImpl
implements AlipayLoginService {
    private static final Logger log = LoggerFactory.getLogger(AlipayLoginServiceImpl.class);
    @Autowired
    private AlipayConfigService alipayConfigService;
    @Autowired
    private AlipayAuthService alipayAuthService;
    @Autowired
    private AccountServiceImpl accountService;
    @Autowired
    private UcAccountMapper ucAccountMapper;
    @Autowired
    private AlipayAuthMapper alipayAuthMapper;
    @Autowired
    private UcPatientUserMapper ucPatientUserMapper;
    @Autowired
    private IAccountService iAccountService;

    public BaseResponse alipayLogin(String ip, AlipayLoginReqVO alipayLoginReqVO, String source) {
        String phone = null;
        AlipayAuthReqVO alipayAuthReqVO = new AlipayAuthReqVO();
        alipayAuthReqVO.setAppCode(alipayLoginReqVO.getAppCode());
        alipayAuthReqVO.setCode(alipayLoginReqVO.getCode());
        BaseResponse userInfoShareResponseBaseResponse = this.alipayAuthService.alipayAuth(alipayAuthReqVO);
        AlipayUserInfoShareResponse response = (AlipayUserInfoShareResponse)userInfoShareResponseBaseResponse.getData();
        log.info("\u652f\u4ed8\u5b9d\u83b7\u53d6\u4e2a\u4eba\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)response));
        if (null == phone) {
            phone = response.getMobile();
        }
        UcAccountEntity ucAccountEntity = null;
        try {
            ucAccountEntity = this.ucAccountMapper.selectByUserTypeAndAppCodeAndAccountNoOrRelatedMobileNumber(Short.valueOf(alipayLoginReqVO.getUserType().shortValue()), alipayLoginReqVO.getAppCode(), phone);
        }
        catch (Exception e) {
            log.error("\u51fa\u73b0\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
            return BaseResponse.error((String)"\u8d26\u6237\u67e5\u8be2\u5931\u8d25");
        }
        UcAlipayAuthEntity ucAlipayAuthEntity = new UcAlipayAuthEntity();
        Optional alipayUserIdOptional = this.alipayAuthService.findByAlipayUserIdAndUserTypeAndAppCodeAndStatus(response.getUserId(), alipayLoginReqVO.getUserType(), alipayLoginReqVO.getAppCode(), Integer.valueOf(WxAuthEnums.WxAuthStatusEnum.NORMAL.getValue().intValue()));
        UcPatientUserEntity patientUserEntity = new UcPatientUserEntity();
        if (!Objects.isNull(ucAccountEntity) && alipayUserIdOptional.isPresent()) {
            if (!UserEnums.UserStatusEnum.NORMAL.getUserStatusValue().equals(ucAccountEntity.getStatus()) && !UserEnums.UserStatusEnum.IMPERFECT.getUserStatusValue().equals(ucAccountEntity.getStatus())) {
                return BaseResponse.error((String)"\u8d26\u53f7\u5df2\u7981\u7528\uff0c\u65e0\u6cd5\u767b\u9646");
            }
            ucAlipayAuthEntity = (UcAlipayAuthEntity)alipayUserIdOptional.get();
            ucAlipayAuthEntity.setAccountId(ucAccountEntity.getAccountId());
            ucAlipayAuthEntity.setAppCode(ucAccountEntity.getAppCode());
            ucAlipayAuthEntity.setHeadPortrait(response.getAvatar());
            ucAlipayAuthEntity.setNickname(response.getNickName());
            ucAlipayAuthEntity.setStatus(Integer.valueOf(1));
            ucAlipayAuthEntity.setSubordinateType(alipayLoginReqVO.getSubordinateType());
            ucAlipayAuthEntity.setUserId(ucAccountEntity.getUserId());
            ucAlipayAuthEntity.setUserType(Integer.valueOf(ucAccountEntity.getUserType().intValue()));
            this.alipayAuthMapper.updateByPrimaryKeySelective(ucAlipayAuthEntity);
        }
        if (!Objects.isNull(ucAccountEntity) && !alipayUserIdOptional.isPresent()) {
            if (!UserEnums.UserStatusEnum.NORMAL.getUserStatusValue().equals(ucAccountEntity.getStatus()) && !UserEnums.UserStatusEnum.IMPERFECT.getUserStatusValue().equals(ucAccountEntity.getStatus())) {
                return BaseResponse.error((String)"\u8d26\u53f7\u5df2\u7981\u7528\uff0c\u65e0\u6cd5\u767b\u9646");
            }
            ucAlipayAuthEntity.setAccountId(ucAccountEntity.getAccountId());
            ucAlipayAuthEntity.setAppCode(ucAccountEntity.getAppCode());
            ucAlipayAuthEntity.setHeadPortrait(response.getAvatar());
            ucAlipayAuthEntity.setNickname(response.getNickName());
            ucAlipayAuthEntity.setStatus(Integer.valueOf(1));
            ucAlipayAuthEntity.setSubordinateType(alipayLoginReqVO.getSubordinateType());
            ucAlipayAuthEntity.setUserId(ucAccountEntity.getUserId());
            ucAlipayAuthEntity.setUserType(Integer.valueOf(ucAccountEntity.getUserType().intValue()));
            ucAlipayAuthEntity.setAlipayUserId(response.getUserId());
            this.alipayAuthMapper.insert(ucAlipayAuthEntity);
        }
        if (Objects.isNull(ucAccountEntity) && !alipayUserIdOptional.isPresent()) {
            AccountRegisterReqVO registerReqVO = new AccountRegisterReqVO();
            BeanUtils.copyProperties((Object)alipayLoginReqVO, (Object)registerReqVO);
            registerReqVO.setPassword("123456");
            registerReqVO.setIgnorePassword(true);
            registerReqVO.setAccountNo(phone);
            registerReqVO.setUserType(Short.valueOf(alipayLoginReqVO.getUserType().shortValue()));
            registerReqVO.setContactMobile(phone);
            registerReqVO.setAccountType(Short.valueOf((short)0));
            BaseResponse register = this.iAccountService.register(registerReqVO);
            if (!register.isSuccess()) {
                BaseResponse.error((IError)ErrorEnum.LOGIN_WX_ERROR);
            }
            BaseIdRespVO data = (BaseIdRespVO)register.getData();
            ucAccountEntity = this.ucAccountMapper.selectByUserTypeAndAppCodeAndStatusAndAccountNoOrRelatedMobileNumber(Short.valueOf(alipayLoginReqVO.getUserType().shortValue()), alipayLoginReqVO.getAppCode(), AccountEnums.AccountStatusEnum.NORMAL.getValue(), phone);
            if (ucAccountEntity == null) {
                BaseResponse.error((IError)ErrorEnum.LOGIN_WX_ERROR);
            }
            patientUserEntity.setUserId(data.getUserId());
            patientUserEntity.setContactMobile(phone);
            if (UserEnums.UserTypeEnum.PATIENT.getUserTypeValue().equals(alipayLoginReqVO.getUserType())) {
                Optional userEntityOptional = this.ucPatientUserMapper.findByUserId(data.getUserId());
                if (!userEntityOptional.isPresent()) {
                    BaseResponse.error((IError)ErrorEnum.LOGIN_WX_ERROR);
                }
                if (userEntityOptional.isPresent()) {
                    patientUserEntity = (UcPatientUserEntity)userEntityOptional.get();
                }
            }
            ucAlipayAuthEntity.setAccountId(data.getAccountId());
            ucAlipayAuthEntity.setAppCode(alipayLoginReqVO.getAppCode());
            ucAlipayAuthEntity.setHeadPortrait(response.getAvatar());
            ucAlipayAuthEntity.setNickname(response.getNickName());
            ucAlipayAuthEntity.setStatus(Integer.valueOf(1));
            ucAlipayAuthEntity.setSubordinateType(alipayLoginReqVO.getSubordinateType());
            ucAlipayAuthEntity.setUserId(data.getUserId());
            ucAlipayAuthEntity.setUserType(Integer.valueOf(alipayLoginReqVO.getUserType()));
            ucAlipayAuthEntity.setAlipayUserId(response.getUserId());
            this.alipayAuthMapper.insert(ucAlipayAuthEntity);
        }
        if (Objects.nonNull(ucAccountEntity)) {
            UserEntity userEntity = new UserEntity();
            userEntity.setUserId(ucAccountEntity.getUserId());
            userEntity.setUserStatus(ucAccountEntity.getStatus());
            return this.createAlipayLoginReqVO(ucAccountEntity, patientUserEntity, ucAlipayAuthEntity, alipayLoginReqVO, ip, source);
        }
        return BaseResponse.error((String)"\u767b\u9646\u5931\u8d25\uff01");
    }

    public BaseResponse<AlipayUserInfoShareResponse> alipayUserinfo(AlipayUserInfoReqVo alipayUserInfoReqVo) {
        AlipayAuthReqVO alipayAuthReqVO = new AlipayAuthReqVO();
        alipayAuthReqVO.setCode(alipayUserInfoReqVo.getCode());
        alipayAuthReqVO.setAppCode(alipayUserInfoReqVo.getAppCode());
        BaseResponse userInfoShareResponseBaseResponse = this.alipayAuthService.alipayAuth(alipayAuthReqVO);
        AlipayUserInfoShareResponse response = (AlipayUserInfoShareResponse)userInfoShareResponseBaseResponse.getData();
        return BaseResponse.success((Object)response);
    }

    public String alipayDncrypData(String encrypData, UcAlipayConfigEntity entity) throws Exception {
        log.info("\u652f\u4ed8\u5b9d\u624b\u673a\u53f7\u89e3\u6790\u5165\u53c2\uff1a{}", (Object)encrypData);
        String charset = "UTF-8";
        String encryptType = "AES";
        String content = JSON.parseObject((String)encrypData).get((Object)"response").toString();
        log.info("\u5f00\u59cb\u89e3\u5bc6:{}", (Object)content);
        String plainData = null;
        plainData = AlipayEncrypt.decryptContent((String)content, (String)encryptType, (String)entity.getSecret(), (String)charset);
        log.info("\u89e3\u5bc6\u7ed3\u679c:{}", (Object)plainData);
        return plainData;
    }

    private BaseResponse<AlipayLoginRespVO> createAlipayLoginReqVO(UcAccountEntity ucAccountEntity, UcPatientUserEntity patientUserEntity, UcAlipayAuthEntity ucAlipayAuthEntity, AlipayLoginReqVO alipayLoginReqVO, String ip, String source) {
        CloudAccountLoginReqVO accountLoginReqVO = new CloudAccountLoginReqVO();
        accountLoginReqVO.setLoginDeviceNum(alipayLoginReqVO.getLoginDeviceNum());
        accountLoginReqVO.setLoginDeviceType(alipayLoginReqVO.getLoginDeviceType());
        accountLoginReqVO.setAppCode(alipayLoginReqVO.getAppCode());
        accountLoginReqVO.setChannelCode(alipayLoginReqVO.getChannelCode());
        accountLoginReqVO.setLoginIp(ip);
        String tokenKey = this.accountService.loginInfoValid(accountLoginReqVO, ucAccountEntity);
        String loginToken = this.accountService.genLoginToken(accountLoginReqVO, ucAccountEntity, tokenKey, source);
        AlipayLoginRespVO phoneLoginRespVO = new AlipayLoginRespVO();
        phoneLoginRespVO.setAccountId(ucAccountEntity.getAccountId());
        phoneLoginRespVO.setAccountStatus(patientUserEntity.getUserStatus());
        phoneLoginRespVO.setAccountType(ucAccountEntity.getAccountType());
        phoneLoginRespVO.setAlipayUserId(ucAlipayAuthEntity.getAlipayUserId());
        phoneLoginRespVO.setContactMobile(ucAccountEntity.getRelatedMobileNumber());
        phoneLoginRespVO.setHeadPortrait(ucAlipayAuthEntity.getHeadPortrait());
        phoneLoginRespVO.setAppCode(ucAccountEntity.getAppCode());
        phoneLoginRespVO.setIsActive(ucAccountEntity.getIsActive());
        phoneLoginRespVO.setNickname(ucAlipayAuthEntity.getNickname());
        phoneLoginRespVO.setUserId(ucAccountEntity.getUserId());
        phoneLoginRespVO.setSubordinateType(ucAlipayAuthEntity.getSubordinateType());
        phoneLoginRespVO.setUserType(Integer.valueOf(ucAccountEntity.getUserType().intValue()));
        phoneLoginRespVO.setStatus(Integer.valueOf(ucAccountEntity.getStatus().intValue()));
        phoneLoginRespVO.setToken(loginToken);
        return BaseResponse.success((Object)phoneLoginRespVO);
    }
}

