/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.HttpUtils;
import com.ebaiyihui.server.config.SettingConfig;
import com.ebaiyihui.server.pojo.entity.UcWxAppletConfigEntity;
import com.ebaiyihui.server.pojo.vo.GetFaceInfoAgainRespVo;
import com.ebaiyihui.server.pojo.vo.GetUserIdKeyRespVo;
import com.ebaiyihui.server.pojo.vo.GetWxAccessTokenRespVo;
import com.ebaiyihui.server.pojo.vo.GetWxUserIdKeyReqVo;
import com.ebaiyihui.server.repository.UcWxAppletConfigMapper;
import com.ebaiyihui.server.service.WxFaceRecognitionService;
import com.ebaiyihui.server.util.RedisUtil;
import java.util.HashMap;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WxFaceRecognitionServiceImpl
implements WxFaceRecognitionService {
    private static final Logger log = LoggerFactory.getLogger(WxFaceRecognitionServiceImpl.class);
    @Autowired
    private UcWxAppletConfigMapper ucWxAppletConfigMapper;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    SettingConfig settingConfig;

    public BaseResponse<GetUserIdKeyRespVo> getUserIdKey(GetWxUserIdKeyReqVo getWxUserIdKeyReqVo) {
        if (this.settingConfig.getTestMode().booleanValue()) {
            GetUserIdKeyRespVo respVo = new GetUserIdKeyRespVo();
            respVo.setErrcode(0);
            respVo.setErrmsg("ok");
            return BaseResponse.success((Object)respVo);
        }
        String wxAccessToken = this.getWxAccessToken(getWxUserIdKeyReqVo.getAppCode());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", getWxUserIdKeyReqVo.getName());
        map.put("id_card_number", getWxUserIdKeyReqVo.getIdCard());
        String body = JSON.toJSONString(map);
        log.info("\u8bf7\u6c42\u7684\u53c2\u6570\u4e3a:{}", (Object)body);
        try {
            String ret = HttpUtils.post((String)("https://api.weixin.qq.com/cityservice/face/identify/getuseridkey?access_token=" + wxAccessToken), (String)body);
            log.info("\u4e0a\u4f20\u7528\u6237\u8eab\u4efd\u4fe1\u606f\u8fd4\u56de\u7ed3\u679c\u4e3a:{}", (Object)ret);
            if (StringUtils.isEmpty((String)ret)) {
                return BaseResponse.error((String)"\u4e0a\u4f20\u8eab\u4efd\u8bc1\u4fe1\u606f\u5f02\u5e38");
            }
            GetUserIdKeyRespVo getUserIdKeyRespVo = (GetUserIdKeyRespVo)JSON.parseObject((String)ret, GetUserIdKeyRespVo.class);
            if (getUserIdKeyRespVo.getErrcode() != 0) {
                return BaseResponse.error((String)getUserIdKeyRespVo.getErrmsg());
            }
            return BaseResponse.success((Object)getUserIdKeyRespVo);
        }
        catch (Exception e) {
            throw new RuntimeException("\u4e0a\u4f20\u8eab\u4efd\u8bc1\u4fe1\u606f\u5f02\u5e38");
        }
    }

    public BaseResponse<GetFaceInfoAgainRespVo> getFaceInfoAgain(String verifyResult, String appCode) {
        if (this.settingConfig.getTestMode().booleanValue()) {
            GetFaceInfoAgainRespVo respVo = new GetFaceInfoAgainRespVo();
            respVo.setErrcode(0);
            respVo.setErrmsg("ok");
            return BaseResponse.success((Object)respVo);
        }
        String wxAccessToken = this.getWxAccessToken(appCode);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("verify_result", verifyResult);
        String body = JSON.toJSONString(map);
        try {
            String ret = HttpUtils.post((String)("https://api.weixin.qq.com/cityservice/face/identify/getinfo?access_token=" + wxAccessToken), (String)body);
            log.info("\u83b7\u53d6\u91cd\u590d\u83b7\u53d6\u6838\u8eab\u7ed3\u679c\u7684\u8fd4\u56de\u503c\u4e3a:{}", (Object)ret);
            if (StringUtils.isEmpty((String)ret)) {
                return BaseResponse.error((String)"\u518d\u6b21\u83b7\u53d6\u6838\u9a8c\u7ed3\u679c\u5f02\u5e38");
            }
            GetFaceInfoAgainRespVo getFaceInfoAgainRespVo = (GetFaceInfoAgainRespVo)JSON.parseObject((String)ret, GetFaceInfoAgainRespVo.class);
            if (getFaceInfoAgainRespVo.getErrcode() != 0) {
                return BaseResponse.error((String)getFaceInfoAgainRespVo.getErrmsg());
            }
            return BaseResponse.success((Object)getFaceInfoAgainRespVo);
        }
        catch (Exception e) {
            throw new RuntimeException("\u518d\u6b21\u83b7\u53d6\u6838\u9a8c\u7ed3\u679c\u5f02\u5e38");
        }
    }

    private String getWxAccessToken(String appCode) {
        Optional ucWxAppletConfigEntity1;
        String accessToken = (String)this.redisUtil.get("wx_access_token_key_" + appCode);
        if (StringUtils.isEmpty((String)accessToken) && (ucWxAppletConfigEntity1 = this.ucWxAppletConfigMapper.selectByAppIdType(appCode)).isPresent()) {
            UcWxAppletConfigEntity ucWxAppletConfigEntity = (UcWxAppletConfigEntity)ucWxAppletConfigEntity1.get();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("grant_type", "client_credential");
            map.put("appid", ucWxAppletConfigEntity.getAppletId());
            map.put("secret", ucWxAppletConfigEntity.getAppletSecret());
            String ret = HttpUtils.get((String)"https://api.weixin.qq.com/cgi-bin/token", map);
            log.info("\u83b7\u53d6\u5fae\u4fe1token\u8fd4\u56de\u7ed3\u679c:{}", (Object)ret);
            if (StringUtils.isEmpty((String)ret)) {
                return accessToken;
            }
            GetWxAccessTokenRespVo getWxAccessTokenRespVo = (GetWxAccessTokenRespVo)JSON.parseObject((String)ret, GetWxAccessTokenRespVo.class);
            if (getWxAccessTokenRespVo.getErrcode() != 0) {
                log.error("\u83b7\u53d6\u5fae\u4fe1token\u5931\u8d25:{}", (Object)getWxAccessTokenRespVo.getErrmsg());
                return accessToken;
            }
            accessToken = getWxAccessTokenRespVo.getAccess_token();
        }
        return accessToken;
    }
}

