/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.service.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.client.RoleClient;
import com.ebaiyihui.common.enums.ErrorEnum;
import com.ebaiyihui.common.enums.LoginDeviceType;
import com.ebaiyihui.common.pojo.login.BaseUserCenterIdRespVO;
import com.ebaiyihui.common.pojo.login.CheckAccountRepeatReqVO;
import com.ebaiyihui.common.pojo.login.CheckAccountRepeatRespVO;
import com.ebaiyihui.common.pojo.login.CusSmsLoginReqVO;
import com.ebaiyihui.common.pojo.login.ManagerUserLoginReqVO;
import com.ebaiyihui.common.pojo.login.PatientRigisterReqVO;
import com.ebaiyihui.common.pojo.login.SmsLoginReqVO;
import com.ebaiyihui.common.pojo.login.UserLoginReqVO;
import com.ebaiyihui.common.pojo.login.UserRigisterReqVO;
import com.ebaiyihui.common.pojo.login.WeChatLoginReqVO;
import com.ebaiyihui.common.pojo.login.WechatRespVO;
import com.ebaiyihui.common.pojo.login.WxBindingReqVo;
import com.ebaiyihui.common.pojo.login.WxPhoneLoginReqVO;
import com.ebaiyihui.common.pojo.login.WxPhoneLoginRespVO;
import com.ebaiyihui.common.pojo.vo.AccountLoginReqVO;
import com.ebaiyihui.common.pojo.vo.AccountLoginRespVO;
import com.ebaiyihui.common.pojo.vo.AccountLogoutIReqVO;
import com.ebaiyihui.common.pojo.vo.AccountLogoutReqVO;
import com.ebaiyihui.common.pojo.vo.AccountNoCheckReqVO;
import com.ebaiyihui.common.pojo.vo.AccountNoCheckRespVO;
import com.ebaiyihui.common.pojo.vo.AccountNoUpdateReqVO;
import com.ebaiyihui.common.pojo.vo.AccountOperateBaseReqVO;
import com.ebaiyihui.common.pojo.vo.AccountPasswordUpdateReqVO;
import com.ebaiyihui.common.pojo.vo.AccountRegisterBaseReqVO;
import com.ebaiyihui.common.pojo.vo.AccountRegisterReqVO;
import com.ebaiyihui.common.pojo.vo.BaseIdRespVO;
import com.ebaiyihui.common.pojo.vo.CloudAccountLoginReqVO;
import com.ebaiyihui.common.pojo.vo.GetbackPasswordReqVO;
import com.ebaiyihui.common.pojo.vo.LoginOrRegisterReqVo;
import com.ebaiyihui.common.pojo.vo.LoginWithMailReqVo;
import com.ebaiyihui.common.pojo.vo.RegisterWithMailReqVo;
import com.ebaiyihui.common.pojo.vo.ResetPasswordReqVO;
import com.ebaiyihui.common.pojo.vo.UpdateLoginPhoneBySmsReqVO;
import com.ebaiyihui.common.pojo.vo.UpdatePasswordReqVO;
import com.ebaiyihui.common.pojo.vo.UpdatePasswordV3ReqVO;
import com.ebaiyihui.common.pojo.vo.UserCenterBaseReqVO;
import com.ebaiyihui.common.pojo.vo.UserInfoRespVO;
import com.ebaiyihui.common.pojo.vo.push.MailVerificationReqVo;
import com.ebaiyihui.common.token.TokenBody;
import com.ebaiyihui.common.token.TokenJson;
import com.ebaiyihui.common.token.UserCenterTokenParseUtil;
import com.ebaiyihui.common.token.exception.TokenParseException;
import com.ebaiyihui.common.vo.role.RoleInfoVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import com.ebaiyihui.framework.utils.JsonUtil;
import com.ebaiyihui.framework.utils.PasswordAndSalt;
import com.ebaiyihui.framework.utils.PasswordUtil;
import com.ebaiyihui.framework.utils.RegexUtils;
import com.ebaiyihui.server.enums.AccountEnums;
import com.ebaiyihui.server.enums.CommonEnums;
import com.ebaiyihui.server.enums.ManagerUserEnums;
import com.ebaiyihui.server.enums.PushCenterContants;
import com.ebaiyihui.server.enums.UserEnums;
import com.ebaiyihui.server.enums.WxAuthEnums;
import com.ebaiyihui.server.exception.UserCenterRuntimeException;
import com.ebaiyihui.server.pojo.entity.UcAccountEntity;
import com.ebaiyihui.server.pojo.entity.UcAccountOperateEntity;
import com.ebaiyihui.server.pojo.entity.UcCommunityUserEntity;
import com.ebaiyihui.server.pojo.entity.UcDoctorUserEntity;
import com.ebaiyihui.server.pojo.entity.UcLoginRecordEntity;
import com.ebaiyihui.server.pojo.entity.UcManagerUserEntity;
import com.ebaiyihui.server.pojo.entity.UcOrganUserEntity;
import com.ebaiyihui.server.pojo.entity.UcPatientInfoEntity;
import com.ebaiyihui.server.pojo.entity.UcPatientOperateEntity;
import com.ebaiyihui.server.pojo.entity.UcPatientUserEntity;
import com.ebaiyihui.server.pojo.entity.UcWxAuthEntity;
import com.ebaiyihui.server.pojo.entity.UserEntity;
import com.ebaiyihui.server.pojo.vo.AndroidUnicastReqVO;
import com.ebaiyihui.server.pojo.vo.IOSUnicastReqVO;
import com.ebaiyihui.server.pojo.vo.SmsVerifiAuthCodeReqVO;
import com.ebaiyihui.server.repository.UcAccountOperateMapper;
import com.ebaiyihui.server.repository.UcWxAuthMapper;
import com.ebaiyihui.server.service.BaseService;
import com.ebaiyihui.server.service.IAccountService;
import com.ebaiyihui.server.service.IMessageService;
import com.ebaiyihui.server.service.IUcWxAuthService;
import com.ebaiyihui.server.service.IUserService;
import com.ebaiyihui.server.util.RedisUtil;
import com.ebaiyihui.server.util.Tokenutil;
import com.netflix.hystrix.exception.HystrixRuntimeException;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class AccountServiceImpl
extends BaseService
implements IAccountService {
    public static final String LOGGING_STORED_URL = "/cloud/sysinfocloud/operationlog/insertOperationLog";
    private static final String SOURCE = "management";
    @Autowired
    private IUserService userService;
    @Autowired
    private IMessageService messageService;
    @Autowired
    private UcWxAuthMapper accountUcWxAuthMapper;
    @Autowired
    private IUcWxAuthService wxAuthService;
    @Resource
    private RedisUtil accountRedisUtil;
    @Autowired
    private UcAccountOperateMapper accountOperateMapper;
    @Autowired
    private RoleClient roleClient;
    public static final String JWT_SECRET = "hxgy-ehospital";
    private static final String NOPWORDSTATUS = "NO_PASSWORD_STATUS";
    private static final String UNUSEFUL_MESSAGE = "\u672a\u83b7\u53d6\u5230\u6709\u6548\u7684\u7528\u6237\u4fe1\u606f,\u8bf7\u6c42\u4fe1\u606f{}";
    private static final String INVALID_PWORD = "INVALID_PASSWORD_";
    private static final String LOCK_ACCOUNT = "===\u9501\u5b9a\u8d26\u53f7\u4e24\u5c0f\u65f6===\u5bc6\u7801\u9519\u8bef==";
    private static final String LOGIN_V2 = "loginV2";
    private static final String ACCOUNT_SAFE = "\u60a8\u7684\u8d26\u6237\u6b63\u5728\u5176\u4ed6\u8bbe\u5907\u767b\u5f55\uff0c\u82e5\u975e\u672c\u4eba\u64cd\u4f5c\u8bf7\u6ce8\u610f\u8d26\u6237\u5b89\u5168\u3002";
    private static final String INVALID_MESSAGE = "\u8d26\u6237\u767b\u9646\uff0c\u8c03\u7528\u63a8\u9001\u670d\u52a1\uff0c\u6821\u9a8c\u77ed\u4fe1\u9a8c\u8bc1\u7801\uff0c\u8bf7\u6c42\u53c2\u6570{}";
    private static final String UNKNOW = "unknown";

    public BaseResponse<AccountLoginRespVO> login(UserLoginReqVO userLoginReqVO, String source) {
        this.log.info("\u5bc6\u7801\u767b\u5f55 \u5165\u53c2:{}", (Object)JSON.toJSONString((Object)userLoginReqVO));
        this.verifyVercode_web_manager(userLoginReqVO.getVercodeKey(), userLoginReqVO.getVercodeValue(), userLoginReqVO.getLoginDeviceType(), userLoginReqVO.getUserType(), userLoginReqVO.getLoginIp(), userLoginReqVO.getAccountNo(), userLoginReqVO.getAppCode());
        List list = this.ucAccountMapper.selectListByUserTypeAndAppCodeAndStatusAndAccountNoOrLoginName(userLoginReqVO.getUserType(), userLoginReqVO.getAppCode(), UserEnums.UserStatusEnum.NORMAL.getUserStatusValue(), userLoginReqVO.getAccountNo());
        UcAccountEntity accountEntity = null;
        if (list == null || list.isEmpty()) {
            return BaseResponse.error((IError)ErrorEnum.NO_EXISTS_ACCOUNT_2);
        }
        if (list != null && list.size() == 1) {
            UcAccountEntity accountEn = (UcAccountEntity)list.get(0);
            if (NOPWORDSTATUS.equals(accountEn.getPwSalt()) && NOPWORDSTATUS.equals(accountEn.getAccountPw())) {
                return BaseResponse.error((IError)ErrorEnum.NO_PASSWORD);
            }
            String pwSalt = accountEn.getPwSalt();
            String mix = PasswordUtil.mix((String)userLoginReqVO.getPassword(), (String)pwSalt);
            if (mix.equals(accountEn.getAccountPw())) {
                accountEntity = accountEn;
            }
        }
        if (list != null && list.size() > 1) {
            for (UcAccountEntity accountEn : list) {
                String pwSalt = accountEn.getPwSalt();
                String mix = PasswordUtil.mix((String)userLoginReqVO.getPassword(), (String)pwSalt);
                if (!mix.equals(accountEn.getAccountPw())) continue;
                accountEntity = accountEn;
            }
        }
        if (accountEntity == null) {
            return BaseResponse.error((IError)ErrorEnum.NO_EXISTS_ACCOUNT_2);
        }
        UserEntity userEntity = this.userService.getUserEntity(accountEntity.getUserId(), accountEntity.getUserType());
        if (userEntity == null) {
            this.log.warn(UNUSEFUL_MESSAGE, (Object)JSON.toJSONString((Object)userLoginReqVO));
            return BaseResponse.error((IError)ErrorEnum.USER_NOT_EXIT);
        }
        return this.postLoginHander(accountEntity, userEntity, (CloudAccountLoginReqVO)userLoginReqVO, source);
    }

    public BaseResponse<AccountLoginRespVO> loginV2(UserLoginReqVO reqVO, String source) {
        this.log.info("====loginV2\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqVO));
        this.verifyVercode_web_manager(reqVO.getVercodeKey(), reqVO.getVercodeValue(), reqVO.getLoginDeviceType(), reqVO.getUserType(), reqVO.getLoginIp(), reqVO.getAccountNo(), reqVO.getAppCode());
        return this.managerLoginHandler(reqVO, source);
    }

    public BaseResponse<AccountLoginRespVO> loginManagerWithpwAndsmscode(ManagerUserLoginReqVO reqVO, String source) {
        SmsVerifiAuthCodeReqVO sms = new SmsVerifiAuthCodeReqVO();
        sms.setAuthCode(reqVO.getAuthCode());
        sms.setAuthKey(reqVO.getAuthKey());
        sms.setPhoneNum(reqVO.getAccountNo());
        super.verifialismsauthcode(sms);
        return this.managerLoginHandler((UserLoginReqVO)reqVO, source);
    }

    private BaseResponse<AccountLoginRespVO> managerLoginHandler(UserLoginReqVO reqVO, String source) {
        UcAccountEntity accountEntity;
        String userId;
        Optional optional;
        Optional entityOptional;
        int action = this.checkAccountNo(reqVO.getAppCode(), reqVO.getUserType(), reqVO.getAccountNo(), Boolean.valueOf(true));
        if (0 == action) {
            return BaseResponse.error((IError)ErrorEnum.NO_EXISTS_ACCOUNT);
        }
        if (2 == action) {
            return BaseResponse.error((IError)ErrorEnum.DISABLED_ACCOUNT);
        }
        UcManagerUserEntity ucManagerUserEntity = null;
        if (UserEnums.UserTypeEnum.MANAGER.getUserTypeValue().equals(reqVO.getUserType())) {
            this.log.info("\u5224\u65ad\u8d26\u53f7\u9501\u5b9a==" + reqVO.getAccountNo());
            String INVALID_PASSWORD_KEY = INVALID_PWORD.concat(reqVO.getAccountNo()).concat("_").concat(String.valueOf(reqVO.getUserType()));
            String accountLockKey = "ACCOUNTNO_LOCKING_".concat(reqVO.getAccountNo()).concat("_").concat(String.valueOf(reqVO.getUserType()));
            Object invalidPasswordValue = this.accountRedisUtil.get(INVALID_PASSWORD_KEY);
            if (invalidPasswordValue instanceof Integer && (Integer)invalidPasswordValue >= 6) {
                this.accountRedisUtil.set(accountLockKey, (Object)reqVO.getAccountNo(), 30L, TimeUnit.MINUTES);
                return BaseResponse.error((IError)ErrorEnum.ACCOUNT_LOCKING);
            }
            Object accountLock = this.accountRedisUtil.get(accountLockKey);
            if (accountLock != null) {
                long expire = this.accountRedisUtil.getExpire(accountLockKey);
                return BaseResponse.error((IError)ErrorEnum.ACCOUNT_LOCKING, (String)("\u5bc6\u7801\u767b\u5f55\u8fde\u7eed\u9519\u8bef\u591a\u6b21,\u8bf7" + expire / 60L + "\u5206\u949f\u540e\u91cd\u8bd5\u6216\u5207\u6362\u81f3\u5176\u4ed6\u65b9\u5f0f\u767b\u5f55"));
            }
        }
        if (UserEnums.UserTypeEnum.MANAGER.getUserTypeValue().equals(reqVO.getUserType()) && (entityOptional = this.ucAccountMapper.selectByAccountNoAndUserTypeAndAppCodeAndStatus(reqVO.getAccountNo(), reqVO.getUserType(), reqVO.getAppCode(), AccountEnums.AccountStatusEnum.NORMAL.getValue())).isPresent() && (optional = this.ucManagerUserMapper.selectByUserId(userId = (accountEntity = (UcAccountEntity)entityOptional.get()).getUserId())).isPresent()) {
            ucManagerUserEntity = (UcManagerUserEntity)optional.get();
            if (ManagerUserEnums.IsActiveEnum.NO.getValue().equals(ucManagerUserEntity.getIsActive())) {
                String mix = PasswordUtil.mix((String)reqVO.getPassword(), (String)accountEntity.getPwSalt());
                String INVALID_PASSWORD_KEY = INVALID_PWORD.concat(reqVO.getAccountNo()).concat("_").concat(String.valueOf(reqVO.getUserType()));
                if (!mix.equals(accountEntity.getAccountPw())) {
                    Object accountNoLockValue = this.accountRedisUtil.get(INVALID_PASSWORD_KEY);
                    this.log.info(LOCK_ACCOUNT + accountNoLockValue + "\u79d2");
                    if (accountNoLockValue instanceof Integer) {
                        int LockValue = (Integer)accountNoLockValue + 1;
                        long expire = this.accountRedisUtil.getExpire(INVALID_PASSWORD_KEY);
                        this.log.info(LOCK_ACCOUNT + expire + "\u79d2");
                        this.accountRedisUtil.set(INVALID_PASSWORD_KEY, (Object)LockValue, expire, TimeUnit.SECONDS);
                    } else {
                        int LockValue = 1;
                        this.accountRedisUtil.set(INVALID_PASSWORD_KEY, (Object)LockValue, 10L, TimeUnit.MINUTES);
                    }
                    return BaseResponse.error((IError)ErrorEnum.INVALID_PASSWORD);
                }
                this.accountRedisUtil.del(new String[]{INVALID_PASSWORD_KEY});
                String actionAuthKey = super.getUsercenterActionAuthKey(reqVO.getAccountNo(), LOGIN_V2);
                AccountLoginRespVO accountLoginRespVO = new AccountLoginRespVO();
                BeanUtils.copyProperties((Object)reqVO, (Object)accountLoginRespVO);
                accountLoginRespVO.setIsActive(ManagerUserEnums.IsActiveEnum.NO.getValue());
                accountLoginRespVO.setUserCenterActionAuthKey(actionAuthKey);
                accountLoginRespVO.setUserCenterActionName(LOGIN_V2);
                this.log.info("\u7ba1\u7406\u5458\u8d26\u6237\u672a\u6fc0\u6d3b,userLoginRespVO:{}", (Object)JSON.toJSONString((Object)accountLoginRespVO));
                return BaseResponse.success((Object)accountLoginRespVO);
            }
        }
        if (Objects.nonNull(ucManagerUserEntity)) {
            this.log.info("====loginV2====\u6b63\u5e38\u767b\u5f55");
            return this.loginV2Posthandler(ucManagerUserEntity, reqVO, source);
        }
        return BaseResponse.error((String)"\u767b\u9646\u5f02\u5e38\uff01");
    }

    private BaseResponse<AccountLoginRespVO> loginV2Posthandler(UcManagerUserEntity ucManagerUserEntity, UserLoginReqVO userLoginReqVO, String source) {
        List list = this.ucAccountMapper.selectListByUserTypeAndAppCodeAndStatusAndAccountNoOrLoginName(userLoginReqVO.getUserType(), userLoginReqVO.getAppCode(), UserEnums.UserStatusEnum.NORMAL.getUserStatusValue(), userLoginReqVO.getAccountNo());
        UcAccountEntity accountEntity = null;
        if (list == null || list.isEmpty()) {
            return BaseResponse.error((IError)ErrorEnum.NO_EXISTS_ACCOUNT_2);
        }
        if (list != null && list.size() == 1) {
            UcAccountEntity accountEn = (UcAccountEntity)list.get(0);
            if (NOPWORDSTATUS.equals(accountEn.getPwSalt()) && NOPWORDSTATUS.equals(accountEn.getAccountPw())) {
                return BaseResponse.error((IError)ErrorEnum.NO_PASSWORD);
            }
            String pwSalt = accountEn.getPwSalt();
            String mix = PasswordUtil.mix((String)userLoginReqVO.getPassword(), (String)pwSalt);
            if (mix.equals(accountEn.getAccountPw())) {
                accountEntity = accountEn;
            } else {
                if (UserEnums.UserTypeEnum.MANAGER.getUserTypeValue().equals(userLoginReqVO.getUserType())) {
                    String INVALID_PASSWORD_KEY = INVALID_PWORD.concat(userLoginReqVO.getAccountNo()).concat("_").concat(String.valueOf(userLoginReqVO.getUserType()));
                    Object accountNoLockValue = this.accountRedisUtil.get(INVALID_PASSWORD_KEY);
                    this.log.info(LOCK_ACCOUNT + accountNoLockValue + "\u79d2");
                    if (accountNoLockValue instanceof Integer) {
                        int LockValue = (Integer)accountNoLockValue + 1;
                        long expire = this.accountRedisUtil.getExpire(INVALID_PASSWORD_KEY);
                        this.log.info(LOCK_ACCOUNT + expire + "\u79d2");
                        this.accountRedisUtil.set(INVALID_PASSWORD_KEY, (Object)LockValue, expire, TimeUnit.SECONDS);
                    } else {
                        int LockValue = 1;
                        this.accountRedisUtil.set(INVALID_PASSWORD_KEY, (Object)LockValue, 10L, TimeUnit.MINUTES);
                    }
                }
                return BaseResponse.error((IError)ErrorEnum.NO_EXISTS_ACCOUNT_2);
            }
        }
        if (accountEntity == null) {
            return BaseResponse.error((IError)ErrorEnum.NO_EXISTS_ACCOUNT_2);
        }
        UserEntity userEntity = this.userService.getUserEntity(accountEntity.getUserId(), accountEntity.getUserType());
        if (userEntity == null) {
            this.log.warn(UNUSEFUL_MESSAGE, (Object)JSON.toJSONString((Object)userLoginReqVO));
            return BaseResponse.error((IError)ErrorEnum.USER_NOT_EXIT);
        }
        this.logStore(ucManagerUserEntity.getName(), accountEntity.getAccountNo(), JSON.toJSONString((Object)userLoginReqVO));
        return this.postLoginHander(accountEntity, userEntity, (CloudAccountLoginReqVO)userLoginReqVO, source);
    }

    public BaseResponse<AccountLoginRespVO> login(AccountLoginReqVO accountLoginReqVO) {
        this.log.info("\u8d26\u6237\u767b\u5f55 \u8c03\u7528\u7528\u6237\u4e2d\u5fc3\u8bf7\u6c42\u53c2\u6570{}", (Object)accountLoginReqVO);
        if (StringUtils.isEmpty((CharSequence)accountLoginReqVO.getVercodeKey()) && StringUtils.isEmpty((CharSequence)accountLoginReqVO.getVercodeValue()) && LoginDeviceType.WEB.equals((Object)accountLoginReqVO.getLoginDeviceType()) && !UserEnums.UserTypeEnum.DOCTOR.getUserTypeValue().equals(accountLoginReqVO.getUserType()) && (super.isVercodeIP(accountLoginReqVO.getLoginIp()).booleanValue() || super.isVercodePhone(accountLoginReqVO.getAccountNo()).booleanValue())) {
            this.log.info("PC\u7aef\u767b\u5f55 \u9700\u8981\u8fdb\u884c\u56fe\u6587\u9a8c\u8bc1");
            return BaseResponse.error((IError)ErrorEnum.VERCODE_NEED_YES);
        }
        if (!(StringUtils.isEmpty((CharSequence)accountLoginReqVO.getVercodeKey()) || StringUtils.isEmpty((CharSequence)accountLoginReqVO.getVercodeValue()) || super.verifyVercode(accountLoginReqVO.getVercodeKey(), accountLoginReqVO.getVercodeValue()))) {
            return BaseResponse.error((IError)ErrorEnum.VERCODE_ERROR);
        }
        UcAccountEntity account = this.validLoginAccount(accountLoginReqVO);
        this.log.info("\u9a8c\u8bc1\u767b\u5f55\u8d26\u53f7:{}", (Object)account);
        UserEntity userEntity = this.userService.getUserEntity(account.getUserId(), account.getUserType());
        if (userEntity == null) {
            this.log.warn(UNUSEFUL_MESSAGE, (Object)accountLoginReqVO);
            throw new UserCenterRuntimeException(ErrorEnum.USER_NOT_EXIT);
        }
        String tokenKey = this.loginInfoValid((CloudAccountLoginReqVO)accountLoginReqVO, account);
        this.log.info("\u5237\u65b0token {}", (Object)tokenKey);
        String loginToken = this.genLoginToken((CloudAccountLoginReqVO)accountLoginReqVO, account, tokenKey, null);
        AccountLoginRespVO loginRespVO = this.createAccountLoginResp(account, userEntity, loginToken);
        return BaseResponse.success((Object)loginRespVO);
    }

    protected void verifyVercode_web_manager(String vercodeKey, String vercodeValue, LoginDeviceType loginDeviceType, Short userType, String loginIp, String accountNo, String appCode) {
        if (this.projProperties.getVercodeEnabled() != null && !this.projProperties.getVercodeEnabled().booleanValue()) {
            this.log.info("web\u7aef\u7ba1\u7406\u5458\u6821\u9a8c\u56fe\u6587\u9a8c\u8bc1\u7801\u662f\u5426\u6b63\u786e--\u8df3\u8fc7");
            return;
        }
        if (LoginDeviceType.WEB.equals((Object)loginDeviceType) && UserEnums.UserTypeEnum.MANAGER.getUserTypeValue().equals(userType)) {
            if (StringUtils.isEmpty((CharSequence)vercodeKey) || StringUtils.isEmpty((CharSequence)vercodeValue)) {
                if (this.projProperties.getVercodeEnabledAppcode() != null && this.projProperties.getVercodeEnabledAppcode().contains(appCode)) {
                    throw new UserCenterRuntimeException(ErrorEnum.VERCODE_ERROR);
                }
                if (super.isVercodeIP(loginIp).booleanValue() || super.isVercodePhone(accountNo).booleanValue()) {
                    this.log.info("PC\u7aef\u767b\u5f55 \u9700\u8981\u8fdb\u884c\u56fe\u6587\u9a8c\u8bc1");
                    throw new UserCenterRuntimeException(ErrorEnum.VERCODE_NEED_YES);
                }
            }
            if (!(StringUtils.isEmpty((CharSequence)vercodeKey) || StringUtils.isEmpty((CharSequence)vercodeValue) || super.verifyVercode(vercodeKey, vercodeValue))) {
                throw new UserCenterRuntimeException(ErrorEnum.VERCODE_ERROR);
            }
        }
    }

    private BaseResponse getBaseResponse(String errCode, String msg) {
        BaseResponse response = new BaseResponse();
        response.setCode("0");
        response.setErrCode(errCode);
        response.setMsg(msg);
        return response;
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<BaseIdRespVO> register(AccountRegisterReqVO accountRegisterReqVO) {
        this.log.info("\u8d26\u6237\u6ce8\u518c\uff1a{}", (Object)accountRegisterReqVO);
        if (!UserEnums.UserTypeEnum.PATIENT.getUserTypeValue().equals(accountRegisterReqVO.getUserType())) {
            if (StringUtils.isEmpty((CharSequence)accountRegisterReqVO.getPassword()) || accountRegisterReqVO.getPassword().length() < 6 || accountRegisterReqVO.getPassword().length() > 20) {
                return BaseResponse.error((IError)ErrorEnum.PASSWORD_SETTING_ERROR);
            }
        } else if (accountRegisterReqVO.isIgnorePassword()) {
            accountRegisterReqVO.setPassword("123456");
        } else if (!RegexUtils.match_a_6_20((String)accountRegisterReqVO.getPassword()).booleanValue()) {
            this.log.info("\u60a3\u8005\u6ce8\u518c \u5bc6\u7801\u8bbe\u7f6e\u6709\u8bef,\u957f\u5ea66-20\u4f4d\u5b57\u6bcd\u52a0\u6570\u5b57,password:{}", (Object)accountRegisterReqVO.getPassword());
            return BaseResponse.error((IError)ErrorEnum.PASSWORD_SETTING_ERROR_4);
        }
        return BaseResponse.success((Object)this.postRegisterHandler(accountRegisterReqVO));
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<BaseIdRespVO> registerV2(AccountRegisterReqVO accountRegisterReqVO) {
        this.log.info("\u8d26\u6237\u6ce8\u518c\uff1a{}", (Object)accountRegisterReqVO);
        accountRegisterReqVO.setPwSalt(NOPWORDSTATUS);
        accountRegisterReqVO.setPassword(NOPWORDSTATUS);
        BaseIdRespVO respVO = this.postRegisterHandler(accountRegisterReqVO);
        return BaseResponse.success((Object)respVO);
    }

    public BaseResponse<BaseUserCenterIdRespVO> register(UserRigisterReqVO userRigisterReqVO) {
        this.log.info("\u8d26\u6237\u6ce8\u518c\uff0c\u8bf7\u6c42\u53c2\u6570{}", (Object)JsonUtil.convertObject((Object)userRigisterReqVO));
        AccountRegisterReqVO accountRegisterReqVO = new AccountRegisterReqVO();
        BeanUtils.copyProperties((Object)userRigisterReqVO, (Object)accountRegisterReqVO);
        accountRegisterReqVO.setUserType(PushCenterContants.CUSTOMER_USER_TYPE);
        this.log.info("\u8d26\u6237\u6ce8\u518c\uff0c\u8c03\u7528\u7528\u6237\u4e2d\u5fc3\u8bf7\u6c42\u53c2\u6570{}", (Object)JsonUtil.convertObject((Object)accountRegisterReqVO));
        BaseResponse resp = this.register(accountRegisterReqVO);
        this.log.info("\u8d26\u6237\u6ce8\u518c\uff0c\u8c03\u7528\u7528\u6237\u4e2d\u5fc3\u8fd4\u56de\u53c2\u6570{}", (Object)JsonUtil.convertObject((Object)resp));
        return this.getUnionResponse(resp);
    }

    private BaseResponse<BaseUserCenterIdRespVO> getUnionResponse(BaseResponse<BaseIdRespVO> resp) {
        if ("0".equals(resp.getCode())) {
            this.log.warn("\u8c03\u7528\u5176\u4ed6\u670d\u52a1\u8fd4\u56de\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f{}", (Object)JsonUtil.convertObject((Object)resp.getMsg()));
            return this.getBaseResponse(resp.getErrCode(), resp.getMsg());
        }
        BaseIdRespVO respData = (BaseIdRespVO)resp.getData();
        BaseUserCenterIdRespVO userCompleteInfoResp = new BaseUserCenterIdRespVO();
        BeanUtils.copyProperties((Object)respData, (Object)userCompleteInfoResp);
        this.log.info("\u8fd4\u56de\u524d\u7aef\u53c2\u6570{}", (Object)JsonUtil.convertObject((Object)userCompleteInfoResp));
        return BaseResponse.success((Object)userCompleteInfoResp);
    }

    public BaseResponse<BaseUserCenterIdRespVO> logout(AccountLogoutIReqVO accountLogoutIReqVO, String headerIp, String accessToken) {
        this.log.info("\u8d26\u6237\u767b\u51fa\uff0c\u8bf7\u6c42\u53c2\u6570{}", (Object)JsonUtil.convertObject((Object)accountLogoutIReqVO));
        TokenBody tokenBody = this.parseToken(accessToken);
        if (tokenBody == null) {
            return BaseResponse.error((IError)ErrorEnum.TOKEN_PARSE_FAIL);
        }
        TokenJson tokenJson = tokenBody.getTokenJson();
        if (!this.checkToken(tokenJson, (UserCenterBaseReqVO)accountLogoutIReqVO)) {
            this.log.warn("token\u68c0\u9a8c\u5f02\u5e38\uff0ctokenJson{}", (Object)tokenJson);
            return BaseResponse.error((IError)ErrorEnum.TOKEN_PARSE_FAIL);
        }
        AccountLogoutReqVO accountLogoutReqVO = new AccountLogoutReqVO();
        accountLogoutReqVO.setChannelCode(accountLogoutIReqVO.getChannelCode());
        accountLogoutReqVO.setLoginIp(headerIp);
        accountLogoutReqVO.setDeviceNumber(accountLogoutIReqVO.getDeviceNumber());
        accountLogoutReqVO.setAppCode(accountLogoutIReqVO.getAppCode());
        accountLogoutReqVO.setAccountId(tokenJson.getAccountId());
        accountLogoutReqVO.setUserId(tokenJson.getUserId());
        accountLogoutReqVO.setDeviceType(tokenJson.getDeviceType());
        this.log.info("\u8d26\u6237\u767b\u51fa\uff0c\u8c03\u7528\u7528\u6237\u4e2d\u5fc3\u8bf7\u6c42\u53c2\u6570{}", (Object)JsonUtil.convertObject((Object)accountLogoutReqVO));
        BaseResponse resp = this.logout(accessToken, accountLogoutReqVO);
        this.log.info("\u8d26\u6237\u767b\u51fa\uff0c\u8c03\u7528\u7528\u6237\u4e2d\u5fc3\u8fd4\u56de\u53c2\u6570{}", (Object)JsonUtil.convertObject((Object)resp));
        return this.getUnionResponse(resp);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<BaseIdRespVO> logout(String token, AccountLogoutReqVO reqVO) {
        String accountId = reqVO.getAccountId();
        UcAccountEntity account = this.getRightAccount(accountId);
        String userId = reqVO.getUserId();
        String appCode = reqVO.getAppCode();
        TokenJson tokenJson = this.getTokenJson(token, appCode);
        if (!userId.equals(account.getUserId()) || !tokenJson.getUserId().equals(userId)) {
            this.log.warn("\u8d26\u6237\u767b\u51fa\uff0c\u8bf7\u6c42\u53c2\u6570\u4e0d\u6b63\u786e\uff0c\u7528\u6237ID\u4e0e\u8bf7\u6c42\u53c2\u6570\u4e2d\u7528\u6237ID\u4e0d\u5339\u914d\uff0c\u8bf7\u6c42\u53c2\u6570={}", (Object)JsonUtil.convertObject((Object)reqVO));
            return BaseResponse.error((IError)ErrorEnum.INVALID_PARAMETER);
        }
        String tokenKey = Tokenutil.genTokenKey((String)account.getUserId(), (String)tokenJson.getAppCode(), (String)tokenJson.getDeviceType());
        String cacheToken = this.cacheService.getLoginToken(tokenKey);
        if (token.equalsIgnoreCase(cacheToken)) {
            boolean delLoginToken = this.cacheService.delLoginToken(tokenKey);
            this.accountRedisUtil.del(new String[]{"last_operation_time_" + accountId});
            if (!delLoginToken) {
                this.log.error("\u767b\u51fa\u5931\u8d25\uff0c\u5220\u9664\u7528\u6237\u5386\u53f2\u767b\u5f55token\u5931\u8d25,\u672a\u5220\u9664Token[{}]" + cacheToken);
                throw new UserCenterRuntimeException(ErrorEnum.SYSTEM_ERROR);
            }
        }
        this.messageService.tokenInvalidMsg(cacheToken, CommonEnums.TokenInvalidCause.LOGOUT);
        UcLoginRecordEntity entity = this.bulidUcLoginRecordEntity(token, reqVO);
        this.ucLoginRecordMapper.save(entity);
        BaseIdRespVO data = new BaseIdRespVO();
        data.setAccountId(accountId);
        data.setUserId(userId);
        this.log.info("\u8d26\u6237\u767b\u51fa,\u4fdd\u5b58\u767b\u51fa\u8bb0\u5f55\uff0c\u8bf7\u6c42\u53c2\u6570={}\uff0c\u767b\u51fa\u8bb0\u5f55\u5b9e\u4f53={}", (Object)JsonUtil.convertObject((Object)reqVO), (Object)JsonUtil.convertObject((Object)entity));
        return BaseResponse.success((Object)data);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<BaseIdRespVO> accountCancel(AccountOperateBaseReqVO accountOperateBaseReqVO, String token) {
        String accountId = accountOperateBaseReqVO.getAccountId();
        String appCode = accountOperateBaseReqVO.getAppCode();
        TokenJson tokenJson = this.getTokenJson(token, appCode);
        UcAccountEntity account = this.getRightAccount(accountId);
        this.checkAccountPassword(accountOperateBaseReqVO, account);
        this.deleteAllToken(tokenJson.getUserId(), tokenJson.getAppCode());
        String tokenKey = Tokenutil.genTokenKey((String)tokenJson.getUserId(), (String)tokenJson.getAppCode(), (String)tokenJson.getDeviceType());
        String cacheToken = this.cacheService.getLoginToken(tokenKey);
        this.accountCancelLinkAction(account, cacheToken);
        this.messageService.tokenInvalidMsg(cacheToken, CommonEnums.TokenInvalidCause.CANCEL);
        account.setStatus(AccountEnums.AccountStatusEnum.CANCELLATION.getValue());
        this.ucAccountMapper.save(account);
        UcAccountOperateEntity operate = new UcAccountOperateEntity(accountOperateBaseReqVO.getChannelCode(), AccountEnums.AccountOperationEnum.ACCOUNT_CANCELLATION.getValue(), "\u8d26\u6237\u6ce8\u9500", accountId, JsonUtil.convertObject((Object)accountOperateBaseReqVO));
        this.ucAccountOperateMapper.save(operate);
        BaseIdRespVO data = new BaseIdRespVO(account.getUserId(), accountId);
        return BaseResponse.success((Object)data);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<BaseIdRespVO> updatePassword(AccountPasswordUpdateReqVO accountPasswordUpdateReqVO, String token) {
        if (accountPasswordUpdateReqVO.getPasswordNew().trim().length() < 6) {
            return BaseResponse.error((IError)ErrorEnum.PASSWORD_SETTING_ERROR);
        }
        String accountId = accountPasswordUpdateReqVO.getAccountId();
        String appCode = accountPasswordUpdateReqVO.getAppCode();
        TokenJson tokenJson = this.getTokenJson(token, appCode);
        UcAccountEntity account = this.getRightAccount(accountId);
        try {
            this.checkAccountPassword((AccountOperateBaseReqVO)accountPasswordUpdateReqVO, account);
        }
        catch (UserCenterRuntimeException e) {
            return BaseResponse.error((IError)ErrorEnum.ORIGINAL_PASSWORD_ERROR);
        }
        this.deletaAllTokenExceptOne(tokenJson.getUserId(), tokenJson.getAppCode(), tokenJson.getDeviceType());
        String tokenKey = Tokenutil.genTokenKey((String)tokenJson.getUserId(), (String)tokenJson.getAppCode(), (String)tokenJson.getDeviceType());
        String cacheToken = this.cacheService.getLoginToken(tokenKey);
        this.messageService.tokenInvalidMsg(cacheToken, CommonEnums.TokenInvalidCause.UPDATE_ACCOUNT_PASSWORD);
        PasswordAndSalt passwordAndSalt = PasswordUtil.mix((String)accountPasswordUpdateReqVO.getPasswordNew().trim());
        account.setAccountPw(passwordAndSalt.getMixedPassword());
        account.setPwSalt(passwordAndSalt.getSalt());
        this.ucAccountMapper.save(account);
        UcAccountOperateEntity operate = new UcAccountOperateEntity(accountPasswordUpdateReqVO.getChannelCode(), AccountEnums.AccountOperationEnum.UPDATE_PASSWORD.getValue(), "\u4fee\u6539\u4e86\u8d26\u6237\u5bc6\u7801", accountId, JsonUtil.convertObject((Object)accountPasswordUpdateReqVO));
        this.ucAccountOperateMapper.save(operate);
        BaseIdRespVO data = new BaseIdRespVO(account.getUserId(), accountId);
        return BaseResponse.success((Object)data);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<BaseIdRespVO> updateAccountNo(AccountNoUpdateReqVO accountNoUpdateReqVO, String token) {
        this.checkAccountNoRightByAccountType(accountNoUpdateReqVO.getAccountNoNew(), accountNoUpdateReqVO.getAccountType());
        String accountId = accountNoUpdateReqVO.getAccountId();
        String appCode = accountNoUpdateReqVO.getAppCode();
        TokenJson tokenJson = this.getTokenJson(token, appCode);
        UcAccountEntity account = this.getRightAccount(accountId);
        this.checkAccountPassword((AccountOperateBaseReqVO)accountNoUpdateReqVO, account);
        UcAccountEntity checkNewAccount = this.getAccount(accountNoUpdateReqVO.getAccountNoNew(), account.getUserType(), account.getAppCode());
        if (checkNewAccount != null) {
            this.log.warn("\u65b0\u767b\u5f55\u8d26\u6237\u540d\u91cd\u590d,\u4fee\u6539\u767b\u5f55\u8d26\u6237\u540d\u5931\u8d25,\u8bf7\u6c42\u53c2\u6570={}", (Object)JsonUtil.convertObject((Object)accountNoUpdateReqVO));
            throw new UserCenterRuntimeException(ErrorEnum.ACCOUNT_NAME_ALREADY_EXISTS);
        }
        this.deletaAllTokenExceptOne(tokenJson.getUserId(), tokenJson.getAppCode(), tokenJson.getDeviceType());
        String tokenKey = Tokenutil.genTokenKey((String)tokenJson.getUserId(), (String)tokenJson.getAppCode(), (String)tokenJson.getDeviceType());
        String cacheToken = this.cacheService.getLoginToken(tokenKey);
        this.messageService.tokenInvalidMsg(cacheToken, CommonEnums.TokenInvalidCause.UPDATE_ACCOUNT_NO);
        String accountNoNew = accountNoUpdateReqVO.getAccountNoNew().trim();
        super.checkAccountNoRightByAccountType(accountNoNew, accountNoUpdateReqVO.getAccountType());
        if (AccountEnums.AccountTypeEnum.CELL_PHONE.getValue().equals(accountNoUpdateReqVO.getAccountType())) {
            account.setRelatedMobileNumber(accountNoNew);
        }
        account.setAccountNo(accountNoNew);
        account.setAccountType(accountNoUpdateReqVO.getAccountType());
        this.ucAccountMapper.save(account);
        this.updateUserInfoFromAccountNO(account);
        UcAccountOperateEntity operate = new UcAccountOperateEntity(accountNoUpdateReqVO.getChannelCode(), AccountEnums.AccountOperationEnum.UPDATE_ACCOUNT_NO.getValue(), "\u4fee\u6539\u4e86\u767b\u5f55\u8d26\u53f7", accountId, JsonUtil.convertObject((Object)accountNoUpdateReqVO));
        this.ucAccountOperateMapper.save(operate);
        BaseIdRespVO data = new BaseIdRespVO(account.getUserId(), accountId);
        return BaseResponse.success((Object)data);
    }

    private void updateUserInfoFromAccountNO(UcAccountEntity account) {
        Optional byUserId;
        if (UserEnums.UserTypeEnum.PATIENT.getUserTypeValue().equals(account.getUserType())) {
            Optional byUserId2 = this.ucPatientUserMapper.findByUserId(account.getUserId());
            if (byUserId2.isPresent()) {
                UcPatientUserEntity patientUserEntity = (UcPatientUserEntity)byUserId2.get();
                patientUserEntity.setContactMobile(account.getRelatedMobileNumber());
                if (AccountEnums.AccountTypeEnum.EMAIL.getValue().equals(account.getAccountType())) {
                    patientUserEntity.setEmail(account.getAccountNo());
                }
                this.ucPatientUserMapper.save(patientUserEntity);
            }
        } else if (UserEnums.UserTypeEnum.MANAGER.getUserTypeValue().equals(account.getUserType()) && (byUserId = this.ucManagerUserMapper.selectByUserId(account.getUserId())).isPresent()) {
            UcManagerUserEntity managerUserEntity = (UcManagerUserEntity)byUserId.get();
            managerUserEntity.setContactMobile(account.getRelatedMobileNumber());
            if (AccountEnums.AccountTypeEnum.EMAIL.getValue().equals(account.getAccountType())) {
                managerUserEntity.setEmail(account.getAccountNo());
            }
            this.ucManagerUserMapper.save(managerUserEntity);
        }
    }

    public BaseResponse<BaseIdRespVO> pwdVerify(AccountOperateBaseReqVO accountOperateBaseReqVO) {
        UcAccountEntity account = this.getRightAccount(accountOperateBaseReqVO.getAccountId());
        this.checkAccountPassword(accountOperateBaseReqVO, account);
        return BaseResponse.success((Object)new BaseIdRespVO(account.getUserId(), account.getAccountId()));
    }

    public BaseResponse<AccountNoCheckRespVO> accountNoVerify(AccountNoCheckReqVO accountNoCheckReqVO) {
        AccountNoCheckRespVO data = new AccountNoCheckRespVO();
        UcAccountEntity account = this.getAccount(accountNoCheckReqVO.getAccountNo(), accountNoCheckReqVO.getUserType(), accountNoCheckReqVO.getAppCode());
        if (account == null) {
            return BaseResponse.success((Object)data);
        }
        data.setIsRepeat(Boolean.TRUE);
        if (!StringUtils.isEmpty((CharSequence)account.getAccountPw())) {
            data.setSetPassword(Boolean.TRUE);
        }
        if (Boolean.TRUE.equals(accountNoCheckReqVO.getCheckWXBind())) {
            this.log.info("\u5fae\u4fe1\u6821\u9a8c--\u300bsubordinateType\u6839\u636echannelcode\u53d6\u503c\uff0cchannelcode={}", (Object)accountNoCheckReqVO.getChannelCode());
            Short subordinateType = null;
            if (accountNoCheckReqVO.getChannelCode().contains("WX")) {
                subordinateType = 1;
            } else if (accountNoCheckReqVO.getChannelCode().contains("IOS") || accountNoCheckReqVO.getChannelCode().contains("ANDROID")) {
                subordinateType = 0;
            } else {
                this.log.info("\u5176\u4ed6\u7684\u7c7b\u578bchannelcode={}", (Object)accountNoCheckReqVO.getChannelCode());
            }
            Optional wxBind = this.accountUcWxAuthMapper.findByUserIdAndUserTypeAndStatusAndSubordinateType(account.getUserId(), account.getUserType(), WxAuthEnums.WxAuthStatusEnum.NORMAL.getValue(), subordinateType);
            if (wxBind.isPresent()) {
                data.setWxBind(Boolean.TRUE);
            }
        }
        return BaseResponse.success((Object)data);
    }

    public BaseResponse<CheckAccountRepeatRespVO> accountNoVerify(CheckAccountRepeatReqVO checkAccountRepeatReqVO) {
        this.log.info("\u8d26\u53f7\u68c0\u67e5\uff0c\u8bf7\u6c42\u53c2\u6570{}", (Object)JsonUtil.convertObject((Object)checkAccountRepeatReqVO));
        AccountNoCheckReqVO accountNoCheckReqVO = new AccountNoCheckReqVO();
        BeanUtils.copyProperties((Object)checkAccountRepeatReqVO, (Object)accountNoCheckReqVO);
        if (accountNoCheckReqVO.getUserType() == null) {
            accountNoCheckReqVO.setUserType(PushCenterContants.CUSTOMER_USER_TYPE);
        }
        this.log.info("\u8d26\u53f7\u68c0\u67e5\uff0c\u8c03\u7528\u7528\u6237\u4e2d\u5fc3\u8bf7\u6c42\u53c2\u6570{}", (Object)JsonUtil.convertObject((Object)accountNoCheckReqVO));
        BaseResponse urResponse = this.accountNoVerify(accountNoCheckReqVO);
        this.log.info("\u8d26\u53f7\u68c0\u67e5\uff0c\u8c03\u7528\u7528\u6237\u4e2d\u5fc3\u8fd4\u56de\u53c2\u6570{}", (Object)JsonUtil.convertObject((Object)urResponse));
        BaseResponse result = new BaseResponse();
        BeanUtils.copyProperties((Object)urResponse, (Object)result);
        this.log.info("\u8d26\u53f7\u68c0\u67e5\uff0c\u8fd4\u56de\u524d\u7aef\u53c2\u6570{[]}", (Object)JsonUtil.convertObject((Object)result));
        return result;
    }

    public BaseResponse<BaseUserCenterIdRespVO> getbackPassword(GetbackPasswordReqVO getbackPasswordReqVO) {
        this.log.info("\u627e\u56de\u5bc6\u7801\uff0c\u8bf7\u6c42\u53c2\u6570{}", (Object)JsonUtil.convertObject((Object)getbackPasswordReqVO));
        SmsVerifiAuthCodeReqVO smsVerifiAuthCodeReqVo = new SmsVerifiAuthCodeReqVO();
        smsVerifiAuthCodeReqVo.setAuthCode(getbackPasswordReqVO.getAuthCode());
        smsVerifiAuthCodeReqVo.setAuthKey(getbackPasswordReqVO.getAuthKey());
        smsVerifiAuthCodeReqVo.setPhoneNum(getbackPasswordReqVO.getAccountNo());
        if (!LoginDeviceType.WEB.equals((Object)getbackPasswordReqVO.getLoginDeviceType())) {
            this.log.info("\u627e\u56de\u5bc6\u7801\uff0c\u77ed\u4fe1\u9a8c\u8bc1\u7801\u6821\u9a8c\uff0c\u8bf7\u6c42\u53c2\u6570{}", (Object)JsonUtil.convertObject((Object)smsVerifiAuthCodeReqVo));
            if (!super.verifialismsauthcode(smsVerifiAuthCodeReqVo)) {
                return BaseResponse.error((IError)ErrorEnum.SMS_CODE_ERROR);
            }
        }
        ResetPasswordReqVO resetPasswordReqVO = new ResetPasswordReqVO();
        BeanUtils.copyProperties((Object)getbackPasswordReqVO, (Object)resetPasswordReqVO);
        resetPasswordReqVO.setPassword(getbackPasswordReqVO.getPasswordNew());
        if (getbackPasswordReqVO.getUserType() != null) {
            resetPasswordReqVO.setUserType(getbackPasswordReqVO.getUserType());
        } else {
            resetPasswordReqVO.setUserType(PushCenterContants.CUSTOMER_USER_TYPE);
        }
        resetPasswordReqVO.setLoginDeviceType(getbackPasswordReqVO.getLoginDeviceType());
        BaseResponse resp = this.resetPassword(resetPasswordReqVO);
        if (!resp.isSuccess()) {
            return BaseResponse.error((String)resp.getMsg());
        }
        BaseIdRespVO respData = (BaseIdRespVO)resp.getData();
        BaseUserCenterIdRespVO userRegisterResp = new BaseUserCenterIdRespVO();
        BeanUtils.copyProperties((Object)respData, (Object)userRegisterResp);
        this.log.info("\u627e\u56de\u5bc6\u7801\uff0c\u8fd4\u56de\u524d\u7aef\u53c2\u6570{}", (Object)JsonUtil.convertObject((Object)userRegisterResp));
        return BaseResponse.success((Object)userRegisterResp);
    }

    public BaseResponse<BaseIdRespVO> resetPassword(ResetPasswordReqVO resetPasswordReqVO) {
        this.log.info("\u627e\u56de\u5bc6\u7801\uff0c\u8c03\u7528\u7528\u6237\u4e2d\u5fc3\u8bf7\u6c42\u53c2\u6570{}", (Object)JsonUtil.convertObject((Object)resetPasswordReqVO));
        UcAccountEntity account = this.getAccount(resetPasswordReqVO.getAccountNo(), resetPasswordReqVO.getUserType(), resetPasswordReqVO.getAppCode());
        if (account == null) {
            return BaseResponse.error((IError)ErrorEnum.NO_EXISTS_ACCOUNT);
        }
        if (AccountEnums.AccountStatusEnum.PROHIBIT.getValue().equals(account.getStatus())) {
            return BaseResponse.error((IError)ErrorEnum.DISABLED_ACCOUNT);
        }
        if (LoginDeviceType.WEB.equals((Object)resetPasswordReqVO.getLoginDeviceType())) {
            this.validNewPassword(account, resetPasswordReqVO.getPassword());
        }
        if (UserEnums.UserTypeEnum.MANAGER.getUserTypeValue().equals(resetPasswordReqVO.getUserType())) {
            if (SOURCE.equals(resetPasswordReqVO.getSource())) {
                if (!RegexUtils.match_a_6_20((String)resetPasswordReqVO.getPassword()).booleanValue()) {
                    throw new UserCenterRuntimeException(ErrorEnum.PASSWORD_SETTING_ERROR_4);
                }
            } else if (!RegexUtils.match_Aa_8_20((String)resetPasswordReqVO.getPassword())) {
                throw new UserCenterRuntimeException(ErrorEnum.PASSWORD_SETTING_ERROR_3);
            }
        } else if ((UserEnums.UserTypeEnum.PATIENT.getUserTypeValue().equals(resetPasswordReqVO.getUserType()) || UserEnums.UserTypeEnum.COMMUNITY.getUserTypeValue().equals(resetPasswordReqVO.getUserType())) && !RegexUtils.match_a_6_20((String)resetPasswordReqVO.getPassword()).booleanValue()) {
            throw new UserCenterRuntimeException(ErrorEnum.PASSWORD_SETTING_ERROR_4);
        }
        this.log.info("\u627e\u56de\u5bc6\u7801\uff0c{}");
        this.deleteAllToken(account.getUserId(), account.getAppCode());
        PasswordAndSalt passwordAndSalt = PasswordUtil.mix((String)resetPasswordReqVO.getPassword());
        account.setAccountPw(passwordAndSalt.getMixedPassword());
        account.setPwSalt(passwordAndSalt.getSalt());
        account.setUpdateTime(new Date());
        this.ucAccountMapper.save(account);
        this.log.info("\u627e\u56de\u5bc6\u7801\uff0c\u4fdd\u5b58\u91cd\u7f6e\u540e\u7684\u5bc6\u7801:{}-->{},\u539f\u5bc6\u7801\uff1a{}", new Object[]{resetPasswordReqVO.getPassword(), passwordAndSalt.getMixedPassword(), account.getAccountPw()});
        UcAccountOperateEntity operate = new UcAccountOperateEntity(resetPasswordReqVO.getChannelCode(), AccountEnums.AccountOperationEnum.UPDATE_PASSWORD.getValue(), "\u91cd\u7f6e\u4e86\u8d26\u6237\u5bc6\u7801", account.getAccountId(), JsonUtil.convertObject((Object)resetPasswordReqVO));
        this.ucAccountOperateMapper.save(operate);
        this.log.info("\u627e\u56de\u5bc6\u7801\uff0c\u8c03\u7528\u7528\u6237\u4e2d\u5fc3\u8fd4\u56de\u53c2\u6570UserId:{},AccountId:{}", (Object)account.getUserId(), (Object)account.getAccountId());
        return BaseResponse.success((Object)new BaseIdRespVO(account.getUserId(), account.getAccountId()));
    }

    private void checkAccountNoRepeat(String accountNo, List<AccountRegisterBaseReqVO> relationAccountList) {
        if (relationAccountList == null || relationAccountList.isEmpty()) {
            return;
        }
        ArrayList<String> accountNoList = new ArrayList<String>();
        accountNoList.add(accountNo);
        for (AccountRegisterBaseReqVO accountRegisterBaseReqVO : relationAccountList) {
            this.checkAccountNoRightByAccountType(accountRegisterBaseReqVO.getAccountNo(), accountRegisterBaseReqVO.getAccountType());
            if (accountNoList.contains(accountRegisterBaseReqVO.getAccountNo())) {
                this.log.warn("\u5173\u8054\u6ce8\u518c\u8d26\u53f7\u91cd\u590d\uff0c\u65e0\u6cd5\u91cd\u590d\u6ce8\u518c,accountNo={}", (Object)accountRegisterBaseReqVO.getAccountNo());
                throw new UserCenterRuntimeException(ErrorEnum.DATA_DUPLICATE, "\u5173\u8054\u6ce8\u518c\u8d26\u53f7" + accountRegisterBaseReqVO.getAccountNo() + "\u91cd\u590d");
            }
            accountNoList.add(accountRegisterBaseReqVO.getAccountNo());
        }
    }

    private UcPatientUserEntity buildPatientUserEntity(AccountRegisterReqVO accountRegisterReqVO) {
        UcPatientUserEntity user = new UcPatientUserEntity(accountRegisterReqVO);
        long userId = this.uniqueID.nextId();
        user.setUserId(String.valueOf(userId));
        return user;
    }

    private UcDoctorUserEntity buildDoctorUserEntity(AccountRegisterReqVO accountRegisterReqVO) {
        if (StringUtils.isEmpty((CharSequence)accountRegisterReqVO.getName())) {
            throw new UserCenterRuntimeException(ErrorEnum.INVALID_PARAMETER);
        }
        if (!StringUtils.isEmpty((CharSequence)accountRegisterReqVO.getDataId())) {
            UcAccountEntity account = this.getDoctorAccount(accountRegisterReqVO.getDataId(), accountRegisterReqVO.getAppCode());
            if (account != null && AccountEnums.AccountStatusEnum.NORMAL.getValue().equals(account.getStatus())) {
                this.log.info("\u5df2\u6709\u8be5doctorId\u7684\u533b\u751f,userId:{}", (Object)account.getUserId());
                throw new UserCenterRuntimeException(ErrorEnum.DATA_DUPLICATE);
            }
            if (account != null && AccountEnums.AccountStatusEnum.PROHIBIT.getValue().equals(account.getStatus())) {
                this.log.info("\u8be5doctorId\u533b\u751f\u5df2\u88ab\u7981\u7528,userId:{}", (Object)account.getUserId());
                throw new UserCenterRuntimeException(ErrorEnum.DISABLED_ACCOUNT);
            }
        }
        UcDoctorUserEntity user = new UcDoctorUserEntity(accountRegisterReqVO);
        long userId = this.uniqueID.nextId();
        user.setUserId(String.valueOf(userId));
        return user;
    }

    private UcOrganUserEntity buildOrganUserEntity(AccountRegisterReqVO accountRegisterReqVO) {
        if (StringUtils.isEmpty((CharSequence)accountRegisterReqVO.getName())) {
            throw new UserCenterRuntimeException(IError.PARAM_CHECK_FAILD, "\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)accountRegisterReqVO.getContactMobile())) {
            throw new UserCenterRuntimeException(IError.PARAM_CHECK_FAILD, "\u8054\u7cfb\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)accountRegisterReqVO.getHeadPortrait())) {
            throw new UserCenterRuntimeException(IError.PARAM_CHECK_FAILD, "\u56fe\u6807\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)accountRegisterReqVO.getIntroduction())) {
            throw new UserCenterRuntimeException(IError.PARAM_CHECK_FAILD, "\u7b80\u4ecb\u4e0d\u80fd\u4e3a\u7a7a");
        }
        UcOrganUserEntity user = new UcOrganUserEntity(accountRegisterReqVO);
        long userId = this.uniqueID.nextId();
        user.setUserId(String.valueOf(userId));
        return user;
    }

    private UcManagerUserEntity buildManagerUserEntity(AccountRegisterReqVO accountRegisterReqVO) {
        UcManagerUserEntity user = new UcManagerUserEntity(accountRegisterReqVO);
        long userId = this.uniqueID.nextId();
        user.setUserId(String.valueOf(userId));
        return user;
    }

    private UcCommunityUserEntity buildCommunityUserEntity(AccountRegisterReqVO accountRegisterReqVO) {
        UcCommunityUserEntity user = new UcCommunityUserEntity(accountRegisterReqVO);
        long userId = this.uniqueID.nextId();
        user.setUserId(String.valueOf(userId));
        return user;
    }

    private UcLoginRecordEntity bulidUcLoginRecordEntity(String token, AccountLogoutReqVO accountLogoutReqVO) {
        UcLoginRecordEntity entity = new UcLoginRecordEntity();
        String accountId = accountLogoutReqVO.getAccountId();
        entity.setAccountId(accountId);
        entity.setLoginType(AccountEnums.LoginTypeEnum.LOGOUT.getType());
        String loginIp = accountLogoutReqVO.getLoginIp();
        entity.setLoginIp(loginIp);
        String loginBussinessCode = accountLogoutReqVO.getChannelCode();
        entity.setLoginBussinessCode(loginBussinessCode);
        entity.setLoginToken(token);
        String deviceType = accountLogoutReqVO.getDeviceType();
        entity.setDeviceType(deviceType);
        String deviceNumber = accountLogoutReqVO.getDeviceNumber();
        entity.setDeviceNumber(deviceNumber);
        entity.setCreateTime(new Date());
        return entity;
    }

    public String genLoginToken(CloudAccountLoginReqVO accountLoginReqVO, UcAccountEntity account, String tokenKey, String source) {
        UcPatientUserEntity user;
        TokenJson tokenJson = new TokenJson();
        tokenJson.setUserId(account.getUserId());
        tokenJson.setAccountId(account.getAccountId());
        tokenJson.setAppCode(account.getAppCode());
        tokenJson.setChannelCode(accountLoginReqVO.getChannelCode());
        if (account.getUserType().equals(UserEnums.UserTypeEnum.MANAGER.getUserTypeValue())) {
            ArrayList<String> list = new ArrayList<String>();
            List byUserId = (List)this.roleClient.findByUserId(account.getUserId()).getData();
            for (RoleInfoVO roleInfoVO : byUserId) {
                list.add(String.valueOf(roleInfoVO.getId()));
            }
            tokenJson.setRoles(list);
        }
        tokenJson.setUserType(account.getUserType().shortValue());
        tokenJson.setDevicenumber(accountLoginReqVO.getLoginDeviceNum());
        tokenJson.setDeviceType(accountLoginReqVO.getLoginDeviceType().name());
        tokenJson.setAccountNo(account.getAccountNo());
        if (UserEnums.UserTypeEnum.PATIENT.getUserTypeValue().equals(account.getUserType())) {
            user = this.getPatientUserEntity(account.getUserId());
            tokenJson.setName(user.getName());
        } else if (UserEnums.UserTypeEnum.DOCTOR.getUserTypeValue().equals(account.getUserType())) {
            user = this.getDoctorUserEntity(account.getUserId());
            tokenJson.setName(user.getName());
        } else if (UserEnums.UserTypeEnum.ORGAN.getUserTypeValue().equals(account.getUserType())) {
            user = this.getOrganUserEntity(account.getUserId());
            tokenJson.setName(user.getOrganName());
        } else if (UserEnums.UserTypeEnum.MANAGER.getUserTypeValue().equals(account.getUserType())) {
            user = this.getManagerUserEntity(account.getUserId());
            tokenJson.setName(user.getName());
        } else if (UserEnums.UserTypeEnum.COMMUNITY.getUserTypeValue().equals(account.getUserType())) {
            if (Objects.equals("NCZK-JSGY", account.getAppCode())) {
                tokenJson.setName(account.getAccountNo());
            } else {
                user = this.ucCommunityUserMapper.selectUserEntityByUserId(account.getUserId());
                tokenJson.setName(user.getName());
            }
        } else {
            throw new UserCenterRuntimeException(ErrorEnum.UNKNOWN_ACCOUNT_TYPE);
        }
        String appCode = account.getAppCode();
        String secryKey = this.getSecryKey(appCode);
        String loginToken = Tokenutil.gen((TokenJson)tokenJson, (String)secryKey);
        this.log.info("\u5b58\u50a8\u7f13\u5b58Token: " + String.valueOf(tokenJson));
        this.cacheService.addLoginToken(tokenKey, loginToken, source);
        String accountId = tokenJson.getAccountId();
        long epochSecondNow = Instant.now().getEpochSecond();
        String lastOperationTimeKey = "last_operation_time_" + accountId;
        this.accountRedisUtil.set(lastOperationTimeKey, (Object)epochSecondNow, 35L, TimeUnit.MINUTES);
        this.log.info("\u8bbe\u7f6e\u7528\u6237\u767b\u5f55\u65f6\u95f4lastOperationTimeKey:{},epochSecondNow:{}", (Object)lastOperationTimeKey, (Object)epochSecondNow);
        UcLoginRecordEntity loginRecord = new UcLoginRecordEntity();
        loginRecord.setAccountId(account.getAccountId());
        loginRecord.setDeviceType(accountLoginReqVO.getLoginDeviceType().name());
        loginRecord.setLoginBussinessCode(accountLoginReqVO.getChannelCode());
        loginRecord.setLoginType(AccountEnums.LoginTypeEnum.LOGIN.getType());
        loginRecord.setLoginToken(loginToken);
        loginRecord.setLoginIp(accountLoginReqVO.getLoginIp());
        loginRecord.setDeviceNumber(accountLoginReqVO.getLoginDeviceNum());
        loginRecord.setCreateTime(new Date());
        this.ucLoginRecordMapper.save(loginRecord);
        account.setLastLoginIp(accountLoginReqVO.getLoginIp());
        account.setLastLoginTime(new Date());
        this.ucAccountMapper.save(account);
        this.log.info("\u7528\u6237\u6210\u529f\u767b\u5f55\uff0c\u767b\u5f55\u7528\u6237\u4fe1\u606f[{}]", (Object)tokenJson);
        return loginToken;
    }

    public String loginInfoValid(CloudAccountLoginReqVO reqVO, UcAccountEntity account) {
        String tokenKey;
        block9: {
            this.log.info("\u767b\u5f55\u4fe1\u606f\u6821\u9a8c  (\u82e5\u5176\u4ed6\u76f8\u540c\u8bbe\u5907\u5df2\u767b\u5f55\u5219\u901a\u77e5\u4e0b\u7ebf CloudAccountLoginReqVO:{},UcAccountEntity\uff1a{}", (Object)JSON.toJSONString((Object)reqVO), (Object)JSON.toJSONString((Object)account));
            String deviceType = reqVO.getLoginDeviceType().name();
            tokenKey = Tokenutil.genTokenKey((String)account.getUserId(), (String)account.getAppCode(), (String)deviceType);
            String cacheToken = this.cacheService.getLoginToken(tokenKey);
            this.log.info("===============\u67e5\u8be2\u5230\u7684\u7f13\u5b58Token\uff1a{}============", (Object)cacheToken);
            if (!StringUtils.isEmpty((CharSequence)cacheToken)) {
                boolean delLoginToken = this.cacheService.delLoginToken(tokenKey);
                if (!delLoginToken) {
                    this.log.warn("\u5220\u9664\u7528\u6237\u5386\u53f2\u767b\u5f55token\u5931\u8d25,\u672a\u5220\u9664Token[{}]" + cacheToken);
                }
                String secryKey = this.getSecryKey(account.getAppCode());
                try {
                    TokenBody tokenBody = Tokenutil.parse((String)cacheToken, (String)secryKey);
                    TokenJson tokenJson = tokenBody.getTokenJson();
                    this.log.info("Token\u89e3\u6790\u6210\u529f,tokenJson:[" + tokenJson.toString() + "]");
                    String devicenumber = tokenJson.getDevicenumber();
                    this.log.info("devicenumber\uff1a" + devicenumber + ";\u4f20\u5165\u7684\u8bbe\u5907\u53f7\uff1a" + reqVO.getLoginDeviceNum());
                    if (devicenumber.equals(reqVO.getLoginDeviceNum())) break block9;
                    this.log.info("\u4e0d\u662f\u540c\u4e00\u4e2a\u8bbe\u5907\u767b\u5f55\uff0c\u53d1\u9001\u63a8\u9001\u6d88\u606f\u901a\u77e5\u4e0b\u7ebf,userID[{}]", (Object)account.getUserId());
                    String channelCode = tokenJson.getChannelCode();
                    if (channelCode.contains("IOS")) {
                        IOSUnicastReqVO iosUnicastReqVO = new IOSUnicastReqVO();
                        HashMap<String, String> extra = new HashMap<String, String>();
                        extra.put("notifyType", "offline");
                        iosUnicastReqVO.setExtra(extra);
                        iosUnicastReqVO.setBody(ACCOUNT_SAFE);
                        iosUnicastReqVO.setBusiStyle(ACCOUNT_SAFE);
                        iosUnicastReqVO.setBusiCode("dz_drop_line");
                        iosUnicastReqVO.setDeviceTokens(tokenJson.getDevicenumber());
                        iosUnicastReqVO.setSubTitle("\u767b\u9646\u4e0b\u7ebf\u901a\u77e5");
                        iosUnicastReqVO.setUserId(tokenJson.getUserId());
                        iosUnicastReqVO.setClientCode(this.projProperties.getUmengClientCodeIos());
                        BaseResponse iosUnicast = null;
                        try {
                            String requestUrl = this.projProperties.getEbaiyihuiDomain() + "/cloud/push/umapi/pushiosunicast";
                            iosUnicast = (BaseResponse)this.restTemplate.postForObject(requestUrl, (Object)iosUnicastReqVO, BaseResponse.class, new Object[0]);
                        }
                        catch (HystrixRuntimeException e) {
                            this.log.error("\u63a8\u9001\u6d88\u606f \u5f02\u5e38 HystrixRuntimeException:{}", (Throwable)e);
                        }
                        this.log.info("\u63a8\u9001\u6d88\u606f token\u5931\u6548\u5230\u8bbe\u5907\uff0cuserID[{}],req[{}],response[{}]", new Object[]{tokenJson.getUserId(), iosUnicastReqVO, iosUnicast});
                        break block9;
                    }
                    if (!channelCode.contains("ANDROID")) break block9;
                    AndroidUnicastReqVO unicastReqVO = new AndroidUnicastReqVO();
                    HashMap<String, String> extra = new HashMap<String, String>();
                    extra.put("notifyType", "offline");
                    unicastReqVO.setExtra(extra);
                    unicastReqVO.setCustom(JsonUtil.convertObject(extra));
                    unicastReqVO.setText(ACCOUNT_SAFE);
                    unicastReqVO.setBusiStyle(ACCOUNT_SAFE);
                    unicastReqVO.setBusiCode("dz_drop_line");
                    unicastReqVO.setDeviceTokens(tokenJson.getDevicenumber());
                    unicastReqVO.setTitle("\u767b\u9646\u4e0b\u7ebf\u901a\u77e5");
                    unicastReqVO.setUserId(tokenJson.getUserId());
                    unicastReqVO.setClientCode(this.projProperties.getUmengClientCodeAndroid());
                    BaseResponse androidUnicast = null;
                    try {
                        String requestUrl = this.projProperties.getEbaiyihuiDomain() + "/cloud/push/umapi/pushandroidunicast";
                        androidUnicast = (BaseResponse)this.restTemplate.postForObject(requestUrl, (Object)unicastReqVO, BaseResponse.class, new Object[0]);
                    }
                    catch (HystrixRuntimeException e) {
                        this.log.error("\u63a8\u9001\u6d88\u606f \u5f02\u5e38 HystrixRuntimeException:{}", (Throwable)e);
                    }
                    this.log.info("\u63a8\u9001\u6d88\u606f token\u5931\u6548\u5230\u8bbe\u5907\uff0cuserID[{}],req[{}],response[{}]", new Object[]{tokenJson.getUserId(), unicastReqVO, androidUnicast});
                }
                catch (TokenParseException e) {
                    this.log.info("\u63a8\u9001\u6d88\u606ftoken\u5931\u6548\u5230\u8bbe\u5907\u53d1\u751f\u5f02\u5e38\uff0cuserID[{}],e[{}]", (Object)account.getUserId(), (Object)e);
                }
            }
        }
        return tokenKey;
    }

    public AccountLoginRespVO createAccountLoginResp(UcAccountEntity account, UserEntity userEntity, String loginToken) {
        AccountLoginRespVO loginRespVO = new AccountLoginRespVO();
        BeanUtils.copyProperties((Object)account, (Object)loginRespVO);
        loginRespVO.setToken(loginToken);
        UserInfoRespVO userInfoRespVO = this.userService.getUserInfoRespVO(userEntity, account.getUserType());
        this.log.info("\u751f\u6210\u7528\u6237\u767b\u5f55\u8fd4\u56de\u5bf9\u8c61-userInfoRespVO:{}", (Object)userInfoRespVO);
        loginRespVO.setUserInfoRespVO(userInfoRespVO);
        loginRespVO.setAccountStatus(userInfoRespVO.getUserStatus());
        loginRespVO.setName(userInfoRespVO.getName());
        loginRespVO.setNickName(userInfoRespVO.getNickName());
        loginRespVO.setHeadPortrait(userInfoRespVO.getHeadPortrait());
        loginRespVO.setContactMobile(userInfoRespVO.getContactMobile());
        loginRespVO.setAccountType(account.getAccountType());
        loginRespVO.setRelatedMobileNumber(account.getRelatedMobileNumber());
        return loginRespVO;
    }

    private UcAccountEntity validLoginNoPwd(CloudAccountLoginReqVO accountLoginReqVO) {
        UcAccountEntity queryUcAccountEntity = new UcAccountEntity();
        queryUcAccountEntity.setAccountNo(accountLoginReqVO.getAccountNo());
        queryUcAccountEntity.setUserType(UserEnums.UserTypeEnum.DOCTOR.getUserTypeValue());
        queryUcAccountEntity.setAppCode(accountLoginReqVO.getAppCode());
        queryUcAccountEntity.setStatus(AccountEnums.AccountStatusEnum.NORMAL.getValue());
        Optional ucAccountEntityOptional = this.getUcAccountEntity(queryUcAccountEntity);
        UcAccountEntity accountEntity = (UcAccountEntity)ucAccountEntityOptional.get();
        return accountEntity;
    }

    private Optional<UcAccountEntity> getUcAccountEntity(UcAccountEntity queryUcAccountEntity) {
        Short status;
        String appCode;
        Short userType;
        String accountNo = queryUcAccountEntity.getAccountNo();
        Optional ucAccountEntityOptional = this.ucAccountMapper.selectByAccountNoAndUserTypeAndAppCodeAndStatus(accountNo, userType = queryUcAccountEntity.getUserType(), appCode = queryUcAccountEntity.getAppCode(), status = queryUcAccountEntity.getStatus());
        if (!ucAccountEntityOptional.isPresent()) {
            status = AccountEnums.AccountStatusEnum.PROHIBIT.getValue();
            Optional prohibitAccountOptional = this.ucAccountMapper.selectByAccountNoAndUserTypeAndAppCodeAndStatus(accountNo, userType, appCode, status);
            if (prohibitAccountOptional.isPresent()) {
                this.log.warn("\u8d26\u6237\u5df2\u7ecf\u88ab\u7981\u7528\uff0c\u8d26\u6237\u767b\u5f55\u4fe1\u606f[{}]", (Object)prohibitAccountOptional);
                throw new UserCenterRuntimeException(ErrorEnum.DISABLED_ACCOUNT);
            }
            this.log.warn("\u672a\u67e5\u8be2\u53ef\u7528\u7684\u8d26\u6237\u4fe1\u606f\uff0c\u8d26\u6237\u767b\u5f55\u4fe1\u606f[{}]", (Object)prohibitAccountOptional);
            throw new UserCenterRuntimeException(ErrorEnum.NO_EXISTS_ACCOUNT);
        }
        return ucAccountEntityOptional;
    }

    private UcAccountEntity validLoginAccount(AccountLoginReqVO accountLoginReqVO) {
        UcAccountEntity queryUcAccountEntity = new UcAccountEntity();
        queryUcAccountEntity.setAccountNo(accountLoginReqVO.getAccountNo());
        queryUcAccountEntity.setUserType(accountLoginReqVO.getUserType());
        queryUcAccountEntity.setAppCode(accountLoginReqVO.getAppCode());
        queryUcAccountEntity.setStatus(AccountEnums.AccountStatusEnum.NORMAL.getValue());
        Optional ucAccountEntityOptional = this.getUcAccountEntity(queryUcAccountEntity);
        UcAccountEntity accountEntity = (UcAccountEntity)ucAccountEntityOptional.get();
        String pwd = PasswordUtil.mix((String)accountLoginReqVO.getPassword(), (String)accountEntity.getPwSalt());
        String INVALID_PASSWORD_KEY = INVALID_PWORD.concat(accountLoginReqVO.getAccountNo()).concat("_").concat(String.valueOf(accountLoginReqVO.getUserType()));
        if (!pwd.equals(accountEntity.getAccountPw())) {
            this.log.info("\u767b\u5f55\u5bc6\u7801\u6821\u9a8c\u5931\u8d25\uff0c\u7528\u6237\u767b\u5f55\u4fe1\u606f[{}]", (Object)accountLoginReqVO);
            Object accountNoLockValue = this.accountRedisUtil.get(INVALID_PASSWORD_KEY);
            this.log.info(LOCK_ACCOUNT + accountNoLockValue + "\u79d2");
            if (accountNoLockValue instanceof Integer) {
                int LockValue = (Integer)accountNoLockValue + 1;
                long expire = this.accountRedisUtil.getExpire(INVALID_PASSWORD_KEY);
                this.log.info(LOCK_ACCOUNT + expire + "\u79d2");
                this.accountRedisUtil.set(INVALID_PASSWORD_KEY, (Object)LockValue, expire, TimeUnit.SECONDS);
            } else {
                int LockValue = 1;
                this.accountRedisUtil.set(INVALID_PASSWORD_KEY, (Object)LockValue, 10L, TimeUnit.MINUTES);
            }
            throw new UserCenterRuntimeException(ErrorEnum.INVALID_PASSWORD);
        }
        this.accountRedisUtil.del(new String[]{INVALID_PASSWORD_KEY});
        return accountEntity;
    }

    private Boolean validNewPassword(UcAccountEntity ucAccountEntity, String passwordNew) {
        String newPwd = PasswordUtil.mix((String)passwordNew, (String)ucAccountEntity.getPwSalt());
        this.log.info("\u627e\u56de\u5bc6\u7801 \u65b0\u5bc6\u7801\u4e0e\u65e7\u5bc6\u7801\u4e0d\u80fd\u76f8\u540c\uff0c\u65b0\u5bc6\u7801[{}]", (Object)passwordNew);
        if (newPwd.equals(ucAccountEntity.getAccountPw())) {
            this.log.info("\u627e\u56de\u5bc6\u7801 \u65b0\u5bc6\u7801\u4e0e\u65e7\u5bc6\u7801\u4e0d\u80fd\u76f8\u540c\uff0c\u65b0\u5bc6\u7801[{}]", (Object)passwordNew);
            throw new UserCenterRuntimeException(ErrorEnum.INVALID_NEW_PASSWORD);
        }
        return true;
    }

    private void deleteAllToken(String userId, String appCode) {
        for (LoginDeviceType loginDeviceType : LoginDeviceType.values()) {
            String tokenKey = Tokenutil.genTokenKey((String)userId, (String)appCode, (String)loginDeviceType.toString());
            if (this.cacheService.delLoginToken(tokenKey)) continue;
            this.log.warn("\u7f13\u5b58\u5220\u9664\u5931\u8d25,tokenKey={}", (Object)tokenKey);
            throw new UserCenterRuntimeException(ErrorEnum.TOKEN_DELETE_FAIL);
        }
    }

    private void deletaAllTokenExceptOne(String userId, String appCode, String deviceType) {
        if (StringUtils.isEmpty((CharSequence)deviceType)) {
            this.deleteAllToken(userId, appCode);
        }
        for (LoginDeviceType loginDeviceType : LoginDeviceType.values()) {
            String tokenKey = Tokenutil.genTokenKey((String)userId, (String)appCode, (String)loginDeviceType.toString());
            if (deviceType.equals(loginDeviceType.toString()) || this.cacheService.delLoginToken(tokenKey)) continue;
            this.log.warn("\u7f13\u5b58\u5220\u9664\u5931\u8d25,tokenKey={}", (Object)tokenKey);
            throw new UserCenterRuntimeException(ErrorEnum.TOKEN_DELETE_FAIL);
        }
    }

    private void checkAccountPassword(AccountOperateBaseReqVO accountOperateBaseReqVO, UcAccountEntity account) {
        if (accountOperateBaseReqVO.getNeedCheckPw().booleanValue()) {
            if (StringUtils.isEmpty((CharSequence)accountOperateBaseReqVO.getPassword())) {
                throw new UserCenterRuntimeException(ErrorEnum.INVALID_PASSWORD);
            }
            String password = accountOperateBaseReqVO.getPassword().trim();
            String mixPassword = PasswordUtil.mix((String)password, (String)account.getPwSalt());
            if (!account.getAccountPw().equals(mixPassword)) {
                throw new UserCenterRuntimeException(ErrorEnum.INVALID_PASSWORD);
            }
        }
    }

    private void accountCancelLinkAction(UcAccountEntity account, String cacheToken) {
        Optional patientInfo;
        if (UserEnums.UserTypeEnum.PATIENT.getUserTypeValue().equals(account.getUserType()) && (patientInfo = this.ucPatientInfoMapper.findByUserIdAndPatientInfoStatus(account.getUserId(), UserEnums.PatientInfoStatusEnum.BINDING.getBinding())).isPresent() && !((List)patientInfo.get()).isEmpty()) {
            List patientInfoList = (List)patientInfo.get();
            String userId = account.getUserId();
            this.messageService.tokenInvalidMsg(cacheToken, CommonEnums.TokenInvalidCause.ULINK_PATIENT);
            String patientId = null;
            for (UcPatientInfoEntity patientInfoEntity : patientInfoList) {
                patientId = patientInfoEntity.getPatientId();
                patientInfoEntity.setPatientInfoStatus(UserEnums.PatientInfoStatusEnum.UNBINGDING.getBinding());
                this.ucPatientInfoMapper.save(patientInfoEntity);
                UcPatientOperateEntity patientOperateEntity = new UcPatientOperateEntity(account.getAccountId(), userId, patientId, patientInfoEntity.getId(), UserEnums.PatientInfoStatusEnum.UNBINGDING.getBinding(), UserEnums.PatientOperatorEnum.ACCOUNT_CANCEL.getUserType());
                this.ucPatientOperateMapper.save(patientOperateEntity);
                this.messageService.patientActionMsg(userId, patientId, UserEnums.PatientInfoStatusEnum.UNBINGDING);
            }
        }
    }

    public BaseResponse<BaseUserCenterIdRespVO> updatePasswordV2(UpdatePasswordReqVO updatePasswordReqVO) {
        UcAccountEntity account;
        this.log.info("\u8bbe\u7f6e\u3001\u66f4\u65b0\u5bc6\u7801\uff0c\u8bf7\u6c42\u53c2\u6570{}", (Object)JsonUtil.convertObject((Object)updatePasswordReqVO));
        if (updatePasswordReqVO.getUserType() == null) {
            updatePasswordReqVO.setUserType(UserEnums.UserTypeEnum.PATIENT.getUserTypeValue());
        }
        if (updatePasswordReqVO.getUserType() == null) {
            updatePasswordReqVO.setUserType(UserEnums.UserTypeEnum.PATIENT.getUserTypeValue());
        }
        if ((account = this.getAccount(updatePasswordReqVO.getAccountNo(), updatePasswordReqVO.getUserType(), updatePasswordReqVO.getAppCode())) == null) {
            return BaseResponse.error((IError)ErrorEnum.NO_EXISTS_ACCOUNT);
        }
        if (AccountEnums.AccountStatusEnum.PROHIBIT.getValue().equals(account.getStatus())) {
            return BaseResponse.error((IError)ErrorEnum.DISABLED_ACCOUNT);
        }
        if (updatePasswordReqVO.getIsCheckAuthCode() != null && updatePasswordReqVO.getIsCheckAuthCode().booleanValue()) {
            if (AccountEnums.AccountTypeEnum.CELL_PHONE.getValue().equals(account.getAccountType())) {
                SmsVerifiAuthCodeReqVO smsVerifiAuthCodeReqVo = new SmsVerifiAuthCodeReqVO();
                smsVerifiAuthCodeReqVo.setAuthCode(updatePasswordReqVO.getAuthCode());
                smsVerifiAuthCodeReqVo.setAuthKey(updatePasswordReqVO.getAuthKey());
                smsVerifiAuthCodeReqVo.setPhoneNum(updatePasswordReqVO.getAccountNo());
                if (!LoginDeviceType.WEB.equals((Object)updatePasswordReqVO.getLoginDeviceType())) {
                    this.log.info("\u8bbe\u7f6e\u3001\u66f4\u65b0\u5bc6\u7801\uff0c\u77ed\u4fe1\u9a8c\u8bc1\u7801\u6821\u9a8c\uff0c\u8bf7\u6c42\u53c2\u6570{}", (Object)JsonUtil.convertObject((Object)smsVerifiAuthCodeReqVo));
                    if (!super.verifialismsauthcode(smsVerifiAuthCodeReqVo)) {
                        return BaseResponse.error((IError)ErrorEnum.SMS_CODE_ERROR);
                    }
                }
            } else if (AccountEnums.AccountTypeEnum.EMAIL.getValue().equals(account.getAccountType())) {
                MailVerificationReqVo reqVo = new MailVerificationReqVo();
                reqVo.setMailAddress(updatePasswordReqVO.getAccountNo());
                reqVo.setAuthCode(updatePasswordReqVO.getAuthCode());
                reqVo.setAuthKey(updatePasswordReqVO.getAuthKey());
                if (!super.verifyMailAuthcode(reqVo)) {
                    return BaseResponse.error((IError)ErrorEnum.SMS_CODE_ERROR);
                }
            }
        }
        if (LoginDeviceType.WEB.equals((Object)updatePasswordReqVO.getLoginDeviceType())) {
            this.validNewPassword(account, updatePasswordReqVO.getPasswordNew());
        }
        PasswordAndSalt passwordAndSalt = PasswordUtil.mix((String)updatePasswordReqVO.getPasswordNew());
        account.setAccountPw(passwordAndSalt.getMixedPassword());
        account.setPwSalt(passwordAndSalt.getSalt());
        account.setUpdateTime(new Date());
        this.ucAccountMapper.save(account);
        UcAccountOperateEntity operate = new UcAccountOperateEntity(updatePasswordReqVO.getChannelCode(), AccountEnums.AccountOperationEnum.UPDATE_PASSWORD.getValue(), "\u8bbe\u7f6e\u3001\u66f4\u65b0\u4e86\u8d26\u6237\u5bc6\u7801", account.getAccountId(), JsonUtil.convertObject((Object)updatePasswordReqVO));
        this.ucAccountOperateMapper.save(operate);
        return BaseResponse.success((Object)new BaseUserCenterIdRespVO(account.getUserId(), account.getAccountId()));
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<BaseUserCenterIdRespVO> getbackPasswordV2(GetbackPasswordReqVO reqVO) {
        BaseResponse response;
        String key = "SMS_".concat(reqVO.getUserType().toString()).concat("_").concat(reqVO.getAccountNo());
        Object value = this.accountRedisUtil.get(key);
        this.log.info("\u627e\u56de\u5bc6\u7801==\u77ed\u4fe1value= {}", value);
        if (value == null || !reqVO.getAuthKey().equals(value)) {
            this.log.info("\u627e\u56de\u5bc6\u7801==\u77ed\u4fe1authkey\u6821\u9a8c\u5931\u8d25,reqVO:{}", (Object)JSON.toJSONString((Object)reqVO));
            return BaseResponse.error((IError)ErrorEnum.INVALID_PARAMETER);
        }
        if (UserEnums.UserTypeEnum.MANAGER.getUserTypeValue().equals(reqVO.getUserType())) {
            if (!RegexUtils.match_Aa_8_20((String)reqVO.getPasswordNew())) {
                this.log.info("\u627e\u56de\u5bc6\u7801==\u5bc6\u7801\u6b63\u5219\u6821\u9a8c\u5931\u8d25,reqVO:{}", (Object)JSON.toJSONString((Object)reqVO));
                return BaseResponse.error((IError)ErrorEnum.PASSWORD_SETTING_ERROR_3);
            }
        } else if (UserEnums.UserTypeEnum.PATIENT.getUserTypeValue().equals(reqVO.getUserType()) && !RegexUtils.match_a_6_20((String)reqVO.getPasswordNew()).booleanValue()) {
            this.log.info("\u627e\u56de\u5bc6\u7801==\u5bc6\u7801\u6b63\u5219\u6821\u9a8c\u5931\u8d25,reqVO:{}", (Object)JSON.toJSONString((Object)reqVO));
            return BaseResponse.error((IError)ErrorEnum.PASSWORD_SETTING_ERROR_4);
        }
        if ((response = this.getbackPassword(reqVO)).isSuccess() && UserEnums.UserTypeEnum.MANAGER.getUserTypeValue().equals(reqVO.getUserType())) {
            Optional ucManagerUserEntityOptional = this.ucManagerUserMapper.selectByUserId(((BaseUserCenterIdRespVO)response.getData()).getUserId());
            if (ucManagerUserEntityOptional.isPresent()) {
                this.log.info("===\u7ba1\u7406\u5458\u6fc0\u6d3b==userId:{}", (Object)((BaseUserCenterIdRespVO)response.getData()).getUserId());
                UcManagerUserEntity managerUserEntity = (UcManagerUserEntity)ucManagerUserEntityOptional.get();
                if (ManagerUserEnums.IsActiveEnum.NO.getValue().equals(managerUserEntity.getIsActive())) {
                    managerUserEntity.setIsActive(ManagerUserEnums.IsActiveEnum.YES.getValue());
                    this.ucManagerUserMapper.updateByPrimaryKeySelective(managerUserEntity);
                }
            }
            UcAccountEntity accountEntity = this.ucAccountMapper.findByAccountId(((BaseUserCenterIdRespVO)response.getData()).getAccountId());
            if (AccountEnums.ActiveEnum.ACTIVE_NO.getValue().equals(accountEntity.getIsActive())) {
                accountEntity.setIsActive(AccountEnums.ActiveEnum.ACTIVE_YES.getValue());
                this.ucAccountMapper.save(accountEntity);
            }
        }
        return response;
    }

    public BaseResponse<BaseUserCenterIdRespVO> updatePasswordV3(UpdatePasswordV3ReqVO updatePasswordReqVO) {
        Optional managerUserEntityOptional;
        UcAccountEntity account;
        this.log.info("v3==\u8bbe\u7f6e\u3001\u66f4\u65b0\u5bc6\u7801\uff0c\u8bf7\u6c42\u53c2\u6570{}", (Object)JsonUtil.convertObject((Object)updatePasswordReqVO));
        String userCenterActionAuthKey = updatePasswordReqVO.getUserCenterActionAuthKey();
        String userCenterActionName = updatePasswordReqVO.getUserCenterActionName();
        if (StringUtils.isEmpty((CharSequence)userCenterActionAuthKey) || StringUtils.isEmpty((CharSequence)userCenterActionName)) {
            return BaseResponse.error((IError)ErrorEnum.INVALID_PARAMETER, (String)"userCenterAuthKey\u3001userCenterActionName\u4e0d\u80fd\u4e3a\u7a7a");
        }
        super.valideUsercenterActionAuthKey(updatePasswordReqVO.getAccountNo(), userCenterActionAuthKey, userCenterActionName);
        if (updatePasswordReqVO.getUserType() == null) {
            updatePasswordReqVO.setUserType(PushCenterContants.CUSTOMER_USER_TYPE);
        }
        if ((account = this.getAccountByAccountNo(updatePasswordReqVO.getAccountNo(), updatePasswordReqVO.getUserType(), updatePasswordReqVO.getAppCode())) == null) {
            List entities = this.ucAccountMapper.selectByLoginNameAndUserTypeAndStatusAndAppCode(updatePasswordReqVO.getAccountNo(), updatePasswordReqVO.getUserType(), UserEnums.UserStatusEnum.NORMAL.getUserStatusValue(), updatePasswordReqVO.getAppCode());
            if (entities != null && entities.size() > 0) {
                account = (UcAccountEntity)entities.get(0);
            } else {
                return BaseResponse.error((IError)ErrorEnum.NO_EXISTS_ACCOUNT);
            }
        }
        if (AccountEnums.AccountStatusEnum.PROHIBIT.getValue().equals(account.getStatus())) {
            return BaseResponse.error((IError)ErrorEnum.DISABLED_ACCOUNT);
        }
        if (UserEnums.UserTypeEnum.MANAGER.getUserTypeValue().equals(updatePasswordReqVO.getUserType())) {
            if (SOURCE.equals(updatePasswordReqVO.getSource())) {
                if (!RegexUtils.match_a_6_20((String)updatePasswordReqVO.getPasswordNew()).booleanValue()) {
                    return BaseResponse.error((IError)ErrorEnum.PASSWORD_SETTING_ERROR_4);
                }
            } else if (!RegexUtils.match_Aa_8_20((String)updatePasswordReqVO.getPasswordNew())) {
                this.log.info("\u7ba1\u7406\u5458 \u8bbe\u7f6e\u3001\u4fee\u6539\u5bc6\u7801==\u5bc6\u7801\u6b63\u5219\u6821\u9a8c\u5931\u8d25,reqVO:{}", (Object)JSON.toJSONString((Object)updatePasswordReqVO));
                return BaseResponse.error((IError)ErrorEnum.PASSWORD_SETTING_ERROR_3);
            }
        } else if (UserEnums.UserTypeEnum.PATIENT.getUserTypeValue().equals(updatePasswordReqVO.getUserType()) && !RegexUtils.match_a_6_20((String)updatePasswordReqVO.getPasswordNew()).booleanValue()) {
            this.log.info("\u60a3\u8005\u7aef \u8bbe\u7f6e\u3001\u4fee\u6539\u5bc6\u7801==\u5bc6\u7801\u6b63\u5219\u6821\u9a8c\u5931\u8d25,reqVO:{}", (Object)JSON.toJSONString((Object)updatePasswordReqVO));
            return BaseResponse.error((IError)ErrorEnum.PASSWORD_SETTING_ERROR_4);
        }
        if (LoginDeviceType.WEB.toString().equalsIgnoreCase(updatePasswordReqVO.getLoginDeviceType())) {
            this.validNewPassword(account, updatePasswordReqVO.getPasswordNew());
        }
        PasswordAndSalt passwordAndSalt = PasswordUtil.mix((String)updatePasswordReqVO.getPasswordNew());
        account.setAccountPw(passwordAndSalt.getMixedPassword());
        account.setPwSalt(passwordAndSalt.getSalt());
        account.setUpdateTime(new Date());
        account.setIsActive(AccountEnums.ActiveEnum.ACTIVE_YES.getValue());
        this.ucAccountMapper.save(account);
        if (UserEnums.UserTypeEnum.MANAGER.getUserTypeValue().equals(updatePasswordReqVO.getUserType()) && (managerUserEntityOptional = this.ucManagerUserMapper.selectByUserId(account.getUserId())).isPresent()) {
            UcManagerUserEntity userEntity = (UcManagerUserEntity)managerUserEntityOptional.get();
            if (ManagerUserEnums.IsActiveEnum.NO.getValue().equals(userEntity.getIsActive())) {
                userEntity.setIsActive(ManagerUserEnums.IsActiveEnum.YES.getValue());
                this.log.info("\u7ba1\u7406\u5458\u72b6\u6001\u6fc0\u6d3b userid:{}", (Object)userEntity.getUserId());
                this.ucManagerUserMapper.updateByPrimaryKeySelective(userEntity);
            }
        }
        UcAccountOperateEntity operate = new UcAccountOperateEntity(updatePasswordReqVO.getChannelCode(), AccountEnums.AccountOperationEnum.UPDATE_PASSWORD.getValue(), "\u8bbe\u7f6e\u3001\u66f4\u65b0\u4e86\u8d26\u6237\u5bc6\u7801", account.getAccountId(), JsonUtil.convertObject((Object)updatePasswordReqVO));
        this.ucAccountOperateMapper.save(operate);
        return BaseResponse.success((Object)new BaseUserCenterIdRespVO(account.getUserId(), account.getAccountId()));
    }

    public BaseResponse<AccountLoginRespVO> wxLogin(WeChatLoginReqVO weChatLoginReqVO, String source) {
        List list = this.accountUcWxAuthMapper.findByOpenIdAndSubordinateTypeAndAppIdType(weChatLoginReqVO.getOpenId(), weChatLoginReqVO.getSubordinateType(), weChatLoginReqVO.getAppIdType());
        if (list == null || list.isEmpty()) {
            this.log.info("\u5fae\u4fe1\u767b\u5f55--\u975e\u6cd5\u7684openId:{}\uff0c\u6570\u636e\u5e93\u4e0d\u5b58\u5728", (Object)weChatLoginReqVO.getOpenId());
            return BaseResponse.error((IError)ErrorEnum.WX_INVALID_PARAMETER);
        }
        List unrelated = list.stream().filter(wxAuth -> wxAuth.getStatus().equals(WxAuthEnums.WxAuthStatusEnum.UNRELATED.getValue())).collect(Collectors.toList());
        if (unrelated != null && unrelated.size() == 1) {
            this.log.info("\u5fae\u4fe1\u767b\u5f55--\u672a\u67e5\u8be2\u5230\u5173\u8054\u8d26\u53f7,openid:{}", (Object)weChatLoginReqVO.getOpenId());
            return BaseResponse.error((IError)ErrorEnum.WX_UNRELATED_ACCOUNT);
        }
        List collect = list.stream().filter(wxAuth -> wxAuth.getStatus().equals(WxAuthEnums.WxAuthStatusEnum.NORMAL.getValue())).collect(Collectors.toList());
        if (collect.size() < 1) {
            this.log.info("\u5fae\u4fe1\u5df2\u5168\u90e8\u89e3\u7ed1==AppIdType:{}, openid:{}", (Object)weChatLoginReqVO.getAppIdType(), (Object)weChatLoginReqVO.getOpenId());
            return BaseResponse.error((IError)ErrorEnum.WX_UNBIND);
        }
        if (collect.size() > 1) {
            this.log.info("===\u5f02\u5e38==\u5fae\u4fe1\u7ed1\u5b9a\u903b\u8f91\u9519\u8bef==\uff1a\u540c\u4e00\u5fae\u4fe1\u4e0e{}\u4e2a\u8d26\u6237\u5b58\u5728\u7ed1\u5b9a\u5173\u7cfb,==AppIdType:{}, openid:{}", new Object[]{collect.size(), weChatLoginReqVO.getAppIdType(), weChatLoginReqVO.getOpenId()});
            return BaseResponse.error((IError)ErrorEnum.SYSTEM_ERROR);
        }
        UcWxAuthEntity wxAuth2 = (UcWxAuthEntity)collect.get(0);
        UcAccountEntity account = this.getRightAccount(wxAuth2.getAccountId());
        if (!wxAuth2.getUserId().equals(account.getUserId()) || !wxAuth2.getUserType().equals(account.getUserType())) {
            this.log.warn("\u5fae\u4fe1\u7ed1\u5b9a\u7528\u6237\u4e0e\u8d26\u6237\u5b9e\u9645\u6240\u5c5e\u8d26\u6237\u4e0d\u5339\u914d,\u8bf7\u6c42\u4fe1\u606f={}\uff0c\u8d26\u6237={}", (Object)JsonUtil.convertObject((Object)weChatLoginReqVO), (Object)JsonUtil.convertObject((Object)account));
            return BaseResponse.error((IError)ErrorEnum.USER_NOT_MATCH);
        }
        UserEntity userEntity = this.userService.getUserEntity(account.getUserId(), account.getUserType());
        if (userEntity == null) {
            this.log.warn("\u672a\u83b7\u53d6\u5230\u6709\u6548\u7684\u7528\u6237\u4fe1\u606f,\u8bf7\u6c42\u4fe1\u606f[{}],\u8d26\u6237\u4fe1\u606f={}", (Object)JsonUtil.convertObject((Object)weChatLoginReqVO), (Object)JsonUtil.convertObject((Object)account));
            return BaseResponse.error((IError)ErrorEnum.USER_NOT_EXIT);
        }
        CloudAccountLoginReqVO cloudAccountLoginReqVO = new CloudAccountLoginReqVO();
        BeanUtils.copyProperties((Object)weChatLoginReqVO, (Object)cloudAccountLoginReqVO);
        return this.postLoginHander(account, userEntity, cloudAccountLoginReqVO, source);
    }

    @Transactional
    public BaseResponse<WxPhoneLoginRespVO> wxPhoneLogin(WxPhoneLoginReqVO wxPhoneLoginReqVO, String source) {
        if (StringUtils.isEmpty((CharSequence)wxPhoneLoginReqVO.getPhoneNum())) {
            BaseResponse baseResponse = this.wxAuthService.getPhoneNumber(wxPhoneLoginReqVO.getEncrypdata(), wxPhoneLoginReqVO.getIvdata(), wxPhoneLoginReqVO.getSessionId());
            if (!baseResponse.isSuccess()) {
                this.log.error("\u5fae\u4fe1\u624b\u673a\u53f7\u83b7\u53d6\u5931\u8d25=={}", (Object)baseResponse.getMsg());
                return BaseResponse.error((IError)ErrorEnum.SYSTEM_ERROR);
            }
            wxPhoneLoginReqVO.setPhoneNum((String)baseResponse.getData());
        }
        List ucAccountEntityList = this.ucAccountMapper.selectListByUserTypeAndAppCodeAndAccountNoOrRelatedMobileNumber(wxPhoneLoginReqVO.getUserType(), wxPhoneLoginReqVO.getAppCode(), wxPhoneLoginReqVO.getPhoneNum());
        for (UcAccountEntity ucAccountEntity : ucAccountEntityList) {
            if (!UserEnums.UserStatusEnum.NORMAL.getUserStatusValue().equals(ucAccountEntity.getStatus()) && !UserEnums.UserStatusEnum.IMPERFECT.getUserStatusValue().equals(ucAccountEntity.getStatus())) continue;
            UserEntity userEntity = this.userService.getUserEntity(ucAccountEntity.getUserId(), ucAccountEntity.getUserType());
            if (userEntity != null) {
                WxBindingReqVo wxBindingReqVo = new WxBindingReqVo(wxPhoneLoginReqVO, ucAccountEntity.getAccountId(), ucAccountEntity.getUserId());
                this.wxAuthService.wxBinding(wxBindingReqVo);
                return this.createWxPhoneLoginReqVO(wxPhoneLoginReqVO, ucAccountEntity, userEntity, source);
            }
            this.log.warn("\u5fae\u4fe1\u4e00\u952e\u767b\u5f55,==\u8d70\u6ce8\u518c\u6d41\u7a0b==,\u8bf7\u6c42\u4fe1\u606f[{}],\u8d26\u6237\u4fe1\u606f={}", (Object)JsonUtil.convertObject((Object)wxPhoneLoginReqVO), (Object)JsonUtil.convertObject((Object)ucAccountEntity));
            break;
        }
        AccountRegisterReqVO registerReqVO = new AccountRegisterReqVO();
        BeanUtils.copyProperties((Object)wxPhoneLoginReqVO, (Object)registerReqVO);
        registerReqVO.setPassword("123456");
        registerReqVO.setIgnorePassword(true);
        registerReqVO.setAccountNo(wxPhoneLoginReqVO.getPhoneNum());
        registerReqVO.setUserType(wxPhoneLoginReqVO.getUserType());
        registerReqVO.setContactMobile(wxPhoneLoginReqVO.getPhoneNum());
        registerReqVO.setAccountType(Short.valueOf((short)0));
        BaseResponse register = this.register(registerReqVO);
        if (!register.isSuccess()) {
            BaseResponse.error((IError)ErrorEnum.LOGIN_WX_ERROR);
        }
        BaseIdRespVO data = (BaseIdRespVO)register.getData();
        UcAccountEntity accountEntity3 = this.ucAccountMapper.selectByUserTypeAndAppCodeAndStatusAndAccountNoOrRelatedMobileNumber(wxPhoneLoginReqVO.getUserType(), wxPhoneLoginReqVO.getAppCode(), AccountEnums.AccountStatusEnum.NORMAL.getValue(), wxPhoneLoginReqVO.getPhoneNum());
        if (accountEntity3 == null) {
            BaseResponse.error((IError)ErrorEnum.LOGIN_WX_ERROR);
        }
        UcPatientUserEntity patientUserEntity = new UcPatientUserEntity();
        patientUserEntity.setUserId(data.getUserId());
        patientUserEntity.setContactMobile(wxPhoneLoginReqVO.getPhoneNum());
        if (UserEnums.UserTypeEnum.PATIENT.getUserTypeValue().equals(wxPhoneLoginReqVO.getUserType())) {
            Optional userEntityOptional = this.ucPatientUserMapper.findByUserId(data.getUserId());
            if (!userEntityOptional.isPresent()) {
                BaseResponse.error((IError)ErrorEnum.LOGIN_WX_ERROR);
            }
            if (userEntityOptional.isPresent()) {
                patientUserEntity = (UcPatientUserEntity)userEntityOptional.get();
            }
        }
        WxBindingReqVo wxBindingReqVo = new WxBindingReqVo(wxPhoneLoginReqVO, data.getAccountId(), data.getUserId());
        this.wxAuthService.wxBinding(wxBindingReqVo);
        return this.createWxPhoneLoginReqVO(wxPhoneLoginReqVO, accountEntity3, (UserEntity)patientUserEntity, source);
    }

    public BaseResponse<AccountLoginRespVO> smsLogin(SmsLoginReqVO smsLoginReqVO, String source) {
        UcAccountEntity accountEntity = this.ucAccountMapper.selectByUserTypeAndAppCodeAndStatusAndAccountNoOrRelatedMobileNumber(smsLoginReqVO.getUserType(), smsLoginReqVO.getAppCode(), UserEnums.UserStatusEnum.NORMAL.getUserStatusValue(), smsLoginReqVO.getAccountNo());
        if (accountEntity == null) {
            this.log.warn("\u672a\u67e5\u8be2\u5230\u8d26\u6237:[{}]\u4fe1\u606f", (Object)smsLoginReqVO.getAccountNo());
            throw new UserCenterRuntimeException(ErrorEnum.NO_EXISTS_ACCOUNT);
        }
        UserEntity userEntity = this.userService.getUserEntity(accountEntity.getUserId(), accountEntity.getUserType());
        if (userEntity == null) {
            this.log.warn(UNUSEFUL_MESSAGE, (Object)smsLoginReqVO);
            throw new UserCenterRuntimeException(ErrorEnum.USER_NOT_EXIT);
        }
        return this.postLoginHander(accountEntity, userEntity, (CloudAccountLoginReqVO)smsLoginReqVO, source);
    }

    public BaseResponse<AccountLoginRespVO> smsLogin(CusSmsLoginReqVO reqVO, String source) {
        Object authKey;
        this.log.info("\u77ed\u4fe1\u9a8c\u8bc1\u7801\u767b\u5f55 \u8c03\u7528\u7528\u6237\u4e2d\u5fc3\u8bf7\u6c42\u53c2\u6570{}", (Object)reqVO);
        this.verifyVercode_web_manager(reqVO.getVercodeKey(), reqVO.getVercodeValue(), reqVO.getLoginDeviceType(), reqVO.getUserType(), reqVO.getLoginIp(), reqVO.getAccountNo(), reqVO.getAppCode());
        if (reqVO.getAuthKey() == null) {
            this.log.error("\u77ed\u4fe1\u6821\u9a8c\u7801\u767b\u5f55 \u53c2\u6570\u9519\u8bef\uff0c\u77ed\u4fe1\u552f\u4e00key\uff08authKey\uff09\u4e0d\u80fd\u4e3a\u7a7a");
            return BaseResponse.error((IError)ErrorEnum.INVALID_PARAMETER);
        }
        UcAccountEntity accountEntity = this.ucAccountMapper.selectByUserTypeAndAppCodeAndStatusAndAccountNoOrRelatedMobileNumber(reqVO.getUserType(), reqVO.getAppCode(), UserEnums.UserStatusEnum.NORMAL.getUserStatusValue(), reqVO.getAccountNo());
        if (accountEntity == null) {
            this.log.warn("\u672a\u67e5\u8be2\u5230\u8d26\u6237:[{}]\u4fe1\u606f", (Object)reqVO.getAccountNo());
            throw new UserCenterRuntimeException(ErrorEnum.NO_EXISTS_ACCOUNT);
        }
        SmsVerifiAuthCodeReqVO smsVerifiAuthCodeReqVo = new SmsVerifiAuthCodeReqVO();
        smsVerifiAuthCodeReqVo.setAuthCode(reqVO.getAuthCode());
        smsVerifiAuthCodeReqVo.setAuthKey(reqVO.getAuthKey());
        smsVerifiAuthCodeReqVo.setPhoneNum(reqVO.getAccountNo());
        this.log.info(INVALID_MESSAGE, (Object)JsonUtil.convertObject((Object)smsVerifiAuthCodeReqVo));
        if (Objects.equals("DYSJPT", reqVO.getAppCode()) ? !Objects.equals((authKey = this.redisUtil.get(reqVO.getAuthKey())).toString(), reqVO.getAuthCode()) : !super.verifialismsauthcode(smsVerifiAuthCodeReqVo)) {
            return BaseResponse.error((IError)ErrorEnum.SMS_CODE_ERROR);
        }
        SmsLoginReqVO smsLoginReqVO = new SmsLoginReqVO();
        BeanUtils.copyProperties((Object)reqVO, (Object)smsLoginReqVO);
        this.redisUtil.del(new String[]{reqVO.getAuthKey()});
        return this.smsLogin(smsLoginReqVO, source);
    }

    public BaseResponse<AccountLoginRespVO> smsLoginV2(SmsLoginReqVO reqVO, String source) {
        if (UserEnums.UserTypeEnum.MANAGER.getUserTypeValue().equals(reqVO.getUserType())) {
            Optional optional;
            UcAccountEntity ucAccountEntity = this.ucAccountMapper.selectByUserTypeAndAppCodeAndStatusAndAccountNoOrRelatedMobileNumber(reqVO.getUserType(), reqVO.getAppCode(), UserEnums.UserStatusEnum.NORMAL.getUserStatusValue(), reqVO.getAccountNo());
            if (ucAccountEntity != null && (optional = this.ucManagerUserMapper.selectByUserId(ucAccountEntity.getUserId())).isPresent()) {
                this.log.info("------smsLoginV2------reqVO:{},appcode:{}", (Object)JSON.toJSONString((Object)reqVO), (Object)JSON.toJSONString((Object)this.projProperties.getVercodeEnabledAppcode()));
                if (this.projProperties.getVercodeEnabled().booleanValue() && this.projProperties.getVercodeEnabledAppcode() != null && this.projProperties.getVercodeEnabledAppcode().contains(reqVO.getAppCode())) {
                    if (StringUtils.isEmpty((CharSequence)reqVO.getAuthKey()) || StringUtils.isEmpty((CharSequence)reqVO.getAuthCode())) {
                        return BaseResponse.error((IError)ErrorEnum.VERCODE_ERROR);
                    }
                    if (!super.verifyVercode(reqVO.getVercodeKey(), reqVO.getVercodeValue())) {
                        return BaseResponse.error((IError)ErrorEnum.VERCODE_ERROR);
                    }
                }
                SmsVerifiAuthCodeReqVO smsVerifiAuthCodeReqVo = new SmsVerifiAuthCodeReqVO();
                smsVerifiAuthCodeReqVo.setAuthCode(reqVO.getAuthCode());
                smsVerifiAuthCodeReqVo.setAuthKey(reqVO.getAuthKey());
                smsVerifiAuthCodeReqVo.setPhoneNum(reqVO.getAccountNo());
                this.log.info(INVALID_MESSAGE, (Object)JsonUtil.convertObject((Object)smsVerifiAuthCodeReqVo));
                if (!super.verifialismsauthcode(smsVerifiAuthCodeReqVo)) {
                    return BaseResponse.error((IError)ErrorEnum.SMS_CODE_ERROR);
                }
                UcManagerUserEntity ucManagerUserEntity = (UcManagerUserEntity)optional.get();
                if (ManagerUserEnums.IsActiveEnum.YES.getValue().equals(ucManagerUserEntity.getIsActive())) {
                    return this.smsLogin(reqVO, source);
                }
                String actionAuthKey = super.getUsercenterActionAuthKey(reqVO.getAccountNo(), LOGIN_V2);
                AccountLoginRespVO userLoginRespVO = new AccountLoginRespVO();
                BeanUtils.copyProperties((Object)reqVO, (Object)userLoginRespVO);
                userLoginRespVO.setIsActive(ManagerUserEnums.IsActiveEnum.NO.getValue());
                userLoginRespVO.setUserCenterActionAuthKey(actionAuthKey);
                userLoginRespVO.setUserCenterActionName(LOGIN_V2);
                this.log.info("\u7ba1\u7406\u5458\u8d26\u6237\u672a\u6fc0\u6d3b,userLoginRespVO:{}", (Object)JSON.toJSONString((Object)userLoginRespVO));
                this.log.info("\u5c1a\u672a\u6fc0\u6d3b\u7684\u8d26\u6237,{}==={}=={}", new Object[]{reqVO.getAccountNo(), reqVO.getUserType(), reqVO.getAppCode()});
                return BaseResponse.success((Object)userLoginRespVO);
            }
            return BaseResponse.error((IError)ErrorEnum.NO_EXISTS_ACCOUNT);
        }
        SmsVerifiAuthCodeReqVO smsVerifiAuthCodeReqVo = new SmsVerifiAuthCodeReqVO();
        smsVerifiAuthCodeReqVo.setAuthCode(reqVO.getAuthCode());
        smsVerifiAuthCodeReqVo.setAuthKey(reqVO.getAuthKey());
        smsVerifiAuthCodeReqVo.setPhoneNum(reqVO.getAccountNo());
        this.log.info(INVALID_MESSAGE, (Object)JsonUtil.convertObject((Object)smsVerifiAuthCodeReqVo));
        if (!super.verifialismsauthcode(smsVerifiAuthCodeReqVo)) {
            return BaseResponse.error((IError)ErrorEnum.SMS_CODE_ERROR);
        }
        return this.smsLogin(reqVO, source);
    }

    public BaseResponse<AccountLoginRespVO> loginWithVercode(UserLoginReqVO userLoginReqVO, String source) {
        return null;
    }

    private WechatRespVO createWeChatLoginResp(UcAccountEntity account, UserEntity userEntity, String loginToken, UcWxAuthEntity wxAuth) {
        WechatRespVO data = new WechatRespVO();
        BeanUtils.copyProperties((Object)account, (Object)data);
        data.setToken(loginToken);
        UserInfoRespVO userInfoRespVO = this.userService.getUserInfoRespVO(userEntity, account.getUserType());
        data.setUserInfoRespVO(userInfoRespVO);
        data.setAccountStatus(userInfoRespVO.getUserStatus());
        data.setOpenId(wxAuth.getWxOpenid());
        data.setUnionId(wxAuth.getWxUnionid());
        data.setSubordinateType(wxAuth.getSubordinateType());
        data.setWxstatus(wxAuth.getStatus());
        return data;
    }

    private TokenBody parseToken(String accessToken) {
        try {
            TokenBody tokenBody = UserCenterTokenParseUtil.parse((String)accessToken, (String)JWT_SECRET);
            if (tokenBody.getTtl().before(new Date())) {
                this.log.warn("token\u89e3\u6790\u5f02\u5e38\uff0caccessToken{}", (Object)accessToken);
                return null;
            }
            return tokenBody;
        }
        catch (TokenParseException | ExpiredJwtException | MalformedJwtException | SignatureException e) {
            this.log.warn("token\u89e3\u6790\u5f02\u5e38\uff0caccessToken{}", (Object)accessToken);
            return null;
        }
    }

    private boolean checkToken(TokenJson tokenJson, UserCenterBaseReqVO baseReq) {
        if (tokenJson == null) {
            return false;
        }
        if (tokenJson.getAppCode().equals(baseReq.getAppCode())) {
            return true;
        }
        return tokenJson.getChannelCode().equals(baseReq.getChannelCode());
    }

    public BaseResponse<WxPhoneLoginRespVO> createWxPhoneLoginReqVO(WxPhoneLoginReqVO wxPhoneLoginReqVO, UcAccountEntity ucAccountEntity, UserEntity userEntity, String source) {
        CloudAccountLoginReqVO accountLoginReqVO = new CloudAccountLoginReqVO();
        accountLoginReqVO.setLoginDeviceNum(wxPhoneLoginReqVO.getLoginDeviceNum());
        accountLoginReqVO.setLoginDeviceType(wxPhoneLoginReqVO.getLoginDeviceType());
        accountLoginReqVO.setAppCode(wxPhoneLoginReqVO.getAppCode());
        accountLoginReqVO.setChannelCode(wxPhoneLoginReqVO.getChannelCode());
        accountLoginReqVO.setLoginIp(wxPhoneLoginReqVO.getLoginIp());
        String tokenKey = this.loginInfoValid(accountLoginReqVO, ucAccountEntity);
        String loginToken = this.genLoginToken(accountLoginReqVO, ucAccountEntity, tokenKey, source);
        AccountLoginRespVO accountLoginResp = this.createAccountLoginResp(ucAccountEntity, userEntity, loginToken);
        this.log.info("\u751f\u6210\u8fd4\u56de\u5bf9\u8c61-accountLoginResp:{}", (Object)accountLoginResp);
        WxPhoneLoginRespVO phoneLoginRespVO = new WxPhoneLoginRespVO(wxPhoneLoginReqVO);
        BeanUtils.copyProperties((Object)accountLoginResp, (Object)phoneLoginRespVO);
        return BaseResponse.success((Object)phoneLoginRespVO);
    }

    @Transactional
    public BaseResponse<AccountLoginRespVO> patientRegister(PatientRigisterReqVO patientRigisterReqVO, String source) {
        this.log.info("\u5927\u4f17\u7528\u6237\u6ce8\u518c \u63a5\u53e3\u5165\u53c2:{}", (Object)patientRigisterReqVO);
        AccountRegisterReqVO accountRegisterReqVO = new AccountRegisterReqVO();
        BeanUtils.copyProperties((Object)patientRigisterReqVO, (Object)accountRegisterReqVO);
        accountRegisterReqVO.setUserType(UserEnums.UserTypeEnum.PATIENT.getUserTypeValue());
        BaseResponse voBaseResponse = this.register(accountRegisterReqVO);
        if (!voBaseResponse.isSuccess()) {
            return BaseResponse.error((IError)ErrorEnum.getEnum((String)voBaseResponse.getErrCode()));
        }
        BaseIdRespVO data1 = (BaseIdRespVO)voBaseResponse.getData();
        UcAccountEntity accountEntity = this.ucAccountMapper.findByAccountId(data1.getAccountId());
        Optional entityOptional = this.ucPatientUserMapper.findByUserId(data1.getUserId());
        if (accountEntity == null || !entityOptional.isPresent()) {
            this.log.error("\u6ce8\u518c\u5931\u8d25==\u672a\u67e5\u8be2\u5230\u8d26\u6237\u4fe1\u606faccountEntity:{},user:{}", (Object)accountEntity, (Object)entityOptional.isPresent());
            return BaseResponse.error((IError)ErrorEnum.REGISTER_ERROR);
        }
        CloudAccountLoginReqVO cloudAccountLoginReqVO = new CloudAccountLoginReqVO();
        BeanUtils.copyProperties((Object)patientRigisterReqVO, (Object)cloudAccountLoginReqVO);
        return this.postLoginHander(accountEntity, (UserEntity)entityOptional.get(), cloudAccountLoginReqVO, source);
    }

    @Transactional
    public BaseResponse<BaseIdRespVO> updateLoginPhoneBySms(UpdateLoginPhoneBySmsReqVO reqVO) {
        this.log.info("\u66f4\u6362\u624b\u673a\u53f7\uff0c\u8bf7\u6c42\u53c2\u6570{}", (Object)JsonUtil.convertObject((Object)reqVO));
        UcAccountEntity accountEntity = this.getAccount(reqVO.getPhoneNum(), reqVO.getUserType(), reqVO.getAppCode());
        if (accountEntity == null) {
            this.log.info("\u66f4\u6362\u624b\u673a\u53f7,\u539f\u8d26\u6237\u4e0d\u5b58\u5728" + reqVO.getPhoneNum());
            return BaseResponse.error((IError)ErrorEnum.NO_EXISTS_ACCOUNT);
        }
        UcAccountEntity account = this.getAccount(reqVO.getAccountNoNew(), reqVO.getUserType(), reqVO.getAppCode());
        if (account != null) {
            this.log.info("\u65b0\u624b\u673a\u5df2\u88ab\u7ed1\u5b9a" + reqVO.getAccountNoNew());
            return BaseResponse.error((IError)ErrorEnum.PHONE_ALREADY_BOUND_ANOTHER_ACCOUNT);
        }
        super.checkAccountNoRightByAccountType(reqVO.getAccountNoNew(), AccountEnums.AccountTypeEnum.CELL_PHONE.getValue());
        if (reqVO.getAccountNoNew() != null) {
            if (AccountEnums.AccountTypeEnum.CELL_PHONE.getValue().equals(accountEntity.getAccountType())) {
                accountEntity.setAccountNo(reqVO.getAccountNoNew());
                accountEntity.setRelatedMobileNumber(reqVO.getAccountNoNew());
            } else if (AccountEnums.AccountTypeEnum.EMAIL.getValue().equals(accountEntity.getAccountType())) {
                accountEntity.setRelatedMobileNumber(reqVO.getAccountNoNew());
            } else {
                accountEntity.setRelatedMobileNumber(reqVO.getAccountNoNew());
            }
            accountEntity.setUpdateTime(new Date());
            this.ucAccountMapper.save(accountEntity);
        }
        if (UserEnums.UserTypeEnum.PATIENT.getUserTypeValue().equals(reqVO.getUserType())) {
            Optional userEntityOptional = this.ucPatientUserMapper.findByUserId(accountEntity.getUserId());
            if (userEntityOptional.isPresent()) {
                UcPatientUserEntity userEntity = (UcPatientUserEntity)userEntityOptional.get();
                userEntity.setContactMobile(reqVO.getAccountNoNew());
                this.ucPatientUserMapper.updateByPrimaryKeySelective(userEntity);
            }
        } else if (UserEnums.UserTypeEnum.MANAGER.getUserTypeValue().equals(reqVO.getUserType())) {
            Optional ucManagerUserEntity = this.ucManagerUserMapper.selectByUserId(accountEntity.getUserId());
            if (ucManagerUserEntity.isPresent()) {
                UcManagerUserEntity managerUserEntity = (UcManagerUserEntity)ucManagerUserEntity.get();
                managerUserEntity.setContactMobile(reqVO.getAccountNoNew());
                this.ucManagerUserMapper.updateByPrimaryKeySelective(managerUserEntity);
            }
        } else {
            throw new UserCenterRuntimeException(ErrorEnum.UNKNOWN_ACCOUNT_TYPE);
        }
        this.accountOperateMapper.insertSelective(new UcAccountOperateEntity(reqVO.getChannelCode(), AccountEnums.AccountOperationEnum.UPDATE_ACCOUNT_NO.getValue(), "\u66f4\u6362\u5173\u8054\u7ed1\u5b9a\u7684\u624b\u673a\u53f7", accountEntity.getAccountId()));
        return BaseResponse.success((Object)new BaseIdRespVO(accountEntity.getUserId(), accountEntity.getAccountId()));
    }

    public BaseResponse<AccountLoginRespVO> loginOrRegisterWithPhone(LoginOrRegisterReqVo reqVO, String source) {
        this.log.info("\u767b\u5f55\u6ce8\u518c\u7edf\u4e00\u5165\u53e3  \u63a5\u53e3\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)reqVO));
        int action = 0;
        action = Objects.equals("NCZK-JSGY", reqVO.getAppCode()) ? this.checkAccountNo(reqVO.getAppCode(), Short.valueOf((short)4), reqVO.getAccountNo(), Boolean.valueOf(false)) : this.checkAccountNo(reqVO.getAppCode(), UserEnums.UserTypeEnum.PATIENT.getUserTypeValue(), reqVO.getAccountNo(), Boolean.valueOf(false));
        this.log.info("\u767b\u5f55\u6ce8\u518c\u7edf\u4e00\u5165\u53e3  \uff080\u6ce8\u518c\uff0c1\u767b\u5f55\uff0c2\u8fd4\u56de\u8d26\u6237\u5df2\u88ab\u7981\u7528\uff0c\u4e0d\u53ef\u767b\u5f55\u6216\u6ce8\u518c\uff09==\u300b\u5224\u65ad[{}]\u767b\u5f55/\u6ce8\u518c:{}", (Object)action, (Object)(action == 0 ? "\u6ce8\u518c" : (action == 1 ? "\u767b\u5f55" : "\u7981\u7528\u7684\u8d26\u6237")));
        switch (action) {
            case 0: {
                Object authKey;
                SmsVerifiAuthCodeReqVO smsVerifiAuthCodeReqVo = new SmsVerifiAuthCodeReqVO();
                smsVerifiAuthCodeReqVo.setAuthCode(reqVO.getAuthCode());
                smsVerifiAuthCodeReqVo.setAuthKey(reqVO.getAuthKey());
                smsVerifiAuthCodeReqVo.setPhoneNum(reqVO.getAccountNo());
                this.log.info(INVALID_MESSAGE, (Object)JsonUtil.convertObject((Object)smsVerifiAuthCodeReqVo));
                if (Objects.equals("DYSJPT", reqVO.getAppCode()) ? !Objects.equals((authKey = this.redisUtil.get(reqVO.getAuthKey())).toString(), reqVO.getAuthCode()) : !super.verifialismsauthcode(smsVerifiAuthCodeReqVo)) {
                    return BaseResponse.error((IError)ErrorEnum.SMS_CODE_ERROR);
                }
                AccountRegisterReqVO rigisterReqVO = new AccountRegisterReqVO();
                BeanUtils.copyProperties((Object)reqVO, (Object)rigisterReqVO);
                rigisterReqVO.setAccountType(AccountEnums.AccountTypeEnum.CELL_PHONE.getValue());
                BaseResponse register = this.registerV2(rigisterReqVO);
                String userId = ((BaseIdRespVO)register.getData()).getUserId();
                String accountId = ((BaseIdRespVO)register.getData()).getAccountId();
                if (register.isSuccess()) {
                    UserEntity userEntity;
                    UcAccountEntity accountEntity = this.ucAccountMapper.findByAccountId(accountId);
                    if (accountEntity == null) {
                        this.log.info("\u6ce8\u518c\u5931\u8d25-->accountId:{}", (Object)accountId);
                        return BaseResponse.error((IError)ErrorEnum.REGISTER_ERROR);
                    }
                    switch (reqVO.getUserType()) {
                        case 0: {
                            Optional optional = this.ucPatientUserMapper.findByUserId(userId);
                            if (!optional.isPresent()) {
                                this.log.info("\u6ce8\u518c\u5931\u8d25-->userId:{}", (Object)userId);
                                return BaseResponse.error((IError)ErrorEnum.REGISTER_ERROR);
                            }
                            userEntity = (UserEntity)optional.get();
                            break;
                        }
                        case 4: {
                            Optional ucPatientUserEntityOptional = this.ucPatientUserMapper.findByUserId(userId);
                            if (!ucPatientUserEntityOptional.isPresent()) {
                                this.log.info("\u6ce8\u518c\u5931\u8d25-->userId:{}", (Object)userId);
                                return BaseResponse.error((IError)ErrorEnum.REGISTER_ERROR);
                            }
                            userEntity = (UserEntity)ucPatientUserEntityOptional.get();
                            break;
                        }
                        case 3: {
                            Optional managerUserEntityOptional = this.ucManagerUserMapper.selectByUserId(userId);
                            if (!managerUserEntityOptional.isPresent()) {
                                this.log.info("\u6ce8\u518c\u5931\u8d25-->userId:{}", (Object)userId);
                                return BaseResponse.error((IError)ErrorEnum.REGISTER_ERROR);
                            }
                            userEntity = (UserEntity)managerUserEntityOptional.get();
                            break;
                        }
                        default: {
                            this.log.info("\u672a\u77e5\u7684\u7528\u6237\u7c7b\u578b={}", (Object)reqVO.getUserType());
                            return BaseResponse.error((IError)ErrorEnum.UNKNOWN_USER_TYPE);
                        }
                    }
                    CloudAccountLoginReqVO cloudAccountLoginReqVO = new CloudAccountLoginReqVO();
                    BeanUtils.copyProperties((Object)reqVO, (Object)cloudAccountLoginReqVO);
                    this.redisUtil.del(new String[]{reqVO.getAuthKey()});
                    return this.postLoginHander(accountEntity, userEntity, cloudAccountLoginReqVO, source);
                }
                this.log.info("\u6ce8\u518c\u5931\u8d25:{}", (Object)JSON.toJSONString((Object)register));
                return BaseResponse.error((IError)ErrorEnum.getEnum((String)register.getErrCode()));
            }
            case 1: {
                return this.smsLogin((CusSmsLoginReqVO)reqVO, source);
            }
            case 2: {
                this.log.info("\u767b\u5f55/\u6ce8\u518c\u5931\u8d25\uff0c\u8d26\u6237\u88ab\u7981\u7528accountNo:{}", (Object)reqVO.getAccountNo());
                return BaseResponse.error((IError)ErrorEnum.DISABLED_ACCOUNT);
            }
        }
        this.log.info("\u767b\u5f55/\u6ce8\u518c\u5931\u8d25\uff0caction={}", (Object)action);
        return BaseResponse.error((IError)ErrorEnum.WX_SYSTEM_BUSY);
    }

    public BaseResponse<AccountLoginRespVO> loginOrRegisterWithPhoneNo(LoginOrRegisterReqVo reqVO, String source) {
        if (Objects.equals("DYSJPT", reqVO.getAppCode())) {
            String phone = this.getPhoneByAuthCode(reqVO.getAuthCode());
            if (Objects.isNull(phone)) {
                this.log.info("\u5fb7\u9633\u4e00\u952e\u767b\u5f55/\u6ce8\u518c\u5931\u8d25\uff0cauthCode={}", (Object)reqVO.getAuthCode());
                return BaseResponse.error((IError)ErrorEnum.REGISTER_ERROR);
            }
            reqVO.setAccountNo(phone);
        }
        this.log.info("\u767b\u5f55\u6ce8\u518c\u7edf\u4e00\u5165\u53e3  \u63a5\u53e3\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)reqVO));
        int action = this.checkAccountNo(reqVO.getAppCode(), UserEnums.UserTypeEnum.PATIENT.getUserTypeValue(), reqVO.getAccountNo(), Boolean.valueOf(false));
        this.log.info("\u767b\u5f55\u6ce8\u518c\u7edf\u4e00\u5165\u53e3  \uff080\u6ce8\u518c\uff0c1\u767b\u5f55\uff0c2\u8fd4\u56de\u8d26\u6237\u5df2\u88ab\u7981\u7528\uff0c\u4e0d\u53ef\u767b\u5f55\u6216\u6ce8\u518c\uff09==\u300b\u5224\u65ad[{}]\u767b\u5f55/\u6ce8\u518c:{}", (Object)action, (Object)(action == 0 ? "\u6ce8\u518c" : (action == 1 ? "\u767b\u5f55" : "\u7981\u7528\u7684\u8d26\u6237")));
        switch (action) {
            case 0: {
                AccountRegisterReqVO rigisterReqVO = new AccountRegisterReqVO();
                BeanUtils.copyProperties((Object)reqVO, (Object)rigisterReqVO);
                rigisterReqVO.setAccountType(AccountEnums.AccountTypeEnum.CELL_PHONE.getValue());
                BaseResponse register = this.registerV2(rigisterReqVO);
                String userId = ((BaseIdRespVO)register.getData()).getUserId();
                String accountId = ((BaseIdRespVO)register.getData()).getAccountId();
                if (register.isSuccess()) {
                    UserEntity userEntity;
                    UcAccountEntity accountEntity = this.ucAccountMapper.findByAccountId(accountId);
                    if (accountEntity == null) {
                        this.log.info("\u6ce8\u518c\u5931\u8d25-->accountId:{}", (Object)accountId);
                        return BaseResponse.error((IError)ErrorEnum.REGISTER_ERROR);
                    }
                    switch (reqVO.getUserType()) {
                        case 0: {
                            Optional optional = this.ucPatientUserMapper.findByUserId(userId);
                            if (!optional.isPresent()) {
                                this.log.info("\u6ce8\u518c\u5931\u8d25-->userId:{}", (Object)userId);
                                return BaseResponse.error((IError)ErrorEnum.REGISTER_ERROR);
                            }
                            userEntity = (UserEntity)optional.get();
                            break;
                        }
                        case 3: {
                            Optional managerUserEntityOptional = this.ucManagerUserMapper.selectByUserId(userId);
                            if (!managerUserEntityOptional.isPresent()) {
                                this.log.info("\u6ce8\u518c\u5931\u8d25-->userId:{}", (Object)userId);
                                return BaseResponse.error((IError)ErrorEnum.REGISTER_ERROR);
                            }
                            userEntity = (UserEntity)managerUserEntityOptional.get();
                            break;
                        }
                        default: {
                            this.log.info("\u672a\u77e5\u7684\u7528\u6237\u7c7b\u578b={}", (Object)reqVO.getUserType());
                            return BaseResponse.error((IError)ErrorEnum.UNKNOWN_USER_TYPE);
                        }
                    }
                    CloudAccountLoginReqVO cloudAccountLoginReqVO = new CloudAccountLoginReqVO();
                    BeanUtils.copyProperties((Object)reqVO, (Object)cloudAccountLoginReqVO);
                    return this.postLoginHander(accountEntity, userEntity, cloudAccountLoginReqVO, source);
                }
                this.log.info("\u6ce8\u518c\u5931\u8d25:{}", (Object)JSON.toJSONString((Object)register));
                return BaseResponse.error((IError)ErrorEnum.getEnum((String)register.getErrCode()));
            }
            case 1: {
                SmsLoginReqVO smsLoginReqVO = new SmsLoginReqVO();
                BeanUtils.copyProperties((Object)reqVO, (Object)smsLoginReqVO);
                return this.smsLogin(smsLoginReqVO, source);
            }
            case 2: {
                this.log.info("\u767b\u5f55/\u6ce8\u518c\u5931\u8d25\uff0c\u8d26\u6237\u88ab\u7981\u7528accountNo:{}", (Object)reqVO.getAccountNo());
                return BaseResponse.error((IError)ErrorEnum.DISABLED_ACCOUNT);
            }
        }
        this.log.info("\u767b\u5f55/\u6ce8\u518c\u5931\u8d25\uff0caction={}", (Object)action);
        return BaseResponse.error((IError)ErrorEnum.WX_SYSTEM_BUSY);
    }

    public BaseResponse<AccountLoginRespVO> loginWithMail(LoginWithMailReqVo reqVO, String source) {
        this.log.info("\u90ae\u7bb1 \u767b\u5f55\u6ce8\u518c\u7edf\u4e00\u5165\u53e3  \u63a5\u53e3\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)reqVO));
        int action = this.checkAccountNo(reqVO.getAppCode(), UserEnums.UserTypeEnum.PATIENT.getUserTypeValue(), reqVO.getMailAddress(), Boolean.valueOf(false));
        this.log.info("\u90ae\u7bb1 \u767b\u5f55\u6ce8\u518c\u7edf\u4e00\u5165\u53e3  \uff080\u6ce8\u518c\uff0c1\u767b\u5f55\uff0c2\u8fd4\u56de\u8d26\u6237\u5df2\u88ab\u7981\u7528\uff0c\u4e0d\u53ef\u767b\u5f55\u6216\u6ce8\u518c\uff09==\u300b\u5224\u65ad[{}]\u767b\u5f55/\u6ce8\u518c:{}", (Object)action, (Object)(action == 0 ? "\u6ce8\u518c" : (action == 1 ? "\u767b\u5f55" : "\u7981\u7528\u7684\u8d26\u6237")));
        MailVerificationReqVo mailVerificationReqVo = new MailVerificationReqVo();
        mailVerificationReqVo.setAuthCode(reqVO.getAuthCode());
        mailVerificationReqVo.setAuthKey(reqVO.getAuthKey());
        mailVerificationReqVo.setMailAddress(reqVO.getMailAddress());
        this.log.info("\u8d26\u6237\u767b\u9646\uff0c\u8c03\u7528\u63a8\u9001\u670d\u52a1\uff0c\u6821\u9a8c\u90ae\u7bb1\u9a8c\u8bc1\u7801\uff0c\u8bf7\u6c42\u53c2\u6570{}", (Object)JsonUtil.convertObject((Object)mailVerificationReqVo));
        if (!super.verifyMailAuthcode(mailVerificationReqVo)) {
            return BaseResponse.error((IError)ErrorEnum.SMS_CODE_ERROR);
        }
        switch (action) {
            case 0: {
                Optional optionalUcAccountEntity = this.ucAccountMapper.selectByAccountNoAndUserTypeAndAppCodeAndStatus(reqVO.getMailAddress(), reqVO.getUserType(), reqVO.getAppCode(), AccountEnums.AccountStatusEnum.NO_REGISTER.getValue());
                if (!optionalUcAccountEntity.isPresent()) {
                    UcAccountEntity accountEntity = new UcAccountEntity(reqVO, AccountEnums.AccountStatusEnum.NO_REGISTER.getValue(), this.uniqueID.getNextId());
                    this.ucAccountMapper.save(accountEntity);
                }
                String actionName = "loginWithMail";
                String usercenterActionAuthKey = super.getUsercenterActionAuthKey(reqVO.getMailAddress(), actionName);
                AccountLoginRespVO respVO = new AccountLoginRespVO();
                respVO.setAccountNo(reqVO.getMailAddress());
                respVO.setAccountStatus(AccountEnums.AccountStatusEnum.NO_REGISTER.getValue());
                respVO.setUserCenterActionAuthKey(usercenterActionAuthKey);
                respVO.setUserCenterActionName(actionName);
                return BaseResponse.success((Object)respVO);
            }
            case 1: {
                return this.postMailLoginHandler(reqVO, source);
            }
            case 2: {
                this.log.info("\u767b\u5f55/\u6ce8\u518c\u5931\u8d25\uff0c\u8d26\u6237\u88ab\u7981\u7528accountNo:{}", (Object)reqVO.getMailAddress());
                return BaseResponse.error((IError)ErrorEnum.DISABLED_ACCOUNT);
            }
        }
        this.log.info("\u90ae\u7bb1\u767b\u5f55\u5931\u8d25\uff0caction={}", (Object)action);
        return BaseResponse.error((IError)ErrorEnum.SYSTEM_BUSY);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<AccountLoginRespVO> registerWithMail(RegisterWithMailReqVo reqVo, String source) {
        Optional optional;
        this.log.info("[\u90ae\u7bb1]\u7528\u6237\u6ce8\u518c \u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqVo));
        if (!RegexUtils.checkEmail((String)reqVo.getMailAddress())) {
            return BaseResponse.error((IError)ErrorEnum.WRONG_EMAIL);
        }
        int i = this.checkAccountNo(reqVo.getAppCode(), reqVo.getUserType(), reqVo.getMailAddress(), Boolean.valueOf(false));
        if (1 == i) {
            return BaseResponse.error((IError)ErrorEnum.EMAIL_ALREADY_EXISTS);
        }
        if (2 == i) {
            return BaseResponse.error((IError)ErrorEnum.EMAIL_PROHIBIT);
        }
        if (!RegexUtils.match_a_6_20((String)reqVo.getPassword()).booleanValue()) {
            this.log.info("\u5bc6\u7801\u8bbe\u7f6e\u6709\u8bef,\u957f\u5ea66-20\u4f4d\u6570\u5b57\u52a0\u5b57\u6bcd,password:{}", (Object)reqVo.getPassword());
            return BaseResponse.error((IError)ErrorEnum.PASSWORD_SETTING_ERROR_4);
        }
        Optional optionalUcAccountEntity = this.ucAccountMapper.selectByAccountNoAndUserTypeAndAppCodeAndStatus(reqVo.getMailAddress(), reqVo.getUserType(), reqVo.getAppCode(), AccountEnums.AccountStatusEnum.NO_REGISTER.getValue());
        if (!optionalUcAccountEntity.isPresent()) {
            this.log.info("[\u90ae\u7bb1]\u7528\u6237\u6ce8\u518c \u975e\u6cd5\u8bf7\u6c42 MailAddress:{}", (Object)reqVo.getMailAddress());
            return BaseResponse.error((IError)ErrorEnum.ILLEGAL_REQUEST);
        }
        UcAccountEntity accountEntity = (UcAccountEntity)optionalUcAccountEntity.get();
        AccountRegisterReqVO registerReqVO = new AccountRegisterReqVO();
        BeanUtils.copyProperties((Object)reqVo, (Object)registerReqVO);
        registerReqVO.setAccountId(accountEntity.getAccountId());
        registerReqVO.setAccountNo(reqVo.getMailAddress());
        registerReqVO.setAccountType(AccountEnums.AccountTypeEnum.EMAIL.getValue());
        registerReqVO.setIgnorePassword(false);
        registerReqVO.setUserType(reqVo.getUserType());
        registerReqVO.setPassword(reqVo.getPassword());
        registerReqVO.setEmail(reqVo.getMailAddress());
        BaseResponse register = this.register(registerReqVO);
        if (!register.isSuccess()) {
            this.log.info("[\u90ae\u7bb1]\u7528\u6237\u6ce8\u518c\u5931\u8d25 " + register.getMsg());
            return BaseResponse.error((IError)ErrorEnum.REGISTER_ERROR, (String)register.getMsg());
        }
        BaseIdRespVO data = (BaseIdRespVO)register.getData();
        UcAccountEntity ucAccountEntity = this.ucAccountMapper.findByAccountId(data.getAccountId());
        if (UserEnums.UserTypeEnum.PATIENT.getUserTypeValue().equals(reqVo.getUserType()) && (optional = this.ucPatientUserMapper.findByUserId(data.getUserId())).isPresent()) {
            UcPatientUserEntity patientUserEntity = (UcPatientUserEntity)optional.get();
            CloudAccountLoginReqVO cloudAccountLoginReqVO = new CloudAccountLoginReqVO();
            BeanUtils.copyProperties((Object)reqVo, (Object)cloudAccountLoginReqVO);
            cloudAccountLoginReqVO.setAccountNo(ucAccountEntity.getAccountNo());
            return this.postLoginHander(ucAccountEntity, (UserEntity)patientUserEntity, cloudAccountLoginReqVO, source);
        }
        return BaseResponse.error((IError)ErrorEnum.REGISTER_ERROR);
    }

    private int checkAccountNo(String appCode, Short userType, String accountNo, Boolean checkLoginName) {
        List accountEntityList = checkLoginName != false ? this.ucAccountMapper.selectListByUserTypeAndAppCodeAndAccountNoOrLoginName(userType, appCode, accountNo) : this.ucAccountMapper.selectListByUserTypeAndAppCodeAndAccountNoOrRelatedMobileNumber(userType, appCode, accountNo);
        this.log.info("\u67e5\u8be2\u8d26\u6237\u4fe1\u606f=={}", (Object)JSON.toJSONString((Object)accountEntityList));
        int action = 0;
        if (accountEntityList == null || accountEntityList.isEmpty()) {
            action = 0;
        } else {
            for (UcAccountEntity ucAccount : accountEntityList) {
                if (ucAccount.getStatus().equals(AccountEnums.AccountStatusEnum.NORMAL.getValue())) {
                    action = 1;
                    break;
                }
                if (ucAccount.getStatus().equals(AccountEnums.AccountStatusEnum.CANCELLATION.getValue())) {
                    if (2 == action) continue;
                    action = 0;
                    continue;
                }
                if (ucAccount.getStatus().equals(AccountEnums.AccountStatusEnum.PROHIBIT.getValue())) {
                    action = 2;
                    continue;
                }
                if (!ucAccount.getStatus().equals(AccountEnums.AccountStatusEnum.NO_REGISTER.getValue())) continue;
                action = 0;
                break;
            }
        }
        return action;
    }

    private BaseResponse<AccountLoginRespVO> postLoginHander(UcAccountEntity accountEntity, UserEntity userEntity, CloudAccountLoginReqVO accountLoginReqVO, String source) {
        this.log.info("post\u767b\u5f55\u5904\u7406 \u53c2\u6570accountEntity={},UserEntity={},CloudAccountLoginReqVO={}", new Object[]{accountEntity, userEntity, accountLoginReqVO});
        String tokenKey = this.loginInfoValid(accountLoginReqVO, accountEntity);
        String loginToken = this.genLoginToken(accountLoginReqVO, accountEntity, tokenKey, source);
        AccountLoginRespVO accountLoginResp = this.createAccountLoginResp(accountEntity, userEntity, loginToken);
        return BaseResponse.success((Object)accountLoginResp);
    }

    private BaseIdRespVO postRegisterHandler(AccountRegisterReqVO accountRegisterReqVO) {
        UcPatientUserEntity user;
        this.checkAccountNoRightByAccountType(accountRegisterReqVO.getAccountNo(), accountRegisterReqVO.getAccountType());
        if (super.checkAccountExist(accountRegisterReqVO.getAccountNo(), accountRegisterReqVO.getUserType(), accountRegisterReqVO.getAppCode(), accountRegisterReqVO.getAccountType()).booleanValue()) {
            throw new UserCenterRuntimeException(ErrorEnum.ACCOUNT_REGISTERED);
        }
        BaseIdRespVO data = new BaseIdRespVO();
        String userId = null;
        if (UserEnums.UserTypeEnum.PATIENT.getUserTypeValue().equals(accountRegisterReqVO.getUserType())) {
            user = this.buildPatientUserEntity(accountRegisterReqVO);
            this.ucPatientUserMapper.save(user);
            userId = user.getUserId();
            this.log.info("\u60a3\u8005\u7528\u6237\u6dfb\u52a0\u6210\u529f,\u8bf7\u6c42\u53c2\u6570={},\u60a3\u8005\u4fe1\u606f={}", (Object)JsonUtil.convertObject((Object)accountRegisterReqVO), (Object)JsonUtil.convertObject((Object)user));
        } else if (UserEnums.UserTypeEnum.DOCTOR.getUserTypeValue().equals(accountRegisterReqVO.getUserType())) {
            user = this.buildDoctorUserEntity(accountRegisterReqVO);
            this.ucDoctorUserMapper.save((UcDoctorUserEntity)user);
            userId = user.getUserId();
            this.log.info("\u533b\u751f\u7528\u6237\u6dfb\u52a0\u6210\u529f,\u8bf7\u6c42\u53c2\u6570={},\u533b\u751f\u4fe1\u606f={}", (Object)JsonUtil.convertObject((Object)accountRegisterReqVO), (Object)JsonUtil.convertObject((Object)user));
        } else if (UserEnums.UserTypeEnum.ORGAN.getUserTypeValue().equals(accountRegisterReqVO.getUserType())) {
            user = this.buildOrganUserEntity(accountRegisterReqVO);
            this.ucOrganUserMapper.save((UcOrganUserEntity)user);
            userId = user.getUserId();
            this.log.info("\u673a\u6784\u7528\u6237\u6dfb\u52a0\u6210\u529f,\u8bf7\u6c42\u53c2\u6570={},\u673a\u6784\u4fe1\u606f={}", (Object)JsonUtil.convertObject((Object)accountRegisterReqVO), (Object)JsonUtil.convertObject((Object)user));
        } else if (UserEnums.UserTypeEnum.MANAGER.getUserTypeValue().equals(accountRegisterReqVO.getUserType())) {
            user = this.buildManagerUserEntity(accountRegisterReqVO);
            this.ucManagerUserMapper.save((UcManagerUserEntity)user);
            userId = user.getUserId();
            this.log.info("\u7ba1\u7406\u5458\u7528\u6237\u6dfb\u52a0\u6210\u529f,\u8bf7\u6c42\u53c2\u6570={},\u7ba1\u7406\u5458\u4fe1\u606f={}", (Object)JsonUtil.convertObject((Object)accountRegisterReqVO), (Object)JsonUtil.convertObject((Object)user));
        } else if (UserEnums.UserTypeEnum.COMMUNITY.getUserTypeValue().equals(accountRegisterReqVO.getUserType())) {
            if (Objects.equals("NCZK-JSGY", accountRegisterReqVO.getAppCode())) {
                user = this.buildPatientUserEntity(accountRegisterReqVO);
                this.ucPatientUserMapper.save(user);
                userId = user.getUserId();
                this.log.info("\u60a3\u8005\u7528\u6237\u6dfb\u52a0\u6210\u529f,\u8bf7\u6c42\u53c2\u6570={},\u60a3\u8005\u4fe1\u606f={}", (Object)JsonUtil.convertObject((Object)accountRegisterReqVO), (Object)JsonUtil.convertObject((Object)user));
            } else {
                user = this.buildCommunityUserEntity(accountRegisterReqVO);
                this.ucCommunityUserMapper.insertSelective((UcCommunityUserEntity)user);
                userId = user.getUserId();
                this.log.info("\u793e\u533a\u7528\u6237\u6dfb\u52a0\u6210\u529f,\u8bf7\u6c42\u53c2\u6570={},\u793e\u533a\u7528\u6237\u4fe1\u606f={}", (Object)JsonUtil.convertObject((Object)accountRegisterReqVO), (Object)JsonUtil.convertObject((Object)user));
            }
        } else {
            throw new UserCenterRuntimeException(ErrorEnum.UNKNOWN_ACCOUNT_TYPE);
        }
        data.setUserId(userId);
        UcAccountEntity account = new UcAccountEntity(accountRegisterReqVO, userId);
        String accountId = accountRegisterReqVO.getAccountId();
        if (StringUtils.isEmpty((CharSequence)accountId)) {
            long accountIdValue = this.uniqueID.nextId();
            accountId = String.valueOf(accountIdValue);
            account.setAccountId(accountId);
            data.setAccountId(accountId);
        } else {
            account.setAccountId(accountId);
            data.setAccountId(accountId);
        }
        UcAccountEntity accountEntity = this.ucAccountMapper.selectByAccountId(accountId);
        if (accountEntity != null) {
            account.setId(accountEntity.getId());
        }
        this.ucAccountMapper.save(account);
        this.log.info("\u65b0\u589e\u8d26\u6237 \u6dfb\u52a0\u6210\u529f,\u8bf7\u6c42\u53c2\u6570={},\u8d26\u6237\u4fe1\u606f={}", (Object)JsonUtil.convertObject((Object)accountRegisterReqVO), (Object)JsonUtil.convertObject((Object)account));
        UcAccountOperateEntity accountOperate = new UcAccountOperateEntity(accountRegisterReqVO.getChannelCode(), AccountEnums.AccountOperationEnum.REGISTER.getValue(), "\u6ce8\u518c\u8d26\u6237", accountId, JsonUtil.convertObject((Object)accountRegisterReqVO));
        this.ucAccountOperateMapper.save(accountOperate);
        return data;
    }

    private BaseResponse<AccountLoginRespVO> postMailLoginHandler(LoginWithMailReqVo reqVO, String source) {
        this.log.info("===\u90ae\u7bb1\u767b\u5f55postMailLoginHander==LoginWithMailReqVo:{}", (Object)JSON.toJSONString((Object)reqVO));
        Optional optionalUcAccountEntity = this.ucAccountMapper.selectByAccountNoAndUserTypeAndAppCodeAndStatus(reqVO.getMailAddress(), reqVO.getUserType(), reqVO.getAppCode(), AccountEnums.AccountStatusEnum.NORMAL.getValue());
        if (!optionalUcAccountEntity.isPresent()) {
            return BaseResponse.error((IError)ErrorEnum.NO_EXISTS_ACCOUNT);
        }
        UcAccountEntity accountEntity = (UcAccountEntity)optionalUcAccountEntity.get();
        Optional userEntityOptional = this.ucPatientUserMapper.findByUserId(accountEntity.getUserId());
        if (!userEntityOptional.isPresent()) {
            return BaseResponse.error((IError)ErrorEnum.USER_NOT_EXIT);
        }
        CloudAccountLoginReqVO cloudAccountLoginReqVO = new CloudAccountLoginReqVO();
        BeanUtils.copyProperties((Object)reqVO, (Object)cloudAccountLoginReqVO);
        return this.postLoginHander(accountEntity, (UserEntity)userEntityOptional.get(), cloudAccountLoginReqVO, source);
    }

    @Async
    void logStore(String name, String phone, String reqParams) {
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap<String, String> param = new HashMap<String, String>();
        HttpServletRequest req = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        param.put("appCode", req.getHeader("appCode"));
        param.put("channelSource", req.getHeader("channelSource"));
        param.put("ip", this.getIpAddress(req));
        param.put("name", name);
        param.put("phone", phone);
        param.put("reqUrl", "/usercenter" + req.getRequestURI());
        param.put("reqParams", reqParams);
        HttpEntity paramEntity = new HttpEntity(param, (MultiValueMap)headers);
        this.log.info("\u53d1\u8d77\u64cd\u4f5c\u65e5\u5fd7\u8bb0\u5f55\u8bf7\u6c42,\u53c2\u6570:{}", (Object)JSON.toJSONString(param));
        restTemplate.postForObject(this.projProperties.getEbaiyihuiDomain().concat(LOGGING_STORED_URL), (Object)paramEntity, BaseResponse.class, new Object[0]);
    }

    private String getIpAddress(HttpServletRequest request) {
        String ip = request.getHeader("X-Forwarded-For");
        if (ip == null || ip.length() == 0 || UNKNOW.equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || UNKNOW.equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || UNKNOW.equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || UNKNOW.equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || UNKNOW.equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    private String getPhoneByAuthCode(String code) {
        HashMap<String, String> tokenMap = new HashMap<String, String>(6);
        tokenMap.put("code", code);
        tokenMap.put("client_id", this.projProperties.getSsoClientId());
        tokenMap.put("client_secret", this.projProperties.getSsoClientSecret());
        tokenMap.put("grant_type", "authorization_code");
        tokenMap.put("redirect_uri", "https://dysmt.chinachdu.com");
        String tokenString = HttpUtil.post((String)this.projProperties.getSsoTokenUrl(), tokenMap);
        Map map = (Map)JSONObject.parseObject((String)tokenString, Map.class);
        Object access_token = map.get("access_token");
        if (Objects.isNull(access_token)) {
            return null;
        }
        HashMap phoneMap = new HashMap(1);
        phoneMap.put("access_token", access_token);
        String phoneString = HttpUtil.post((String)this.projProperties.getSsoUserUrl(), phoneMap);
        Map phoneRedultMap = (Map)JSONObject.parseObject((String)phoneString, Map.class);
        Object resultCode = phoneRedultMap.get("code");
        if (Objects.isNull(resultCode)) {
            return null;
        }
        Map contentMap = (Map)JSONObject.parseObject((String)phoneRedultMap.get("content").toString(), Map.class);
        return contentMap.get("phone").toString();
    }
}

