/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.LoggerContextVO;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.AppenderBase;
import com.ebaiyihui.framework.utils.DateTimeUtil;
import com.ebaiyihui.framework.utils.StringUtil;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAlarmAppender
extends AppenderBase<LoggingEvent> {
    private static final Logger log = LoggerFactory.getLogger(AbstractAlarmAppender.class);
    private static final String template_offline = "\u670d\u52a1\u540d: %s \n\u5f53\u524d\u73af\u5883: %s \n\u65e5\u5fd7\u7b49\u7ea7: %s \n\u5f02\u5e38\u65f6\u95f4: %s \n\u5f02\u5e38\u63cf\u8ff0: %s \n\u5f02\u5e38\u8be6\u7ec6\u4fe1\u606f: %s";

    protected void append(LoggingEvent eventObject) {
        try {
            Level level = eventObject.getLevel();
            if (Level.ERROR != level) {
                return;
            }
            LoggerContextVO loggerContextVO = eventObject.getLoggerContextVO();
            IThrowableProxy proxy = eventObject.getThrowableProxy();
            Map propertyMap = loggerContextVO.getPropertyMap();
            String active = (String)propertyMap.get("ACTIVE");
            if (null == proxy) {
                return;
            }
            Throwable t = ((ThrowableProxy)proxy).getThrowable();
            if (t.getMessage().contains("com.ebaiyihui.server.exception.BusinessException") || t.toString().contains("Exceptions")) {
                log.info("\u81ea\u5b9a\u4e49\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)Arrays.toString(t.getStackTrace()));
                return;
            }
            if (t.getMessage().contains("org.springframework.web.method.annotation.MethodArgumentTypeMismatchException") || t.toString().contains("MethodArgumentTypeMismatchException")) {
                log.info("mvc\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)Arrays.toString(t.getStackTrace()));
                return;
            }
            String name = (String)propertyMap.get("springAppName");
            log.info("propertyMap\u8fc7\u6ee4\u524d={}", (Object)propertyMap);
            Map<String, String> filterMap = propertyMap.entrySet().stream().filter(map -> !"FILE_PATTERN".equalsIgnoreCase((String)map.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            log.info("propertyMap\u8fc7\u6ee4\u540e={}", filterMap);
            String messageText = String.format(template_offline, StringUtil.isBlank((String)name) ? loggerContextVO.getName() : name, filterMap, eventObject.getLevel(), DateTimeUtil.formatTime((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"), t.toString().length() <= 1000 ? t : t.toString().substring(0, 1000), Arrays.toString(t.getStackTrace()).length() <= 1888 ? Arrays.toString(t.getStackTrace()) : Arrays.toString(t.getStackTrace()).substring(0, 1888));
            System.out.println("-----" + messageText);
            this.monitor(messageText);
        }
        catch (Exception e) {
            this.addError("\u65e5\u5fd7\u62a5\u8b66\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0:{}", (Throwable)e);
        }
    }

    private static String subStr4Byte(String str, Integer len) {
        byte[] bt;
        String strRet = str;
        if (str != null && (bt = str.getBytes()).length > len) {
            strRet = bt[len - 1] < 0 ? new String(bt, 0, len - 1) : new String(bt, 0, (int)len);
        }
        return strRet;
    }

    protected abstract void monitor(String var1);
}

