/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.logback.wx;

import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.server.logback.MessageManager;
import com.ebaiyihui.server.logback.TextMessage;
import com.ebaiyihui.server.logback.wx.Message;
import com.ebaiyihui.server.logback.wx.MessageTypeEnum;
import com.ebaiyihui.server.logback.wx.WxAlarmService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class WechatAlarm
implements WxAlarmService {
    private String webHookUrl;
    private ThreadPoolTaskExecutor threadPoolExecutor;

    @Autowired
    public void setTaskExecutePool(ThreadPoolTaskExecutor threadPoolExecutor) {
        this.threadPoolExecutor = threadPoolExecutor;
    }

    public WechatAlarm() {
    }

    public WechatAlarm(String webHookUrl) {
        this.webHookUrl = webHookUrl;
    }

    private Message buildParam(String messageText) {
        Message message = new Message();
        message.setMsgtype(MessageTypeEnum.text);
        TextMessage textMessage = new TextMessage();
        textMessage.setContent(messageText);
        JSONObject text = JSONObject.parseObject((String)JSONObject.toJSONString((Object)textMessage));
        message.setText(text);
        return message;
    }

    public boolean alarm(String messageText) {
        this.threadPoolExecutor.execute(() -> {
            try {
                Message message = this.buildParam(messageText);
                MessageManager.sendMessage((Message)message, (String)this.webHookUrl);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        return true;
    }
}

