/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.client.RoleClient;
import com.ebaiyihui.client.UserOrganClient;
import com.ebaiyihui.common.UserOrganInfoVO;
import com.ebaiyihui.common.enums.ErrorEnum;
import com.ebaiyihui.common.pojo.query.UcAccountQuery;
import com.ebaiyihui.common.pojo.systemauthVo.AccountResVo;
import com.ebaiyihui.common.pojo.systemauthVo.ManagerAddReqVo;
import com.ebaiyihui.common.pojo.systemauthVo.ManagerEditReqVo;
import com.ebaiyihui.common.pojo.systemauthVo.MemberCountResVo;
import com.ebaiyihui.common.pojo.systemauthVo.VerifyPasswordReqVo;
import com.ebaiyihui.common.vo.role.RoleInfoVO;
import com.ebaiyihui.framework.model.ExcelData;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import com.ebaiyihui.framework.utils.PasswordAndSalt;
import com.ebaiyihui.framework.utils.PasswordUtil;
import com.ebaiyihui.framework.utils.RegexUtils;
import com.ebaiyihui.server.enums.AccountEnums;
import com.ebaiyihui.server.enums.ManagerUserEnums;
import com.ebaiyihui.server.enums.UserEnums;
import com.ebaiyihui.server.exception.UserCenterRuntimeException;
import com.ebaiyihui.server.pojo.entity.UcAccountEntity;
import com.ebaiyihui.server.pojo.entity.UcManagerUserEntity;
import com.ebaiyihui.server.repository.UcAccountMapper;
import com.ebaiyihui.server.repository.UcManagerUserMapper;
import com.ebaiyihui.server.service.BaseService;
import com.ebaiyihui.server.service.IManagerAuthService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ManagerAuthServiceImpl
extends BaseService
implements IManagerAuthService {
    private static final Logger log = LoggerFactory.getLogger(ManagerAuthServiceImpl.class);
    @Autowired
    private UcAccountMapper accountMapper;
    @Autowired
    private UcManagerUserMapper managerUserMapper;
    @Autowired
    private RoleClient roleClient;
    @Autowired
    private UserOrganClient userOrganClient;

    public BaseResponse<MemberCountResVo> getMemberCount(String appCode) {
        log.info("ManagerAuth::\u8fdb\u5165[\u83b7\u53d6\u6210\u5458\u7edf\u8ba1\u4fe1\u606f]\u65b9\u6cd5");
        UcAccountQuery query = new UcAccountQuery();
        query.setAppCode(appCode);
        MemberCountResVo vo = new MemberCountResVo();
        vo.setAllCount(this.accountMapper.selectCountByCondition(query));
        query.setIsActive(AccountEnums.ActiveEnum.ACTIVE_YES.getValue());
        vo.setActiveCount(this.accountMapper.selectCountByCondition(query));
        query.setIsActive(AccountEnums.ActiveEnum.ACTIVE_NO.getValue());
        vo.setNotActiveCount(this.accountMapper.selectCountByCondition(query));
        log.info("ManagerAuth::[\u83b7\u53d6\u6210\u5458\u7edf\u8ba1\u4fe1\u606f]\u6210\u529f");
        return BaseResponse.success((Object)vo);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<AccountResVo> addMember(ManagerAddReqVo vo) {
        log.info("ManagerAuth::\u8fdb\u5165[\u6dfb\u52a0\u6210\u5458]\u65b9\u6cd5,\u5165\u53c2\u4e3a{}", (Object)JSON.toJSONString((Object)vo));
        if (vo.getAccountNo() == null || StringUtils.isEmpty((CharSequence)vo.getAccountNo())) {
            vo.setAccountNo(vo.getLoginPhone());
        }
        if (vo.getAccountType() == null) {
            vo.setAccountType(AccountEnums.AccountTypeEnum.CELL_PHONE.getValue());
        }
        this.verifyManagerAddAvailable(vo);
        UcAccountEntity entity = new UcAccountEntity();
        entity.setAccountNo(vo.getAccountNo());
        PasswordAndSalt passwordAndSalt = PasswordUtil.mix((String)vo.getPassword());
        entity.setAccountPw(passwordAndSalt.getMixedPassword());
        entity.setPwSalt(passwordAndSalt.getSalt());
        entity.setLoginName(vo.getLoginName());
        entity.setRealName(vo.getRealName());
        entity.setAppCode(vo.getAppCode());
        if (AccountEnums.AccountTypeEnum.CELL_PHONE.getValue().equals(vo.getAccountType())) {
            entity.setRelatedMobileNumber(vo.getLoginPhone());
        }
        entity.setRegisterChannel(vo.getChannelCode());
        String snowId = this.uniqueID.getNextId();
        entity.setAccountId(snowId);
        entity.setUserId(snowId);
        entity.setUserType(UserEnums.UserTypeEnum.MANAGER.getUserTypeValue());
        entity.setAccountType(vo.getAccountType());
        entity.setStatus(UserEnums.UserStatusEnum.NORMAL.getUserStatusValue());
        entity.setIsActive(AccountEnums.ActiveEnum.ACTIVE_NO.getValue());
        this.accountMapper.save(entity);
        log.info("ManagerAuth::\u6210\u5458\u6210\u529f\u6dfb\u52a0\u5230 uc_account \u8868\u4e2d");
        this.updateManagerUser(entity, vo.getPassword());
        log.info("ManagerAuth::\u6210\u5458\u6210\u529f\u6dfb\u52a0\u5230 uc_manager_user \u8868\u4e2d");
        AccountResVo resVo = this.getResVo(entity);
        return BaseResponse.success((Object)resVo);
    }

    private AccountResVo getResVo(UcAccountEntity entity) {
        AccountResVo vo = new AccountResVo();
        vo.setId(entity.getId());
        vo.setCreateTime(entity.getCreateTime());
        vo.setLoginName(entity.getLoginName());
        vo.setIsActive(entity.getIsActive());
        vo.setAccountNo(entity.getAccountNo());
        vo.setUserId(entity.getUserId());
        vo.setAccountId(entity.getAccountId());
        vo.setRealName(entity.getRealName());
        return vo;
    }

    private void updateManagerUser(UcAccountEntity entity, String initializePassword) {
        Optional optional = this.managerUserMapper.selectByUserId(entity.getUserId());
        UcManagerUserEntity manager = optional.orElseGet(UcManagerUserEntity::new);
        manager.setUserId(entity.getUserId());
        manager.setContactMobile(entity.getRelatedMobileNumber());
        if (manager.getRegisterMobile() == null) {
            manager.setRegisterMobile(entity.getRelatedMobileNumber());
        }
        manager.setName(entity.getRealName());
        manager.setUserStatus(entity.getStatus());
        if (manager.getIsActive() == null) {
            manager.setIsActive(ManagerUserEnums.IsActiveEnum.NO.getValue());
        }
        if (null != initializePassword) {
            manager.setInitializePassword(initializePassword);
        }
        log.info("\u4fdd\u5b58\u6210\u5458\u4fe1\u606fmanager:{}", (Object)JSON.toJSONString((Object)manager));
        this.managerUserMapper.save(manager);
    }

    public BaseResponse<AccountResVo> editMember(ManagerEditReqVo vo) {
        UcAccountEntity ucAccountEntity;
        log.info("ManagerAuth::[\u4fee\u6539\u6210\u5458\u4fe1\u606f]\u65b9\u6cd5\u8fdb\u5165...\u5165\u53c2\u4e3a{}", (Object)JSON.toJSONString((Object)vo));
        if (vo.getAccountNo() == null || StringUtils.isEmpty((CharSequence)vo.getAccountNo())) {
            vo.setAccountNo(vo.getLoginPhone());
        }
        if (vo.getAccountType() == null) {
            vo.setAccountType(AccountEnums.AccountTypeEnum.CELL_PHONE.getValue());
        }
        if ((ucAccountEntity = this.accountMapper.findByAccountIdAndAppCode(vo.getObjectAccountId(), vo.getAppCode())) == null) {
            log.info("[\u4fee\u6539\u6210\u5458\u4fe1\u606f]\u4fee\u6539\u5bf9\u8c61\u67e5\u8be2\u4e3a\u7a7a accountId:{},appCode:{} ", (Object)vo.getObjectAccountId(), (Object)vo.getAppCode());
            return BaseResponse.error((IError)ErrorEnum.INVALID_PARAMETER, (String)"\u6210\u5458\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        if (!StringUtils.isBlank((CharSequence)vo.getRealName())) {
            ucAccountEntity.setRealName(vo.getRealName());
        }
        if (!StringUtils.isBlank((CharSequence)vo.getLoginName())) {
            List list = this.ucAccountMapper.selectByLoginNameAndUserTypeAndStatusAndAppCode(vo.getLoginName(), UserEnums.UserTypeEnum.MANAGER.getUserTypeValue(), AccountEnums.AccountStatusEnum.NORMAL.getValue(), vo.getAppCode());
            if (list != null && list.size() > 0) {
                if (list.size() > 1) {
                    throw new UserCenterRuntimeException(ErrorEnum.LOGIN_NAME_ALREADY_EXISTS);
                }
                if (!((UcAccountEntity)list.get(0)).getAccountId().equals(ucAccountEntity.getAccountId())) {
                    throw new UserCenterRuntimeException(ErrorEnum.LOGIN_NAME_ALREADY_EXISTS);
                }
            }
            ucAccountEntity.setLoginName(vo.getLoginName());
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getAccountNo()) && AccountEnums.AccountTypeEnum.CELL_PHONE.getValue().equals(ucAccountEntity.getAccountType())) {
            super.checkAccountNoRightByAccountType(vo.getAccountNo(), ucAccountEntity.getAccountType());
            UcAccountEntity accountEntity = this.ucAccountMapper.selectByUserTypeAndAppCodeAndStatusAndAccountNoOrRelatedMobileNumber(UserEnums.UserTypeEnum.MANAGER.getUserTypeValue(), vo.getAppCode(), AccountEnums.AccountStatusEnum.NORMAL.getValue(), vo.getAccountNo());
            if (accountEntity != null && !ucAccountEntity.getAccountId().equals(accountEntity.getAccountId())) {
                if (AccountEnums.AccountTypeEnum.CELL_PHONE.getValue().equals(vo.getAccountType())) {
                    throw new UserCenterRuntimeException(ErrorEnum.ACCOUNT_REGISTERED);
                }
                if (AccountEnums.AccountTypeEnum.EMAIL.getValue().equals(vo.getAccountType())) {
                    throw new UserCenterRuntimeException(ErrorEnum.EMAIL_ALREADY_EXISTS);
                }
                throw new UserCenterRuntimeException(ErrorEnum.ACCOUNT_REGISTERED);
            }
            ucAccountEntity.setAccountNo(vo.getAccountNo());
            if (!StringUtils.isBlank((CharSequence)vo.getLoginPhone()) && super.checkAccountNoRightByAccountType(vo.getLoginPhone(), AccountEnums.AccountTypeEnum.CELL_PHONE.getValue()).booleanValue()) {
                ucAccountEntity.setRelatedMobileNumber(vo.getLoginPhone());
            }
        }
        this.accountMapper.save(ucAccountEntity);
        this.updateManagerUser(ucAccountEntity, null);
        AccountResVo resVo = this.getResVo(ucAccountEntity);
        log.info("ManagerAuth::[\u4fee\u6539\u6210\u5458\u4fe1\u606f]\u6210\u529f!");
        return BaseResponse.success((Object)resVo);
    }

    public BaseResponse<Boolean> deleteMember(String accountId) {
        log.info("ManagerAuth::[\u5220\u9664\u6210\u5458]\u65b9\u6cd5\u8fdb\u5165...accountId = {}", (Object)accountId);
        UcAccountEntity entity = this.accountMapper.findByAccountId(accountId);
        entity.setStatus(AccountEnums.AccountStatusEnum.CANCELLATION.getValue());
        this.accountMapper.save(entity);
        Optional optional = this.managerUserMapper.selectByUserId(entity.getUserId());
        if (optional.isPresent()) {
            UcManagerUserEntity managerUserEntity = (UcManagerUserEntity)optional.get();
            managerUserEntity.setUserStatus(AccountEnums.AccountStatusEnum.CANCELLATION.getValue());
            this.managerUserMapper.updateByPrimaryKeySelective(managerUserEntity);
        }
        log.info("ManagerAuth::[\u5220\u9664\u6210\u5458]\u65b9\u6cd5\u6210\u529f!");
        return BaseResponse.success((Object)true);
    }

    public BaseResponse<Boolean> verifyPassword(VerifyPasswordReqVo vo) {
        UcAccountEntity entity = this.getRightAccount(vo.getAccountId());
        String mixPassword = PasswordUtil.mix((String)vo.getPassword(), (String)entity.getPwSalt());
        if (!entity.getAccountPw().equals(mixPassword)) {
            throw new UserCenterRuntimeException(ErrorEnum.OTHER_SERVICE_ERROR_DEFAULT_CODE, "\u767b\u5f55\u5bc6\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        return BaseResponse.success((Object)true);
    }

    private boolean verifyManagerAddAvailable(ManagerAddReqVo vo) {
        super.checkAccountNoRightByAccountType(vo.getAccountNo(), vo.getAccountType());
        if (vo.getLoginName() != null && vo.getLoginName().equals(vo.getAccountNo())) {
            throw new UserCenterRuntimeException(ErrorEnum.INVALID_ACCOUNTNO);
        }
        if (super.checkAccountExist(vo.getAccountNo(), UserEnums.UserTypeEnum.MANAGER.getUserTypeValue(), vo.getAppCode(), vo.getAccountType()).booleanValue()) {
            throw new UserCenterRuntimeException(ErrorEnum.ACCOUNT_REGISTERED);
        }
        List list = this.ucAccountMapper.selectByLoginNameAndUserTypeAndStatusAndAppCode(vo.getLoginName(), UserEnums.UserTypeEnum.MANAGER.getUserTypeValue(), AccountEnums.AccountStatusEnum.NORMAL.getValue(), vo.getAppCode());
        if (list != null && list.size() > 0) {
            throw new UserCenterRuntimeException(ErrorEnum.LOGIN_NAME_ALREADY_EXISTS);
        }
        return true;
    }

    public BaseResponse<AccountResVo> getMemberInfo(String accountId) {
        log.info("ManagerAuth::[\u83b7\u53d6\u6210\u5458\u4fe1\u606f] \u65b9\u6cd5\u8fdb\u5165...accountId = {}", (Object)accountId);
        UcAccountEntity account = this.getRightAccount(accountId);
        AccountResVo vo = this.getResVo(account);
        Optional ucManagerUser = this.managerUserMapper.selectByUserId(account.getUserId());
        ucManagerUser.ifPresent(ucManagerUserEntity -> vo.setPassword(ucManagerUserEntity.getInitializePassword()));
        BaseResponse roleList = this.roleClient.findByUserId(account.getUserId());
        vo.setRoleList((List)roleList.getData());
        log.info("ManagerAuth::[\u83b7\u53d6\u6210\u5458\u4fe1\u606f] \u8c03\u7528\u83b7\u53d6\u89d2\u8272\u4fe1\u606f, roleList = {}", roleList.getData());
        BaseResponse organList = this.userOrganClient.select(account.getUserId());
        vo.setRelHospitalList((List)organList.getData());
        String accountNo = vo.getAccountNo();
        if (RegexUtils.checkMobile((String)accountNo)) {
            vo.setAccountNo(new StringBuilder(accountNo).replace(3, 7, "****").toString());
        }
        log.info("ManagerAuth::[\u83b7\u53d6\u6210\u5458\u4fe1\u606f] \u8c03\u7528\u83b7\u53d6\u533b\u9662\u4fe1\u606f, organList = {}", organList.getData());
        return BaseResponse.success((Object)vo);
    }

    public BaseResponse<PageResult<AccountResVo>> getMemberList(UcAccountQuery query) {
        List userIds;
        log.info("ManagerAuth::[\u83b7\u53d6\u6210\u5458\u5217\u8868]\u65b9\u6cd5\u8fdb\u5165... \u67e5\u8be2\u5165\u53c2 = {}", (Object)query);
        PageResult result = new PageResult();
        if (query.getIsActive() != null && query.getIsActive() == -1) {
            log.info("\u83b7\u53d6\u6210\u5458\u5217\u8868]  \u6fc0\u6d3b\u72b6\u4f20-1\uff0c\u76f4\u63a5\u8fd4\u56de\u7a7a");
            return BaseResponse.success((Object)result);
        }
        if (query.getPageNum() != null && query.getPageSize() != null) {
            PageHelper.startPage((int)query.getPageNum(), (int)query.getPageSize());
        }
        if (StringUtils.isBlank((CharSequence)query.getStatusList())) {
            query.setStatusList("0");
        }
        if ((userIds = query.getUserIds()) != null && userIds.size() > 0) {
            query.setUserIdList(userIds.stream().collect(Collectors.joining(",")));
        }
        Page entityPage = this.accountMapper.selectByIsActiveAndStatusAndAppCode(query);
        ArrayList list = new ArrayList();
        entityPage.forEach(item -> {
            try {
                BaseResponse roleList = this.roleClient.findByUserId(item.getUserId());
                item.setRoleList((List)roleList.getData());
            }
            catch (Exception e) {
                log.error("ManagerAuth:[\u83b7\u53d6\u6210\u5458\u5217\u8868--\u83b7\u53d6\u89d2\u8272] {}", (Throwable)e);
            }
            try {
                BaseResponse organList = this.userOrganClient.select(item.getUserId());
                item.setRelHospitalList((List)organList.getData());
            }
            catch (Exception e) {
                log.error("ManagerAuth:[\u83b7\u53d6\u6210\u5458\u5217\u8868--\u83b7\u53d6\u533b\u9662] {}", (Throwable)e);
            }
            item.setPassword("");
            String accountNo = item.getAccountNo();
            if (RegexUtils.checkMobile((String)accountNo)) {
                item.setAccountNo(new StringBuilder(accountNo).replace(3, 7, "****").toString());
            }
            list.add(item);
        });
        result.setTotal((int)entityPage.getTotal());
        result.setTotalPages(entityPage.getPages());
        result.setContent(list);
        if (query.getPageNum() != null && query.getPageSize() != null) {
            result.setPageNum(query.getPageNum().intValue());
            result.setPageSize(query.getPageSize().intValue());
        }
        log.info("ManagerAuth::[\u83b7\u53d6\u6210\u5458\u5217\u8868]\u65b9\u6cd5\u6267\u884c\u5b8c\u6210!\u7ed3\u679c\u4e3a:result:{}", (Object)result);
        return BaseResponse.success((Object)result);
    }

    public static void main(String[] args) {
        String accountNo = "12243568765";
        if (RegexUtils.checkMobile((String)accountNo)) {
            System.out.println(new StringBuilder(accountNo).replace(3, 7, "****").toString());
        } else {
            System.out.println(accountNo);
        }
    }

    public ExcelData exportMemberList(String ids) {
        log.info("ManagerAuth::[\u5bfc\u51fa\u6210\u5458\u8868\u683c]\u65b9\u6cd5\u8fdb\u5165... ids = {} ", (Object)ids);
        UcAccountQuery query = new UcAccountQuery();
        query.setIds(ids);
        Page accountEntities = this.ucAccountMapper.selectByCondition(query);
        ExcelData excelData = new ExcelData();
        excelData.setName("\u6210\u5458\u4fe1\u606f");
        excelData.setTitles(this.getTitle());
        List collect = accountEntities.stream().map(arg_0 -> this.getRow(arg_0)).collect(Collectors.toList());
        excelData.setRows(collect);
        log.info("ManagerAuth::[\u5bfc\u51fa\u6210\u5458\u8868\u683c] \u65b9\u6cd5\u6267\u884c\u6210\u529f!");
        return excelData;
    }

    private List<Object> getRow(UcAccountEntity entity) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74-MM\u6708-dd\u65e5");
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(entity.getRealName());
        list.add(entity.getLoginName());
        list.add(entity.getAccountNo());
        try {
            List organInfoVOList = (List)this.userOrganClient.select(entity.getUserId()).getData();
            String organString = organInfoVOList.stream().map(UserOrganInfoVO::getOrganName).collect(Collectors.joining(","));
            list.add(organString);
        }
        catch (RuntimeException e) {
            log.error("\u5bfc\u51fa\u8868\u683c:\u83b7\u53d6\u6240\u5c5e\u533b\u9662\u5931\u8d25! message = {}", (Throwable)e);
            list.add("");
        }
        try {
            List roleList = (List)this.roleClient.findByUserId(entity.getUserId()).getData();
            String roleString = roleList.stream().map(RoleInfoVO::getRoleName).collect(Collectors.joining(","));
            list.add(roleString);
        }
        catch (RuntimeException e) {
            log.error("\u5bfc\u51fa\u8868\u683c:\u83b7\u53d6\u7528\u6237\u89d2\u8272\u5931\u8d25! message = {}", (Throwable)e);
            list.add("");
        }
        list.add(sdf.format(entity.getCreateTime() == null ? new Date() : entity.getCreateTime()));
        list.add(AccountEnums.ActiveEnum.getByValue((Short)(entity.getIsActive() == null ? AccountEnums.ActiveEnum.ACTIVE_NO.getValue() : entity.getIsActive())).getDesc());
        return list;
    }

    private List<String> getTitle() {
        return Arrays.asList("\u59d3\u540d", "\u7528\u6237\u540d", "\u624b\u673a\u53f7", "\u6240\u5c5e\u533b\u9662", "\u89d2\u8272", "\u52a0\u5165\u65f6\u95f4", "\u72b6\u6001");
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<AccountResVo> addDefaultManager(ManagerAddReqVo vo) {
        log.info("ManagerAuth::\u8fdb\u5165\u6dfb\u52a0\u9ed8\u8ba4\u7ba1\u7406\u5458\u65b9\u6cd5,\u5165\u53c2\u4e3a{}", (Object)vo);
        if (vo.getLoginPhone() == null || StringUtils.isEmpty((CharSequence)vo.getLoginPhone()) || vo.getPassword() == null || StringUtils.isEmpty((CharSequence)vo.getPassword())) {
            vo.setLoginPhone("18812345678");
            vo.setAccountNo("18812345678");
            vo.setLoginName(vo.getAppCode() + "-18812345678");
            String password = RandomStringUtils.random((int)8, (char[])new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', '1', '2', '3', '4', '5', '6', '7', '8', '9'});
            vo.setPassword(password);
        }
        if (StringUtils.isEmpty((CharSequence)vo.getLoginName())) {
            vo.setLoginName(vo.getAppCode() + "-18812345678");
        }
        if (StringUtils.isEmpty((CharSequence)vo.getRealName())) {
            vo.setRealName("\u521d\u59cb\u7ba1\u7406\u5458-" + vo.getAppCode());
        }
        if (vo.getAccountType() == null) {
            vo.setAccountType(AccountEnums.AccountTypeEnum.CELL_PHONE.getValue());
        }
        this.verifyManagerAddAvailable(vo);
        UcAccountEntity entity = new UcAccountEntity();
        entity.setAccountNo(vo.getLoginPhone());
        entity.setAccountPw(PasswordUtil.mixPassword((String)vo.getPassword()));
        entity.setLoginName(vo.getLoginName());
        entity.setRealName(vo.getRealName());
        entity.setAppCode(vo.getAppCode());
        entity.setRegisterChannel(vo.getChannelCode());
        String snowId = this.uniqueID.getNextId();
        entity.setAccountId(snowId);
        entity.setUserId(snowId);
        entity.setUserType(UserEnums.UserTypeEnum.MANAGER.getUserTypeValue());
        entity.setAccountType(vo.getAccountType());
        if (AccountEnums.AccountTypeEnum.CELL_PHONE.getValue().equals(entity.getAccountType())) {
            entity.setRelatedMobileNumber(vo.getLoginPhone());
        }
        entity.setStatus(UserEnums.UserStatusEnum.NORMAL.getUserStatusValue());
        entity.setIsActive(AccountEnums.ActiveEnum.ACTIVE_NO.getValue());
        this.accountMapper.save(entity);
        log.info("ManagerAuth::\u6210\u5458\u6210\u529f\u6dfb\u52a0\u5230 uc_account \u8868\u4e2d");
        this.updateManagerUser(entity, vo.getPassword());
        log.info("ManagerAuth::\u6210\u5458\u6210\u529f\u6dfb\u52a0\u5230 uc_manager_user \u8868\u4e2d");
        AccountResVo resVo = new AccountResVo();
        resVo.setPassword(vo.getPassword());
        resVo.setAccountId(entity.getAccountId());
        resVo.setUserId(entity.getUserId());
        resVo.setLoginName(entity.getLoginName());
        resVo.setAccountNo(entity.getAccountNo());
        return BaseResponse.success((Object)resVo);
    }

    public BaseResponse<List<AccountResVo>> getMemberListAntianaphylaxis(UcAccountQuery query) {
        log.info("getMemberListAntianaphylaxis::[\u83b7\u53d6\u6210\u5458\u5217\u8868]\u65b9\u6cd5\u8fdb\u5165... \u67e5\u8be2\u5165\u53c2 = {}", (Object)query);
        List userIds = query.getUserIds();
        if (userIds != null && userIds.size() > 0) {
            query.setUserIdList(userIds.stream().collect(Collectors.joining(",")));
        }
        List entityPage = this.accountMapper.selectByIsActiveAndStatusAndAppCodeAntianaphylaxis(query);
        log.info("entityPage: {}", (Object)entityPage.size());
        ArrayList list = new ArrayList();
        entityPage.forEach(item -> {
            try {
                BaseResponse roleList = this.roleClient.findByUserId(item.getUserId());
                item.setRoleList((List)roleList.getData());
            }
            catch (Exception e) {
                log.error("getMemberListAntianaphylaxis:[\u83b7\u53d6\u6210\u5458\u5217\u8868--\u83b7\u53d6\u89d2\u8272] {}", (Throwable)e);
            }
            try {
                BaseResponse organList = this.userOrganClient.select(item.getUserId());
                item.setRelHospitalList((List)organList.getData());
            }
            catch (Exception e) {
                log.error("getMemberListAntianaphylaxis:[\u83b7\u53d6\u6210\u5458\u5217\u8868--\u83b7\u53d6\u533b\u9662] {}", (Throwable)e);
            }
            item.setPassword("");
            list.add(item);
        });
        log.info("getMemberListAntianaphylaxis::[\u83b7\u53d6\u6210\u5458\u5217\u8868]\u65b9\u6cd5\u6267\u884c\u5b8c\u6210!\u7ed3\u679c\u4e3a:result:{}", list);
        return BaseResponse.success(list);
    }
}

