/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.controller;

import com.alipay.api.response.AlipayUserInfoShareResponse;
import com.ebaiyihui.common.NodeAccountApi;
import com.ebaiyihui.common.pojo.annotation.AccessCheck;
import com.ebaiyihui.common.pojo.login.AlipayLoginReqVO;
import com.ebaiyihui.common.pojo.login.AlipayUserInfoReqVo;
import com.ebaiyihui.common.pojo.login.BaseUserCenterIdRespVO;
import com.ebaiyihui.common.pojo.login.CheckAccountRepeatReqVO;
import com.ebaiyihui.common.pojo.login.CheckAccountRepeatRespVO;
import com.ebaiyihui.common.pojo.login.CusSmsLoginReqVO;
import com.ebaiyihui.common.pojo.login.ManagerUserLoginReqVO;
import com.ebaiyihui.common.pojo.login.PatientRigisterReqVO;
import com.ebaiyihui.common.pojo.login.SmsLoginReqVO;
import com.ebaiyihui.common.pojo.login.UcWxAuthReqVo;
import com.ebaiyihui.common.pojo.login.UcWxAuthRespVo;
import com.ebaiyihui.common.pojo.login.UserLoginReqVO;
import com.ebaiyihui.common.pojo.login.UserRigisterReqVO;
import com.ebaiyihui.common.pojo.login.WeChatLoginReqVO;
import com.ebaiyihui.common.pojo.login.WechatRespVO;
import com.ebaiyihui.common.pojo.login.WxBindingReqVo;
import com.ebaiyihui.common.pojo.login.WxPhoneLoginReqVO;
import com.ebaiyihui.common.pojo.login.WxPhoneLoginRespVO;
import com.ebaiyihui.common.pojo.vo.AccountLoginRespVO;
import com.ebaiyihui.common.pojo.vo.AccountLogoutIReqVO;
import com.ebaiyihui.common.pojo.vo.AccountNoUpdateReqVO;
import com.ebaiyihui.common.pojo.vo.AccountOperateBaseReqVO;
import com.ebaiyihui.common.pojo.vo.BaseIdRespVO;
import com.ebaiyihui.common.pojo.vo.GetWxOpenidReqVO;
import com.ebaiyihui.common.pojo.vo.GetWxOpenidRespVO;
import com.ebaiyihui.common.pojo.vo.GetbackPasswordReqVO;
import com.ebaiyihui.common.pojo.vo.LoginOrRegisterReqVo;
import com.ebaiyihui.common.pojo.vo.LoginWithMailReqVo;
import com.ebaiyihui.common.pojo.vo.OperateWxInfoSomeReqVo;
import com.ebaiyihui.common.pojo.vo.OperateWxInfoSomeRespVo;
import com.ebaiyihui.common.pojo.vo.RegisterWithMailReqVo;
import com.ebaiyihui.common.pojo.vo.UpdateLoginPhoneBySmsReqVO;
import com.ebaiyihui.common.pojo.vo.UpdatePasswordReqVO;
import com.ebaiyihui.common.pojo.vo.UpdatePasswordV3ReqVO;
import com.ebaiyihui.common.pojo.vo.UserUniqueIdentifyReqVo;
import com.ebaiyihui.common.pojo.vo.UserUniqueIdentifyRespVo;
import com.ebaiyihui.common.pojo.vo.VercodeRespVo;
import com.ebaiyihui.common.pojo.vo.WxAppletReqVO;
import com.ebaiyihui.common.pojo.vo.push.SmsSendAuthCodeReqVO;
import com.ebaiyihui.common.pojo.vo.push.SmsSendAuthCodeRspVO;
import com.ebaiyihui.common.pojo.vo.push.SmsVerifiAuthcodeReqVo;
import com.ebaiyihui.common.token.TokenBody;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.CommonsUtils;
import com.ebaiyihui.framework.utils.MdcUtil;
import com.ebaiyihui.server.annotation.PreventDuplication;
import com.ebaiyihui.server.service.AlipayLoginService;
import com.ebaiyihui.server.service.IAccessTokenService;
import com.ebaiyihui.server.service.IAccountService;
import com.ebaiyihui.server.service.ICommonService;
import com.ebaiyihui.server.service.IPushCenterService;
import com.ebaiyihui.server.service.IUcWxAuthService;
import com.ebaiyihui.server.service.impl.UserServiceImpl;
import com.ebaiyihui.server.util.RSAUtils;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@AccessCheck(value=AccessCheck.PermissionType.ACCESS_TOKEN_API)
public class NodeAccountController
implements NodeAccountApi {
    private static final Logger log = LoggerFactory.getLogger(NodeAccountController.class);
    @Autowired
    private IAccountService accountService;
    @Autowired
    private IUcWxAuthService ucWxAuthService;
    @Autowired
    private IAccessTokenService accessTokenService;
    @Autowired
    private ICommonService commonService;
    @Autowired
    private IPushCenterService pushCenterService;
    @Resource
    private HttpServletRequest request;
    @Autowired
    private AlipayLoginService alipayLoginService;
    @Autowired
    private UserServiceImpl userService;

    @PreventDuplication
    public BaseResponse<AccountLoginRespVO> loginOrRegisterWithPhone(@RequestBody @Valid LoginOrRegisterReqVo reqVO) {
        String headerIp = CommonsUtils.getRealIp((HttpServletRequest)this.request);
        reqVO.setLoginIp(headerIp);
        return this.accountService.loginOrRegisterWithPhone(reqVO, "small_program");
    }

    @PreventDuplication
    public BaseResponse<AccountLoginRespVO> loginOrRegisterWithPhoneNo(@RequestBody LoginOrRegisterReqVo reqVO) {
        String headerIp = CommonsUtils.getRealIp((HttpServletRequest)this.request);
        reqVO.setLoginIp(headerIp);
        return this.accountService.loginOrRegisterWithPhoneNo(reqVO, "small_program");
    }

    public BaseResponse<AccountLoginRespVO> loginWithMail(@RequestBody @Valid LoginWithMailReqVo reqVO) {
        String headerIp = CommonsUtils.getRealIp((HttpServletRequest)this.request);
        reqVO.setLoginIp(headerIp);
        return this.accountService.loginWithMail(reqVO, "default");
    }

    public BaseResponse<AccountLoginRespVO> registerWithMail(@RequestBody @Valid RegisterWithMailReqVo reqVo) {
        String headerIp = CommonsUtils.getRealIp((HttpServletRequest)this.request);
        reqVo.setLoginIp(headerIp);
        return this.accountService.registerWithMail(reqVo, "default");
    }

    @AccessCheck(value=AccessCheck.PermissionType.OPEN_API)
    public BaseResponse<AccountLoginRespVO> login(@RequestBody @Validated UserLoginReqVO userLoginReqVO) {
        String headerIp = CommonsUtils.getRealIp((HttpServletRequest)this.request);
        userLoginReqVO.setLoginIp(headerIp);
        MdcUtil.setCallerUserMethod((String)userLoginReqVO.getAppCode(), (String)userLoginReqVO.getAccountNo(), (String)"\u8d26\u6237\u767b\u5f55");
        return this.accountService.login(userLoginReqVO, "small_program");
    }

    public BaseResponse<AccountLoginRespVO> loginV2(@RequestBody @Valid UserLoginReqVO userLoginReqVO) {
        String headerIp = CommonsUtils.getRealIp((HttpServletRequest)this.request);
        String password = RSAUtils.decode((String)userLoginReqVO.getPassword());
        userLoginReqVO.setPassword(password);
        userLoginReqVO.setLoginIp(headerIp);
        return this.accountService.loginV2(userLoginReqVO, "integrated_management");
    }

    public BaseResponse<AccountLoginRespVO> loginWithVercode(@RequestBody @Valid UserLoginReqVO userLoginReqVO) {
        String headerIp = CommonsUtils.getRealIp((HttpServletRequest)this.request);
        String password = RSAUtils.decode((String)userLoginReqVO.getPassword());
        userLoginReqVO.setPassword(password);
        userLoginReqVO.setLoginIp(headerIp);
        return this.accountService.loginWithVercode(userLoginReqVO, "default");
    }

    public BaseResponse<AccountLoginRespVO> loginManagerWithpwAndsmscode(@RequestBody @Valid ManagerUserLoginReqVO managerUserLoginReqVO) {
        String headerIp = CommonsUtils.getRealIp((HttpServletRequest)this.request);
        String password = RSAUtils.decode((String)managerUserLoginReqVO.getPassword());
        String authCode = RSAUtils.decode((String)managerUserLoginReqVO.getAuthCode());
        managerUserLoginReqVO.setPassword(password);
        managerUserLoginReqVO.setLoginIp(headerIp);
        managerUserLoginReqVO.setAuthCode(authCode);
        return this.accountService.loginManagerWithpwAndsmscode(managerUserLoginReqVO, "default");
    }

    public BaseResponse<BaseUserCenterIdRespVO> logout(@RequestBody @Validated AccountLogoutIReqVO accountLogoutIReqVO, @RequestHeader(value="accessToken") String accessToken, HttpServletRequest request) {
        String headerIp = CommonsUtils.getRealIp((HttpServletRequest)request);
        return this.accountService.logout(accountLogoutIReqVO, headerIp, accessToken);
    }

    public BaseResponse<BaseIdRespVO> accountCancel(@RequestBody @Validated AccountOperateBaseReqVO accountOperateBaseReqVO, @RequestHeader(value="accessToken") String accessToken) {
        MdcUtil.setCallerUserMethod((String)accountOperateBaseReqVO.getAppCode(), (String)accountOperateBaseReqVO.getAccountId(), (String)"\u8d26\u6237\u6ce8\u9500");
        return this.accountService.accountCancel(accountOperateBaseReqVO, accessToken);
    }

    public BaseResponse<BaseIdRespVO> updateAccountNo(@RequestBody @Validated AccountNoUpdateReqVO accountNoUpdateReqVO, @RequestHeader(value="accessToken") String accessToken) {
        MdcUtil.setCallerUserMethod((String)accountNoUpdateReqVO.getAppCode(), (String)accountNoUpdateReqVO.getAccountId(), (String)"\u767b\u5f55\u5e10\u53f7\u4fee\u6539");
        return this.accountService.updateAccountNo(accountNoUpdateReqVO, accessToken);
    }

    public BaseResponse<BaseIdRespVO> updateLoginPhoneBySms(@RequestBody @Valid UpdateLoginPhoneBySmsReqVO reqVO) {
        MdcUtil.setCallerUserMethod((String)reqVO.getAppCode(), (String)reqVO.getPhoneNum(), (String)"\u66f4\u6362\u8d26\u6237\u624b\u673a\u53f7");
        return this.accountService.updateLoginPhoneBySms(reqVO);
    }

    public BaseResponse<BaseIdRespVO> pwdVerify(@RequestBody @Validated AccountOperateBaseReqVO accountPwdVerifyReqVO) {
        MdcUtil.setCallerUserMethod((String)accountPwdVerifyReqVO.getAppCode(), (String)accountPwdVerifyReqVO.getAccountId(), (String)"\u767b\u5f55\u5bc6\u7801\u6821\u9a8c");
        return this.accountService.pwdVerify(accountPwdVerifyReqVO);
    }

    public BaseResponse<CheckAccountRepeatRespVO> accountNoVerify(@RequestBody @Validated CheckAccountRepeatReqVO checkAccountRepeatReqVO) {
        MdcUtil.setCallerUserMethod((String)checkAccountRepeatReqVO.getAppCode(), (String)checkAccountRepeatReqVO.getAccountNo(), (String)"\u68c0\u67e5\u8d26\u6237");
        return this.accountService.accountNoVerify(checkAccountRepeatReqVO);
    }

    public BaseResponse<BaseUserCenterIdRespVO> getbackpassword(@RequestBody @Validated GetbackPasswordReqVO getbackPasswordReqVO) {
        MdcUtil.setCallerUserMethod((String)getbackPasswordReqVO.getAppCode(), (String)getbackPasswordReqVO.getAccountNo(), (String)"\u5fd8\u8bb0\u5bc6\u7801");
        String headerIp = CommonsUtils.getRealIp((HttpServletRequest)this.request);
        getbackPasswordReqVO.setLoginIp(headerIp);
        return this.accountService.getbackPassword(getbackPasswordReqVO);
    }

    public BaseResponse<BaseUserCenterIdRespVO> getbackpasswordV2(@RequestBody @Valid GetbackPasswordReqVO getbackPasswordReqVO) {
        String headerIp = CommonsUtils.getRealIp((HttpServletRequest)this.request);
        getbackPasswordReqVO.setLoginIp(headerIp);
        String authcode = RSAUtils.decode((String)getbackPasswordReqVO.getAuthCode());
        String password = RSAUtils.decode((String)getbackPasswordReqVO.getPasswordNew());
        getbackPasswordReqVO.setAuthCode(authcode);
        getbackPasswordReqVO.setPasswordNew(password);
        return this.accountService.getbackPasswordV2(getbackPasswordReqVO);
    }

    public BaseResponse<BaseUserCenterIdRespVO> getbackpasswordV3(@RequestBody @Valid GetbackPasswordReqVO getbackPasswordReqVO) {
        MdcUtil.setCallerUserMethod((String)getbackPasswordReqVO.getAppCode(), (String)getbackPasswordReqVO.getAccountNo(), (String)"\u5fd8\u8bb0\u5bc6\u7801");
        String headerIp = CommonsUtils.getRealIp((HttpServletRequest)this.request);
        getbackPasswordReqVO.setLoginIp(headerIp);
        String authcode = RSAUtils.decode((String)getbackPasswordReqVO.getAuthCode());
        String password = RSAUtils.decode((String)getbackPasswordReqVO.getPasswordNew());
        getbackPasswordReqVO.setAuthCode(authcode);
        getbackPasswordReqVO.setPasswordNew(password);
        return this.accountService.getbackPassword(getbackPasswordReqVO);
    }

    public BaseResponse<BaseUserCenterIdRespVO> updatePasswordV3(@RequestBody @Validated UpdatePasswordV3ReqVO reqVO) {
        String headerIp = CommonsUtils.getRealIp((HttpServletRequest)this.request);
        reqVO.setLoginIp(headerIp);
        String password = RSAUtils.decode((String)reqVO.getPasswordNew());
        reqVO.setPasswordNew(password);
        return this.accountService.updatePasswordV3(reqVO);
    }

    public BaseResponse<BaseUserCenterIdRespVO> updatePassword(@RequestBody @Validated UpdatePasswordReqVO reqVO) {
        String headerIp = CommonsUtils.getRealIp((HttpServletRequest)this.request);
        reqVO.setLoginIp(headerIp);
        return this.accountService.updatePasswordV2(reqVO);
    }

    public BaseResponse<WechatRespVO> getWxApplet(@RequestBody @Validated WxAppletReqVO wxAppletReqVO) {
        return this.ucWxAuthService.getWxApplet(wxAppletReqVO);
    }

    public BaseResponse<GetWxOpenidRespVO> getWxOpenid(@RequestBody GetWxOpenidReqVO getWxOpenidReqVO) {
        return this.ucWxAuthService.getWxOpenid(getWxOpenidReqVO);
    }

    public BaseResponse<AccountLoginRespVO> wxLogin(@RequestBody @Validated WeChatLoginReqVO weChatLoginReqVO) {
        MdcUtil.setCallerUserMethod((String)weChatLoginReqVO.getAppCode(), (String)weChatLoginReqVO.getOpenId(), (String)"app-\u5fae\u4fe1\u6388\u6743\u767b\u5f55");
        return this.accountService.wxLogin(weChatLoginReqVO, "default");
    }

    public BaseResponse<WxPhoneLoginRespVO> wxPhoneLogin(@RequestBody @Validated WxPhoneLoginReqVO wxPhoneLoginReqVO) {
        MdcUtil.setCallerUserMethod((String)wxPhoneLoginReqVO.getAppCode(), (String)wxPhoneLoginReqVO.getChannelCode(), (String)"\u5fae\u4fe1\u624b\u673a\u53f7\u4e00\u952e\u767b\u5f55");
        String headerIp = CommonsUtils.getRealIp((HttpServletRequest)this.request);
        wxPhoneLoginReqVO.setLoginIp(headerIp);
        return this.accountService.wxPhoneLogin(wxPhoneLoginReqVO, "small_program");
    }

    public BaseResponse<WxPhoneLoginRespVO> bdPhoneLogin(@RequestBody @Validated WxPhoneLoginReqVO wxPhoneLoginReqVO) {
        MdcUtil.setCallerUserMethod((String)wxPhoneLoginReqVO.getAppCode(), (String)wxPhoneLoginReqVO.getChannelCode(), (String)"\u5fae\u4fe1\u624b\u673a\u53f7\u4e00\u952e\u767b\u5f55");
        String headerIp = CommonsUtils.getRealIp((HttpServletRequest)this.request);
        wxPhoneLoginReqVO.setLoginIp(headerIp);
        return this.accountService.bdPhoneLogin(wxPhoneLoginReqVO, "small_program");
    }

    public BaseResponse<AccountLoginRespVO> smsLogin(@RequestBody @Validated CusSmsLoginReqVO reqVO) {
        String headerIp = CommonsUtils.getRealIp((HttpServletRequest)this.request);
        String authcode = RSAUtils.decode((String)reqVO.getAuthCode());
        reqVO.setLoginIp(headerIp);
        reqVO.setAuthCode(authcode);
        return this.accountService.smsLogin(reqVO, "default");
    }

    public BaseResponse<AccountLoginRespVO> smsLoginV2(@RequestBody @Validated SmsLoginReqVO reqVO) {
        String headerIp = CommonsUtils.getRealIp((HttpServletRequest)this.request);
        reqVO.setLoginIp(headerIp);
        String authcode = RSAUtils.decode((String)reqVO.getAuthCode());
        reqVO.setAuthCode(authcode);
        return this.accountService.smsLoginV2(reqVO, "integrated_management");
    }

    public BaseResponse<BaseUserCenterIdRespVO> register(@RequestBody @Validated UserRigisterReqVO userRigisterReqVO) {
        MdcUtil.setCallerUserMethod((String)userRigisterReqVO.getAppCode(), (String)userRigisterReqVO.getAccountNo(), (String)"\u8d26\u6237\u6ce8\u518c");
        return this.accountService.register(userRigisterReqVO);
    }

    public BaseResponse<AccountLoginRespVO> patientRegister(@RequestBody @Valid PatientRigisterReqVO patientRigisterReqVO, HttpServletRequest request) {
        MdcUtil.setCallerUserMethod((String)patientRigisterReqVO.getAppCode(), (String)patientRigisterReqVO.getChannelCode(), (String)"\u60a3\u8005\u7aef\u8d26\u6237\u6ce8\u518c");
        String headerIp = CommonsUtils.getRealIp((HttpServletRequest)request);
        patientRigisterReqVO.setLoginIp(headerIp);
        return this.accountService.patientRegister(patientRigisterReqVO, "default");
    }

    public BaseResponse<BaseUserCenterIdRespVO> wxBinding(@RequestBody @Valid WxBindingReqVo wxBindingReqVo) {
        return BaseResponse.success();
    }

    public BaseResponse<UcWxAuthRespVo> getWxAuthByCondition(@RequestBody @Valid UcWxAuthReqVo ucWxAuthReqVo) {
        return this.ucWxAuthService.getWxAuthByCondition(ucWxAuthReqVo);
    }

    public BaseResponse<String> getPhoneNumber(String encrypdata, String ivdata, String sessionId) {
        return this.ucWxAuthService.getPhoneNumber(encrypdata, ivdata, sessionId);
    }

    public BaseResponse<TokenBody> validateAccessToken(@RequestParam(value="accessToken") String accessToken) {
        return this.accessTokenService.validateAccessToken(accessToken);
    }

    public BaseResponse<TokenBody> validateAccessTokenV2(@RequestParam(value="accessToken") String accessToken, @RequestParam(value="url") String url) {
        log.info("\u63a5\u53e3:[/validateAccessToken] \u5f00\u59cbaccessToken\u6821\u9a8c! \u53c2\u6570:accessToken:[" + accessToken + "]\t url:[" + url + "]");
        return this.accessTokenService.validateAccessTokenV2(accessToken, url);
    }

    public BaseResponse<VercodeRespVo> getVercode(@RequestParam(required=false, defaultValue="100") int width, @RequestParam(required=false, defaultValue="40") int height) {
        return this.commonService.getVerCode(width, height);
    }

    public BaseResponse<OperateWxInfoSomeRespVo> operateWxInfoSome(@RequestBody @Valid OperateWxInfoSomeReqVo operateWxInfoSomeReqVo) {
        MdcUtil.setCallerUserMethod((String)operateWxInfoSomeReqVo.getAppCode(), (String)operateWxInfoSomeReqVo.getUserId(), (String)"\u66f4\u6539\u5fae\u4fe1\u5934\u50cf\u6635\u79f0\u7b49\u4fe1\u606f");
        return this.ucWxAuthService.operateWxInfoSome(operateWxInfoSomeReqVo);
    }

    public BaseResponse<SmsSendAuthCodeRspVO> sendAuthCode(@RequestBody @Valid SmsSendAuthCodeReqVO reqVO) {
        MdcUtil.setCallerUserMethod((String)reqVO.getAppCode(), (String)reqVO.getPhone(), (String)"\u53d1\u9001\u77ed\u4fe1\u9a8c\u8bc1\u7801");
        return this.pushCenterService.sendAuthCode(reqVO);
    }

    public BaseResponse<SmsSendAuthCodeRspVO> sendAuthCodWithMd5(@RequestHeader String sign, @RequestBody @Valid SmsSendAuthCodeReqVO reqVO) {
        MdcUtil.setCallerUserMethod((String)reqVO.getAppCode(), (String)reqVO.getPhone(), (String)"\u53d1\u9001sign\u77ed\u4fe1\u9a8c\u8bc1\u7801");
        return this.pushCenterService.sendAuthCodeWithMd5(sign, reqVO);
    }

    public BaseResponse<SmsSendAuthCodeRspVO> sendAuthCodWithMd5V2(@RequestHeader String sign, @RequestBody @Valid SmsSendAuthCodeReqVO reqVO) {
        return this.pushCenterService.sendAuthCodeWithMd5V2(sign, reqVO);
    }

    public BaseResponse verifialismsauthcode(@RequestBody @Valid SmsVerifiAuthcodeReqVo reqVO) {
        String authcode = RSAUtils.decode((String)reqVO.getAuthCode());
        reqVO.setAuthCode(authcode);
        return this.pushCenterService.verifialismsauthcode(reqVO);
    }

    public BaseResponse alipaylogin(@RequestBody AlipayLoginReqVO alipayLoginReqVO) {
        String headerIp = CommonsUtils.getRealIp((HttpServletRequest)this.request);
        return this.alipayLoginService.alipayLogin(headerIp, alipayLoginReqVO, "default");
    }

    @RequestMapping(value={"/alipayuserInfo"}, method={RequestMethod.POST})
    @ApiOperation(value="\u652f\u4ed8\u5b9d\u83b7\u53d6\u7528\u6237\u4fe1\u606f")
    public BaseResponse<AlipayUserInfoShareResponse> alipayUserinfo(@RequestBody AlipayUserInfoReqVo alipayUserInfoReqVo) {
        return this.alipayLoginService.alipayUserinfo(alipayUserInfoReqVo);
    }

    @RequestMapping(value={"/getuniqueidentify"}, method={RequestMethod.POST})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u652f\u4ed8\u5b9d/\u5fae\u4fe1\u552f\u4e00\u6807\u8bc6")
    public BaseResponse<UserUniqueIdentifyRespVo> getUniqueIdentify(@RequestBody UserUniqueIdentifyReqVo userUniqueIdentifyReqVo) {
        return this.userService.getUniqueIdentify(userUniqueIdentifyReqVo);
    }
}

