/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.common.enums.ErrorEnum;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import com.ebaiyihui.server.config.ProjProperties;
import com.ebaiyihui.server.pojo.bo.BaiduLoginDTO;
import com.ebaiyihui.server.pojo.entity.UcBaiduConfigEntity;
import com.ebaiyihui.server.repository.BaiduConfigMapper;
import com.ebaiyihui.server.service.BaiduAuthService;
import com.ebaiyihui.server.util.BaiduUtil;
import com.ebaiyihui.server.util.HttpKit;
import com.ebaiyihui.server.util.RedisUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BaiduAuthServiceImpl
implements BaiduAuthService {
    private static final Logger log = LoggerFactory.getLogger(BaiduAuthServiceImpl.class);
    @Autowired
    private BaiduConfigMapper baiduConfigMapper;
    @Autowired
    protected ProjProperties projProperties;
    @Autowired
    private RedisUtil redisUtil;

    public BaseResponse<BaiduLoginDTO> getPhoneNumber(String encrypdata, String ivdata, String code, String appCode) {
        log.info("\u83b7\u53d6\u767e\u5ea6\u624b\u673a\u53f7 [\u5165\u53c2]encrypdata: {}, ivdata: {}, sessionId: {}", new Object[]{encrypdata, ivdata, code});
        if (StringUtils.isEmpty((Object)encrypdata) || StringUtils.isEmpty((Object)ivdata) || StringUtils.isEmpty((Object)code)) {
            return BaseResponse.error((IError)ErrorEnum.INVALID_PARAMETER);
        }
        String sessionkey = null;
        BaseResponse sessionkeyRes = this.getSessionkey(code, appCode);
        if (!sessionkeyRes.isSuccess()) {
            log.error("\u767e\u5ea6\u83b7\u53d6sessionkey \u5931\u8d25=={}", (Object)sessionkeyRes.getMsg());
            return BaseResponse.error((String)sessionkeyRes.getMsg());
        }
        try {
            sessionkey = ((BaiduLoginDTO)sessionkeyRes.getData()).getSessionKey();
            String result = new BaiduUtil().decrypt(encrypdata, sessionkey, ivdata);
            JSONObject jsonObject = JSONObject.parseObject((String)result);
            if (jsonObject == null || jsonObject.isEmpty() || null == jsonObject.get((Object)"mobile")) {
                log.info("\u83b7\u53d6\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u624b\u673a\u53f7 jsonObject.isEmpty");
                return BaseResponse.error((IError)ErrorEnum.BD_GET_PHONE_FAILED);
            }
            String phoneNumber = (String)jsonObject.get((Object)"mobile");
            BaiduLoginDTO baiduLoginDTO = (BaiduLoginDTO)sessionkeyRes.getData();
            baiduLoginDTO.setPhoneNumber(phoneNumber);
            return BaseResponse.success((Object)baiduLoginDTO);
        }
        catch (Exception e) {
            log.info("\u83b7\u53d6\u5fae\u4fe1\u624b\u673a\u53f7\u5931\u8d25 {}", (Throwable)e);
            return BaseResponse.error((IError)ErrorEnum.BD_GET_PHONE_FAILED);
        }
    }

    private BaseResponse<BaiduLoginDTO> getSessionkey(String code, String appCode) {
        try {
            String accessid = appCode + "_BAIDU_ACCESSTOKEN";
            String accessToken = null;
            BaseResponse accessTokenRes = this.getAccessToken(appCode);
            if (!accessTokenRes.isSuccess()) {
                log.error("\u767e\u5ea6\u83b7\u53d6accessToken \u5931\u8d25=={}", (Object)accessTokenRes.getMsg());
                return BaseResponse.error((String)accessTokenRes.getMsg());
            }
            accessToken = (String)accessTokenRes.getData();
            String sessionkeyRes = HttpKit.get((String)(this.projProperties.getGetSessionKeyUrl() + "?access_token=" + accessToken + "&code=" + code));
            JSONObject jsonObject = JSONObject.parseObject((String)sessionkeyRes);
            if (jsonObject == null || jsonObject.isEmpty() || null == jsonObject.get((Object)"data")) {
                log.info("\u83b7\u53d6\u767e\u5ea6sessionkey jsonObject.isEmpty");
                return BaseResponse.error((IError)ErrorEnum.BD_GET_SESSIONKEY_FAILED);
            }
            JSONObject data = (JSONObject)jsonObject.get((Object)"data");
            String sessionKey = (String)data.get((Object)"session_key");
            String openId = (String)data.get((Object)"open_id");
            BaiduLoginDTO baiduLoginDTO = new BaiduLoginDTO();
            baiduLoginDTO.setOpenId(openId);
            baiduLoginDTO.setSessionKey(sessionKey);
            return BaseResponse.success((Object)baiduLoginDTO);
        }
        catch (Exception e) {
            log.info("\u83b7\u53d6\u767e\u5ea6accessToken\u5931\u8d25 {}", (Throwable)e);
            return BaseResponse.error((IError)ErrorEnum.BD_GET_SESSIONKEY_FAILED);
        }
    }

    private BaseResponse<String> getAccessToken(String appCode) {
        try {
            UcBaiduConfigEntity baiduConfigEntity = this.baiduConfigMapper.getByAppCode(appCode);
            String accessid = baiduConfigEntity.getAppCode() + "_BAIDU_ACCESSTOKEN";
            Object accessTokenObject = this.redisUtil.get(accessid);
            if (accessTokenObject != null) {
                return BaseResponse.success((Object)accessTokenObject.toString());
            }
            String accessTokenRes = HttpKit.get((String)(this.projProperties.getGetAccessTokenUrl() + "?grant_type=client_credentials&client_id=" + baiduConfigEntity.getAppKey() + "&client_secret=" + baiduConfigEntity.getAppSecret() + "&scope=smartapp_snsapi_base"));
            JSONObject jsonObject = JSONObject.parseObject((String)accessTokenRes);
            String accessToken = (String)jsonObject.get((Object)"access_token");
            this.redisUtil.set(accessid, (Object)accessToken, 2505600L);
            return BaseResponse.success((Object)accessToken);
        }
        catch (Exception e) {
            log.info("\u83b7\u53d6\u767e\u5ea6accessToken\u5931\u8d25 {}", (Throwable)e);
            return BaseResponse.error((IError)ErrorEnum.BD_GET_TOKEN_FAILED);
        }
    }
}

