/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.service.impl;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.common.enums.ErrorEnum;
import com.ebaiyihui.common.pojo.vo.push.MailSendReqVo;
import com.ebaiyihui.common.pojo.vo.push.MailVerificationReqVo;
import com.ebaiyihui.common.pojo.vo.push.SmsSendAuthCodeReqVO;
import com.ebaiyihui.common.pojo.vo.push.SmsSendAuthCodeRspVO;
import com.ebaiyihui.common.pojo.vo.push.SmsVerifiAuthcodeReqVo;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import com.ebaiyihui.framework.utils.RegexUtils;
import com.ebaiyihui.server.config.ProjProperties;
import com.ebaiyihui.server.enums.PushCenterEnums;
import com.ebaiyihui.server.enums.UserEnums;
import com.ebaiyihui.server.exception.UserCenterRuntimeException;
import com.ebaiyihui.server.pojo.vo.AliSmsSendAuthCodeReqPhoneVO;
import com.ebaiyihui.server.pojo.vo.SmsConfig;
import com.ebaiyihui.server.service.BaseService;
import com.ebaiyihui.server.service.IPushCenterService;
import com.ebaiyihui.server.util.RedisUtil;
import com.ebaiyihui.server.util.RestTemplateUtils;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.DigestUtils;
import org.springframework.util.MultiValueMap;

@Service
public class PushCenterServiceImpl
extends BaseService
implements IPushCenterService {
    private static final Logger log = LoggerFactory.getLogger(PushCenterServiceImpl.class);
    @Autowired
    protected RedisUtil pushRedisUtil;
    @Autowired
    protected ProjProperties pushProjProperties;

    public BaseResponse<SmsSendAuthCodeRspVO> sendAuthCode(SmsSendAuthCodeReqVO reqVO) {
        SmsConfig smsConfig;
        if (StringUtils.isEmpty((CharSequence)reqVO.getPhone())) {
            return BaseResponse.error((IError)ErrorEnum.INVALID_PARAMETER, (String)"\u8f93\u5165\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Objects.equals("DYSJPT", reqVO.getAppCode())) {
            HashMap<String, String> smsMap = new HashMap<String, String>(2);
            String authCode = RandomStringUtils.random((int)6, (String)"1234567890");
            String ms = "\u60a8\u767b\u5f55\u7684\u9a8c\u8bc1\u7801\u662f" + authCode + "\uff0c\u8bf7\u572810\u5206\u949f\u5185\u8f93\u5165\uff0c\u82e5\u975e\u60a8\u672c\u4eba\u64cd\u4f5c\u8bf7\u5ffd\u7565\u3002";
            smsMap.put("phone", reqVO.getPhone());
            smsMap.put("ms", ms);
            String result = HttpUtil.post((String)"https://smtpj-dysmt-cn.chinachdu.com/index.php/index/index/sendtohos", smsMap);
            if (result.contains("-")) {
                return BaseResponse.error((IError)ErrorEnum.OTHER_SERVICE_ERROR_DEFAULT_CODE, (String)"\u77ed\u4fe1\u53d1\u9001\u5931\u8d25");
            }
            long effTime = 600000L;
            this.pushRedisUtil.set(result, (Object)authCode, effTime, TimeUnit.MILLISECONDS);
            SmsSendAuthCodeRspVO rspVO = new SmsSendAuthCodeRspVO();
            rspVO.setEffTime(effTime);
            rspVO.setAuthKey(result);
            return BaseResponse.success((Object)rspVO);
        }
        AliSmsSendAuthCodeReqPhoneVO params = new AliSmsSendAuthCodeReqPhoneVO();
        BeanUtils.copyProperties((Object)reqVO, (Object)params);
        params.setAppSdkType("ali");
        params.setPhone(reqVO.getPhone());
        params.setTemplateCode(reqVO.getTemplateCode());
        if (reqVO.getParams() != null) {
            log.info("\u7ba1\u7406\u5458\u5bc6\u7801\u4e0b\u53d1 \u53c2\u6570:{}", (Object)JSON.toJSONString((Object)reqVO.getParams()));
            params.setParams(reqVO.getParams());
        }
        if ((smsConfig = this.getSmsConfig(reqVO.getAppCode(), PushCenterEnums.PushTypeEnum.SMS.getValue())).getPatientSignCode() == null || smsConfig.getClientCode() == null) {
            log.info("\u8c03\u7528\u533b\u751f\u670d\u52a1 - \u67e5\u8be2\u63a8\u9001\u914d\u7f6e\u4fe1\u606f \u914d\u7f6e\u4e3a\u7a7asmsConfig:{}", (Object)smsConfig);
            return BaseResponse.error((IError)ErrorEnum.PUSH_CONFIG_NULL);
        }
        params.setSignCode(smsConfig.getPatientSignCode());
        params.setSmsAppCode(smsConfig.getClientCode());
        String baseUrl = this.pushProjProperties.getEbaiyihuiDomain().concat("/cloud/push/alismsapi/sendAuthCodeWithPhoneV2");
        log.info("\u8c03\u7528\u63a8\u9001\u63a5\u53e3URL:{},\u5165\u53c2:{}", (Object)baseUrl, (Object)JSON.toJSONString((Object)params));
        try {
            if (!this.pushProjProperties.getI18nEnabled().booleanValue()) {
                HttpHeaders headers = new HttpHeaders();
                headers.set("accept-language", "zh-CN,zh;q=0.9,en;q=0.8");
                HttpEntity httpEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
                String resp = ((HttpRequest)HttpRequest.post((String)baseUrl).header("accept-language", "zh-CN,zh;q=0.9,en;q=0.8")).body(JSON.toJSONString((Object)params)).execute().body();
                log.info("resp , {}", (Object)resp);
                log.error("\u6821\u9a8c\u77ed\u4fe1\u9a8c\u8bc1\u7801--\u54cd\u5e94:" + resp);
                JSONObject jsonObject1 = JSONObject.parseObject((String)resp);
                if ("1".equals(jsonObject1.getString("code"))) {
                    SmsSendAuthCodeRspVO rspVO = (SmsSendAuthCodeRspVO)JSONObject.parseObject((String)jsonObject1.getString("data"), SmsSendAuthCodeRspVO.class);
                    return BaseResponse.success((Object)rspVO);
                }
                return BaseResponse.error((IError)ErrorEnum.OTHER_SERVICE_ERROR_DEFAULT_CODE, (String)("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25:" + jsonObject1.getString("msg")));
            }
            String baseResponse = HttpRequest.post((String)baseUrl).body(JSON.toJSONString((Object)params)).execute().body();
            if (baseResponse == null) {
                log.error("\u8c03\u7528\u63a8\u9001\u670d\u52a1 - \u53d1\u9001\u77ed\u4fe1\u6821\u9a8c\u7801\u63a5\u53e3sendAuthCode - \u8fd4\u56denull");
                return BaseResponse.error((IError)ErrorEnum.SYSTEM_PUSH_CENTER_ERROR);
            }
            JSONObject jsonObject1 = JSONObject.parseObject((String)baseResponse);
            log.info("\u8c03\u7528\u63a8\u9001 \u53d1\u9001\u9a8c\u8bc1\u7801\u63a5\u53e3 \u8fd4\u56de " + baseResponse);
            if ("1".equalsIgnoreCase(jsonObject1.getString("code"))) {
                JSONObject jsonObject = JSONObject.parseObject((String)baseResponse);
                Object effTime = jsonObject.get((Object)"effTime");
                Object authKey = jsonObject.get((Object)"authKey");
                if (effTime != null && authKey != null) {
                    log.info("\u77ed\u4fe1\u53d1\u9001\u6210\u529fjsonString:" + baseResponse);
                    SmsSendAuthCodeRspVO result = new SmsSendAuthCodeRspVO(Long.parseLong(effTime.toString()), (String)authKey);
                    return BaseResponse.success((Object)result);
                }
            } else if ("0".equalsIgnoreCase(jsonObject1.getString("code"))) {
                log.warn("\u63a8\u9001\u670d\u52a1==\u8fd4\u56de\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)jsonObject1.getString("msg"));
                if ("-1".equalsIgnoreCase(jsonObject1.getString("errCode"))) {
                    return BaseResponse.error((IError)ErrorEnum.SMS_LIMIT_EXCEEDED, (String)jsonObject1.getString("msg"));
                }
                return BaseResponse.error((IError)ErrorEnum.SYSTEM_PUSH_CENTER_ERROR, (String)jsonObject1.getString("msg"));
            }
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u63a8\u9001\u670d\u52a1 - \u53d1\u9001\u77ed\u4fe1\u6821\u9a8c\u7801\u63a5\u53e3sendAuthCode - \u5f02\u5e38:{}", (Object)e.getMessage());
            log.info("\u91cd\u8bd5\u8c03\u7528\u53d1\u9001\u9a8c\u8bc1\u7801");
            log.info("restTemplate error {}", (Throwable)e);
            return this.sendAuthCode(reqVO);
        }
        return BaseResponse.error((IError)ErrorEnum.SYSTEM_PUSH_CENTER_ERROR);
    }

    public BaseResponse<SmsSendAuthCodeRspVO> sendAuthCodeWithMd5(String sign, SmsSendAuthCodeReqVO reqVO) {
        log.info("\u77ed\u4fe1\u52a0\u5bc6\u63a5\u53e3\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)reqVO));
        String key = reqVO.getPhone().concat("b62d1b33a1b54d0cb39554c534249f09");
        String smsSign = DigestUtils.md5DigestAsHex((byte[])key.getBytes());
        if (!smsSign.equals(sign)) {
            log.info("\u53d1\u9001\u77ed\u4fe1\u6821\u9a8c\u7801,\u6821\u9a8c\u5931\u8d25,\u5934\u4fe1\u606f\uff1a{},\u624b\u673a\u53f7:{}", (Object)sign, (Object)reqVO.getPhone());
            return BaseResponse.error((IError)ErrorEnum.SYSYTEM_UNKNOW, (String)"\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        return this.sendAuthCode(reqVO);
    }

    public BaseResponse<SmsSendAuthCodeRspVO> sendAuthCodeWithMd5V2(String sign, SmsSendAuthCodeReqVO reqVO) {
        Optional optionalUcAccountEntity;
        if (reqVO.getUserType() == null) {
            return BaseResponse.error((IError)ErrorEnum.INVALID_PARAMETER, (String)"\u7528\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqVO.getUserType() < UserEnums.UserTypeEnum.PATIENT.getUserTypeValue() || reqVO.getUserType() > UserEnums.UserTypeEnum.MANAGER.getUserTypeValue()) {
            return BaseResponse.error((IError)ErrorEnum.INVALID_PARAMETER, (String)"\u9519\u8bef\u7684\u7528\u6237\u7c7b\u578b");
        }
        if (!RegexUtils.checkMobile((String)reqVO.getPhone())) {
            return BaseResponse.error((IError)ErrorEnum.WRONG_PHONE_NUMBER);
        }
        if (reqVO.getIsCheckAccount() != null && reqVO.getIsCheckAccount().booleanValue() && !(optionalUcAccountEntity = this.ucAccountMapper.selectByAccountNoAndUserTypeAndAppCodeAndStatus(reqVO.getPhone(), reqVO.getUserType(), reqVO.getAppCode(), UserEnums.UserStatusEnum.NORMAL.getUserStatusValue())).isPresent()) {
            return BaseResponse.error((IError)ErrorEnum.ACCOUNT_ERROR_OR_DOES_NOT_EXIST);
        }
        BaseResponse baseResponse = this.sendAuthCodeWithMd5(sign, reqVO);
        if (baseResponse.isSuccess()) {
            String key = "SMS_".concat(reqVO.getUserType().toString()).concat("_").concat(reqVO.getPhone());
            this.pushRedisUtil.set(key, (Object)((SmsSendAuthCodeRspVO)baseResponse.getData()).getAuthKey(), 20L, TimeUnit.MINUTES);
        }
        return baseResponse;
    }

    public BaseResponse verifialismsauthcode(SmsVerifiAuthcodeReqVo reqVO) {
        log.info("\u77ed\u4fe1\u6821\u9a8c===\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)reqVO));
        String s = JSONObject.toJSONString((Object)reqVO);
        JSONObject object = JSONObject.parseObject((String)s);
        String url = this.pushProjProperties.getEbaiyihuiDomain().concat("/cloud/push/alismsapi/verifialismsauthcode");
        if (!this.pushProjProperties.getI18nEnabled().booleanValue()) {
            HttpHeaders headers = new HttpHeaders();
            headers.set("accept-language", "zh-CN,zh;q=0.9,en;q=0.8");
            HttpEntity httpEntity = new HttpEntity((Object)reqVO, (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, BaseResponse.class, new Object[0]);
            log.error("\u6821\u9a8c\u77ed\u4fe1\u9a8c\u8bc1\u7801--\u54cd\u5e94:" + JSON.toJSONString((Object)responseEntity));
            if (HttpStatus.OK.equals((Object)responseEntity.getStatusCode()) && ((BaseResponse)responseEntity.getBody()).isSuccess()) {
                return (BaseResponse)responseEntity.getBody();
            }
            return BaseResponse.error((IError)ErrorEnum.OTHER_SERVICE_ERROR_DEFAULT_CODE, (String)(responseEntity.getBody() == null ? "\u77ed\u4fe1\u9a8c\u8bc1\u7801\u6821\u9a8c\u5931\u8d25" : ((BaseResponse)responseEntity.getBody()).getMsg()));
        }
        String result = RestTemplateUtils.post((String)url, (JSONObject)object, (MediaType)MediaType.APPLICATION_JSON_UTF8);
        log.info("\u8c03\u7528\u63a8\u9001\u670d\u52a1---\u6821\u9a8c\u9a8c\u8bc1\u7801--\u8fd4\u56de\u7ed3\u679c--{}", (Object)result);
        if (result == null) {
            log.info("\u8c03\u7528\u63a8\u9001\u670d\u52a1---\u6821\u9a8c\u9a8c\u8bc1\u7801--\u8fd4\u56denull");
            return BaseResponse.error((IError)ErrorEnum.FEGIN_ERROR);
        }
        return (BaseResponse)JSONObject.parseObject((String)result, BaseResponse.class);
    }

    public BaseResponse mailSend(MailSendReqVo reqVo) {
        log.info("\u53d1\u9001\u90ae\u4ef6 \u5165\u53c2:{}", (Object)JSON.toJSONString((Object)reqVo));
        JSONObject params = JSON.parseObject((String)JSON.toJSONString((Object)reqVo));
        String url = this.pushProjProperties.getEbaiyihuiDomain().concat("/cloud/push/mail/send");
        String result = RestTemplateUtils.post((String)url, (JSONObject)params, (MediaType)MediaType.APPLICATION_JSON_UTF8);
        if (result == null) {
            log.info("\u8c03\u7528\u63a8\u9001\u670d\u52a1---\u6821\u9a8c\u90ae\u4ef6\u9a8c\u8bc1\u7801--\u8fd4\u56denull");
            return BaseResponse.error((IError)ErrorEnum.FEGIN_ERROR);
        }
        return (BaseResponse)JSONObject.parseObject((String)result, BaseResponse.class);
    }

    public BaseResponse mailVerify(MailVerificationReqVo reqVo) {
        log.info("\u6821\u9a8c\u90ae\u4ef6\u9a8c\u8bc1\u7801 \u5165\u53c2:{}", (Object)JSON.toJSONString((Object)reqVo));
        JSONObject params = JSON.parseObject((String)JSON.toJSONString((Object)reqVo));
        String url = this.pushProjProperties.getEbaiyihuiDomain().concat("/cloud/push/mail/verify");
        String result = RestTemplateUtils.post((String)url, (JSONObject)params, (MediaType)MediaType.APPLICATION_JSON_UTF8);
        if (result == null) {
            log.info("\u8c03\u7528\u63a8\u9001\u670d\u52a1---\u6821\u9a8c\u90ae\u4ef6\u9a8c\u8bc1\u7801--\u8fd4\u56denull");
            return BaseResponse.error((IError)ErrorEnum.FEGIN_ERROR);
        }
        return (BaseResponse)JSONObject.parseObject((String)result, BaseResponse.class);
    }

    public static void main(String[] args) {
        String key = "18182443996".concat("b62d1b33a1b54d0cb39554c534249f09");
        String smsSign = DigestUtils.md5DigestAsHex((byte[])key.getBytes());
        System.out.println(smsSign);
    }

    private SmsConfig getSmsConfig(String appCode, String type) {
        String cacheKey = "PUSH".concat(appCode).concat("_").concat(type);
        try {
            SmsConfig smsConfig;
            Object sms = this.pushRedisUtil.get(cacheKey);
            if (sms != null && (smsConfig = (SmsConfig)JSONObject.parseObject((String)((String)sms), SmsConfig.class)).getClientCode() != null && smsConfig.getPatientSignCode() != null) {
                return smsConfig;
            }
        }
        catch (Exception e) {
            log.info("\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6sms\u914d\u7f6e\u4fe1\u606f \u5f02\u5e38{}", (Object)e.getMessage());
        }
        SmsConfig smsConfig = new SmsConfig();
        smsConfig.setAppCode(appCode);
        smsConfig.setType(type);
        String url = this.pushProjProperties.getEbaiyihuiDomain().concat("/cloud/doctoruser/configuration/getdetail");
        log.info("\u8c03\u7528\u533b\u751f\u63a5\u53e3URL:{},\u5165\u53c2:{}", (Object)url, (Object)smsConfig);
        BaseResponse baseResponse = (BaseResponse)this.restTemplate.postForObject(url, (Object)smsConfig, BaseResponse.class, new Object[0]);
        if (baseResponse == null) {
            log.error("\u8c03\u7528\u533b\u751f\u670d\u52a1 - \u67e5\u8be2\u63a8\u9001\u914d\u7f6e\u4fe1\u606f - \u8fd4\u56denull");
            throw new UserCenterRuntimeException(ErrorEnum.DOCTOR_SYSTEM_RETURN_NULL);
        }
        String toJSONString = JSON.toJSONString((Object)baseResponse);
        JSONObject jsonObject1 = JSONObject.parseObject((String)toJSONString);
        log.info("\u8c03\u7528\u533b\u751f\u670d\u52a1 - \u67e5\u8be2\u63a8\u9001\u914d\u7f6e\u4fe1\u606f \u8fd4\u56de " + toJSONString);
        if ("1".equalsIgnoreCase(jsonObject1.getString("code"))) {
            String data = jsonObject1.getString("data");
            JSONObject jsonDate = JSONObject.parseObject((String)data);
            if (null == jsonDate) {
                throw new UserCenterRuntimeException(ErrorEnum.INVALID_PUSH_PARAMETER);
            }
            String clientCodeStr = jsonDate.getString("clientCode");
            String statusStr = jsonDate.getString("status");
            if (statusStr != null) {
                smsConfig.setStatus(Integer.valueOf(statusStr).intValue());
            }
            if (clientCodeStr != null) {
                log.info("==========clientCodeStr========" + clientCodeStr);
                JSONObject clientCodeJson = JSONObject.parseObject((String)clientCodeStr);
                if (PushCenterEnums.PushTypeEnum.SMS.getValue().equalsIgnoreCase(type) && clientCodeJson != null) {
                    String clientCode1 = clientCodeJson.getString("clientCode");
                    smsConfig.setClientCode(clientCode1);
                    String signCode = clientCodeJson.getString("signCode");
                    JSONObject signCodeJson = JSONObject.parseObject((String)signCode);
                    if (signCodeJson != null) {
                        smsConfig.setDoctorSignCode(signCodeJson.getString("doctorCode"));
                        smsConfig.setPatientSignCode(signCodeJson.getString("patientCode"));
                        this.pushRedisUtil.set(cacheKey, (Object)JSON.toJSONString((Object)smsConfig), 1440L, TimeUnit.MINUTES);
                    }
                }
            }
        }
        return smsConfig;
    }
}

