/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.util;

import cn.hutool.core.date.DateUtil;
import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.server.config.ProjProperties;
import com.ebaiyihui.server.pojo.bo.PushSubscribeMessageReqVO;
import com.ebaiyihui.server.pojo.bo.PushTemplateReqVO;
import com.ebaiyihui.server.pojo.bo.UcConfigurationDTO;
import com.ebaiyihui.server.pojo.bo.UcConfigurationVO;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PushMessageUtils {
    private static final Logger log = LoggerFactory.getLogger(PushMessageUtils.class);
    public static final String APP_CODE = "LYCITYYS";
    public static final String BD_APP_CODE = "BDDYZYY";
    public static final String INDEX_PAGE = "pages/index/main/index";
    public static final String UNBIND_REMARK = "\u5df2\u89e3\u9664\u7ed1\u5b9a\u5173\u7cfb\uff0c\u82e5\u7ebf\u4e0a\u5c31\u533b\u65f6\u9700\u8981\u91cd\u65b0\u7ed1\u5b9a";
    public static final String BIND_REMARK = "\u60a8\u5df2\u6210\u529f\u7ed1\u5b9a\uff0c\u53ef\u4ee5\u8fdb\u884c\u7ebf\u4e0a\u7ebf\u4e0b\u5c31\u533b\u670d\u52a1";
    public static final String LYT_CARD_UNBIND = "lyt_card_unbind";
    public static final String LYT_CARD_BIND = "lyt_card_bind";
    public static final String BD_CARD_UNBIND = "card_unbind";
    public static final String BD_CARD_BIND = "card_bind";
    @Autowired
    private ProjProperties projProperties;

    public void unbindWx(String patientName, String openId, String appCode) {
        PushTemplateReqVO template = new PushTemplateReqVO();
        template.setPage(INDEX_PAGE);
        LinkedHashMap templateParam = new LinkedHashMap();
        HashMap<String, String> remark = new HashMap<String, String>();
        remark.put("value", UNBIND_REMARK);
        HashMap<String, String> name = new HashMap<String, String>();
        name.put("value", patientName);
        HashMap<String, String> time = new HashMap<String, String>();
        time.put("value", DateUtil.now());
        templateParam.put("thing1", name);
        templateParam.put("time2", time);
        templateParam.put("thing3", remark);
        if (APP_CODE.equals(appCode)) {
            template.setAppCode(APP_CODE);
            this.pushTemplateWx(template, LYT_CARD_UNBIND, templateParam, openId);
        } else if (BD_APP_CODE.equals(appCode)) {
            template.setAppCode(BD_APP_CODE);
            this.pushTemplateWx(template, BD_CARD_UNBIND, templateParam, openId);
        }
    }

    public void bindWx(String patientName, String openId, String appCode) {
        PushTemplateReqVO template = new PushTemplateReqVO();
        template.setPage(INDEX_PAGE);
        LinkedHashMap templateParam = new LinkedHashMap();
        HashMap<String, String> remark = new HashMap<String, String>();
        remark.put("value", BIND_REMARK);
        HashMap<String, String> name = new HashMap<String, String>();
        name.put("value", patientName);
        HashMap<String, String> time = new HashMap<String, String>();
        time.put("value", DateUtil.now());
        templateParam.put("thing1", name);
        templateParam.put("time2", time);
        templateParam.put("thing3", remark);
        if (APP_CODE.equals(appCode)) {
            template.setAppCode(APP_CODE);
            this.pushTemplateWx(template, LYT_CARD_BIND, templateParam, openId);
        } else if (BD_APP_CODE.equals(appCode)) {
            template.setAppCode(BD_APP_CODE);
            this.pushTemplateWx(template, BD_CARD_BIND, templateParam, openId);
        }
    }

    public void unbindAli(String patientName, String patientNumber, String openId, String appCode) {
        PushTemplateReqVO template = new PushTemplateReqVO();
        template.setAppCode(APP_CODE);
        template.setPage(INDEX_PAGE);
        LinkedHashMap templateParam = new LinkedHashMap();
        HashMap<String, String> name = new HashMap<String, String>();
        name.put("value", patientName);
        HashMap<String, String> number = new HashMap<String, String>();
        number.put("value", patientNumber);
        templateParam.put("keyword1", name);
        templateParam.put("keyword2", number);
        this.pushTemplateAli(template, LYT_CARD_UNBIND, templateParam, openId);
    }

    public void pushTemplateWx(PushTemplateReqVO template, String templateId, Map<String, Map<String, Object>> templateParam, String openId) {
        UcConfigurationDTO clientCodeParam = new UcConfigurationDTO(template.getAppCode(), "weChatApplets");
        UcConfigurationVO client = this.getClientCode(clientCodeParam);
        if (Objects.isNull(client)) {
            log.error("\u5fae\u4fe1\u63a8\u9001\u5931\u8d25,\u83b7\u53d6clientCode\u5931\u8d25");
            return;
        }
        String clientCode = JSONObject.parseObject((String)client.getClientCode()).getString("clientCode");
        PushSubscribeMessageReqVO message = new PushSubscribeMessageReqVO();
        message.setClientCode(clientCode);
        message.setTemplateCode(templateId);
        message.setOpenId(openId);
        message.setData(templateParam);
        message.setPage(template.getPage());
        message.setPlatform("wx");
        String pushUrl = this.projProperties.getDomainName() + this.projProperties.getMsgPush();
        log.info("\u5fae\u4fe1\u6a21\u677f\u6d88\u606f\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)message));
        String result = ((HttpRequest)HttpRequest.post((String)pushUrl).header("Content-Type", "application/json;charset=UTF-8")).body(JSON.toJSONString((Object)message)).execute().body();
        log.info("\u5fae\u4fe1\u6a21\u677f\u6d88\u606f\u63a8\u9001\u7ed3\u679c\uff1a{}", (Object)result);
    }

    public void pushTemplateAli(PushTemplateReqVO template, String templateId, Map<String, Map<String, Object>> templateParam, String openId) {
        UcConfigurationDTO clientCodeParam = new UcConfigurationDTO(template.getAppCode(), "aliApplets");
        UcConfigurationVO client = this.getClientCode(clientCodeParam);
        if (Objects.isNull(client)) {
            log.error("\u5fae\u4fe1\u63a8\u9001\u5931\u8d25,\u83b7\u53d6clientCode\u5931\u8d25");
            return;
        }
        String clientCode = JSONObject.parseObject((String)client.getClientCode()).getString("clientCode");
        PushSubscribeMessageReqVO message = new PushSubscribeMessageReqVO();
        message.setClientCode(clientCode);
        message.setTemplateCode(templateId);
        message.setOpenId(openId);
        message.setData(templateParam);
        message.setPage(template.getPage());
        message.setPlatform("alipay");
        String pushUrl = this.projProperties.getDomainName() + this.projProperties.getMsgPush();
        log.info("\u5fae\u4fe1\u6a21\u677f\u6d88\u606f\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)message));
        String result = ((HttpRequest)HttpRequest.post((String)pushUrl).header("Content-Type", "application/json;charset=UTF-8")).body(JSON.toJSONString((Object)message)).execute().body();
        log.info("\u5fae\u4fe1\u6a21\u677f\u6d88\u606f\u63a8\u9001\u7ed3\u679c\uff1a{}", (Object)result);
    }

    public UcConfigurationVO getClientCode(UcConfigurationDTO configDto) {
        UcConfigurationVO configurationVO = null;
        try {
            BaseResponse baseResponse;
            String clientCodeUrl = this.projProperties.getDomainName() + this.projProperties.getGetDetail();
            String result = ((HttpRequest)HttpRequest.post((String)clientCodeUrl).header("Content-Type", "application/json;charset=UTF-8")).body(JSON.toJSONString((Object)configDto)).execute().body();
            log.info("\u83b7\u53d6\u5ba2\u6237\u7aef\u7f16\u7801\u7ed3\u679c\uff1a{}", (Object)result);
            if (StringUtils.isNotEmpty((String)result) && (baseResponse = (BaseResponse)JSONObject.parseObject((String)result, BaseResponse.class)).isSuccess()) {
                configurationVO = (UcConfigurationVO)JSONObject.parseObject((String)String.valueOf(baseResponse.getData()), UcConfigurationVO.class);
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u63a8\u9001client_code - \u83b7\u53d6\u5f02\u5e38{}", (Object)e.getMessage());
        }
        return configurationVO;
    }
}

