/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.common.enums.ErrorEnum;
import com.ebaiyihui.common.pojo.login.UcWxAuthRespVo;
import com.ebaiyihui.common.pojo.login.WxBindingReqVo;
import com.ebaiyihui.common.pojo.vo.BaiduEmpowerResVo;
import com.ebaiyihui.common.pojo.vo.GetBdEmpowerReqVo;
import com.ebaiyihui.common.pojo.vo.GetWxOpenidReqVO;
import com.ebaiyihui.common.pojo.vo.GetWxOpenidRespVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import com.ebaiyihui.server.config.ProjProperties;
import com.ebaiyihui.server.enums.WxAuthEnums;
import com.ebaiyihui.server.pojo.bo.BaiduLoginDTO;
import com.ebaiyihui.server.pojo.entity.UcBaiduConfigEntity;
import com.ebaiyihui.server.pojo.entity.UcBaiduEmpowerConfigEntity;
import com.ebaiyihui.server.pojo.entity.UcWxAuthEntity;
import com.ebaiyihui.server.repository.BaiduConfigMapper;
import com.ebaiyihui.server.repository.UcBaiduEmpowerMapper;
import com.ebaiyihui.server.repository.UcBdAuthMapper;
import com.ebaiyihui.server.service.BaiduAuthService;
import com.ebaiyihui.server.service.BaseService;
import com.ebaiyihui.server.util.BaiduUtil;
import com.ebaiyihui.server.util.HttpKit;
import com.ebaiyihui.server.util.RedisUtil;
import com.ebaiyihui.server.util.WXLabelUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class BaiduAuthServiceImpl
extends BaseService
implements BaiduAuthService {
    private static final Logger log = LoggerFactory.getLogger(BaiduAuthServiceImpl.class);
    @Autowired
    protected UcBdAuthMapper ucBdAuthMapper;
    @Autowired
    private BaiduConfigMapper baiduConfigMapper;
    @Autowired
    private UcBaiduEmpowerMapper ucBaiduEmpowerMapper;
    @Resource
    private RedisTemplate redisTemplate;
    @Autowired
    protected ProjProperties projProperties;
    @Autowired
    private RedisUtil redisUtil;

    public BaseResponse<BaiduLoginDTO> getPhoneNumber(String encrypdata, String ivdata, String code, String appCode, String unionId) {
        log.info("\u83b7\u53d6\u767e\u5ea6\u624b\u673a\u53f7 [\u5165\u53c2]encrypdata: {}, ivdata: {}, sessionId: {}", new Object[]{encrypdata, ivdata, code});
        if (StringUtils.isEmpty((Object)encrypdata) || StringUtils.isEmpty((Object)ivdata) || StringUtils.isEmpty((Object)code)) {
            return BaseResponse.error((IError)ErrorEnum.INVALID_PARAMETER);
        }
        String sessionkey = null;
        BaseResponse sessionkeyRes = this.getSessionkey(code, appCode);
        if (!sessionkeyRes.isSuccess()) {
            log.error("\u767e\u5ea6\u83b7\u53d6sessionkey \u5931\u8d25=={}", (Object)sessionkeyRes.getMsg());
            return BaseResponse.error((String)sessionkeyRes.getMsg());
        }
        UcBaiduConfigEntity baiduConfigEntity = this.baiduConfigMapper.getByAppCode(appCode);
        if (null == baiduConfigEntity) {
            return BaseResponse.error((String)"\u83b7\u53d6\u6570\u636e\u5e93\u914d\u7f6e\u5931\u8d25");
        }
        try {
            HashMap<String, String> swanOpenAdd = new HashMap<String, String>();
            swanOpenAdd.put("openid", ((BaiduLoginDTO)sessionkeyRes.getData()).getOpenId());
            swanOpenAdd.put("swanid", unionId);
            swanOpenAdd.put("app_code", baiduConfigEntity.getAppKey());
            String s = HttpKit.jsonPost((String)this.projProperties.getSwanOpenAdd(), (String)JSONObject.toJSONString(swanOpenAdd));
            log.info("\u8c03\u7528\u767e\u5ea6swanid \u548c openid \u6620\u5c04\u5173\u7cfb\u63a5\u53e3OUT" + s);
            JSONObject swanOpenAddJsonObject = JSONObject.parseObject((String)s);
            if (swanOpenAddJsonObject == null || swanOpenAddJsonObject.isEmpty() || null == swanOpenAddJsonObject.get((Object)"data")) {
                log.info("\u8c03\u7528\u767e\u5ea6swanid \u548c openid \u6620\u5c04\u5173\u7cfb\u63a5\u53e3\u5931\u8d25");
                return BaseResponse.error((IError)ErrorEnum.BD_GET_PHONE_FAILED);
            }
            sessionkey = ((BaiduLoginDTO)sessionkeyRes.getData()).getSessionKey();
            String result = new BaiduUtil().decrypt(encrypdata, sessionkey, ivdata);
            JSONObject jsonObject = JSONObject.parseObject((String)result);
            if (jsonObject == null || jsonObject.isEmpty() || null == jsonObject.get((Object)"mobile")) {
                log.info("\u83b7\u53d6\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u624b\u673a\u53f7 jsonObject.isEmpty");
                return BaseResponse.error((IError)ErrorEnum.BD_GET_PHONE_FAILED);
            }
            String phoneNumber = (String)jsonObject.get((Object)"mobile");
            BaiduLoginDTO baiduLoginDTO = (BaiduLoginDTO)sessionkeyRes.getData();
            baiduLoginDTO.setPhoneNumber(phoneNumber);
            return BaseResponse.success((Object)baiduLoginDTO);
        }
        catch (Exception e) {
            log.info("\u83b7\u53d6\u5fae\u4fe1\u624b\u673a\u53f7\u5931\u8d25 {}", (Throwable)e);
            return BaseResponse.error((IError)ErrorEnum.BD_GET_PHONE_FAILED);
        }
    }

    private BaseResponse<BaiduLoginDTO> getSessionkey(String code, String appCode) {
        try {
            String accessid = appCode + "_BAIDU_ACCESSTOKEN";
            String accessToken = null;
            BaseResponse accessTokenRes = this.getAccessToken(appCode);
            if (!accessTokenRes.isSuccess()) {
                log.error("\u767e\u5ea6\u83b7\u53d6accessToken \u5931\u8d25=={}", (Object)accessTokenRes.getMsg());
                return BaseResponse.error((String)accessTokenRes.getMsg());
            }
            accessToken = (String)accessTokenRes.getData();
            String sessionkeyRes = HttpKit.get((String)(this.projProperties.getGetSessionKeyUrl() + "?access_token=" + accessToken + "&code=" + code));
            JSONObject jsonObject = JSONObject.parseObject((String)sessionkeyRes);
            JSONObject data = (JSONObject)jsonObject.get((Object)"data");
            if (jsonObject == null || jsonObject.isEmpty() || null == data.get((Object)"session_key") || null == data.get((Object)"open_id")) {
                log.info("\u83b7\u53d6\u767e\u5ea6sessionkey jsonObject.isEmpty");
                return BaseResponse.error((IError)ErrorEnum.BD_GET_SESSIONKEY_FAILED);
            }
            String sessionKey = (String)data.get((Object)"session_key");
            String openId = (String)data.get((Object)"open_id");
            BaiduLoginDTO baiduLoginDTO = new BaiduLoginDTO();
            baiduLoginDTO.setOpenId(openId);
            baiduLoginDTO.setSessionKey(sessionKey);
            return BaseResponse.success((Object)baiduLoginDTO);
        }
        catch (Exception e) {
            log.info("\u83b7\u53d6\u767e\u5ea6accessToken\u5931\u8d25 {}", (Throwable)e);
            return BaseResponse.error((IError)ErrorEnum.BD_GET_SESSIONKEY_FAILED);
        }
    }

    private BaseResponse<String> getAccessToken(String appCode) {
        try {
            UcBaiduConfigEntity baiduConfigEntity = this.baiduConfigMapper.getByAppCode(appCode);
            String accessid = baiduConfigEntity.getAppCode() + "_BAIDU_ACCESSTOKEN";
            Object accessTokenObject = this.redisUtil.get(accessid);
            if (accessTokenObject != null) {
                log.info("==\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6AccessToken==" + accessTokenObject.toString());
                return BaseResponse.success((Object)accessTokenObject.toString());
            }
            String accessTokenRes = HttpKit.get((String)(this.projProperties.getGetAccessTokenUrl() + "?grant_type=client_credentials&client_id=" + baiduConfigEntity.getAppKey() + "&client_secret=" + baiduConfigEntity.getAppSecret() + "&scope=smartapp_snsapi_base"));
            JSONObject jsonObject = JSONObject.parseObject((String)accessTokenRes);
            String accessToken = (String)jsonObject.get((Object)"access_token");
            this.redisTemplate.opsForValue().set((Object)accessid, (Object)accessToken, 29L, TimeUnit.DAYS);
            baiduConfigEntity.setAccessToken(accessToken);
            this.baiduConfigMapper.updateBaiduConfigEntityById(baiduConfigEntity);
            log.info("==\u66f4\u65b0\u6570\u636e\u5e93AccessToken==" + accessToken);
            return BaseResponse.success((Object)accessToken);
        }
        catch (Exception e) {
            log.info("\u83b7\u53d6\u767e\u5ea6accessToken\u5931\u8d25 {}", (Throwable)e);
            return BaseResponse.error((IError)ErrorEnum.BD_GET_TOKEN_FAILED);
        }
    }

    public BaseResponse<UcWxAuthRespVo> bdBinding(WxBindingReqVo wxBindingReqVo) {
        log.info("\u5fae\u4fe1\u8d26\u53f7\u7ed1\u5b9a  \u5173\u6ce8\u5fae\u4fe1\u516c\u4f17\u53f7  \u8bf7\u6c42\u53c2\u6570{}", (Object)wxBindingReqVo);
        new Thread(() -> WXLabelUtil.accessToken((RestTemplate)this.restTemplate, (RedisUtil)this.redisUtil, (String)this.projProperties.getWxAppid(), (String)this.projProperties.getWxSecret(), (String)wxBindingReqVo.getWxOpenid(), (String)"\u7528\u6237")).start();
        log.info("\u5fae\u4fe1\u8d26\u53f7\u7ed1\u5b9a \u5165\u53c2\uff1awxBindingReqVo\uff1a{}", (Object)wxBindingReqVo);
        Optional wxopenIdOptional = this.ucBdAuthMapper.findByWxOpenidAndSubordinateTypeAndAppIdTypeAndStatus(wxBindingReqVo.getWxOpenid(), wxBindingReqVo.getSubordinateType(), wxBindingReqVo.getAppIdType(), WxAuthEnums.WxAuthStatusEnum.NORMAL.getValue());
        Optional userOptional = this.ucBdAuthMapper.findByUserIdAndUserType(wxBindingReqVo.getUserId(), wxBindingReqVo.getUserType());
        boolean userIdExist = userOptional.isPresent();
        boolean openIdExist = wxopenIdOptional.isPresent();
        log.info("\u5fae\u4fe1\u8d26\u53f7\u7ed1\u5b9a userIdExist:{},openIdExist:{}", (Object)userIdExist, (Object)openIdExist);
        if (userIdExist || openIdExist) {
            if (openIdExist && userIdExist) {
                if (((UcWxAuthEntity)userOptional.get()).getAccountId().equals(((UcWxAuthEntity)wxopenIdOptional.get()).getAccountId())) {
                    log.info("\u5fae\u4fe1\u8d26\u53f7\u7ed1\u5b9a \u540c\u4e00\u6761\u8bb0\u5f55 \u6210\u529f {}", wxopenIdOptional.get());
                    return BaseResponse.success((Object)this.buildWxBaseRespVo((UcWxAuthEntity)wxopenIdOptional.get()));
                }
                UcWxAuthEntity openidWxAuth = (UcWxAuthEntity)wxopenIdOptional.get();
                openidWxAuth.setStatus(WxAuthEnums.WxAuthStatusEnum.UNBIND.getValue());
                this.ucBdAuthMapper.updateByPrimaryKeySelective(openidWxAuth);
                UcWxAuthEntity userIdWxAuth = (UcWxAuthEntity)userOptional.get();
                BeanUtils.copyProperties((Object)wxBindingReqVo, (Object)userIdWxAuth);
                userIdWxAuth.setStatus(WxAuthEnums.WxAuthStatusEnum.NORMAL.getValue());
                userIdWxAuth.setUpdateTime(new Date());
                this.ucBdAuthMapper.updateByPrimaryKeySelective(userIdWxAuth);
                log.info("openid,userid\u5747\u5df2\u5b58\u5728\uff0c\u4e24\u6761\u8bb0\u5f55\uff0c\u5148\u89e3\u7ed1\u518d\u66f4\u65b0\u7ed1\u5b9a--\u300b{}", (Object)JSON.toJSONString((Object)userIdWxAuth));
                return BaseResponse.success((Object)this.buildWxBaseRespVo(userIdWxAuth));
            }
            if (openIdExist) {
                UcWxAuthEntity openidWxAuth = (UcWxAuthEntity)wxopenIdOptional.get();
                openidWxAuth.setStatus(WxAuthEnums.WxAuthStatusEnum.UNBIND.getValue());
                this.ucBdAuthMapper.updateByPrimaryKeySelective(openidWxAuth);
                log.info("openid\u5df2\u5b58\u5728\uff0c\u5148\u89e3\u7ed1--\u300b{}", (Object)openidWxAuth.getAccountId());
                UcWxAuthEntity userIdWxAuth = new UcWxAuthEntity();
                BeanUtils.copyProperties((Object)wxBindingReqVo, (Object)userIdWxAuth);
                userIdWxAuth.setStatus(WxAuthEnums.WxAuthStatusEnum.NORMAL.getValue());
                userIdWxAuth.setCreateTime(new Date());
                log.info("openid\u5df2\u5b58\u5728\uff0c\u518d\u6dfb\u52a0\u7ed1\u5b9a--\u300b{}", (Object)JSON.toJSONString((Object)userIdWxAuth));
                this.ucBdAuthMapper.insertSelective(userIdWxAuth);
                return BaseResponse.success((Object)this.buildWxBaseRespVo(userIdWxAuth));
            }
            UcWxAuthEntity wxAuthEntity = (UcWxAuthEntity)userOptional.get();
            BeanUtils.copyProperties((Object)wxBindingReqVo, (Object)wxAuthEntity);
            wxAuthEntity.setStatus(WxAuthEnums.WxAuthStatusEnum.NORMAL.getValue());
            wxAuthEntity.setUpdateTime(new Date());
            this.ucBdAuthMapper.updateByPrimaryKeySelective(wxAuthEntity);
            log.info("\u5fae\u4fe1\u8d26\u53f7\u7ed1\u5b9a userId\u5b58\u5728 \u6210\u529f {}", (Object)wxAuthEntity);
            return BaseResponse.success((Object)this.buildWxBaseRespVo(wxAuthEntity));
        }
        UcWxAuthEntity wxAuth = new UcWxAuthEntity();
        BeanUtils.copyProperties((Object)wxBindingReqVo, (Object)wxAuth);
        wxAuth.setCreateTime(new Date());
        wxAuth.setUpdateTime(new Date());
        wxAuth.setStatus(WxAuthEnums.WxAuthStatusEnum.NORMAL.getValue());
        this.ucBdAuthMapper.save(wxAuth);
        log.info("\u5fae\u4fe1\u8d26\u53f7\u7ed1\u5b9a \u65b0\u589e \u6210\u529f {}", (Object)wxAuth);
        return BaseResponse.success((Object)this.buildWxBaseRespVo(wxAuth));
    }

    public BaseResponse<GetWxOpenidRespVO> getBdOpenid(GetWxOpenidReqVO getWxOpenidReqVO) {
        BaseResponse sessionkeyRes = this.getSessionkey(getWxOpenidReqVO.getCode(), getWxOpenidReqVO.getAppIdType());
        if (!sessionkeyRes.isSuccess()) {
            log.error("\u767e\u5ea6\u83b7\u53d6sessionkey \u5931\u8d25=={}", (Object)sessionkeyRes.getMsg());
            return BaseResponse.error((String)sessionkeyRes.getMsg());
        }
        GetWxOpenidRespVO getWxOpenidRespVO = new GetWxOpenidRespVO();
        getWxOpenidRespVO.setOpenid(((BaiduLoginDTO)sessionkeyRes.getData()).getOpenId());
        return BaseResponse.success((Object)getWxOpenidRespVO);
    }

    public BaseResponse<String> getbdAccessToken(String appCode) {
        UcBaiduConfigEntity baiduConfigEntity = this.baiduConfigMapper.getByAppCode(appCode);
        if (null != baiduConfigEntity && null != baiduConfigEntity.getAccessToken()) {
            return BaseResponse.success((Object)baiduConfigEntity.getAccessToken());
        }
        return BaseResponse.error((String)"\u83b7\u53d6\u767e\u5ea6AccessToken\u5931\u8d25");
    }

    public BaseResponse<Boolean> getBdEmpower(GetBdEmpowerReqVo getBdEmpowerReqVo) {
        if (getBdEmpowerReqVo.getIsQuery() == 1) {
            UcBaiduEmpowerConfigEntity ucBaiduEmpowerConfigEntity = this.ucBaiduEmpowerMapper.getBySwanId(getBdEmpowerReqVo.getSwanid());
            if (null != ucBaiduEmpowerConfigEntity) {
                return BaseResponse.success((Object)true);
            }
            return BaseResponse.success((Object)false);
        }
        UcBaiduEmpowerConfigEntity ucBaiduEmpowerConfigEntity = this.ucBaiduEmpowerMapper.getBySwanId(getBdEmpowerReqVo.getSwanid());
        if (null != ucBaiduEmpowerConfigEntity) {
            this.ucBaiduEmpowerMapper.updateBaiduConfigEntityById(ucBaiduEmpowerConfigEntity);
            return BaseResponse.success((Object)true);
        }
        UcBaiduEmpowerConfigEntity ucBaiduEmpowerConfig = new UcBaiduEmpowerConfigEntity();
        ucBaiduEmpowerConfig.setIsEmpower(Integer.valueOf(1));
        ucBaiduEmpowerConfig.setCreateTime(new Date());
        ucBaiduEmpowerConfig.setSwanId(getBdEmpowerReqVo.getSwanid());
        this.ucBaiduEmpowerMapper.insertSelective(ucBaiduEmpowerConfig);
        return BaseResponse.success((Object)true);
    }

    public BaseResponse<BaiduEmpowerResVo> getEmpowerTime(String swanId) {
        UcBaiduEmpowerConfigEntity ucBaiduEmpowerConfigEntity = this.ucBaiduEmpowerMapper.getBySwanId(swanId);
        if (null != ucBaiduEmpowerConfigEntity) {
            BaiduEmpowerResVo baiduEmpowerResVo = new BaiduEmpowerResVo();
            BeanUtils.copyProperties((Object)ucBaiduEmpowerConfigEntity, (Object)baiduEmpowerResVo);
            return BaseResponse.success();
        }
        return BaseResponse.error((String)"\u672a\u67e5\u5bfb\u5230\u76f8\u5173\u6570\u636e");
    }

    private UcWxAuthRespVo buildWxBaseRespVo(UcWxAuthEntity ucWxAuthEntity) {
        UcWxAuthRespVo ucWxAuthRespVo = new UcWxAuthRespVo();
        BeanUtils.copyProperties((Object)ucWxAuthEntity, (Object)ucWxAuthRespVo);
        if (org.apache.commons.lang.StringUtils.isEmpty((String)ucWxAuthEntity.getNickname()) && org.apache.commons.lang.StringUtils.isEmpty((String)ucWxAuthEntity.getHeadPortrait())) {
            ucWxAuthRespVo.setIsPerfect(Boolean.valueOf(false));
        } else {
            ucWxAuthRespVo.setIsPerfect(Boolean.valueOf(true));
        }
        log.info("\u5fae\u4fe1\u6388\u6743\u4fe1\u606f==>{}", (Object)JSON.toJSONString((Object)ucWxAuthRespVo));
        return ucWxAuthRespVo;
    }
}

