/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.util;

import com.ebaiyihui.common.enums.ErrorEnum;
import com.ebaiyihui.server.exception.UserCenterRuntimeException;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class RSAUtils {
    private static final Logger log = LoggerFactory.getLogger(RSAUtils.class);
    public static final String CHARSET = "UTF-8";
    public static final String RSA_ALGORITHM = "RSA";
    private static final String MEET_EXCEPTION = "]\u65f6\u9047\u5230\u5f02\u5e38";
    private static final String FIND_EXCEPTION = "\u51fa\u73b0\u5f02\u5e38:";
    public static final String PRIVATE_KEY = "MIIBVQIBADANBgkqhkiG9w0BAQEFAASCAT8wggE7AgEAAkEAqr3FbEJsSm47nE+jV9nlISWPblyrKVlG3rr7ms6bqzcGQpNzt6YI83YRSEp7ZP5BWBaqItOJzSbs+rAyHzQGBQIDAQABAkA4WMBaZeFO/un1P+LsDyCqu7aF+VcTIj9dKd/2ytBcxBUoybJZACJb95AjZfrU+yD+TTZsRLjvb5FVWZBfSvZRAiEA6KYOkRjBXHeftfYCwnkpggWr9zNGdWl3+JXYE1d4RacCIQC74P63gP0QhlNNOX49E4f53z7A1oPhWTbIBROE5TzkcwIhAOeogpTEm7Xhf+0GfJT9ZPGNiEDsk9pSHR4wxynrTV29AiAlQmChecY2Mb1xcjZz3Fy6FCj4y1IKLcwsbL1LPL8PuwIhAMilIoul+MokHUxzBGNWQCaXTimmHtxrGo3WW4Bd/2O3";

    public static String decode(String encodeString) {
        String decodeResult = null;
        try {
            decodeResult = RSAUtils.privateDecrypt((String)encodeString, (RSAPrivateKey)RSAUtils.getPrivateKey((String)"MIIBVQIBADANBgkqhkiG9w0BAQEFAASCAT8wggE7AgEAAkEAqr3FbEJsSm47nE+jV9nlISWPblyrKVlG3rr7ms6bqzcGQpNzt6YI83YRSEp7ZP5BWBaqItOJzSbs+rAyHzQGBQIDAQABAkA4WMBaZeFO/un1P+LsDyCqu7aF+VcTIj9dKd/2ytBcxBUoybJZACJb95AjZfrU+yD+TTZsRLjvb5FVWZBfSvZRAiEA6KYOkRjBXHeftfYCwnkpggWr9zNGdWl3+JXYE1d4RacCIQC74P63gP0QhlNNOX49E4f53z7A1oPhWTbIBROE5TzkcwIhAOeogpTEm7Xhf+0GfJT9ZPGNiEDsk9pSHR4wxynrTV29AiAlQmChecY2Mb1xcjZz3Fy6FCj4y1IKLcwsbL1LPL8PuwIhAMilIoul+MokHUxzBGNWQCaXTimmHtxrGo3WW4Bd/2O3"));
        }
        catch (Exception e) {
            log.info("-----RSA\u89e3\u5bc6\u5f02\u5e38----" + decodeResult);
            throw new UserCenterRuntimeException(ErrorEnum.RSA_DECODE_ERROR);
        }
        return decodeResult;
    }

    public static RSAPublicKey getPublicKey(String publicKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(Base64.decodeBase64((String)publicKey));
        RSAPublicKey key = (RSAPublicKey)keyFactory.generatePublic(x509KeySpec);
        return key;
    }

    public static RSAPrivateKey getPrivateKey(String privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(Base64.decodeBase64((String)privateKey));
        RSAPrivateKey key = (RSAPrivateKey)keyFactory.generatePrivate(pkcs8KeySpec);
        return key;
    }

    public static String publicEncrypt(String data, RSAPublicKey publicKey) {
        try {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(1, publicKey);
            return Base64.encodeBase64URLSafeString((byte[])RSAUtils.rsaSplitCodec((Cipher)cipher, (int)1, (byte[])data.getBytes("UTF-8"), (int)publicKey.getModulus().bitLength()));
        }
        catch (Exception e) {
            throw new RuntimeException("\u52a0\u5bc6\u5b57\u7b26\u4e32[" + data + "]\u65f6\u9047\u5230\u5f02\u5e38", e);
        }
    }

    public static String privateDecrypt(String data, RSAPrivateKey privateKey) {
        try {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(2, privateKey);
            return new String(RSAUtils.rsaSplitCodec((Cipher)cipher, (int)2, (byte[])Base64.decodeBase64((String)data), (int)privateKey.getModulus().bitLength()), "UTF-8");
        }
        catch (Exception e) {
            log.info("\u89e3\u5bc6\u5b57\u7b26\u4e32[" + data + "]\u65f6\u9047\u5230\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException("\u89e3\u5bc6\u5b57\u7b26\u4e32[" + data + "]\u65f6\u9047\u5230\u5f02\u5e38", e);
        }
    }

    private static byte[] rsaSplitCodec(Cipher cipher, int opmode, byte[] datas, int keySize) {
        int maxBlock = 0;
        maxBlock = opmode == 2 ? keySize / 8 : keySize / 8 - 11;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        int i = 0;
        try {
            while (datas.length > offSet) {
                byte[] buff = datas.length - offSet > maxBlock ? cipher.doFinal(datas, offSet, maxBlock) : cipher.doFinal(datas, offSet, datas.length - offSet);
                out.write(buff, 0, buff.length);
                offSet = ++i * maxBlock;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u52a0\u89e3\u5bc6\u9600\u503c\u4e3a[" + maxBlock + "]\u7684\u6570\u636e\u65f6\u53d1\u751f\u5f02\u5e38", e);
        }
        byte[] resultDatas = out.toByteArray();
        IOUtils.closeQuietly((OutputStream)out);
        return resultDatas;
    }

    public static Map<String, String> createKeys(int keySize) {
        KeyPairGenerator kpg;
        try {
            kpg = KeyPairGenerator.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("No such algorithm-->[RSA]");
        }
        kpg.initialize(keySize);
        KeyPair keyPair = kpg.generateKeyPair();
        PublicKey publicKey = keyPair.getPublic();
        String publicKeyStr = Base64.encodeBase64String((byte[])publicKey.getEncoded());
        PrivateKey privateKey = keyPair.getPrivate();
        String privateKeyStr = Base64.encodeBase64String((byte[])privateKey.getEncoded());
        HashMap<String, String> keyPairMap = new HashMap<String, String>();
        keyPairMap.put("publicKey", publicKeyStr);
        keyPairMap.put("privateKey", privateKeyStr);
        RSAPublicKey rsp = (RSAPublicKey)keyPair.getPublic();
        BigInteger bit = rsp.getModulus();
        byte[] b = bit.toByteArray();
        byte[] deBase64Value = Base64.encodeBase64((byte[])b);
        String retValue = new String(deBase64Value);
        keyPairMap.put("model", retValue);
        return keyPairMap;
    }

    public static void main(String[] args) {
        Map keyPairMap = RSAUtils.createKeys((int)512);
        System.out.println("-----\u516c\u94a5----\n" + (String)keyPairMap.get("publicKey"));
        System.out.println("-----\u79c1\u94a5----\n" + (String)keyPairMap.get("privateKey"));
        String data = "1234567";
        String encode = null;
        try {
            encode = RSAUtils.publicEncrypt((String)data, (RSAPublicKey)RSAUtils.getPublicKey((String)"MFwwDQYJKoZIhvcNAQEBBQADSwAwSAJBAKq9xWxCbEpuO5xPo1fZ5SElj25cqylZRt66+5rOm6s3BkKTc7emCPN2EUhKe2T+QVgWqiLTic0m7PqwMh80BgUCAwEAAQ=="));
        }
        catch (NoSuchAlgorithmException e) {
            log.error("\u51fa\u73b0\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
        }
        catch (InvalidKeySpecException e) {
            log.error("\u51fa\u73b0\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
        }
        System.out.println("-----\u52a0\u5bc6\u7ed3\u679c----\n" + encode);
        String decodeResult = null;
        try {
            decodeResult = RSAUtils.privateDecrypt((String)encode, (RSAPrivateKey)RSAUtils.getPrivateKey((String)"MIIBVQIBADANBgkqhkiG9w0BAQEFAASCAT8wggE7AgEAAkEAqr3FbEJsSm47nE+jV9nlISWPblyrKVlG3rr7ms6bqzcGQpNzt6YI83YRSEp7ZP5BWBaqItOJzSbs+rAyHzQGBQIDAQABAkA4WMBaZeFO/un1P+LsDyCqu7aF+VcTIj9dKd/2ytBcxBUoybJZACJb95AjZfrU+yD+TTZsRLjvb5FVWZBfSvZRAiEA6KYOkRjBXHeftfYCwnkpggWr9zNGdWl3+JXYE1d4RacCIQC74P63gP0QhlNNOX49E4f53z7A1oPhWTbIBROE5TzkcwIhAOeogpTEm7Xhf+0GfJT9ZPGNiEDsk9pSHR4wxynrTV29AiAlQmChecY2Mb1xcjZz3Fy6FCj4y1IKLcwsbL1LPL8PuwIhAMilIoul+MokHUxzBGNWQCaXTimmHtxrGo3WW4Bd/2O3"));
        }
        catch (NoSuchAlgorithmException e) {
            log.error("\u51fa\u73b0\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
        }
        catch (InvalidKeySpecException e) {
            log.error("\u51fa\u73b0\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
        }
        System.out.println("-----\u89e3\u5bc6\u7ed3\u679c----\n" + decodeResult);
    }
}

