/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.common.enums.ErrorEnum;
import com.ebaiyihui.common.pojo.vo.push.MailVerificationReqVo;
import com.ebaiyihui.common.token.TokenBody;
import com.ebaiyihui.common.token.TokenJson;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.UUIDUtils;
import com.ebaiyihui.server.config.ProjProperties;
import com.ebaiyihui.server.config.UniqueID;
import com.ebaiyihui.server.enums.AccountEnums;
import com.ebaiyihui.server.enums.UserEnums;
import com.ebaiyihui.server.exception.UserCenterRuntimeException;
import com.ebaiyihui.server.pojo.entity.UcAccountEntity;
import com.ebaiyihui.server.pojo.entity.UcAppTokenKeyEntity;
import com.ebaiyihui.server.pojo.entity.UcDoctorUserEntity;
import com.ebaiyihui.server.pojo.entity.UcManagerUserEntity;
import com.ebaiyihui.server.pojo.entity.UcOrganUserEntity;
import com.ebaiyihui.server.pojo.entity.UcPatientUserEntity;
import com.ebaiyihui.server.pojo.entity.UcWxAppletConfigEntity;
import com.ebaiyihui.server.pojo.vo.SmsVerifiAuthCodeReqVO;
import com.ebaiyihui.server.repository.UcAccountMapper;
import com.ebaiyihui.server.repository.UcAccountOperateMapper;
import com.ebaiyihui.server.repository.UcAppTokenKeyMapper;
import com.ebaiyihui.server.repository.UcCardBindLogMapper;
import com.ebaiyihui.server.repository.UcDoctorUserMapper;
import com.ebaiyihui.server.repository.UcLoginRecordMapper;
import com.ebaiyihui.server.repository.UcManageOperateMapper;
import com.ebaiyihui.server.repository.UcManagerUserMapper;
import com.ebaiyihui.server.repository.UcOrganUserMapper;
import com.ebaiyihui.server.repository.UcPatientInfoMapper;
import com.ebaiyihui.server.repository.UcPatientOperateMapper;
import com.ebaiyihui.server.repository.UcPatientUserMapper;
import com.ebaiyihui.server.repository.UcUserCardBindMapper;
import com.ebaiyihui.server.repository.UcWxAppletConfigMapper;
import com.ebaiyihui.server.repository.UcWxAuthMapper;
import com.ebaiyihui.server.service.ICacheService;
import com.ebaiyihui.server.util.RedisUtil;
import com.ebaiyihui.server.util.RegexUtils;
import com.ebaiyihui.server.util.RestTemplateUtils;
import com.ebaiyihui.server.util.Tokenutil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.DigestUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public abstract class BaseService {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    protected ProjProperties projProperties;
    @Autowired
    protected RestTemplate restTemplate;
    @Autowired
    protected ICacheService cacheService;
    @Autowired
    protected UcDoctorUserMapper ucDoctorUserMapper;
    @Autowired
    protected UcOrganUserMapper ucOrganUserMapper;
    @Autowired
    protected UcManagerUserMapper ucManagerUserMapper;
    @Autowired
    protected UcPatientUserMapper ucPatientUserMapper;
    @Autowired
    protected UcAccountMapper ucAccountMapper;
    @Autowired
    protected UniqueID uniqueID;
    @Autowired
    protected UcLoginRecordMapper ucLoginRecordMapper;
    @Autowired
    protected UcAccountOperateMapper ucAccountOperateMapper;
    @Autowired
    protected UcPatientInfoMapper ucPatientInfoMapper;
    @Autowired
    protected UcManageOperateMapper ucManageOperateMapper;
    @Autowired
    protected UcWxAuthMapper ucWxAuthMapper;
    @Autowired
    protected UcAppTokenKeyMapper ucAppTokenKeyMapper;
    @Autowired
    protected UcPatientOperateMapper ucPatientOperateMapper;
    @Autowired
    protected UcCardBindLogMapper cardBindLogMapper;
    @Autowired
    protected UcUserCardBindMapper cardBindMapper;
    @Autowired
    protected UcWxAppletConfigMapper wxAppletConfigMapper;
    @Autowired
    protected RedisUtil redisUtil;
    private static final String REGEX_PHONE = "^(13[0-9]|141|14[4-9]|15[0-3]|15[5-9]|166|17[0-1]|17[3-8]|18[0-9]|19[8-9])\\d{8}$";

    protected List<UcAccountEntity> getAllAccounts(String accountNo, Short userType, String appCode) {
        if (StringUtils.isEmpty((Object)accountNo) || StringUtils.isEmpty((Object)appCode) || userType == null) {
            this.log.warn("\u83b7\u53d6\u6240\u6709\u72b6\u6001\u7684\u8d26\u6237\u5931\u8d25,\u53c2\u6570\u7f3a\u5931,accountNo={},userType={},appCode={}", new Object[]{accountNo, userType, appCode});
            throw new UserCenterRuntimeException(ErrorEnum.INVALID_PARAMETER);
        }
        return this.ucAccountMapper.selectListByUserTypeAndAppCodeAndAccountNoOrRelatedMobileNumber(userType, appCode, accountNo);
    }

    protected UcAccountEntity getAccount(String accountNo, Short userType, String appCode) {
        if (StringUtils.isEmpty((Object)accountNo) || StringUtils.isEmpty((Object)appCode) || userType == null) {
            this.log.warn("\u83b7\u53d6\u552f\u4e00\u975e\u6ce8\u9500\u72b6\u6001\u7684\u8d26\u6237\u5931\u8d25,\u53c2\u6570\u7f3a\u5931,accountNo={},userType={},appCode={}", new Object[]{accountNo, userType, appCode});
            throw new UserCenterRuntimeException(ErrorEnum.INVALID_PARAMETER);
        }
        List list = this.getAllAccounts(accountNo, userType, appCode);
        if (list == null || list.isEmpty()) {
            return null;
        }
        for (UcAccountEntity ucAccountEntity : list) {
            if (AccountEnums.AccountStatusEnum.CANCELLATION.getValue().equals(ucAccountEntity.getStatus()) || AccountEnums.AccountStatusEnum.NO_REGISTER.getValue().equals(ucAccountEntity.getStatus())) continue;
            return ucAccountEntity;
        }
        return null;
    }

    protected UcAccountEntity getAccountByAccountNo(String accountNo, Short userType, String appCode) {
        if (StringUtils.isEmpty((Object)accountNo) || StringUtils.isEmpty((Object)appCode) || userType == null) {
            this.log.warn("\u83b7\u53d6\u552f\u4e00\u975e\u6ce8\u9500\u72b6\u6001\u7684\u8d26\u6237\u5931\u8d25,\u53c2\u6570\u7f3a\u5931,accountNo={},userType={},appCode={}", new Object[]{accountNo, userType, appCode});
            throw new UserCenterRuntimeException(ErrorEnum.INVALID_PARAMETER);
        }
        List list = this.ucAccountMapper.selectListByUserTypeAndAppCodeAndAccountNoOrRelatedMobileNumber(userType, appCode, accountNo);
        if (list == null || list.isEmpty()) {
            return null;
        }
        for (UcAccountEntity ucAccountEntity : list) {
            if (!AccountEnums.AccountStatusEnum.NORMAL.getValue().equals(ucAccountEntity.getStatus())) continue;
            return ucAccountEntity;
        }
        return null;
    }

    protected UcAccountEntity getAccountByUserId(String userId, Short userType, String appCode) {
        if (StringUtils.isEmpty((Object)userId) || StringUtils.isEmpty((Object)appCode) || userType == null) {
            this.log.warn("\u83b7\u53d6\u975e\u6ce8\u9500\u72b6\u6001\u7684\u8d26\u6237\u5931\u8d25,\u53c2\u6570\u7f3a\u5931,userId={},userType={},appCode={}", new Object[]{userId, userType, appCode});
            throw new UserCenterRuntimeException(ErrorEnum.INVALID_PARAMETER);
        }
        List list = this.ucAccountMapper.selectListByUserIdAndUserTypeAndAppCode(userId, userType, appCode);
        if (list == null || list.isEmpty()) {
            return null;
        }
        ArrayList<UcAccountEntity> accounts = new ArrayList<UcAccountEntity>();
        for (UcAccountEntity ucAccountEntity : list) {
            if (AccountEnums.AccountStatusEnum.CANCELLATION.getValue().equals(ucAccountEntity.getStatus())) continue;
            if (AccountEnums.AccountTypeEnum.CELL_PHONE.getValue().equals(ucAccountEntity.getAccountType())) {
                return ucAccountEntity;
            }
            accounts.add(ucAccountEntity);
        }
        if (!accounts.isEmpty()) {
            return (UcAccountEntity)accounts.get(0);
        }
        return null;
    }

    protected TokenBody getTokenBody(String token, String appCode) {
        if (StringUtils.isEmpty((Object)token) || StringUtils.isEmpty((Object)appCode)) {
            this.log.warn("\u83b7\u53d6TokenBody,\u53c2\u6570\u7f3a\u5931,token={},appCode={}", (Object)token, (Object)appCode);
            throw new UserCenterRuntimeException(ErrorEnum.INVALID_PARAMETER);
        }
        String secryKey = this.getSecryKey(appCode);
        try {
            return Tokenutil.parse((String)token, (String)secryKey);
        }
        catch (Exception e) {
            this.log.error("TOKEN\u89e3\u6790\u5931\u8d25\uff0cappCode={},token={}", (Object)appCode, (Object)token);
            throw new UserCenterRuntimeException(ErrorEnum.TOKEN_PARSE_FAIL);
        }
    }

    protected String getSecryKey(String appCode) {
        String secryKey = (String)this.redisUtil.get(appCode);
        if (secryKey == null) {
            UcAppTokenKeyEntity entity = this.ucAppTokenKeyMapper.getByAppCode(appCode);
            if (entity == null) {
                this.log.warn("token\u5bc6\u94a5\u67e5\u8be2\u5931\u8d25\uff0cappCode={}", (Object)appCode);
                throw new UserCenterRuntimeException(ErrorEnum.TOKEN_SECRYKEY_NOT_EXIST);
            }
            secryKey = entity.getKey();
            this.redisUtil.set(appCode, (Object)secryKey);
        }
        return secryKey;
    }

    protected TokenJson getTokenJson(String token, String appCode) {
        if (StringUtils.isEmpty((Object)token) || StringUtils.isEmpty((Object)appCode)) {
            this.log.warn("\u83b7\u53d6TokenBody,\u53c2\u6570\u7f3a\u5931,token={},appCode={}", (Object)token, (Object)appCode);
            throw new UserCenterRuntimeException(ErrorEnum.INVALID_PARAMETER);
        }
        return this.getTokenBody(token, appCode).getTokenJson();
    }

    protected void checkAccountNoAndLoginNameEqual(String newAccountNo, UcAccountEntity account) {
        if (newAccountNo == null || account == null) {
            this.log.warn("\u6821\u9a8c\u65b0\u8d26\u53f7\u4e0eloginname\u4e92\u4e0d\u76f8\u7b49,\u53c2\u6570\u7f3a\u5931,accountNo={},UcAccountEntity={}", (Object)newAccountNo, (Object)JSON.toJSONString((Object)account));
            throw new UserCenterRuntimeException(ErrorEnum.INVALID_PARAMETER);
        }
        if (newAccountNo.equals(account.getLoginName()) || account.getLoginName().equals(account.getRelatedMobileNumber()) || account.getLoginName().equals(account.getAccountNo())) {
            this.log.warn("\u6821\u9a8c\u65b0\u8d26\u53f7\u4e0eloginname\u4e92\u4e0d\u76f8\u7b49,\u53c2\u6570\u7f3a\u5931,accountNo={},UcAccountEntity={}", (Object)newAccountNo, (Object)JSON.toJSONString((Object)account));
            throw new UserCenterRuntimeException(ErrorEnum.INVALID_ACCOUNTNO);
        }
    }

    protected Boolean checkAccountNoRightByAccountType(String accountNo, Short accountType) {
        if (StringUtils.isEmpty((Object)accountNo) || accountType == null) {
            this.log.warn("\u901a\u8fc7\u8d26\u6237\u7c7b\u578b\u6821\u9a8c\u8d26\u6237\u6821\u9a8c\u5931\u8d25,\u53c2\u6570\u7f3a\u5931,accountNo={},accountType={}", (Object)accountNo, (Object)accountType);
            throw new UserCenterRuntimeException(ErrorEnum.INVALID_PARAMETER);
        }
        switch (accountType) {
            case 0: {
                if (RegexUtils.checkMobile((String)accountNo)) break;
                this.log.info("\u901a\u8fc7\u8d26\u6237\u7c7b\u578b\u6821\u9a8c\u8d26\u6237  \u9519\u8bef\u7684\u767b\u5f55\u624b\u673a\u53f7\u7801,accountNo={}", (Object)accountNo);
                throw new UserCenterRuntimeException(ErrorEnum.WRONG_PHONE_NUMBER);
            }
            case 1: {
                if (RegexUtils.checkEmail((String)accountNo)) break;
                this.log.info("\u901a\u8fc7\u8d26\u6237\u7c7b\u578b\u6821\u9a8c\u8d26\u6237  \u9519\u8bef\u7684\u767b\u5f55\u624b\u673a\u53f7\u7801,accountNo={}", (Object)accountNo);
                throw new UserCenterRuntimeException(ErrorEnum.WRONG_EMAIL);
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new UserCenterRuntimeException(ErrorEnum.UNKNOWN_ACCOUNT_TYPE);
            }
        }
        return true;
    }

    protected UcAccountEntity getRightAccount(String accountId) {
        UcAccountEntity account = this.ucAccountMapper.findByAccountId(accountId);
        if (account == null || AccountEnums.AccountStatusEnum.CANCELLATION.getValue().equals(account.getStatus())) {
            this.log.warn("\u8d26\u6237\u4e0d\u5b58\u5728\u6216\u8005\u5df2\u6ce8\u9500,accountId={}", (Object)accountId);
            throw new UserCenterRuntimeException(ErrorEnum.NO_EXISTS_ACCOUNT);
        }
        if (AccountEnums.AccountStatusEnum.PROHIBIT.getValue().equals(account.getStatus())) {
            this.log.warn("\u8d26\u6237\u5df2\u7981\u7528,accountId={}", (Object)accountId);
            throw new UserCenterRuntimeException(ErrorEnum.DISABLED_ACCOUNT);
        }
        return account;
    }

    protected UcPatientUserEntity getPatientUserEntity(String userId) {
        Optional optional = this.ucPatientUserMapper.findByUserId(userId);
        if (!optional.isPresent()) {
            this.log.warn("\u67e5\u8be2\u60a3\u8005\u7528\u6237\u4e0d\u5b58\u5728,userId={}", (Object)userId);
            throw new UserCenterRuntimeException(ErrorEnum.USER_NOT_EXIT);
        }
        UcPatientUserEntity user = (UcPatientUserEntity)optional.get();
        if (UserEnums.UserStatusEnum.CANCELLATION.getUserStatusValue().equals(user.getUserStatus())) {
            this.log.warn("\u60a3\u8005\u7528\u6237\u5df2\u88ab\u6ce8\u9500,userId={}", (Object)userId);
            throw new UserCenterRuntimeException(ErrorEnum.CANCELED_USER);
        }
        if (UserEnums.UserStatusEnum.PROHIBIT.getUserStatusValue().equals(user.getUserStatus())) {
            this.log.warn("\u60a3\u8005\u7528\u6237\u5df2\u88ab\u7981\u7528,userId={}", (Object)userId);
            throw new UserCenterRuntimeException(ErrorEnum.DISABLED_USER);
        }
        return user;
    }

    protected UcDoctorUserEntity getDoctorUserEntity(String userId) {
        Optional optional = this.ucDoctorUserMapper.selectByUserId(userId);
        if (!optional.isPresent()) {
            this.log.warn("\u67e5\u8be2\u533b\u751f\u7528\u6237\u4e0d\u5b58\u5728,userId={}", (Object)userId);
            throw new UserCenterRuntimeException(ErrorEnum.USER_NOT_EXIT);
        }
        UcDoctorUserEntity user = (UcDoctorUserEntity)optional.get();
        if (UserEnums.UserStatusEnum.CANCELLATION.getUserStatusValue().equals(user.getUserStatus())) {
            this.log.warn("\u533b\u751f\u7528\u6237\u5df2\u88ab\u6ce8\u9500,userId={}", (Object)userId);
            throw new UserCenterRuntimeException(ErrorEnum.CANCELED_USER);
        }
        if (UserEnums.UserStatusEnum.PROHIBIT.getUserStatusValue().equals(user.getUserStatus())) {
            this.log.warn("\u533b\u751f\u7528\u6237\u5df2\u88ab\u7981\u7528,userId={}", (Object)userId);
            throw new UserCenterRuntimeException(ErrorEnum.DISABLED_USER);
        }
        return user;
    }

    protected UcManagerUserEntity getManagerUserEntity(String userId) {
        Optional optional = this.ucManagerUserMapper.selectByUserId(userId);
        if (!optional.isPresent()) {
            this.log.warn("\u67e5\u8be2\u7ba1\u7406\u5458\u7528\u6237\u4e0d\u5b58\u5728,userId={}", (Object)userId);
            throw new UserCenterRuntimeException(ErrorEnum.USER_NOT_EXIT);
        }
        UcManagerUserEntity user = (UcManagerUserEntity)optional.get();
        if (UserEnums.UserStatusEnum.CANCELLATION.getUserStatusValue().equals(user.getUserStatus())) {
            this.log.warn("\u7ba1\u7406\u5458\u7528\u6237\u5df2\u88ab\u6ce8\u9500,userId={}", (Object)userId);
            throw new UserCenterRuntimeException(ErrorEnum.CANCELED_USER);
        }
        if (UserEnums.UserStatusEnum.PROHIBIT.getUserStatusValue().equals(user.getUserStatus())) {
            this.log.warn("\u7ba1\u7406\u5458\u7528\u6237\u5df2\u88ab\u7981\u7528,userId={}", (Object)userId);
            throw new UserCenterRuntimeException(ErrorEnum.DISABLED_USER);
        }
        return user;
    }

    protected UcOrganUserEntity getOrganUserEntity(String userId) {
        Optional optional = this.ucOrganUserMapper.selectByUserId(userId);
        if (!optional.isPresent()) {
            this.log.warn("\u67e5\u8be2\u673a\u6784\u7528\u6237\u4e0d\u5b58\u5728,userId={}", (Object)userId);
            throw new UserCenterRuntimeException(ErrorEnum.USER_NOT_EXIT);
        }
        UcOrganUserEntity user = (UcOrganUserEntity)optional.get();
        if (UserEnums.UserStatusEnum.CANCELLATION.getUserStatusValue().equals(user.getUserStatus())) {
            this.log.warn("\u673a\u6784\u7528\u6237\u5df2\u88ab\u6ce8\u9500,userId={}", (Object)userId);
            throw new UserCenterRuntimeException(ErrorEnum.CANCELED_USER);
        }
        if (UserEnums.UserStatusEnum.PROHIBIT.getUserStatusValue().equals(user.getUserStatus())) {
            this.log.warn("\u673a\u6784\u7528\u6237\u5df2\u88ab\u7981\u7528,userId={}", (Object)userId);
            throw new UserCenterRuntimeException(ErrorEnum.DISABLED_USER);
        }
        return user;
    }

    protected UcAccountEntity getDoctorAccount(String doctorId, String appCode) {
        List userIds = this.ucDoctorUserMapper.findByDoctorIdAndAppCode(doctorId, appCode);
        if (userIds == null || userIds.isEmpty()) {
            return null;
        }
        UcAccountEntity account = this.getAccountByUserId((String)userIds.get(0), UserEnums.UserTypeEnum.DOCTOR.getUserTypeValue(), appCode);
        return account;
    }

    public Boolean isVercodePhone(String phoneNum) {
        if (phoneNum == null) {
            return false;
        }
        if (this.redisUtil.hasKey(ErrorEnum.VERCODE_NEED_PHONENUM + "_" + phoneNum)) {
            int loginCount = (Integer)this.redisUtil.get(ErrorEnum.VERCODE_NEED_PHONENUM + "_" + phoneNum);
            if (loginCount >= 3) {
                this.log.info("\u540c\u4e00\u4e2a\u624b\u673a\u53f7\u572824\u5c0f\u65f6\u5185\u51fa\u73b0\u8d85\u8fc73\u6b21\uff0c\u6b21\u6570\uff1a{},ip:{}", (Object)loginCount, (Object)phoneNum);
                return true;
            }
            long expire = this.redisUtil.getExpire(ErrorEnum.VERCODE_NEED_PHONENUM + "_" + phoneNum);
            ++loginCount;
            if (expire <= 0L) {
                expire = 86400L;
                loginCount = 1;
            }
            this.redisUtil.set(ErrorEnum.VERCODE_NEED_PHONENUM + "_" + phoneNum, (Object)loginCount, expire, TimeUnit.SECONDS);
            this.log.info("\u540c\u4e00\u4e2a\u624b\u673a\u53f7\u572824\u5c0f\u65f6\u5185\u51fa\u73b0\u6b21\u6570loginCount:{},ip:{}", (Object)loginCount, (Object)phoneNum);
            return false;
        }
        long expire = 86400L;
        int loginCount = 1;
        this.redisUtil.set(ErrorEnum.VERCODE_NEED_PHONENUM + "_" + phoneNum, (Object)loginCount, expire, TimeUnit.SECONDS);
        this.log.info("\u540c\u4e00\u4e2a\u624b\u673a\u53f7\u572824\u5c0f\u65f6\u5185\u51fa\u73b0\u6b21\u6570loginCount:{},ip:{}", (Object)loginCount, (Object)phoneNum);
        return false;
    }

    public Boolean isVercodeIP(String loginIp) {
        if (loginIp == null) {
            return false;
        }
        if (this.redisUtil.hasKey(ErrorEnum.VERCODE_NEED_IP + "_" + loginIp)) {
            int loginCount = (Integer)this.redisUtil.get(ErrorEnum.VERCODE_NEED_IP + "_" + loginIp);
            if (loginCount >= 10) {
                this.log.info("\u540c\u4e00\u4e2aIP\u572824\u5c0f\u65f6\u5185\u51fa\u73b0\u8d85\u8fc710\u6b21\uff0c\u6b21\u6570\uff1a{},ip:{}", (Object)loginCount, (Object)loginIp);
                return true;
            }
            long expire = this.redisUtil.getExpire(ErrorEnum.VERCODE_NEED_IP + "_" + loginIp);
            ++loginCount;
            if (expire <= 0L) {
                expire = 86400L;
                loginCount = 1;
            }
            this.redisUtil.set(ErrorEnum.VERCODE_NEED_IP + "_" + loginIp, (Object)loginCount, expire, TimeUnit.SECONDS);
            this.log.info("\u540c\u4e00\u4e2aIP\u572824\u5c0f\u65f6\u5185\u767b\u5f55\u6b21\u6570\uff0c\u6b21\u6570\uff1a{},ip:{}", (Object)loginCount, (Object)loginIp);
            return false;
        }
        long expire = 86400L;
        int loginCount = 1;
        this.redisUtil.set(ErrorEnum.VERCODE_NEED_IP + "_" + loginIp, (Object)loginCount, expire, TimeUnit.SECONDS);
        this.log.info("\u540c\u4e00\u4e2aIP\u572824\u5c0f\u65f6\u5185\u767b\u5f55\u6b21\u6570\uff0c\u6b21\u6570\uff1a{},ip:{}", (Object)loginCount, (Object)loginIp);
        return false;
    }

    protected boolean verifyVercode(String vercodeKey, String vercodeValue) {
        Object vercode = "";
        if (!StringUtils.isEmpty((Object)vercodeKey) && !StringUtils.isEmpty((Object)vercodeValue) && (vercode = this.redisUtil.get(vercodeKey)) != null && vercodeValue.equalsIgnoreCase((String)vercode)) {
            this.log.info("\u56fe\u6587\u9a8c\u8bc1\u901a\u8fc7  \u5165\u53c2\uff1a{},\u5b9e\u9645\u9a8c\u8bc1\u7801\uff1a{}", (Object)vercodeValue, vercode);
            return true;
        }
        this.log.info("\u56fe\u6587\u9a8c\u8bc1\u4e0d\u6b63\u786e \u5165\u53c2\uff1a{},\u5b9e\u9645\u9a8c\u8bc1\u7801\uff1a{}", (Object)vercodeValue, vercode);
        return false;
    }

    protected boolean verifialismsauthcode(SmsVerifiAuthCodeReqVO smsVerifiAuthCodeReqVo) {
        try {
            String requestUrl = this.projProperties.getEbaiyihuiDomain() + "/cloud/push/alismsapi/verifialismsauthcode";
            if (!this.projProperties.getI18nEnabled().booleanValue()) {
                HttpHeaders headers = new HttpHeaders();
                headers.set("accept-language", "zh-CN,zh;q=0.9,en;q=0.8");
                HttpEntity httpEntity = new HttpEntity((Object)smsVerifiAuthCodeReqVo, (MultiValueMap)headers);
                ResponseEntity responseEntity = this.restTemplate.exchange(requestUrl, HttpMethod.POST, httpEntity, BaseResponse.class, new Object[0]);
                this.log.error("\u6821\u9a8c\u77ed\u4fe1\u9a8c\u8bc1\u7801--\u54cd\u5e94:" + JSON.toJSONString((Object)responseEntity));
                if (HttpStatus.OK.equals((Object)responseEntity.getStatusCode()) && ((BaseResponse)responseEntity.getBody()).isSuccess()) {
                    return true;
                }
                throw new UserCenterRuntimeException(ErrorEnum.OTHER_SERVICE_ERROR_DEFAULT_CODE, responseEntity.getBody() == null ? "\u77ed\u4fe1\u9a8c\u8bc1\u7801\u6821\u9a8c\u5931\u8d25" : ((BaseResponse)responseEntity.getBody()).getMsg());
            }
            BaseResponse checkMsgResp = (BaseResponse)this.restTemplate.postForObject(requestUrl, (Object)smsVerifiAuthCodeReqVo, BaseResponse.class, new Object[0]);
            if (checkMsgResp != null && checkMsgResp.isSuccess()) {
                return true;
            }
            if (checkMsgResp != null && !checkMsgResp.isSuccess()) {
                throw new UserCenterRuntimeException(ErrorEnum.OTHER_SERVICE_ERROR_DEFAULT_CODE, checkMsgResp.getMsg());
            }
            this.log.info("\u6821\u9a8c\u90ae\u4ef6\u9a8c\u8bc1\u7801 \u62a5\u9519" + JSON.toJSONString((Object)checkMsgResp));
            return false;
        }
        catch (Exception e) {
            this.log.error("\u627e\u56de\u5bc6\u7801\uff0c\u77ed\u4fe1\u9a8c\u8bc1\u7801\u6821\u9a8c\uff0c\u5f02\u5e38\uff0c{}", (Object)e.getMessage());
            throw new UserCenterRuntimeException(ErrorEnum.OTHER_SERVICE_ERROR_DEFAULT_CODE, e.getMessage());
        }
    }

    protected boolean verifyMailAuthcode(MailVerificationReqVo reqVo) {
        this.log.info("\u6821\u9a8c\u90ae\u4ef6\u9a8c\u8bc1\u7801 \u5165\u53c2:{}", (Object)JSON.toJSONString((Object)reqVo));
        try {
            JSONObject params = JSON.parseObject((String)JSON.toJSONString((Object)reqVo));
            String url = this.projProperties.getEbaiyihuiDomain().concat("/cloud/push/mail/verify");
            String result = RestTemplateUtils.post((String)url, (JSONObject)params, (MediaType)MediaType.APPLICATION_JSON_UTF8);
            this.log.info("\u6821\u9a8c\u90ae\u4ef6\u9a8c\u8bc1\u7801--url:{},---result:{}", (Object)url, (Object)result);
            if (result == null) {
                this.log.info("\u8c03\u7528\u63a8\u9001\u670d\u52a1---\u6821\u9a8c\u90ae\u4ef6\u9a8c\u8bc1\u7801--\u8fd4\u56denull");
                return false;
            }
            BaseResponse checkMsgResp = (BaseResponse)JSONObject.parseObject((String)result, BaseResponse.class);
            if (Objects.nonNull(checkMsgResp)) {
                if ("1".equals(checkMsgResp.getCode())) {
                    return true;
                }
                if ("0".equals(checkMsgResp.getCode())) {
                    this.log.info("\u8c03\u7528\u63a8\u9001\u670d\u52a1---\u6821\u9a8c\u90ae\u4ef6\u9a8c\u8bc1\u7801checkMsgResp===={}", (Object)JSON.toJSONString((Object)checkMsgResp));
                    throw new UserCenterRuntimeException(ErrorEnum.OTHER_SERVICE_ERROR_DEFAULT_CODE, checkMsgResp.getMsg());
                }
                this.log.info("\u6821\u9a8c\u90ae\u4ef6\u9a8c\u8bc1\u7801 \u62a5\u9519" + result);
                return false;
            }
            return false;
        }
        catch (Exception e) {
            this.log.error("\u90ae\u7bb1\u9a8c\u8bc1\u7801\u6821\u9a8c\uff0c\u5f02\u5e38\uff0c{}", (Object)e.getMessage());
            throw new UserCenterRuntimeException(ErrorEnum.OTHER_SERVICE_ERROR_DEFAULT_CODE, e.getMessage());
        }
    }

    protected UcWxAppletConfigEntity getWxAppletConfig(String appIdType) {
        String key = "wx_miniProgram_".concat(appIdType);
        try {
            UcWxAppletConfigEntity ucWxAppletConfigEntity;
            Object config = this.redisUtil.get(key);
            if (config != null && (ucWxAppletConfigEntity = (UcWxAppletConfigEntity)JSON.parseObject((String)JSON.toJSONString((Object)config), UcWxAppletConfigEntity.class)) != null && ucWxAppletConfigEntity.getAppletId() != null && ucWxAppletConfigEntity.getAppletSecret() != null) {
                this.log.info("\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u4fe1\u606f entity:{}", (Object)JSON.toJSONString((Object)ucWxAppletConfigEntity));
                ucWxAppletConfigEntity.setAppIdType(appIdType);
                return ucWxAppletConfigEntity;
            }
        }
        catch (Exception e) {
            this.log.error("==================\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u4fe1\u606f \u5931\u8d25===========" + e.getMessage());
        }
        Optional entityOptional = this.wxAppletConfigMapper.selectByAppIdType(appIdType);
        if (!entityOptional.isPresent()) {
            this.log.info("\u4ece\u6570\u636e\u5e93\u67e5\u65b0\u5c0f\u7a0b\u5e8f\u914d\u7f6e\u4fe1\u606f \u7ed3\u679c\u4e3a\u7a7a AppIdType:{}", (Object)appIdType);
            throw new UserCenterRuntimeException(ErrorEnum.INVALID_PARAMETER);
        }
        UcWxAppletConfigEntity appletConfigEntity = (UcWxAppletConfigEntity)entityOptional.get();
        try {
            boolean set = this.redisUtil.set(key, (Object)appletConfigEntity, 86400L);
            this.log.info("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u4fe1\u606f\u7f13\u5b58 {}", (Object)set);
        }
        catch (Exception e) {
            this.log.error("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u4fe1\u606f\u7f13\u5b58 \u5931\u8d25:{}", (Throwable)e);
        }
        this.log.info("\u4ece\u6570\u636e\u5e93\u4e2d\u83b7\u53d6\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u4fe1\u606f entity:{}", (Object)JSON.toJSONString((Object)appletConfigEntity));
        return appletConfigEntity;
    }

    public String getUsercenterActionAuthKey(String accountNo, String actionName) {
        String usercenterActionAuthKey = UUIDUtils.getUUID();
        String key = actionName + "_" + accountNo;
        String value = usercenterActionAuthKey.trim().concat("_").concat(accountNo.trim());
        String cacheValue = DigestUtils.md5DigestAsHex((byte[])value.getBytes());
        this.redisUtil.set(key, (Object)cacheValue, 60L, TimeUnit.MINUTES);
        this.log.info("==getUsercenterActionAuthKey===cacheValue:{},value:{}", (Object)cacheValue, (Object)value);
        return usercenterActionAuthKey;
    }

    public void valideUsercenterActionAuthKey(String accountNo, String usercenterAuthKey, String actionName) {
        String key = actionName + "_" + accountNo;
        String value = usercenterAuthKey.trim().concat("_").concat(accountNo.trim());
        String md5Value = DigestUtils.md5DigestAsHex((byte[])value.getBytes());
        Object cacheValue = this.redisUtil.get(key);
        if (cacheValue == null || !cacheValue.equals(md5Value)) {
            this.log.info("----\u975e\u6cd5\u8bf7\u6c42---valideUsercenterActionAuthKey----md5Value:{},cacheValue:{},value:{}", new Object[]{md5Value, cacheValue, value});
            throw new UserCenterRuntimeException(ErrorEnum.INVALID_PARAMETER);
        }
    }

    protected Boolean checkAccountExist(String accountNo, Short userType, String appCode, Short accountType) {
        UcAccountEntity accountEntity = null;
        if (AccountEnums.AccountTypeEnum.CELL_PHONE.getValue().equals(accountType)) {
            accountEntity = this.ucAccountMapper.selectByUserTypeAndAppCodeAndStatusAndAccountNoOrRelatedMobileNumber(userType, appCode, AccountEnums.AccountStatusEnum.NORMAL.getValue(), accountNo);
        } else if (AccountEnums.AccountTypeEnum.EMAIL.getValue().equals(accountType)) {
            accountEntity = this.ucAccountMapper.selectByUserTypeAndAppCodeAndStatusAndEmail(userType, appCode, AccountEnums.AccountStatusEnum.NORMAL.getValue(), accountNo);
        } else {
            List list = this.ucAccountMapper.selectListByUserTypeAndAppCodeAndStatusAndAccountNoOrLoginName(userType, appCode, AccountEnums.AccountStatusEnum.NORMAL.getValue(), accountNo);
            if (list != null && list.size() > 0) {
                this.log.warn("\u8d26\u53f7\u5df2\u7ecf\u88ab\u5b58\u5728,accountNo={},userType={},appCode={},accountType:{}", new Object[]{accountNo, userType, appCode, accountType});
                return true;
            }
        }
        if (accountEntity != null) {
            this.log.warn("\u8d26\u53f7\u5df2\u7ecf\u88ab\u5b58\u5728,accountNo={},userType={},appCode={},accountType:{}", new Object[]{accountNo, userType, appCode, accountType});
            return true;
        }
        return false;
    }
}

