/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.common.enums.ErrorEnum;
import com.ebaiyihui.common.pojo.vo.addressInfo.City;
import com.ebaiyihui.common.pojo.vo.addressInfo.CreateAddressInfoReqVo;
import com.ebaiyihui.common.pojo.vo.addressInfo.DistrictInfo;
import com.ebaiyihui.common.pojo.vo.addressInfo.GetAddressInfoDetailResVo;
import com.ebaiyihui.common.pojo.vo.addressInfo.GetAddressInfoResVo;
import com.ebaiyihui.common.pojo.vo.addressInfo.Location;
import com.ebaiyihui.common.pojo.vo.addressInfo.SearchLocalReqVo;
import com.ebaiyihui.common.pojo.vo.addressInfo.SearchLocaltionResVo;
import com.ebaiyihui.common.pojo.vo.addressInfo.TxPlaceSearchRespVo;
import com.ebaiyihui.common.pojo.vo.addressInfo.UpdateAddressInfoReqVo;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.server.config.ProjProperties;
import com.ebaiyihui.server.enums.AddressEnums;
import com.ebaiyihui.server.exception.UserCenterRuntimeException;
import com.ebaiyihui.server.pojo.entity.AddressInfoEntity;
import com.ebaiyihui.server.pojo.vo.JsonResult;
import com.ebaiyihui.server.repository.AddressInfoMapper;
import com.ebaiyihui.server.service.AddressService;
import com.ebaiyihui.server.service.BaseService;
import com.ebaiyihui.server.util.HanyupinyinUtil;
import com.ebaiyihui.server.util.RestTemplateUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AddressServiceImpl
extends BaseService
implements AddressService {
    private static final Logger log = LoggerFactory.getLogger(AddressServiceImpl.class);
    @Autowired
    private AddressInfoMapper addressInfoMapper;
    @Autowired
    private ProjProperties addressProjProperties;
    private String DISTRICT_LIST = "district_list";
    private String DISTRICT_ABC_LIST = "district_abc_list";
    private static final String SERVCODE = "yyy";

    public BaseResponse<List<GetAddressInfoResVo>> getAddressListByUserId(String userId) {
        ArrayList volist = new ArrayList();
        List list = this.addressInfoMapper.getAddressListByUserId(userId);
        if (list == null || list.isEmpty()) {
            log.info("\u6839\u636e\u7528\u6237id\u67e5\u8be2\u5730\u5740\u4fe1\u606f\u5217\u8868 \u7a7a userID:{}", (Object)userId);
            return BaseResponse.success(volist);
        }
        list.forEach(addressInfoEntity -> {
            GetAddressInfoResVo getAddressInfoResVo = new GetAddressInfoResVo();
            BeanUtils.copyProperties((Object)addressInfoEntity, (Object)getAddressInfoResVo);
            volist.add(getAddressInfoResVo);
        });
        return BaseResponse.success(volist);
    }

    @Transactional
    public BaseResponse<String> addNewAddress(CreateAddressInfoReqVo vo) {
        if (AddressEnums.DefaultAddress.YES.getValue().equals(vo.getIsDefault())) {
            List addressListByUserId = this.addressInfoMapper.getAddressListByUserId(vo.getUserId());
            for (AddressInfoEntity entity : addressListByUserId) {
                if (!AddressEnums.DefaultAddress.YES.getValue().equals(entity.getIsDefault())) continue;
                entity.setIsDefault(AddressEnums.DefaultAddress.NO.getValue());
                this.addressInfoMapper.updateByPrimaryKeySelective(entity);
            }
        }
        AddressInfoEntity entity = new AddressInfoEntity();
        BeanUtils.copyProperties((Object)vo, (Object)entity);
        log.info("\u5730\u5740\u6dfb\u52a0 entity:{}", (Object)JSON.toJSONString((Object)entity));
        int i = this.addressInfoMapper.insertSelective(entity);
        return i > 0 ? BaseResponse.success() : BaseResponse.error((String)"\u5730\u5740\u6dfb\u52a0\u5931\u8d25");
    }

    public BaseResponse<List<GetAddressInfoDetailResVo>> selectByAddressIds(List<Long> addressIdList) {
        ArrayList getAddressInfoDetailResVoList = new ArrayList();
        List addressInfoEntityList = this.addressInfoMapper.selectByAddressIds(addressIdList);
        addressInfoEntityList.forEach(addressInfoEntity -> {
            GetAddressInfoDetailResVo getAddressInfoDetailResVo = new GetAddressInfoDetailResVo();
            BeanUtils.copyProperties((Object)addressInfoEntity, (Object)getAddressInfoDetailResVo);
            getAddressInfoDetailResVoList.add(getAddressInfoDetailResVo);
        });
        return BaseResponse.success(getAddressInfoDetailResVoList);
    }

    @Transactional
    public BaseResponse<String> updateAddress(UpdateAddressInfoReqVo vo) {
        AddressInfoEntity entity = this.addressInfoMapper.selectByPrimaryKey(vo.getId());
        if (null == entity) {
            log.info("\u66f4\u65b0\u5730\u5740\u5931\u8d25->\u539f\u5730\u5740\u4e0d\u5b58\u5728");
            return BaseResponse.error((String)"\u66f4\u65b0\u5730\u5740\u5931\u8d25");
        }
        if (AddressEnums.DefaultAddress.YES.getValue().equals(vo.getIsDefault())) {
            List addressListByUserId = this.addressInfoMapper.getAddressListByUserId(vo.getUserId());
            for (AddressInfoEntity entity2 : addressListByUserId) {
                if (!AddressEnums.DefaultAddress.YES.getValue().equals(entity2.getIsDefault())) continue;
                entity2.setIsDefault(AddressEnums.DefaultAddress.NO.getValue());
                this.addressInfoMapper.updateByPrimaryKeySelective(entity2);
            }
        }
        AddressInfoEntity updateEntity = new AddressInfoEntity();
        BeanUtils.copyProperties((Object)vo, (Object)updateEntity);
        log.info("\u5730\u5740\u66f4\u65b0 entity:{}", (Object)JSON.toJSONString((Object)updateEntity));
        int i = this.addressInfoMapper.updateByPrimaryKeySelective(updateEntity);
        return i > 0 ? BaseResponse.success() : BaseResponse.error((String)"\u5730\u5740\u66f4\u65b0\u5931\u8d25");
    }

    @Transactional
    public BaseResponse<String> deleteAddress(Long id) {
        AddressInfoEntity addressInfoEntity = this.addressInfoMapper.selectByPrimaryKey(id);
        if (null == addressInfoEntity) {
            log.info("\u5730\u5740\u5220\u9664--\u300b\u5730\u5740\u4e0d\u5b58\u5728 id:{}", (Object)id);
            return BaseResponse.success();
        }
        addressInfoEntity.setStatus(Short.valueOf(AddressEnums.Status.DELETE.getValue()));
        int i = this.addressInfoMapper.updateByPrimaryKeySelective(addressInfoEntity);
        return i > 0 ? BaseResponse.success() : BaseResponse.error((String)"\u5730\u5740\u5220\u9664\u5931\u8d25");
    }

    public BaseResponse<List<DistrictInfo>> getDistrictInfoList(String orderBy) {
        String[] zm;
        if (StringUtils.isNotEmpty((CharSequence)orderBy)) {
            return BaseResponse.success();
        }
        try {
            List cityList;
            Object abcList = this.redisUtil.get(this.DISTRICT_ABC_LIST);
            if (JSON.toJSONString((Object)abcList).length() > 1000) {
                log.info("\u8bf7\u6c42\u7f13\u5b58==\u4ece\u7f13\u5b58\u83b7\u53d6\u884c\u653f1 objects={}", (Object)JSON.toJSONString((Object)abcList).substring(0, 1000));
            }
            if (abcList instanceof String && null != (cityList = JSONObject.parseArray((String)((String)abcList), DistrictInfo.class)) && !cityList.isEmpty()) {
                log.info("\u8bf7\u6c42\u7f13\u5b58==\u57ce\u5e02\u5217\u88681 size:{}", (Object)cityList.size());
                return BaseResponse.success((Object)cityList);
            }
        }
        catch (Exception e) {
            log.info("\u8bf7\u6c42\u7f13\u5b58==\u5b57\u7b26\u4e32--\u9ed8\u8ba4\u6309\u7167abc\u6392\u5e8f,\u4ece\u7f13\u5b58\u83b7\u53d6\u884c\u653f\u533a\u57df\u4fe1\u606f \u5f02\u5e38==={}", (Throwable)e);
        }
        List cities = this.getDistrictListFromTencent();
        Map<String, List<City>> map = cities.stream().collect(Collectors.groupingBy(City::getFirstLetter));
        ArrayList<DistrictInfo> list = new ArrayList<DistrictInfo>();
        for (String ss : zm = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"}) {
            List<City> cityList = map.get(ss);
            DistrictInfo info = new DistrictInfo();
            info.setLetter(ss);
            info.setData(cityList);
            list.add(info);
        }
        this.cacheABCCityList(list);
        return BaseResponse.success(list);
    }

    public List<SearchLocaltionResVo> searchLocation(SearchLocalReqVo searchLocalReqVo) {
        String params;
        log.info("=====000   \u4f4d\u7f6e\u641c\u7d22 \u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)searchLocalReqVo));
        String url = this.addressProjProperties.getGdSearchUrl();
        if (searchLocalReqVo.getServCode().equals(SERVCODE)) {
            params = "?keywords={0}&output={1}&offset={2}&page={3}&key={4}&extensions={5}";
            params = MessageFormat.format(params, searchLocalReqVo.getKeywords(), "JSON", searchLocalReqVo.getOffset(), searchLocalReqVo.getPage(), this.addressProjProperties.getGdKey(), "all");
            log.info("\u9ad8\u5fb7\u641c\u7d22\u5730\u5740\u53c2\u6570params: " + params);
        } else {
            params = "?keywords={0}&city={1}&output={2}&offset={3}&page={4}&key={5}&extensions={6}&citylimit={7}";
            params = MessageFormat.format(params, searchLocalReqVo.getKeywords(), "110000", "JSON", searchLocalReqVo.getOffset(), searchLocalReqVo.getPage(), this.addressProjProperties.getGdKey(), "all", true);
            log.info("\u9ad8\u5fb7\u641c\u7d22\u4f4d\u7f6e\u53c2\u6570params: " + params);
        }
        JsonResult resquestResult = (JsonResult)this.restTemplate.getForObject(url + params, JsonResult.class, new Object[0]);
        log.info("resquestResult:{}", (Object)JSON.toJSONString((Object)resquestResult));
        List poisList = resquestResult.getPois();
        if (poisList.isEmpty()) {
            log.info("\u9ad8\u5fb7\u4f4d\u7f6e\u641c\u7d22 \u7ed3\u679c\u7a7a");
            return new ArrayList<SearchLocaltionResVo>();
        }
        log.info("=========111 txPlaceSearchRespVos:{} ", (Object)JSON.toJSONString((Object)poisList));
        String placeSeachUrl = this.addressProjProperties.getTxMapDomain().concat("/ws/place/v1/search?");
        JSONObject txParams = new JSONObject();
        String boundary = searchLocalReqVo.getLocation() == null || searchLocalReqVo.getLocation().getLatitude() == null || searchLocalReqVo.getLocation().getLongitude() == null ? "region".concat("(").concat(searchLocalReqVo.getCityName().trim()).concat(",1)") : "region".concat("(").concat(searchLocalReqVo.getCityName().trim()).concat(",1,").concat(searchLocalReqVo.getLocation().getLatitude()).concat(",").concat(searchLocalReqVo.getLocation().getLongitude()).concat(")");
        txParams.put("boundary", (Object)boundary);
        Integer offset = searchLocalReqVo.getOffset();
        txParams.put("page_size", (Object)(offset > 20 ? 20 : (offset < 1 ? 1 : offset)));
        txParams.put("page_index", (Object)(searchLocalReqVo.getPage() < 1 ? 1 : searchLocalReqVo.getPage()));
        txParams.put("keyword", (Object)searchLocalReqVo.getKeywords().replaceAll("\\|", "  "));
        txParams.put("orderby", (Object)"_distance");
        txParams.put("key", (Object)this.addressProjProperties.getTxMapKey());
        String s = RestTemplateUtils.get((String)placeSeachUrl, (JSONObject)txParams);
        if (s == null) {
            log.info("\u5730\u5740\u641c\u7d22 \u817e\u8baf\u8fd4\u56denull,url:{}======param:{}", (Object)placeSeachUrl, (Object)JSON.toJSONString((Object)txParams));
        }
        JSONObject jsonObject = JSONObject.parseObject((String)s);
        ArrayList<SearchLocaltionResVo> searchLocaltionResVoList = new ArrayList<SearchLocaltionResVo>();
        if (jsonObject != null) {
            String message = jsonObject.getString("message");
            log.info("\u5730\u5740\u641c\u7d22 \u817e\u8baf\u8fd4\u56de message:{} ", (Object)message);
            Object data = jsonObject.get((Object)"data");
            List txPlaceSearchRespVos = JSONObject.parseArray((String)JSON.toJSONString((Object)data), TxPlaceSearchRespVo.class);
            log.info("\u5730\u5740\u641c\u7d22 \u817e\u8baf\u8fd4\u56de txPlaceSearchRespVos:{} ", (Object)JSON.toJSONString((Object)txPlaceSearchRespVos));
            if (txPlaceSearchRespVos != null && !txPlaceSearchRespVos.isEmpty()) {
                txPlaceSearchRespVos.forEach(txPlaceSearch -> {
                    SearchLocaltionResVo vo = new SearchLocaltionResVo();
                    vo.setLocation(txPlaceSearch.getLocation().getLongitude() + "," + txPlaceSearch.getLocation().getLatitude());
                    vo.setName(txPlaceSearch.getTitle());
                    if (!"4".equals(txPlaceSearch.getType())) {
                        vo.setId(txPlaceSearch.getId());
                        vo.setAddress(txPlaceSearch.getAddress());
                        vo.setAdname(txPlaceSearch.getAd_info().getDistrict());
                        vo.setCityname(txPlaceSearch.getAd_info().getCity());
                        vo.setPname(txPlaceSearch.getAd_info().getProvince());
                        vo.setType(txPlaceSearch.getCategory());
                    }
                    searchLocaltionResVoList.add(vo);
                });
            }
        }
        log.info("=========222  txPlaceSearchRespVos:{} ", (Object)JSON.toJSONString(searchLocaltionResVoList));
        if (searchLocaltionResVoList.isEmpty()) {
            return poisList;
        }
        return searchLocaltionResVoList;
    }

    public BaseResponse<List<City>> searchDistrict(String keyword) {
        ArrayList cityRespVo = new ArrayList();
        try {
            List cityList;
            Object o = this.redisUtil.get(this.DISTRICT_LIST);
            if (JSON.toJSONString((Object)o).length() > 100) {
                log.info("\u8bf7\u6c42\u7f13\u5b58==\u5b57\u7b26\u4e32-----{}", (Object)JSON.toJSONString((Object)o).substring(0, 100));
            }
            if (o instanceof String && null != (cityList = JSONObject.parseArray((String)((String)o), City.class)) && !cityList.isEmpty()) {
                log.info("\u8bf7\u6c42\u7f13\u5b58==\u6839\u636e\u5173\u952e\u5b57\u641c\u7d22\u57ce\u5e021 size:{}", (Object)cityList.size());
                List collect = cityList.stream().filter(city -> city.getFullName().startsWith(keyword)).collect(Collectors.toList());
                if (JSON.toJSONString(collect).length() < 1000) {
                    log.info("\u8bf7\u6c42\u7f13\u5b58==\u6839\u636e\u5173\u952e\u5b57\u641c\u7d22\u57ce\u5e021 list:{}", (Object)JSON.toJSONString(collect));
                } else {
                    log.info("\u8bf7\u6c42\u7f13\u5b58==\u6839\u636e\u5173\u952e\u5b57\u641c\u7d22\u57ce\u5e021 list:{}", (Object)JSON.toJSONString(collect).substring(0, 1000));
                }
                collect = collect.stream().filter(city -> !city.getFullName().endsWith("\u9547") && !city.getFullName().endsWith("\u4e61") && !city.getFullName().endsWith("\u7701")).collect(Collectors.toList());
                return BaseResponse.success(collect);
            }
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u7f13\u5b58==\u6839\u636e\u5173\u952e\u5b57\u641c\u7d22\u57ce\u5e02  \u5f02\u5e38:{}", (Throwable)e);
        }
        try {
            List objects = this.redisUtil.lGet(this.DISTRICT_LIST, 0L, -1L);
            if (JSON.toJSONString((Object)objects).length() < 1000) {
                log.info("\u8bf7\u6c42\u7f13\u5b58==\u5217\u8868----{}", (Object)JSON.toJSONString((Object)objects));
            } else {
                log.info("\u8bf7\u6c42\u7f13\u5b58==\u5217\u8868----{}", (Object)JSON.toJSONString((Object)objects).substring(0, 1000));
            }
            if (null != objects && !objects.isEmpty()) {
                log.info("\u8bf7\u6c42\u7f13\u5b58==\u6839\u636e\u5173\u952e\u5b57\u641c\u7d22\u57ce\u5e022 size:{}", (Object)objects.size());
                List list = JSONObject.parseArray((String)JSON.toJSONString((Object)objects), City.class);
                if (list != null && !list.isEmpty()) {
                    List collect = list.stream().filter(city -> city.getFullName().startsWith(keyword)).collect(Collectors.toList());
                    if (JSON.toJSONString(collect).length() < 1000) {
                        log.info("\u8bf7\u6c42\u7f13\u5b58==\u6839\u636e\u5173\u952e\u5b57\u641c\u7d22\u57ce\u5e022 list:{}", (Object)JSON.toJSONString(collect));
                    } else {
                        log.info("\u8bf7\u6c42\u7f13\u5b58==\u6839\u636e\u5173\u952e\u5b57\u641c\u7d22\u57ce\u5e022 list:{}", (Object)JSON.toJSONString(collect).substring(0, 1000));
                    }
                    return BaseResponse.success(collect);
                }
            }
        }
        catch (Exception e) {
            log.info("\u8bf7\u6c42\u7f13\u5b58==\u6839\u636e\u5173\u952e\u5b57\u641c\u7d22\u57ce\u5e02\uff0c\u4ece\u7f13\u5b58\u83b7\u53d6\u884c\u653f\u533a\u57df\u4fe1\u606f \u5f02\u5e38: {}", (Throwable)e);
        }
        List cities = this.getDistrictListFromTencent();
        this.cacheCityList(cities);
        List collect = cities.stream().filter(city -> city.getFullName().startsWith(keyword)).collect(Collectors.toList());
        log.info("\u8bf7\u6c42\u817e\u8baf,\u6839\u636e\u5173\u952e\u5b57\u83b7\u53d6\u884c\u653f\u533a\u57df\u4fe1\u606f \u8fd4\u56desize:{}", (Object)collect.size());
        return BaseResponse.success(collect);
    }

    @Async
    public void cacheCityList(List<City> cities) {
        boolean set = this.redisUtil.set(this.DISTRICT_LIST, (Object)JSON.toJSONString(cities), 86400L);
        log.info("\u7f13\u5b58\u6240\u6709 \u7701\u5e02\u53bf\u533a \u57ce\u5e02\u5b57\u7b26\u4e32\u6570\u636e {}", (Object)set);
    }

    @Async
    public void cacheABCCityList(List<DistrictInfo> list) {
        boolean b3 = this.redisUtil.set(this.DISTRICT_ABC_LIST, (Object)JSON.toJSONString(list), 30L, TimeUnit.DAYS);
        log.info("\u7f13\u5b58\u6240\u6709ABC\u5206\u7c7b\u7684\u57ce\u5e02\u6570\u636e b3={}", (Object)b3);
    }

    public List<City> getDistrictListFromTencent() {
        JSONObject param = new JSONObject();
        param.put("key", (Object)this.addressProjProperties.getTxMapKey());
        log.info("\u8bf7\u6c42\u817e\u8baf\u83b7\u53d6\u884c\u653f\u533a\u57df\u4fe1\u606f \u8bf7\u6c42 tencentMapUrl:{},param:{}", (Object)this.addressProjProperties.getTxMapDistrictUrl(), (Object)JSON.toJSONString((Object)param));
        String result = RestTemplateUtils.get((String)this.addressProjProperties.getTxMapDistrictUrl(), (JSONObject)param);
        if (result == null) {
            log.info("\u8bf7\u6c42\u817e\u8baf\u83b7\u53d6\u884c\u653f\u533a\u57df\u4fe1\u606f result\u8fd4\u56denull");
            throw new UserCenterRuntimeException(ErrorEnum.SYSTEM_ERROR, "\u8bf7\u6c42\u817e\u8baf\u83b7\u53d6\u884c\u653f\u533a\u57df\u4fe1\u606f\u5931\u8d25");
        }
        JSONObject json = JSON.parseObject((String)result);
        String resultObj = json.getString("result");
        String message = json.getString("message");
        log.info("\u8bf7\u6c42\u817e\u8baf\u83b7\u53d6\u884c\u653f\u533a\u57df\u4fe1\u606f \u7ed3\u679c message:{}", (Object)message);
        if (resultObj == null) {
            log.info("\u8bf7\u6c42\u817e\u8baf\u83b7\u53d6\u884c\u653f\u533a\u57df\u4fe1\u606f resultObj\u8fd4\u56denull");
            throw new UserCenterRuntimeException(ErrorEnum.SYSTEM_ERROR, "\u8bf7\u6c42\u817e\u8baf\u83b7\u53d6\u884c\u653f\u533a\u57df\u4fe1\u606f\u5931\u8d25");
        }
        List lists = JSON.parseArray((String)resultObj, List.class);
        ArrayList<City> cities = new ArrayList<City>();
        for (List list : lists) {
            for (Object o1 : list) {
                String s1 = JSON.toJSONString(o1);
                City city = (City)JSON.parseObject((String)s1, City.class);
                JSONObject object = JSON.parseObject((String)s1);
                String locationStr = object.getString("location");
                JSONObject locationStrObj = JSON.parseObject((String)locationStr);
                Location location = new Location();
                location.setLatitude(locationStrObj.getString("lat"));
                location.setLongitude(locationStrObj.getString("lng"));
                city.setLocation(location);
                log.info("---------city-" + JSON.toJSONString((Object)city));
                if (city.getFullName().endsWith("\u9547") || city.getFullName().endsWith("\u4e61") || city.getFullName().endsWith("\u7701")) continue;
                city.setCityName(city.getCityName() == null ? city.getFullName() : city.getCityName());
                city.setPinyin(HanyupinyinUtil.getPinyinString((String)city.getCityName()));
                city.setFirstLetter(HanyupinyinUtil.getFirstLetter((String)city.getFullName()));
                cities.add(city);
            }
        }
        return cities;
    }

    public BaseResponse<GetAddressInfoDetailResVo> getAddressDetailByAddressId(Long addressId) {
        GetAddressInfoDetailResVo resVo = new GetAddressInfoDetailResVo();
        AddressInfoEntity entity = this.addressInfoMapper.selectById(addressId);
        if (entity == null) {
            log.info("\u6839\u636eid\u67e5\u5730\u5740\u4fe1\u606f \u5730\u5740\u4e3a\u7a7a  id:{}", (Object)addressId);
            return BaseResponse.success((Object)resVo);
        }
        BeanUtils.copyProperties((Object)entity, (Object)resVo);
        log.info("\u6839\u636eid\u67e5\u5730\u5740\u4fe1\u606f id:{},\u8fd4\u56de{}", (Object)addressId, (Object)JSON.toJSONString((Object)resVo));
        return BaseResponse.success((Object)resVo);
    }
}

