/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.card.client.ICardHospitalFeignClient;
import com.ebaiyihui.card.client.ICardServiceFeginClient;
import com.ebaiyihui.card.client.PatientServiceClient;
import com.ebaiyihui.card.common.vo.CardDetailsInfoReqVO;
import com.ebaiyihui.card.common.vo.CardDetailsInfoRespVO;
import com.ebaiyihui.card.common.vo.OrganConfigReqVO;
import com.ebaiyihui.card.common.vo.OrganConfigRespVO;
import com.ebaiyihui.card.common.vo.RegisterCardReqVO;
import com.ebaiyihui.card.common.vo.UpdateCardInfoReqVO;
import com.ebaiyihui.common.enums.ErrorEnum;
import com.ebaiyihui.common.pojo.vo.BaseReqVO;
import com.ebaiyihui.common.pojo.vo.card.CardDetailQueryReqVO;
import com.ebaiyihui.common.pojo.vo.card.CardDetailReqVo;
import com.ebaiyihui.common.pojo.vo.card.CardDetailRespVO;
import com.ebaiyihui.common.pojo.vo.card.CardListQueryReqVO;
import com.ebaiyihui.common.pojo.vo.card.CardListRespVO;
import com.ebaiyihui.common.pojo.vo.card.OrganBindCountRespVO;
import com.ebaiyihui.common.pojo.vo.card.OrganCodeListReqVO;
import com.ebaiyihui.common.pojo.vo.card.UcBindCardReqVO;
import com.ebaiyihui.common.pojo.vo.card.UcCardListReqVO;
import com.ebaiyihui.common.pojo.vo.card.UcRegisterCardReqVO;
import com.ebaiyihui.common.pojo.vo.card.UnbindCardReqVO;
import com.ebaiyihui.common.pojo.vo.card.UnbindCardRespVO;
import com.ebaiyihui.common.pojo.vo.card.UpdateCardInfoVO;
import com.ebaiyihui.common.pojo.vo.card.UserCardListRespVO;
import com.ebaiyihui.common.pojo.vo.card.UserPatientListRespVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import com.ebaiyihui.framework.utils.IdCardUtil;
import com.ebaiyihui.framework.utils.JsonUtil;
import com.ebaiyihui.server.enums.CardEnums;
import com.ebaiyihui.server.enums.UserEnums;
import com.ebaiyihui.server.exception.UserCenterRuntimeException;
import com.ebaiyihui.server.pojo.bo.ExcelData;
import com.ebaiyihui.server.pojo.bo.OrganBindCountBO;
import com.ebaiyihui.server.pojo.entity.UcAccountEntity;
import com.ebaiyihui.server.pojo.entity.UcCardBindLogEntity;
import com.ebaiyihui.server.pojo.entity.UcPatientInfoEntity;
import com.ebaiyihui.server.pojo.entity.UcUserCardBindEntity;
import com.ebaiyihui.server.repository.UcAccountMapper;
import com.ebaiyihui.server.service.BaseService;
import com.ebaiyihui.server.service.ICardBindService;
import com.ebaiyihui.server.service.ICardHospitalService;
import com.ebaiyihui.server.util.DateUtils;
import com.ebaiyihui.server.util.SensitiveInfoUtils;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class CardBindServiceImpl
extends BaseService
implements ICardBindService {
    @Autowired
    private ICardServiceFeginClient cardServiceFeginClient;
    @Autowired
    private PatientServiceClient patientServiceClient;
    @Autowired
    private ICardHospitalFeignClient cardHospitaFeignClient;
    @Autowired
    private ICardHospitalService cardHospitaService;
    @Autowired
    private MessageSource messageSource;
    private static String ID_CARD_CODE = "01";
    private static String HOUSEHOLD_CARD_CODE = "09";
    @Autowired
    private UcAccountMapper cardUcAccountMapper;

    public BaseResponse<List<OrganBindCountRespVO>> getBindCount(OrganCodeListReqVO organCodeListReqVo) {
        ArrayList<OrganBindCountRespVO> organBindCountRespList = new ArrayList<OrganBindCountRespVO>();
        List organList = organCodeListReqVo.getOrganCodeReqVO();
        List cardCountlist = this.cardBindMapper.getCardCount(organList, organCodeListReqVo.getUserId(), CardEnums.CardBindStatus.BIND);
        HashMap<String, Long> cardCountMap = new HashMap<String, Long>();
        for (OrganBindCountBO organBindCountBo : cardCountlist) {
            cardCountMap.put(organBindCountBo.getOrganCode(), organBindCountBo.getBindCount());
        }
        for (String organCode : organList) {
            OrganBindCountRespVO organBindCountRespVO = new OrganBindCountRespVO();
            organBindCountRespVO.setOrganCode(organCode);
            if (cardCountMap.containsKey(organCode)) {
                organBindCountRespVO.setCount((Long)cardCountMap.get(organCode));
            } else {
                organBindCountRespVO.setCount(Long.valueOf(0L));
            }
            organBindCountRespList.add(organBindCountRespVO);
        }
        return BaseResponse.success(organBindCountRespList);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<UnbindCardRespVO> unbindCard(UnbindCardReqVO reqVo) {
        this.log.info("\u89e3\u7ed1\u5c31\u8bca\u5361\u8bf7\u6c42\u53c2\u6570={}", (Object)JsonUtil.convertObject((Object)reqVo));
        UcUserCardBindEntity userBind = this.cardBindMapper.findOneByUserIdAndCardId(reqVo.getUserId(), reqVo.getCardId());
        if (userBind != null) {
            UnbindCardRespVO data = new UnbindCardRespVO(reqVo);
            if (CardEnums.CardBindStatus.BIND.equals((Object)userBind.getBindStatus())) {
                OrganConfigReqVO organConfigReq = new OrganConfigReqVO(userBind.getOrganCode(), reqVo.getChannelCode());
                BaseResponse hospitalResp = this.cardHospitaFeignClient.getOrganConfig(organConfigReq);
                if (!hospitalResp.isSuccess()) {
                    this.log.warn("\u83b7\u53d6\u5c31\u8bca\u5361\u6240\u5c5e\u673a\u6784\u4fe1\u606f\u5931\u8d25,organCode={},\u54cd\u5e94={}", (Object)userBind.getOrganCode(), (Object)JsonUtil.convertObject((Object)hospitalResp));
                    return BaseResponse.error((IError)IError.FEIGN_FAIL, (String)hospitalResp.getMsg());
                }
                this.unbindCard(userBind, (OrganConfigRespVO)hospitalResp.getData());
                userBind.setUnbindReason(reqVo.getUnbindReason());
                this.cardBindMapper.save(userBind);
                UcCardBindLogEntity unbindLong = new UcCardBindLogEntity(reqVo.getAccountId(), reqVo.getCardId(), CardEnums.CardBindStatus.UNBIND, userBind.getId(), reqVo.getOperateUser());
                this.log.info("\u7ed1\u5361\u65e5\u5fd7\u4fdd\u5b58\u5bf9\u8c61,unbindLong = {}", (Object)unbindLong);
                this.cardBindLogMapper.save(unbindLong);
            }
            return BaseResponse.success((Object)data);
        }
        return BaseResponse.error((IError)ErrorEnum.BIND_CARD_NOT_EXIST);
    }

    public BaseResponse<CardDetailRespVO> getCardDetail(CardDetailQueryReqVO cardDetailQueryReqVO) {
        this.log.info("\u67e5\u8be2\u5361\u8be6\u60c5\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)cardDetailQueryReqVO));
        UcUserCardBindEntity ucUserCardBindEntity = this.cardBindMapper.findByBindStatusAndCardId(CardEnums.CardBindStatus.BIND, cardDetailQueryReqVO.getCardId(), cardDetailQueryReqVO.getUserId());
        this.log.info("\u83b7\u53d6\u8be6\u60c5\u5b9e\u4f53\u8fd4\u56de\u503c{}", (Object)JsonUtil.convertObject((Object)ucUserCardBindEntity));
        if (ucUserCardBindEntity == null) {
            this.log.warn("\u672a\u67e5\u8be2\u5230\u5361\u7ed1\u5b9a\u8be6\u60c5\uff0ccardId = {}", (Object)cardDetailQueryReqVO.getCardId());
            return BaseResponse.error((IError)IError.DATA_NOT_EXIST, (String)"\u672a\u67e5\u8be2\u5230\u5361\u7ed1\u5b9a\u8be6\u60c5!");
        }
        BaseResponse data = this.getCardDetailsInfoRespVOFromCardService(cardDetailQueryReqVO);
        if (!data.isSuccess()) {
            this.log.warn("\u672a\u4ece\u5c31\u8bca\u5361\u4e2d\u5fc3\u67e5\u8be2\u5230\u5361\u57fa\u7840\u4fe1\u606f\uff01");
            return BaseResponse.error((IError)IError.DATA_NOT_EXIST, (String)"\u672a\u4ece\u5c31\u8bca\u5361\u4e2d\u5fc3\u67e5\u8be2\u5230\u5361\u57fa\u7840\u4fe1\u606f\uff01");
        }
        CardDetailRespVO cardDetailRespVO = this.buildCardDetail((CardDetailsInfoRespVO)data.getData(), ucUserCardBindEntity, (BaseReqVO)cardDetailQueryReqVO);
        this.log.info("\u83b7\u53d6\u8be6\u60c5\u7ec4\u88c5\u8fd4\u56de\u503c{}", (Object)JsonUtil.convertObject((Object)cardDetailRespVO));
        return BaseResponse.success((Object)cardDetailRespVO);
    }

    public BaseResponse<CardDetailRespVO> getByCardNo(CardDetailReqVo cardDetailReqVo) {
        UcUserCardBindEntity ucUserCardBindEntity = this.cardBindMapper.findByBindStatusAndCardNo(cardDetailReqVo.getCardNo(), cardDetailReqVo.getUserId());
        if (null == ucUserCardBindEntity) {
            return BaseResponse.error((IError)IError.DATA_NOT_EXIST, (String)"\u672a\u67e5\u8be2\u5230\u5361\u7ed1\u5b9a\u8be6\u60c5!");
        }
        this.log.info("\u83b7\u53d6\u8be6\u60c5\u5b9e\u4f53\u8fd4\u56de\u503c{}", (Object)JsonUtil.convertObject((Object)ucUserCardBindEntity));
        CardDetailRespVO cardDetailRespVO = new CardDetailRespVO();
        BeanUtils.copyProperties((Object)ucUserCardBindEntity, (Object)cardDetailRespVO);
        this.log.info("cardDetailRespVO\u503c\u4e3a{}:", (Object)JSON.toJSONString((Object)cardDetailRespVO));
        return BaseResponse.success((Object)cardDetailRespVO);
    }

    private void DetailBySen(CardDetailRespVO cardDetailRespVO) {
        String credNo;
        String tel;
        String cardNo;
        String accountNo = cardDetailRespVO.getAccountNo();
        if (StringUtils.isNotEmpty((CharSequence)accountNo)) {
            cardDetailRespVO.setAccountNo(SensitiveInfoUtils.mobilePhone((String)accountNo));
        }
        if (StringUtils.isNotEmpty((CharSequence)(cardNo = cardDetailRespVO.getCardNo()))) {
            cardDetailRespVO.setCardNo(SensitiveInfoUtils.cnapsCode((String)cardNo));
        }
        if (StringUtils.isNotEmpty((CharSequence)(tel = cardDetailRespVO.getTel()))) {
            cardDetailRespVO.setTel(SensitiveInfoUtils.mobilePhone((String)tel));
        }
        if (StringUtils.isNotEmpty((CharSequence)(credNo = cardDetailRespVO.getCredNo()))) {
            cardDetailRespVO.setCredNo(SensitiveInfoUtils.idCard((String)credNo));
        }
    }

    public BaseResponse<Map<String, Object>> getCardList(CardListQueryReqVO cardListQueryReqVO) {
        UcAccountEntity ucAccountEntity;
        if (StringUtils.isNotBlank((CharSequence)cardListQueryReqVO.getSearchParam()) && null != (ucAccountEntity = this.cardUcAccountMapper.selectByAccountNO(cardListQueryReqVO.getSearchParam())) && StringUtils.isNotEmpty((CharSequence)ucAccountEntity.getUserId())) {
            cardListQueryReqVO.setSearchParam(ucAccountEntity.getUserId());
        }
        PageHelper.startPage((int)cardListQueryReqVO.getPageNum(), (int)cardListQueryReqVO.getPageSize());
        Page byStatus = this.cardBindMapper.findByStatus(CardEnums.CardBindStatus.BIND, cardListQueryReqVO.getCardTypeCode(), cardListQueryReqVO.getOrganCode(), cardListQueryReqVO.getStartTime(), cardListQueryReqVO.getEndTime(), cardListQueryReqVO.getSearchParam(), cardListQueryReqVO.getAppCode());
        if (byStatus.size() > 0) {
            for (CardListRespVO cardListRespVO : byStatus) {
                CardDetailsInfoReqVO cardStatusReqVO = new CardDetailsInfoReqVO();
                cardStatusReqVO.setCardId(cardListRespVO.getCardId());
                BaseResponse cardStatusFromCardService = this.getCardStatusFromCardService(cardStatusReqVO);
                if (null != cardStatusFromCardService.getData()) {
                    this.buildCardListRespVO(cardListRespVO, (CardDetailsInfoRespVO)cardStatusFromCardService.getData());
                } else {
                    this.log.info("\u7efc\u5408\u7ba1\u7406\u5e73\u53f0\u83b7\u53d6\u5217\u8868\u6570\u636e\u5f02\u5e38\uff0c\u672a\u67e5\u8be2\u5230\u5361\u8be6\u7ec6\uff1a{}", (Object)JsonUtil.convertObject((Object)cardStatusReqVO));
                }
                this.CardListBySen(cardListRespVO);
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("total", byStatus.getTotal());
        map.put("pageData", byStatus.getResult());
        map.put("pages", byStatus.getPages());
        map.put("data", byStatus);
        List byStatusPatientNum = this.cardBindMapper.findByStatusPatientNum(CardEnums.CardBindStatus.BIND, cardListQueryReqVO.getCardTypeCode(), cardListQueryReqVO.getOrganCode(), cardListQueryReqVO.getStartTime(), cardListQueryReqVO.getEndTime(), cardListQueryReqVO.getSearchParam(), cardListQueryReqVO.getAppCode());
        if (null != byStatusPatientNum && byStatusPatientNum.size() > 0) {
            map.put("patientTotal", byStatusPatientNum.size());
        } else {
            map.put("patientTotal", 0);
        }
        return BaseResponse.success(map);
    }

    private void CardListBySen(CardListRespVO cardListRespVO) {
        String cardNo;
        String credNo;
        String accountNo;
        String tel = cardListRespVO.getTel();
        if (StringUtils.isNotEmpty((CharSequence)tel)) {
            cardListRespVO.setTel(SensitiveInfoUtils.mobilePhone((String)tel));
        }
        if (StringUtils.isNotEmpty((CharSequence)(accountNo = cardListRespVO.getAccountNo()))) {
            cardListRespVO.setAccountNo(SensitiveInfoUtils.mobilePhone((String)accountNo));
        }
        if (StringUtils.isNotEmpty((CharSequence)(credNo = cardListRespVO.getCredNo()))) {
            cardListRespVO.setCredNo(SensitiveInfoUtils.idCard((String)credNo));
        }
        if (StringUtils.isNotEmpty((CharSequence)(cardNo = cardListRespVO.getCardNo()))) {
            cardListRespVO.setCardNo(SensitiveInfoUtils.cnapsCode((String)cardNo));
        }
    }

    private void checkFivePatients(String userId, String credNo) {
        HashSet<String> credNos = new HashSet<String>();
        List byUserId = this.cardBindMapper.findByUserId(userId, CardEnums.CardBindStatus.BIND);
        for (UcUserCardBindEntity uucbe : byUserId) {
            CardDetailRespVO data;
            CardDetailQueryReqVO cardDetailQueryReqVO = new CardDetailQueryReqVO();
            cardDetailQueryReqVO.setCardId(uucbe.getCardId());
            cardDetailQueryReqVO.setUserId(userId);
            BaseResponse cardDetail = this.getCardDetail(cardDetailQueryReqVO);
            if (!cardDetail.isSuccess() || null == (data = (CardDetailRespVO)cardDetail.getData())) continue;
            credNos.add(data.getCredNo());
        }
        this.log.info("\u6821\u9a8c5\u4e2a\u4eba\u8eab\u4efd\u8bc1\u53f7[{}]", (Object)((Object)credNos).toString());
        if (credNos.size() >= 5 && !credNos.contains(credNo)) {
            throw new UserCenterRuntimeException(ErrorEnum.CARD_BIND_FULL);
        }
    }

    private void virualCardReq(UcRegisterCardReqVO reqVo) {
        if ("1703".equals(reqVo.getCardTypeCode())) {
            reqVo.setOrganCode("10000000");
            reqVo.setOrganName("\u4f70\u533b\u5e73\u53f0");
        }
    }

    private void checkCardNo(BaseResponse<CardDetailsInfoRespVO> registerCardResp, String cardTypeCode) {
        List byCardNo;
        if (registerCardResp.isSuccess() && null != registerCardResp.getData() && !"1703".equals(cardTypeCode) && null != (byCardNo = this.cardBindMapper.findByCardNo(((CardDetailsInfoRespVO)registerCardResp.getData()).getCardNo(), CardEnums.CardBindStatus.BIND)) && byCardNo.size() > 0) {
            throw new UserCenterRuntimeException(ErrorEnum.PATIENT_ALREADY_BIND);
        }
    }

    private boolean getuserIdByAccountNo(UcRegisterCardReqVO reqVo) {
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getAccountNo()) && StringUtils.isEmpty((CharSequence)reqVo.getUserId())) {
            UcAccountEntity ucAccountEntity = this.cardUcAccountMapper.selectByAccountNO(reqVo.getAccountNo());
            if (null != ucAccountEntity) {
                reqVo.setUserId(ucAccountEntity.getUserId());
                reqVo.setAccountId(ucAccountEntity.getAccountId());
            } else {
                return true;
            }
        }
        return false;
    }

    public BaseResponse<List<UserPatientListRespVO>> getUserCardList(UcCardListReqVO reqVo) {
        this.log.info("\u83b7\u53d6\u5361\u5217\u8868\u5165\u53c2\uff1a{}", (Object)JsonUtil.convertObject((Object)reqVo));
        List organCodes = null;
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getOrganCode())) {
            organCodes = this.getOrganCodes(reqVo);
        }
        this.log.info("\u83b7\u53d6\u5361\u5217\u8868organCodes\uff1a{}", (Object)organCodes);
        List byUserIdAndOrganCode = this.cardBindMapper.findByUserIdAndOrganCode(reqVo.getUserId(), organCodes, CardEnums.CardBindStatus.BIND);
        if (null != byUserIdAndOrganCode && byUserIdAndOrganCode.size() > 0) {
            for (UserPatientListRespVO userPatientListRespVO : byUserIdAndOrganCode) {
                UserCardListRespVO userCardListRespVO;
                List byUserIdAndOrganCodeAndBindStatus = this.cardBindMapper.findByUserIdAndOrganCodeAndBindStatus(reqVo.getUserId(), organCodes, userPatientListRespVO.getPatientId(), CardEnums.CardBindStatus.BIND, userPatientListRespVO.getPatientName());
                if (null == byUserIdAndOrganCodeAndBindStatus) continue;
                userPatientListRespVO.setUserCardListRespVOS(byUserIdAndOrganCodeAndBindStatus);
                Optional<UserCardListRespVO> optional = byUserIdAndOrganCodeAndBindStatus.stream().max(Comparator.comparing(UserCardListRespVO::getUpdateTime));
                if (!optional.isPresent() || null == (userCardListRespVO = optional.get()).getRelation()) continue;
                String userRelationDesc = UserEnums.UserRelationEnum.getEnumByCode((short)userCardListRespVO.getRelation()).getUserRelationDesc();
                userPatientListRespVO.setRelation(userRelationDesc);
            }
        }
        return BaseResponse.success((Object)byUserIdAndOrganCode);
    }

    private List<String> getOrganCodes(UcCardListReqVO reqVo) {
        Boolean hospitalStatus = false;
        OrganConfigReqVO organConfigReqVO = new OrganConfigReqVO();
        organConfigReqVO.setOrganCode(reqVo.getOrganCode());
        organConfigReqVO.setChannelCode(reqVo.getChannelCode());
        BaseResponse organConfig = this.cardHospitaFeignClient.getOrganConfig(organConfigReqVO);
        this.log.info("\u83b7\u53d6\u7ed3\u6784\u4fe1\u606f\uff1a{}", (Object)JsonUtil.convertObject((Object)organConfig));
        Integer status = 1;
        if (null != organConfig.getData() && status.equals(((OrganConfigRespVO)organConfig.getData()).getStatus())) {
            hospitalStatus = true;
        }
        ArrayList<String> organCodes = new ArrayList<String>();
        if (hospitalStatus.booleanValue() && "1".equals(reqVo.getCardType())) {
            organCodes.add(reqVo.getOrganCode());
        } else {
            organCodes.add(reqVo.getOrganCode());
            organCodes.add("10000000");
        }
        return organCodes;
    }

    public BaseResponse updateCardInfo(UpdateCardInfoVO reqVO) {
        int i = this.cardBindMapper.updateByUserIdAndCardId(reqVO.getUserId(), reqVO.getCardId(), reqVO.getRelation(), reqVO.getFaceRecognition(), reqVO.getGuardianName(), reqVO.getGuardianTel(), reqVO.getGuardianCredNo());
        UpdateCardInfoReqVO updateCardInfoReqVO = new UpdateCardInfoReqVO();
        BeanUtils.copyProperties((Object)reqVO, (Object)updateCardInfoReqVO);
        BaseResponse cardDetailsInfoRespVOBaseResponse = this.cardServiceFeginClient.updateCardInfo(updateCardInfoReqVO);
        if (cardDetailsInfoRespVOBaseResponse.isSuccess()) {
            return BaseResponse.success();
        }
        return BaseResponse.error((String)"fail!");
    }

    public BaseResponse<List<String>> getUserList(String patientId) {
        return BaseResponse.success((Object)this.cardBindMapper.getUserList(patientId));
    }

    public ExcelData cardExcel(CardListQueryReqVO reqVo) {
        BaseResponse cardList = this.getCardList(reqVo);
        Page data = (Page)((Map)cardList.getData()).get("data");
        ExcelData excelData = new ExcelData();
        excelData.setName("\u5361\u5217\u8868");
        excelData.setRows(this.doctorToExcel((List)data));
        excelData.setTitles(this.doctorTitle());
        return excelData;
    }

    public BaseResponse<CardDetailRespVO> registerOrBindCard(UcRegisterCardReqVO reqVo) {
        this.virualCardReq(reqVo);
        if (this.getuserIdByAccountNo(reqVo)) {
            return BaseResponse.error((IError)ErrorEnum.NO_BIND_ACCOUNT, (String)"\u7ed1\u5b9a\u8d26\u53f7\u4e0d\u5b58\u5728\uff01");
        }
        this.log.info("\u65e0\u5361\u6ce8\u518c\u6216\u7ed1\u5b9a\u5165\u53c2:{}", (Object)JsonUtil.convertObject((Object)reqVo));
        UcAccountEntity ucAccountEntity = this.cardUcAccountMapper.selectByUserId(reqVo.getUserId());
        if (null == ucAccountEntity) {
            return BaseResponse.error((String)"\u8be5\u60a3\u8005userId\u4e0d\u5b58\u5728");
        }
        this.checkRegisterCredParams(reqVo);
        this.checkFivePatients(reqVo.getUserId(), reqVo.getCredNo());
        this.checkUserCanBindCard(reqVo.getUserId(), reqVo.getOrganCode(), reqVo.getChannelCode());
        RegisterCardReqVO reqVO = this.buildregisterCardVO(reqVo);
        this.log.info("\u65e0\u5361\u6ce8\u518c\u6216\u7ed1\u5b9a\u8c03\u7528\u5361\u670d\u52a1\u5165\u53c2:{}", (Object)JsonUtil.convertObject((Object)reqVO));
        BaseResponse registerCardResp = this.cardServiceFeginClient.registerOrBindCard(reqVO);
        this.log.info("\u65e0\u5361\u6ce8\u518c\u6216\u7ed1\u5b9a\u8c03\u7528\u5361\u670d\u52a1\u8fd4\u56de\u503c:{}", (Object)JsonUtil.convertObject((Object)registerCardResp));
        this.checkCardNo(registerCardResp, reqVo.getCardTypeCode());
        return this.handleCardResp((UcBindCardReqVO)reqVo, registerCardResp, CardEnums.CardSignType.OTHER);
    }

    public BaseResponse bindCardList(UcRegisterCardReqVO reqVo) {
        block4: {
            RegisterCardReqVO reqVO = this.buildregisterCardVO(reqVo);
            this.log.info("\u4e2d\u65e5\u7ed1\u5b9a\u5361\u96c6\u5408\u8c03\u7528\u5361\u670d\u52a1\u5165\u53c2:{}", (Object)JsonUtil.convertObject((Object)reqVO));
            try {
                BaseResponse listBaseResponse = this.cardServiceFeginClient.bindListCard(reqVO);
                this.log.info("\u4e2d\u65e5\u7ed1\u5b9a\u5361\u96c6\u5408\u8c03\u7528\u5361\u670d\u52a1\u8fd4\u56de\u503c:{}", (Object)JsonUtil.convertObject((Object)listBaseResponse));
                if (listBaseResponse.isSuccess()) {
                    List data = (List)listBaseResponse.getData();
                    String s = this.handleCardResp((UcBindCardReqVO)reqVo, data, CardEnums.CardSignType.OTHER);
                    if (s != null) {
                        return new BaseResponse("-2", "\u91cd\u590d\u7ed1\u5361", (Object)s);
                    }
                    break block4;
                }
                return new BaseResponse("-1", listBaseResponse.getMsg(), null);
            }
            catch (Exception e) {
                this.log.error("bindCardList error ,e=", (Throwable)e);
                return BaseResponse.error((String)"bindCardList error");
            }
        }
        return BaseResponse.success();
    }

    public BaseResponse hyBindCardList(UcRegisterCardReqVO reqVo) {
        block4: {
            RegisterCardReqVO reqVO = this.buildregisterCardVO(reqVo);
            this.log.info("\u822a\u5929\u4e2d\u5fc3\u533b\u9662\u7ed1\u5b9a\u5361\u96c6\u5408\u8c03\u7528\u5361\u670d\u52a1\u5165\u53c2:{}", (Object)JsonUtil.convertObject((Object)reqVO));
            try {
                BaseResponse listBaseResponse = this.cardServiceFeginClient.hyNewbindListCard(reqVO);
                this.log.info("\u822a\u5929\u4e2d\u5fc3\u533b\u9662\u7ed1\u5b9a\u5361\u96c6\u5408\u8c03\u7528\u5361\u670d\u52a1\u8fd4\u56de\u503c:{}", (Object)JsonUtil.convertObject((Object)listBaseResponse));
                if (listBaseResponse.isSuccess()) {
                    List data = (List)listBaseResponse.getData();
                    String s = this.handleCardResp((UcBindCardReqVO)reqVo, data, CardEnums.CardSignType.OTHER);
                    if (s != null) {
                        return new BaseResponse("-2", "\u91cd\u590d\u7ed1\u5361", (Object)s);
                    }
                    break block4;
                }
                return new BaseResponse("-1", listBaseResponse.getMsg(), null);
            }
            catch (Exception e) {
                this.log.error("hyBindCardList error ,e=", (Throwable)e);
                return BaseResponse.error((String)"\u533b\u4fdd\u7cfb\u7edf\u5f02\u5e38\uff0c\u6682\u65f6\u65e0\u6cd5\u7ed1\u5361\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d");
            }
        }
        return BaseResponse.success();
    }

    private String handleCardResp(UcBindCardReqVO reqVo, List<CardDetailsInfoRespVO> result, CardEnums.CardSignType cardSignType) {
        for (CardDetailsInfoRespVO cardDetailsInfo : result) {
            UcUserCardBindEntity userCardBindOp = this.cardBindMapper.selectBindByCardId(cardDetailsInfo.getCardId());
            if (userCardBindOp != null && userCardBindOp.getBindStatus().equals((Object)CardEnums.CardBindStatus.BIND)) {
                return cardDetailsInfo.getTel();
            }
            if (userCardBindOp != null && userCardBindOp.getBindStatus().equals((Object)CardEnums.CardBindStatus.UNBIND)) {
                cardDetailsInfo.setTel(reqVo.getTel());
                userCardBindOp.setUserId(reqVo.getUserId());
                userCardBindOp.setOrganCode(reqVo.getOrganCode());
                userCardBindOp.setOrganName(reqVo.getOrganName());
            }
            UcUserCardBindEntity userCardBind = this.updateBindInfo(reqVo, cardDetailsInfo, userCardBindOp);
            userCardBind.setSignType(cardSignType);
            userCardBind.setFaceRecognition(reqVo.getFaceRecognition());
            userCardBind.setRelationImg(reqVo.getRelationImg());
            userCardBind.setGuardianTel(reqVo.getGuardianTel());
            userCardBind.setGuardianName(reqVo.getGuardianName());
            userCardBind.setGuardianCredNo(reqVo.getGuardianCredNo());
            this.cardBindMapper.save(userCardBind);
            UcCardBindLogEntity bindLog = new UcCardBindLogEntity(reqVo.getAccountId(), userCardBind.getCardId(), CardEnums.CardBindStatus.BIND, userCardBind.getId(), reqVo.getOperateUser());
            this.cardBindLogMapper.save(bindLog);
            UcPatientInfoEntity ucPatientInfoEntity = new UcPatientInfoEntity();
            ucPatientInfoEntity.setPatientId(userCardBind.getPatientId());
            ucPatientInfoEntity.setUserId(userCardBind.getUserId());
            ucPatientInfoEntity.setUserRelation(Short.valueOf((short)userCardBind.getRelation().ordinal()));
            ucPatientInfoEntity.setPatientInfoStatus(Short.valueOf("0"));
            ucPatientInfoEntity.setUpdateTime(new Date());
            UcPatientInfoEntity upife = this.ucPatientInfoMapper.selectByPatientIdAndUserId(ucPatientInfoEntity.getPatientId(), ucPatientInfoEntity.getUserId());
            if (null != upife) {
                ucPatientInfoEntity.setId(upife.getId());
            } else {
                ucPatientInfoEntity.setCreateTime(new Date());
            }
            this.ucPatientInfoMapper.save(ucPatientInfoEntity);
        }
        this.log.info("saveOrUpdate card info!!");
        this.cardServiceFeginClient.saveOrUpdate(result);
        return null;
    }

    private List<List<Object>> doctorToExcel(List<CardListRespVO> listVos) {
        ArrayList<List<Object>> result = new ArrayList<List<Object>>();
        for (CardListRespVO vo : listVos) {
            result.add(this.doctorRow(vo));
        }
        return result;
    }

    private List<Object> doctorRow(CardListRespVO vo) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(vo.getPatientId());
        result.add(vo.getPatientName());
        result.add(vo.getCredTypeName());
        result.add(vo.getCredNo());
        if (Objects.isNull(vo.getGender())) {
            result.add("\u672a\u77e5");
        } else if (vo.getGender() == 1) {
            result.add("\u7537");
        } else if (vo.getGender() == 2) {
            result.add("\u5973");
        } else {
            result.add("\u672a\u77e5");
        }
        result.add(Objects.isNull(vo.getBirthdate()) ? "" : formatter.format(vo.getBirthdate()));
        result.add(vo.getTel());
        result.add(vo.getCardTypeName());
        result.add(vo.getCardNo());
        result.add(vo.getOrganName());
        result.add(vo.getAccountNo());
        result.add(Objects.isNull(vo.getBindTime()) ? "" : formatter.format(vo.getBindTime()));
        return result;
    }

    private List<String> doctorTitle() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("\u60a3\u8005id");
        result.add("\u59d3\u540d");
        result.add("\u8bc1\u4ef6\u7c7b\u578b");
        result.add("\u8bc1\u4ef6\u53f7");
        result.add("\u6027\u522b");
        result.add("\u51fa\u751f\u5e74\u6708\u65e5");
        result.add("\u8054\u7cfb\u7535\u8bdd");
        result.add("\u5c31\u8bca\u5361\u7c7b\u578b");
        result.add("\u5c31\u8bca\u5361\u53f7");
        result.add("\u6240\u5c5e\u533b\u9662");
        result.add("\u7ed1\u5b9a\u8d26\u53f7");
        result.add("\u7ed1\u5b9a\u65f6\u95f4");
        return result;
    }

    private void checkUserCanBindCard(String userId, String organCode, String channelCode) {
        OrganConfigRespVO config = this.cardHospitaService.getOrganConfig(organCode);
        if (!ObjectUtils.isEmpty((Object)config)) {
            if (config.getCardSlot() == null || config.getCardSlot() < 0) {
                return;
            }
            Integer maxBindCardNum = config.getCardSlot();
            List cards = this.cardBindMapper.findListByUserIdAndOrganCode(userId, organCode);
            if (CollectionUtils.isEmpty((Collection)cards)) {
                return;
            }
            Date now = new Date();
            for (UcUserCardBindEntity userCardBind : cards) {
                Integer n;
                Integer n2;
                if (CardEnums.CardBindStatus.BIND.equals((Object)userCardBind.getBindStatus())) {
                    n2 = maxBindCardNum;
                    n = maxBindCardNum = Integer.valueOf(maxBindCardNum - 1);
                    continue;
                }
                if (!CardEnums.CardBindStatus.UNBIND.equals((Object)userCardBind.getBindStatus()) || !userCardBind.getCardReleaseTime().after(now)) continue;
                n2 = maxBindCardNum;
                n = maxBindCardNum = Integer.valueOf(maxBindCardNum - 1);
            }
            if (maxBindCardNum <= 0) {
                throw new UserCenterRuntimeException(ErrorEnum.CARD_BIND_ERROR);
            }
            return;
        }
        throw new UserCenterRuntimeException(ErrorEnum.FEGIN_ERROR);
    }

    private void unbindCard(UcUserCardBindEntity userBind, OrganConfigRespVO hospitalConfig) {
        Integer slotReleaseTime;
        Date now = new Date();
        userBind.setBindStatus(CardEnums.CardBindStatus.UNBIND);
        userBind.setUnbindTime(now);
        Integer cardReleaseTime = hospitalConfig.getCardReleaseTime();
        if (cardReleaseTime != null && cardReleaseTime > 0) {
            userBind.setCardReleaseTime(DateUtils.dateModifOfSecond((Date)now, (int)cardReleaseTime));
        }
        if ((slotReleaseTime = hospitalConfig.getSlotReleaseTime()) != null && slotReleaseTime > 0) {
            userBind.setSlotReleaseTime(DateUtils.dateModifOfSecond((Date)now, (int)slotReleaseTime));
        }
    }

    private CardDetailRespVO buildCardDetail(CardDetailsInfoRespVO data, UcUserCardBindEntity ucUserCardBindEntity, BaseReqVO reqVO) {
        CardDetailRespVO cardDetailRespVO = new CardDetailRespVO();
        BeanUtils.copyProperties((Object)data, (Object)cardDetailRespVO);
        cardDetailRespVO.setBirthdate(data.getBirth());
        cardDetailRespVO.setBindStatus(Short.valueOf((short)ucUserCardBindEntity.getBindStatus().ordinal()));
        cardDetailRespVO.setSignType(Short.valueOf((short)ucUserCardBindEntity.getSignType().ordinal()));
        cardDetailRespVO.setRelation(Short.valueOf((short)ucUserCardBindEntity.getRelation().ordinal()));
        cardDetailRespVO.setUserId(ucUserCardBindEntity.getUserId());
        cardDetailRespVO.setBindTime(ucUserCardBindEntity.getBindTime());
        cardDetailRespVO.setFaceRecognition(ucUserCardBindEntity.getFaceRecognition());
        cardDetailRespVO.setGuardianTel(ucUserCardBindEntity.getGuardianTel());
        cardDetailRespVO.setGuardianName(ucUserCardBindEntity.getGuardianName());
        cardDetailRespVO.setGuardianCredNo(ucUserCardBindEntity.getGuardianCredNo());
        String signTypeName = CardEnums.CardSignType.getDesc((CardEnums.CardSignType)ucUserCardBindEntity.getSignType());
        cardDetailRespVO.setSignTypeName(signTypeName);
        String userId = ucUserCardBindEntity.getUserId();
        UcAccountEntity ucAccountEntity = this.cardUcAccountMapper.selectByUserId(userId);
        if (null != ucAccountEntity) {
            cardDetailRespVO.setAccountNo(ucAccountEntity.getAccountNo());
        }
        return cardDetailRespVO;
    }

    private BaseResponse<CardDetailRespVO> handleCardResp(UcBindCardReqVO reqVo, BaseResponse<?> bindResult, CardEnums.CardSignType cardSignType) {
        if (bindResult.isSuccess()) {
            CardDetailsInfoRespVO cardDetailsInfo = (CardDetailsInfoRespVO)bindResult.getData();
            UcUserCardBindEntity userCardBindOp = this.cardBindMapper.findOneByUserIdAndCardId(reqVo.getUserId(), cardDetailsInfo.getCardId());
            UcUserCardBindEntity userCardBind = this.updateBindInfo(reqVo, cardDetailsInfo, userCardBindOp);
            userCardBind.setSignType(cardSignType);
            userCardBind.setFaceRecognition(reqVo.getFaceRecognition());
            userCardBind.setRelationImg(reqVo.getRelationImg());
            userCardBind.setGuardianTel(reqVo.getGuardianTel());
            userCardBind.setGuardianName(reqVo.getGuardianName());
            userCardBind.setGuardianCredNo(reqVo.getGuardianCredNo());
            this.cardBindMapper.save(userCardBind);
            UcCardBindLogEntity bindLog = new UcCardBindLogEntity(reqVo.getAccountId(), userCardBind.getCardId(), CardEnums.CardBindStatus.BIND, userCardBind.getId(), reqVo.getOperateUser());
            this.cardBindLogMapper.save(bindLog);
            CardDetailRespVO data = this.buildCardDetail(cardDetailsInfo, userCardBind, (BaseReqVO)reqVo);
            UcPatientInfoEntity ucPatientInfoEntity = new UcPatientInfoEntity();
            ucPatientInfoEntity.setPatientId(userCardBind.getPatientId());
            ucPatientInfoEntity.setUserId(userCardBind.getUserId());
            ucPatientInfoEntity.setUserRelation(Short.valueOf((short)userCardBind.getRelation().ordinal()));
            ucPatientInfoEntity.setPatientInfoStatus(Short.valueOf("0"));
            ucPatientInfoEntity.setUpdateTime(new Date());
            UcPatientInfoEntity upife = this.ucPatientInfoMapper.selectByPatientIdAndUserId(ucPatientInfoEntity.getPatientId(), ucPatientInfoEntity.getUserId());
            if (null != upife) {
                ucPatientInfoEntity.setId(upife.getId());
            } else {
                ucPatientInfoEntity.setCreateTime(new Date());
            }
            this.ucPatientInfoMapper.save(ucPatientInfoEntity);
            return BaseResponse.success((Object)data);
        }
        return BaseResponse.error((IError)IError.FEIGN_FAIL, (String)bindResult.getMsg());
    }

    private RegisterCardReqVO buildregisterCardVO(UcRegisterCardReqVO ucReqVO) {
        RegisterCardReqVO reqVO = new RegisterCardReqVO();
        BeanUtils.copyProperties((Object)ucReqVO, (Object)reqVO);
        return reqVO;
    }

    private UcUserCardBindEntity updateBindInfo(UcBindCardReqVO reqVo, CardDetailsInfoRespVO cardDetailsInfo, UcUserCardBindEntity userCardBindOp) {
        UcUserCardBindEntity userCardBind;
        if (userCardBindOp == null) {
            userCardBind = new UcUserCardBindEntity();
            userCardBind.setCardId(cardDetailsInfo.getCardId());
            userCardBind.setCardNo(cardDetailsInfo.getCardNo());
            userCardBind.setUserId(reqVo.getUserId());
            userCardBind.setOrganCode(reqVo.getOrganCode());
            userCardBind.setOrganName(reqVo.getOrganName());
            userCardBind.setCardTypeCode(cardDetailsInfo.getCardTypeCode());
            userCardBind.setCardTypeName(cardDetailsInfo.getCardTypeName());
            userCardBind.setPatientId(cardDetailsInfo.getPatientId());
        } else {
            userCardBind = userCardBindOp;
        }
        userCardBind.setBindStatus(CardEnums.CardBindStatus.BIND);
        for (UserEnums.UserRelationEnum userRelationEnum : UserEnums.UserRelationEnum.values()) {
            if (!reqVo.getIsPerson().equals(userRelationEnum.getUserRelation())) continue;
            userCardBind.setRelation(userRelationEnum);
        }
        userCardBind.setBindTime(new Date());
        userCardBind.setPatientName(reqVo.getPatientName());
        return userCardBind;
    }

    private BaseResponse<CardDetailsInfoRespVO> getCardDetailsInfoRespVOFromCardService(CardDetailQueryReqVO cardDetailQueryReqVO) {
        CardDetailsInfoReqVO cardDetailsInfoReqVO = new CardDetailsInfoReqVO();
        cardDetailsInfoReqVO.setCardId(cardDetailQueryReqVO.getCardId());
        cardDetailsInfoReqVO.setChannelCode(cardDetailQueryReqVO.getChannelCode());
        this.log.info("\u67e5\u8be2\u5c31\u8bca\u5361\u8be6\u60c5\uff0c\u8c03\u7528\u5c31\u8bca\u5361\u4e2d\u5fc3\u8bf7\u6c42\u53c2\u6570{}", (Object)cardDetailsInfoReqVO);
        BaseResponse cardDetailFromCardService = this.cardServiceFeginClient.getCardDetail(cardDetailsInfoReqVO);
        this.log.info("\u67e5\u8be2\u5c31\u8bca\u5361\u8be6\u60c5\uff0c\u8c03\u7528\u5c31\u8bca\u5361\u4e2d\u5fc3\u8fd4\u56de\u53c2\u6570{}", (Object)cardDetailFromCardService);
        return cardDetailFromCardService;
    }

    private CardListRespVO buildCardListRespVO(CardListRespVO cardListRespVO, CardDetailsInfoRespVO cardDetailsInfoRespVO) {
        String birthStr;
        cardListRespVO.setOrganCode(cardDetailsInfoRespVO.getOrganCode());
        cardListRespVO.setOrganName(cardDetailsInfoRespVO.getOrganName());
        cardListRespVO.setPatientId(cardDetailsInfoRespVO.getPatientId());
        cardListRespVO.setPatientName(cardDetailsInfoRespVO.getPatientName());
        cardListRespVO.setCredNo(cardDetailsInfoRespVO.getCredNo());
        cardListRespVO.setCredTypeCode(cardDetailsInfoRespVO.getCredTypeCode());
        cardListRespVO.setCredTypeName(cardDetailsInfoRespVO.getCredTypeName());
        cardListRespVO.setCardTypeCode(cardDetailsInfoRespVO.getCardTypeCode());
        cardListRespVO.setCardTypeName(cardDetailsInfoRespVO.getCardTypeName());
        cardListRespVO.setCardNo(cardDetailsInfoRespVO.getCardNo());
        cardListRespVO.setCardId(cardDetailsInfoRespVO.getCardId());
        cardListRespVO.setGender(cardDetailsInfoRespVO.getGender());
        cardListRespVO.setTel(cardDetailsInfoRespVO.getTel());
        cardListRespVO.setCardStatus(cardDetailsInfoRespVO.getCardStatus());
        cardListRespVO.setCardStatusDesc(cardDetailsInfoRespVO.getCardStatusDesc());
        UcAccountEntity ucAccountEntity = this.cardUcAccountMapper.selectByUserId(cardListRespVO.getUserId());
        if (null != ucAccountEntity) {
            cardListRespVO.setAccountNo(ucAccountEntity.getAccountNo());
        }
        if (IdCardUtil.validateIdCard18((String)cardListRespVO.getCredNo()) && (birthStr = IdCardUtil.getBirthByIdCard2((String)cardListRespVO.getCredNo())) != null) {
            try {
                Date dob = DateUtils.formatDate((String)birthStr);
                cardListRespVO.setBirthdate(dob);
            }
            catch (ParseException e) {
                this.log.warn("\u8bc1\u4ef6\u53f7\u89e3\u6790\u51fa\u751f\u65e5\u671f\u5931\u8d25,e={}", (Throwable)e);
            }
        }
        return cardListRespVO;
    }

    private BaseResponse<CardDetailsInfoRespVO> getCardStatusFromCardService(CardDetailsInfoReqVO cardDetailsInfoRespVO) {
        this.log.info("\u67e5\u8be2\u5c31\u8bca\u5361\u5217\u8868\uff0c\u8c03\u7528\u5c31\u8bca\u5361\u4e2d\u5fc3\u8bf7\u6c42\u53c2\u6570{}", (Object)cardDetailsInfoRespVO);
        BaseResponse cardDetail = this.cardServiceFeginClient.getCardDetail(cardDetailsInfoRespVO);
        this.log.info("\u67e5\u8be2\u5c31\u8bca\u5361\u5217\u8868\uff0c\u8c03\u7528\u5c31\u8bca\u5361\u4e2d\u5fc3\u8fd4\u56de\u53c2\u6570{}", (Object)cardDetail);
        return cardDetail;
    }

    private void checkRegisterCredParams(UcRegisterCardReqVO reqVo) {
        if (ID_CARD_CODE.equals(reqVo.getCredTypeCode()) || HOUSEHOLD_CARD_CODE.equals(reqVo.getCredTypeCode())) {
            if (IdCardUtil.validateIdCard15((String)reqVo.getCredNo())) {
                String s = IdCardUtil.convert15CardTo18((String)reqVo.getCredNo());
                reqVo.setCredNo(s);
                this.log.info("15\u4f4d\u539f\u8eab\u4efd\u8bc1\u53f7\uff1a{},\u8f6c\u6362\u540e18\u4f4d\u8eab\u4efd\u8bc1\u53f7\uff1a{}", (Object)reqVo.getCredNo(), (Object)s);
            }
            if (!IdCardUtil.validateIdCard18((String)reqVo.getCredNo())) {
                this.log.warn("\u8eab\u4efd\u8bc1\u6216\u6237\u53e3\u7c3f\u9a8c\u8bc1\u5931\u8d25[{}],\u5361\u53f7\u4fe1\u606f[{}]", (Object)reqVo.getCredNo());
                throw new UserCenterRuntimeException(ErrorEnum.CARD_REGISTER_CRED_WRONG);
            }
        }
    }
}

