/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.service.impl;

import com.ebaiyihui.card.client.ICardServiceFeginClient;
import com.ebaiyihui.card.common.vo.CardDetailsInfoReqVO;
import com.ebaiyihui.card.common.vo.CardDetailsInfoRespVO;
import com.ebaiyihui.common.pojo.vo.card.CardListRespVO;
import com.ebaiyihui.common.pojo.vo.card.PatientQueryReqVO;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.server.enums.CardEnums;
import com.ebaiyihui.server.repository.UcUserCardBindMapper;
import com.ebaiyihui.server.service.PatientSearchService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class PatientSearchServiceImpl
implements PatientSearchService {
    private static final Logger log = LoggerFactory.getLogger(PatientSearchServiceImpl.class);
    @Autowired
    protected UcUserCardBindMapper cardBindMapper;
    @Autowired
    private ICardServiceFeginClient cardServiceFeginClient;

    public BaseResponse<PageResult<CardListRespVO>> searchPatient(PatientQueryReqVO queryVO) {
        PageHelper.startPage((int)queryVO.getPageNum(), (int)queryVO.getPageSize());
        Page cardListPage = this.cardBindMapper.findPatientInfo(CardEnums.CardBindStatus.BIND, queryVO.getOrganCode(), queryVO.getSearchParam(), queryVO.getAppCode());
        PageResult pageResult = new PageResult();
        if (CollectionUtils.isEmpty((Collection)cardListPage)) {
            return BaseResponse.success((Object)pageResult);
        }
        for (CardListRespVO cardInfo : cardListPage) {
            CardDetailsInfoReqVO cardStatusReqVO = new CardDetailsInfoReqVO();
            cardStatusReqVO.setCardId(cardInfo.getCardId());
            log.info("\u67e5\u8be2\u5c31\u8bca\u5361\u5217\u8868\uff0c\u8c03\u7528\u5c31\u8bca\u5361\u4e2d\u5fc3\u8bf7\u6c42\u53c2\u6570{}", (Object)cardStatusReqVO);
            BaseResponse baseResponse = this.cardServiceFeginClient.getCardDetail(cardStatusReqVO);
            log.info("\u67e5\u8be2\u5c31\u8bca\u5361\u5217\u8868\uff0c\u8c03\u7528\u5c31\u8bca\u5361\u4e2d\u5fc3\u8fd4\u56de\u53c2\u6570{}", (Object)baseResponse);
            if (baseResponse.isSuccess() && baseResponse.getData() != null) {
                BeanUtils.copyProperties((Object)baseResponse.getData(), (Object)cardInfo);
                String patientName = ((CardDetailsInfoRespVO)baseResponse.getData()).getPatientName();
                String telPhone = ((CardDetailsInfoRespVO)baseResponse.getData()).getTel();
                String fullName = patientName;
                if (!StringUtils.isEmpty((Object)telPhone)) {
                    fullName = fullName + "(" + telPhone.substring(telPhone.length() - 4) + ")";
                }
                cardInfo.setFullName(fullName);
                continue;
            }
            log.info("\u7efc\u5408\u7ba1\u7406\u5e73\u53f0\u83b7\u53d6\u5217\u8868\u6570\u636e\u5f02\u5e38\uff0c\u672a\u67e5\u8be2\u5230\u5361\u8be6\u7ec6\uff1a{}", (Object)cardStatusReqVO);
        }
        pageResult.setContent(cardListPage.getResult());
        pageResult.setTotal((int)cardListPage.getTotal());
        return BaseResponse.success((Object)pageResult);
    }
}

