/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server;

import java.util.ArrayList;
import java.util.List;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.data.mongo.MongoDataAutoConfiguration;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.netflix.eureka.EnableEurekaClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Bean;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.RestTemplate;

@SpringBootApplication
@EnableCaching
@EnableFeignClients(basePackages={"com.ebaiyihui.patient", "com.ebaiyihui.doctor", "com.ebaiyihui.card", "com.ebaiyihui.server.service.feign", "com.ebaiyihui.client", "com.ebaiyihui.push", "com.ebaiyihui.imforward.client.feignClient"})
@EnableEurekaClient
@EnableDiscoveryClient
@MapperScan(value={"com.ebaiyihui.server.repository"})
@EnableAutoConfiguration(exclude={MongoDataAutoConfiguration.class})
public class UserCenterApplication {
    private static final Logger log = LoggerFactory.getLogger(UserCenterApplication.class);

    @Bean
    public RestTemplate restTemplate(RestTemplateBuilder builder) {
        List converters = builder.build().getMessageConverters();
        for (HttpMessageConverter converter : converters) {
            if (!(converter instanceof MappingJackson2HttpMessageConverter)) continue;
            try {
                ArrayList<MediaType> mediaTypeList = new ArrayList<MediaType>(converter.getSupportedMediaTypes());
                mediaTypeList.add(MediaType.TEXT_HTML);
                ((MappingJackson2HttpMessageConverter)converter).setSupportedMediaTypes(mediaTypeList);
            }
            catch (Exception e) {
                log.error("\u51fa\u73b0\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
            }
        }
        return builder.build();
    }

    public static void main(String[] args) {
        SpringApplication.run(UserCenterApplication.class, (String[])args);
    }
}

