/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.config;

import com.ebaiyihui.server.config.MongodbConfig;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.MongoDriverInformation;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoClient;
import com.mongodb.client.internal.MongoClientImpl;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoClientDatabaseFactory;
import org.springframework.data.mongodb.core.convert.DefaultMongoTypeMapper;
import org.springframework.data.mongodb.core.convert.MongoTypeMapper;

/*
 * Exception performing whole class analysis ignored.
 */
@Configuration
@EnableConfigurationProperties(value={MongoClientOptionProperties.class})
public class MongodbConfig {
    private static final Logger log = LoggerFactory.getLogger(MongodbConfig.class);

    @Bean
    public MongoTypeMapper defaultMongoTypeMapper() {
        return new DefaultMongoTypeMapper(null);
    }

    @Bean
    public MongoTemplate mongoTemplate(MongoDatabaseFactory mongoDbFactory) {
        MongoTemplate mongoTemplate = new MongoTemplate(mongoDbFactory);
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return mongoTemplate;
    }

    @Bean
    public MongoDatabaseFactory mongoDbFactory(MongoClientOptionProperties properties) {
        MongoClientSettings mongoClientOptions = this.mongoClientSettings(properties);
        MongoDriverInformation info = MongoDriverInformation.builder().build();
        MongoClientImpl mongoClient = new MongoClientImpl(mongoClientOptions, info);
        return new SimpleMongoClientDatabaseFactory((MongoClient)mongoClient, MongoClientOptionProperties.access$000((MongoClientOptionProperties)properties));
    }

    @Bean
    public MongoClientSettings mongoClientSettings(MongoClientOptionProperties properties) {
        MongoCredential mongoCredential = this.getCredential(properties);
        List serverAddressList = this.getServerAddress(properties.getAddress());
        return MongoClientSettings.builder().applyToClusterSettings(i -> i.hosts(serverAddressList)).credential(mongoCredential).build();
    }

    private MongoCredential getCredential(MongoClientOptionProperties properties) {
        if (!StringUtils.isEmpty((CharSequence)properties.getUsername()) && !StringUtils.isEmpty((CharSequence)properties.getPassword())) {
            String database = StringUtils.isEmpty((CharSequence)properties.getAuthenticationDatabase()) ? properties.getDatabase() : properties.getAuthenticationDatabase();
            return MongoCredential.createCredential((String)properties.getUsername(), (String)database, (char[])properties.getPassword().toCharArray());
        }
        return null;
    }

    private List<ServerAddress> getServerAddress(String mongoAddress) {
        String[] mongoAddressArray = mongoAddress.trim().split(",");
        ArrayList<ServerAddress> serverAddressList = new ArrayList<ServerAddress>(4);
        for (String address : mongoAddressArray) {
            String[] hostAndPort = address.split(":");
            serverAddressList.add(new ServerAddress(hostAndPort[0], Integer.parseInt(hostAndPort[1])));
        }
        return serverAddressList;
    }
}

