/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.controller;

import com.ebaiyihui.common.AddressInfoApi;
import com.ebaiyihui.common.pojo.vo.addressInfo.City;
import com.ebaiyihui.common.pojo.vo.addressInfo.CreateAddressInfoReqVo;
import com.ebaiyihui.common.pojo.vo.addressInfo.DistrictInfo;
import com.ebaiyihui.common.pojo.vo.addressInfo.GetAddressInfoDetailResVo;
import com.ebaiyihui.common.pojo.vo.addressInfo.GetAddressInfoResVo;
import com.ebaiyihui.common.pojo.vo.addressInfo.SearchLocalReqVo;
import com.ebaiyihui.common.pojo.vo.addressInfo.SearchLocaltionResVo;
import com.ebaiyihui.common.pojo.vo.addressInfo.UpdateAddressInfoReqVo;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.patient.common.api.PatientServiceApi;
import com.ebaiyihui.server.repository.ServicepkgOrderMapper;
import com.ebaiyihui.server.service.AddressService;
import com.ebaiyihui.server.service.ServicepkgInfoOrderService;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class AddressInfoController
implements AddressInfoApi {
    private static final Logger log = LoggerFactory.getLogger(AddressInfoController.class);
    @Autowired
    private AddressService addressService;
    @Autowired
    private ServicepkgOrderMapper servicepkgOrderMapper;
    @Autowired
    private ServicepkgInfoOrderService servicepkgInfoOrderService;
    @Autowired
    PatientServiceApi patientServiceApi;
    private static final String SERVCODE = "yyy";

    @ApiOperation(value="\u6839\u636euserid\u83b7\u53d6\u5730\u5740\u5217\u8868")
    public BaseResponse<List<GetAddressInfoResVo>> getAddressListByUserId(@RequestParam(value="userId") String userId) {
        return this.addressService.getAddressListByUserId(userId);
    }

    public BaseResponse<String> addNewAddress(@RequestBody @Valid CreateAddressInfoReqVo vo) {
        return this.addressService.addNewAddress(vo);
    }

    public BaseResponse<String> updateAddress(@RequestBody @Valid UpdateAddressInfoReqVo vo) {
        return this.addressService.updateAddress(vo);
    }

    public BaseResponse<String> deleteAddress(@RequestParam(value="id") Long id) {
        return this.addressService.deleteAddress(id);
    }

    public BaseResponse<GetAddressInfoDetailResVo> getAddressInfoDetailByAddressId(@RequestParam(value="addressId") Long addressId) {
        return this.addressService.getAddressDetailByAddressId(addressId);
    }

    public BaseResponse<List<GetAddressInfoDetailResVo>> getAddressInfoDetailListByAddressId(@RequestParam(value="addressIdList") List<Long> addressIdList) {
        return this.addressService.selectByAddressIds(addressIdList);
    }

    public BaseResponse<List<DistrictInfo>> getDistrictInfoList(@RequestParam(value="orderBy", required=false) String orderBy) {
        return this.addressService.getDistrictInfoList(orderBy);
    }

    public BaseResponse<List<City>> searchDistrict(String keyword) {
        return this.addressService.searchDistrict(keyword);
    }

    public BaseResponse<List<SearchLocaltionResVo>> searchLocation(@RequestBody @Validated SearchLocalReqVo searchLocalReqVo) {
        return BaseResponse.success((Object)this.addressService.searchLocation(searchLocalReqVo));
    }
}

