/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.common.enums.ErrorEnum;
import com.ebaiyihui.common.enums.LoginDeviceType;
import com.ebaiyihui.common.pojo.systemauthVo.AccountResVo;
import com.ebaiyihui.common.pojo.systemauthVo.ManagerAddReqVo;
import com.ebaiyihui.common.pojo.systemauthVo.PlatformInitializationReqVo;
import com.ebaiyihui.common.pojo.systemauthVo.PlatformInitializationRespVo;
import com.ebaiyihui.common.pojo.vo.BaseIdRespVO;
import com.ebaiyihui.common.pojo.vo.DoctorIdReqVO;
import com.ebaiyihui.common.pojo.vo.manage.ManageDoctorDetailsInfoRespVO;
import com.ebaiyihui.common.pojo.vo.manage.ManageDoctorListInfoReqVO;
import com.ebaiyihui.common.pojo.vo.manage.ManageDoctorListInfoRespVO;
import com.ebaiyihui.common.pojo.vo.manage.ManageDoctorRegisterVerifReqVO;
import com.ebaiyihui.common.pojo.vo.manage.ManageDoctorRegisterVerifRespVO;
import com.ebaiyihui.common.pojo.vo.manage.ManageEnableReqVO;
import com.ebaiyihui.common.pojo.vo.manage.ManageOperateLogRespVO;
import com.ebaiyihui.common.pojo.vo.manage.ManageProhibitReqVO;
import com.ebaiyihui.common.pojo.vo.manage.ManageResetPasswordReqVO;
import com.ebaiyihui.common.pojo.vo.manage.ManageSearchUserListReqVO;
import com.ebaiyihui.common.pojo.vo.manage.ManageSearchUserListRespVO;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import com.ebaiyihui.framework.utils.JsonUtil;
import com.ebaiyihui.server.enums.AccountEnums;
import com.ebaiyihui.server.enums.NetinquiryBusinessEnums;
import com.ebaiyihui.server.enums.UserEnums;
import com.ebaiyihui.server.exception.UserCenterRuntimeException;
import com.ebaiyihui.server.pojo.entity.UcAccountEntity;
import com.ebaiyihui.server.pojo.entity.UcAccountOperateEntity;
import com.ebaiyihui.server.pojo.entity.UcAppTokenKeyEntity;
import com.ebaiyihui.server.pojo.entity.UcDoctorUserEntity;
import com.ebaiyihui.server.pojo.entity.UcManageOperateEntity;
import com.ebaiyihui.server.pojo.entity.UcManagerUserEntity;
import com.ebaiyihui.server.pojo.entity.UcOrganUserEntity;
import com.ebaiyihui.server.pojo.entity.UcPatientUserEntity;
import com.ebaiyihui.server.pojo.entity.UcWxAppletConfigEntity;
import com.ebaiyihui.server.repository.UcAppTokenKeyMapper;
import com.ebaiyihui.server.repository.UcWxAppletConfigMapper;
import com.ebaiyihui.server.service.BaseService;
import com.ebaiyihui.server.service.ICacheService;
import com.ebaiyihui.server.service.IManageUserService;
import com.ebaiyihui.server.service.IManagerAuthService;
import com.ebaiyihui.server.util.PasswordAndSalt;
import com.ebaiyihui.server.util.PasswordUtil;
import com.ebaiyihui.server.util.Tokenutil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ManageUserServiceImpl
extends BaseService
implements IManageUserService {
    @Autowired
    private ICacheService manageICacheService;
    @Autowired
    private IManagerAuthService managerAuthService;
    @Autowired
    private UcAppTokenKeyMapper appTokenKeyMapper;
    @Autowired
    private UcWxAppletConfigMapper manageWxAppletConfigMapper;

    public BaseResponse<ManageDoctorDetailsInfoRespVO> queryDoctorDetailsInfo(DoctorIdReqVO doctorIdReqVO) {
        UcAccountEntity account = this.getDoctorAccount(doctorIdReqVO.getDoctorId(), doctorIdReqVO.getAppCode());
        if (account == null) {
            return BaseResponse.error((IError)ErrorEnum.USER_NOT_EXIT);
        }
        if (AccountEnums.AccountStatusEnum.PROHIBIT.getValue().equals(account.getStatus())) {
            return BaseResponse.error((IError)ErrorEnum.DISABLED_ACCOUNT);
        }
        ManageDoctorDetailsInfoRespVO data = new ManageDoctorDetailsInfoRespVO();
        data.setAccountNo(account.getAccountNo());
        String accountId = account.getAccountId();
        ArrayList logs = new ArrayList();
        logs.addAll(this.getSelfOperateLog(accountId));
        logs.addAll(this.getManageOperateLog(accountId));
        this.sortLog(logs, true);
        data.setLogs(logs);
        return BaseResponse.success((Object)data);
    }

    public BaseResponse<ManageDoctorRegisterVerifRespVO> doctorRegisterVerif(ManageDoctorRegisterVerifReqVO manageDoctorRegisterVerifReqVO) {
        UcAccountEntity account = this.getAccount(manageDoctorRegisterVerifReqVO.getAccountNo(), UserEnums.UserTypeEnum.DOCTOR.getUserTypeValue(), manageDoctorRegisterVerifReqVO.getAppCode());
        if (account == null) {
            return BaseResponse.success((Object)this.setManageDoctorRegisterVerifRespVO(NetinquiryBusinessEnums.DoctorRegisterVerifTypeEnum.NO_REGISTER));
        }
        UcDoctorUserEntity doctor = this.getDoctorUserEntity(account.getUserId());
        if (StringUtils.isEmpty((Object)doctor.getDoctorId())) {
            return BaseResponse.success((Object)this.setManageDoctorRegisterVerifRespVO(NetinquiryBusinessEnums.DoctorRegisterVerifTypeEnum.NO_BIND_DOCTOR_ID));
        }
        if (manageDoctorRegisterVerifReqVO.getDoctorId().equals(doctor.getDoctorId())) {
            return BaseResponse.success((Object)this.setManageDoctorRegisterVerifRespVO(NetinquiryBusinessEnums.DoctorRegisterVerifTypeEnum.DOCTOR_ID_IS_SAME));
        }
        return BaseResponse.success((Object)this.setManageDoctorRegisterVerifRespVO(NetinquiryBusinessEnums.DoctorRegisterVerifTypeEnum.DOCTOR_ID_NOT_SAME));
    }

    private ManageDoctorRegisterVerifRespVO setManageDoctorRegisterVerifRespVO(NetinquiryBusinessEnums.DoctorRegisterVerifTypeEnum typeEnum) {
        ManageDoctorRegisterVerifRespVO data = new ManageDoctorRegisterVerifRespVO();
        data.setType(typeEnum.getValue());
        data.setDesc(typeEnum.getDesc());
        return data;
    }

    private void sortLog(List<ManageOperateLogRespVO> logs, boolean isDesc) {
        if (CollectionUtils.isEmpty(logs) || logs.size() == 1) {
            return;
        }
        logs.sort((Comparator<ManageOperateLogRespVO>)new /* Unavailable Anonymous Inner Class!! */);
    }

    private List<ManageOperateLogRespVO> getSelfOperateLog(String accountId) {
        ArrayList<ManageOperateLogRespVO> logs = new ArrayList<ManageOperateLogRespVO>();
        List list = this.ucAccountOperateMapper.getListByaccountId(accountId);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return logs;
        }
        for (UcAccountOperateEntity ucAccountOperateEntity : list) {
            logs.add(new ManageOperateLogRespVO(ucAccountOperateEntity.getCreateTime(), ucAccountOperateEntity.getOperayeContent()));
        }
        return logs;
    }

    private List<ManageOperateLogRespVO> getManageOperateLog(String accountId) {
        ArrayList<ManageOperateLogRespVO> logs = new ArrayList<ManageOperateLogRespVO>();
        List list = this.ucManageOperateMapper.getListByAccountId(accountId);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return logs;
        }
        for (UcManageOperateEntity ucManageOperateEntity : list) {
            logs.add(new ManageOperateLogRespVO(ucManageOperateEntity.getCreateTime(), ucManageOperateEntity.getOperayeContent()));
        }
        return logs;
    }

    public BaseResponse<List<ManageDoctorListInfoRespVO>> queryDoctoListInfo(ManageDoctorListInfoReqVO manageDoctorListInfoReqVO) {
        ArrayList<ManageDoctorListInfoRespVO> dataList = new ArrayList<ManageDoctorListInfoRespVO>();
        String appCode = manageDoctorListInfoReqVO.getAppCode();
        UcAccountEntity tempAccount = null;
        Short accountStatus = null;
        String registerAccountNo = null;
        for (String doctorId : manageDoctorListInfoReqVO.getDoctorIds()) {
            tempAccount = this.getDoctorAccount(doctorId, appCode);
            Short s = accountStatus = tempAccount == null ? AccountEnums.AccountStatusEnum.CANCELLATION.getValue() : tempAccount.getStatus();
            if (tempAccount != null) {
                Optional optional = this.ucDoctorUserMapper.selectByUserId(tempAccount.getUserId());
                if (!optional.isPresent()) {
                    this.log.warn("\u67e5\u8be2\u533b\u751f\u7528\u6237\u4e0d\u5b58\u5728,userId={}", (Object)tempAccount.getUserId());
                    throw new UserCenterRuntimeException(ErrorEnum.USER_NOT_EXIT);
                }
                UcDoctorUserEntity doctor = (UcDoctorUserEntity)optional.get();
                registerAccountNo = doctor.getRegisterMobile();
            }
            ManageDoctorListInfoRespVO data = new ManageDoctorListInfoRespVO(doctorId, registerAccountNo, accountStatus);
            dataList.add(data);
            registerAccountNo = null;
        }
        return BaseResponse.success(dataList);
    }

    public BaseResponse<PageResult<ManageSearchUserListRespVO>> searchUserList(ManageSearchUserListReqVO req) {
        Integer pageSize = req.getPageSize();
        Integer pageNum = req.getPageNum();
        String appCode = req.getAppCode();
        Short userType = req.getUserType();
        PageResult data = new PageResult(pageNum.intValue(), pageSize.intValue());
        Integer count = this.ucAccountMapper.countAccountByAppCodeAndUserType(appCode, userType);
        if (count == 0) {
            data.setTotalPages(0);
            data.setContent(new ArrayList());
        } else {
            Integer totalPage = count / pageSize;
            if (count % pageSize > 0) {
                Integer n = totalPage;
                Integer n2 = totalPage = Integer.valueOf(totalPage + 1);
            }
            data.setTotalPages(totalPage.intValue());
            ArrayList<ManageSearchUserListRespVO> content = new ArrayList<ManageSearchUserListRespVO>();
            data.setContent(content);
            if (totalPage >= pageNum) {
                Integer startRow = (pageNum - 1) * pageSize;
                List accountList = this.ucAccountMapper.getAccountByAppCodeAndUserTypeAndStartRowAndSize(appCode, userType, startRow, pageSize);
                for (UcAccountEntity account : accountList) {
                    ManageSearchUserListRespVO respVO = this.buildManageSearchUserListRespVO(account);
                    content.add(respVO);
                }
            }
        }
        return BaseResponse.success((Object)data);
    }

    private ManageSearchUserListRespVO buildManageSearchUserListRespVO(UcAccountEntity account) {
        ManageSearchUserListRespVO respVO = new ManageSearchUserListRespVO();
        BeanUtils.copyProperties((Object)account, (Object)respVO);
        String userId = account.getUserId();
        if (UserEnums.UserTypeEnum.PATIENT.getUserTypeValue().equals(account.getUserType())) {
            Optional optional = this.ucPatientUserMapper.findByUserId(userId);
            if (!optional.isPresent()) {
                this.log.warn("\u67e5\u8be2\u60a3\u8005\u7528\u6237\u4e0d\u5b58\u5728,userId={}", (Object)userId);
                throw new UserCenterRuntimeException(ErrorEnum.USER_NOT_EXIT);
            }
            UcPatientUserEntity user = (UcPatientUserEntity)optional.get();
            respVO.setName(user.getName());
        } else if (UserEnums.UserTypeEnum.DOCTOR.getUserTypeValue().equals(account.getUserType())) {
            Optional optional = this.ucDoctorUserMapper.selectByUserId(userId);
            if (!optional.isPresent()) {
                this.log.warn("\u67e5\u8be2\u533b\u751f\u7528\u6237\u4e0d\u5b58\u5728,userId={}", (Object)userId);
                throw new UserCenterRuntimeException(ErrorEnum.USER_NOT_EXIT);
            }
            UcDoctorUserEntity user = (UcDoctorUserEntity)optional.get();
            respVO.setName(user.getName());
        } else if (UserEnums.UserTypeEnum.ORGAN.getUserTypeValue().equals(account.getUserType())) {
            Optional optional = this.ucOrganUserMapper.selectByUserId(userId);
            if (!optional.isPresent()) {
                this.log.warn("\u67e5\u8be2\u673a\u6784\u7528\u6237\u4e0d\u5b58\u5728,userId={}", (Object)userId);
                throw new UserCenterRuntimeException(ErrorEnum.USER_NOT_EXIT);
            }
            UcOrganUserEntity user = (UcOrganUserEntity)optional.get();
            respVO.setName(user.getOrganName());
        } else if (UserEnums.UserTypeEnum.MANAGER.getUserTypeValue().equals(account.getUserType())) {
            Optional optional = this.ucManagerUserMapper.selectByUserId(userId);
            if (!optional.isPresent()) {
                this.log.warn("\u67e5\u8be2\u7ba1\u7406\u5458\u7528\u6237\u4e0d\u5b58\u5728,userId={}", (Object)userId);
                throw new UserCenterRuntimeException(ErrorEnum.USER_NOT_EXIT);
            }
            UcManagerUserEntity user = (UcManagerUserEntity)optional.get();
            respVO.setName(user.getName());
        } else {
            throw new UserCenterRuntimeException(ErrorEnum.UNKNOWN_ACCOUNT_TYPE);
        }
        return respVO;
    }

    public BaseResponse<BaseIdRespVO> resetPassword(ManageResetPasswordReqVO reqVO) {
        UcAccountEntity manageAccount = this.getRightAccount(reqVO.getAccountId());
        if (!UserEnums.UserTypeEnum.MANAGER.getUserTypeValue().equals(manageAccount.getUserType())) {
            return BaseResponse.error((IError)ErrorEnum.NO_PERMISSION, (String)"\u975e\u7ba1\u7406\u5458\u7528\u6237,\u65e0\u6cd5\u8fdb\u884c\u7ba1\u7406\u64cd\u4f5c");
        }
        UcAccountEntity beOpAccount = this.getRightAccount(reqVO.getBeOpAccountId());
        this.deleteAllToken(beOpAccount.getUserId(), beOpAccount.getAppCode());
        PasswordAndSalt passwordAndSalt = PasswordUtil.mix((String)reqVO.getPassword());
        beOpAccount.setAccountPw(passwordAndSalt.getMixedPassword());
        beOpAccount.setPwSalt(passwordAndSalt.getSalt());
        this.ucAccountMapper.save(beOpAccount);
        UcManageOperateEntity manageOperateEntity = new UcManageOperateEntity(reqVO.getChannelCode(), AccountEnums.AccountOperationEnum.UPDATE_PASSWORD.getValue(), "\u4fee\u6539\u5bc6\u7801", beOpAccount.getAccountId(), manageAccount.getAccountId(), JsonUtil.convertObject((Object)reqVO));
        this.ucManageOperateMapper.save(manageOperateEntity);
        return BaseResponse.success((Object)new BaseIdRespVO(beOpAccount.getUserId(), beOpAccount.getAccountId()));
    }

    private void deleteAllToken(String userId, String appCode) {
        for (LoginDeviceType loginDeviceType : LoginDeviceType.values()) {
            String tokenKey = Tokenutil.genTokenKey((String)userId, (String)appCode, (String)loginDeviceType.toString());
            if (this.manageICacheService.delLoginToken(tokenKey)) continue;
            this.log.warn("\u7f13\u5b58\u5220\u9664\u5931\u8d25,tokenKey={}", (Object)tokenKey);
            throw new UserCenterRuntimeException(ErrorEnum.TOKEN_DELETE_FAIL);
        }
    }

    public BaseResponse<BaseIdRespVO> prohibitAccount(ManageProhibitReqVO reqVO) {
        UcAccountEntity manageAccount = this.getRightAccount(reqVO.getAccountId());
        if (!UserEnums.UserTypeEnum.MANAGER.getUserTypeValue().equals(manageAccount.getUserType())) {
            return BaseResponse.error((IError)ErrorEnum.NO_MANAGER_PERMISSION);
        }
        UcAccountEntity beOpAccount = this.getRightAccount(reqVO.getBeOpAccountId());
        this.deleteAllToken(beOpAccount.getUserId(), beOpAccount.getAppCode());
        beOpAccount.setStatus(AccountEnums.AccountStatusEnum.PROHIBIT.getValue());
        this.ucAccountMapper.save(beOpAccount);
        UcManageOperateEntity manageOperateEntity = new UcManageOperateEntity(reqVO.getChannelCode(), AccountEnums.AccountOperationEnum.PROHIBIT_ACCOUNT.getValue(), "\u7ba1\u7406\u5458\u7981\u7528\u8d26\u6237", beOpAccount.getAccountId(), manageAccount.getAccountId(), JsonUtil.convertObject((Object)reqVO));
        this.ucManageOperateMapper.save(manageOperateEntity);
        return BaseResponse.success((Object)new BaseIdRespVO(beOpAccount.getUserId(), beOpAccount.getAccountId()));
    }

    public BaseResponse<BaseIdRespVO> enableAccount(ManageEnableReqVO reqVO) {
        UcAccountEntity manageAccount = this.getRightAccount(reqVO.getAccountId());
        if (!UserEnums.UserTypeEnum.MANAGER.getUserTypeValue().equals(manageAccount.getUserType())) {
            return BaseResponse.error((IError)ErrorEnum.NO_MANAGER_PERMISSION);
        }
        UcAccountEntity beOpAccount = this.ucAccountMapper.findByAccountId(reqVO.getBeOpAccountId());
        if (beOpAccount == null || AccountEnums.AccountStatusEnum.CANCELLATION.getValue().equals(beOpAccount.getStatus())) {
            return BaseResponse.error((IError)ErrorEnum.NO_EXISTS_ACCOUNT, (String)"\u542f\u7528\u8d26\u6237\u4e0d\u5b58\u5728");
        }
        beOpAccount.setStatus(AccountEnums.AccountStatusEnum.NORMAL.getValue());
        this.ucAccountMapper.save(beOpAccount);
        UcManageOperateEntity manageOperateEntity = new UcManageOperateEntity(reqVO.getChannelCode(), AccountEnums.AccountOperationEnum.ENABLE_ACCOUNT.getValue(), "\u7ba1\u7406\u5458\u542f\u7528\u8d26\u6237", beOpAccount.getAccountId(), manageAccount.getAccountId(), JsonUtil.convertObject((Object)reqVO));
        this.ucManageOperateMapper.save(manageOperateEntity);
        return BaseResponse.success((Object)new BaseIdRespVO(beOpAccount.getUserId(), beOpAccount.getAccountId()));
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<PlatformInitializationRespVo> platformInitialization(PlatformInitializationReqVo reqVO) {
        UcAccountEntity ucAccountEntity;
        Optional managerUserEntityOptional;
        this.log.info("\u65b0\u5efa\u8bca\u7597\u5e73\u53f0\u8282\u70b9\u4fe1\u606f\u521d\u59cb\u5316 \u5165\u53c2:{}", (Object)JSON.toJSONString((Object)reqVO));
        PlatformInitializationRespVo respVO = new PlatformInitializationRespVo();
        if (reqVO.getAppCode() == null) {
            return BaseResponse.error((IError)ErrorEnum.INVALID_PARAMETER, (String)"appcode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List entityList = this.ucAccountMapper.findListByAppCodeAndUserTypeAndStatus(reqVO.getAppCode(), UserEnums.UserTypeEnum.MANAGER.getUserTypeValue(), UserEnums.UserStatusEnum.NORMAL.getUserStatusValue());
        if (!entityList.isEmpty() && (managerUserEntityOptional = this.ucManagerUserMapper.selectByUserId((ucAccountEntity = (UcAccountEntity)entityList.get(0)).getUserId())).isPresent()) {
            UcManagerUserEntity ucManagerUserEntity = (UcManagerUserEntity)managerUserEntityOptional.get();
            respVO.setLoginName(ucAccountEntity.getLoginName());
            respVO.setLoginPhone(ucAccountEntity.getAccountNo());
            respVO.setAccountId(ucAccountEntity.getAccountId());
            respVO.setUserId(ucAccountEntity.getUserId());
            respVO.setPassword(ucManagerUserEntity.getInitializePassword());
            this.log.info("==platformInitialization===\u67e5\u8be2\u5df2\u5b58\u5728\u7ba1\u7406\u5458\u8d26\u6237,respVO:{}", (Object)JSON.toJSONString((Object)respVO));
            return BaseResponse.success((Object)respVO);
        }
        BaseResponse addMember = this.managerAuthService.addDefaultManager((ManagerAddReqVo)reqVO);
        if (!addMember.isSuccess()) {
            this.log.info("\u65b0\u5efa\u8bca\u7597\u5e73\u53f0\u8282\u70b9\u4fe1\u606f\u521d\u59cb\u5316 \u5931\u8d25:{}", (Object)JSON.toJSONString((Object)addMember));
            return BaseResponse.error((IError)ErrorEnum.getEnum((String)addMember.getErrCode()), (String)addMember.getMsg());
        }
        UcAppTokenKeyEntity byAppCode = this.appTokenKeyMapper.getByAppCode(reqVO.getAppCode());
        int save = 0;
        if (byAppCode == null) {
            UcAppTokenKeyEntity entity = new UcAppTokenKeyEntity(reqVO.getAppCode(), "hxgy-ehospital", reqVO.getHospitalName());
            save = this.appTokenKeyMapper.save(entity);
        } else {
            save = 1;
        }
        int insert = 0;
        String appIdType = reqVO.getAppCode().trim().concat("MP");
        if (reqVO.getAppletId() != null && reqVO.getAppletSecret() != null) {
            Optional optional = this.manageWxAppletConfigMapper.selectByAppIdType(appIdType);
            if (!optional.isPresent()) {
                UcWxAppletConfigEntity configEntity = new UcWxAppletConfigEntity(appIdType, reqVO.getAppletId(), reqVO.getAppletSecret());
                insert = this.manageWxAppletConfigMapper.insert(configEntity);
            }
        } else {
            insert = 1;
        }
        AccountResVo addMemberData = (AccountResVo)addMember.getData();
        BeanUtils.copyProperties((Object)addMemberData, (Object)respVO);
        respVO.setLoginPhone(addMemberData.getAccountNo());
        respVO.setAppIdType(appIdType);
        this.log.info("\u65b0\u5efa\u8bca\u7597\u5e73\u53f0\u8282\u70b9\u4fe1\u606f\u521d\u59cb\u5316 \u54cd\u5e94\uff0c\u6dfb\u52a0\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u914d\u7f6e:{},\u6dfb\u52a0\u5e73\u53f0AppCode\u5230uc_app_token_key\u8868:{},respVO:{}", new Object[]{insert, save, JSON.toJSONString((Object)respVO)});
        if (insert > 0 && save > 0) {
            return BaseResponse.success((Object)respVO);
        }
        if (insert == 0 && save > 0) {
            return BaseResponse.error((String)"\u65b0\u5efa\u8bca\u7597\u5e73\u53f0\u8282\u70b9\u4fe1\u606f\u521d\u59cb\u5316\u5931\u8d25--> \u5c0f\u7a0b\u5e8f\u4fe1\u606f\u914d\u7f6e\u5931\u8d25 ");
        }
        if (insert > 0 && save == 0) {
            return BaseResponse.error((String)"\u65b0\u5efa\u8bca\u7597\u5e73\u53f0\u8282\u70b9\u4fe1\u606f\u521d\u59cb\u5316\u5931\u8d25-> \u6dfb\u52a0\u5e73\u53f0AppCode\u5230uc_app_token_key\u8868\u5931\u8d25");
        }
        if (insert == 0 && save == 0) {
            return BaseResponse.error((String)"\u65b0\u5efa\u8bca\u7597\u5e73\u53f0\u8282\u70b9\u4fe1\u606f\u521d\u59cb\u5316\u5931\u8d25--> \u5c0f\u7a0b\u5e8f\u4fe1\u606f\u914d\u7f6e\u5931\u8d25 && \u6dfb\u52a0\u5e73\u53f0AppCode\u5230uc_app_token_key\u8868\u5931\u8d25");
        }
        return BaseResponse.error((String)"\u65b0\u5efa\u8bca\u7597\u5e73\u53f0\u8282\u70b9\u4fe1\u606f\u521d\u59cb\u5316\u5931\u8d25--> \u672a\u77e5\u9519\u8bef\uff0c\u8bf7\u6838\u5b9e\u6570\u636e\u5e93\u4fe1\u606f");
    }
}

