/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class RegexUtils {
    private static final String PW_6_20_AA = "^(?=.*[A-Z])(?=.*[a-z])[a-zA-Z0-9]{6,20}$";
    private static final String PW_6_20_A = "^(?=.*[A-Za-z])(?=.*[0-9])[A-Za-z0-9\\d$@!%*?&#.,;]{6,20}$";
    private static final String PW_A_A = "^(?=.*[a-z])(?=.*[A-Z])[A-Za-z\\d$@!%*?&#.,;]{2,}$";
    private static final String REGEX_A_8_20 = "(?=.*\\d)(?=.*[a-zA-Z]).{8,20}";
    private static final String PW_AA_8_20 = "^(?![A-Za-z0-9]+$)(?![a-z0-9\\W]+$)(?![A-Za-z\\W]+$)(?![A-Z0-9\\W]+$)[a-zA-Z0-9\\W]{8,}$";

    public static boolean checkEmail(String email) {
        String regex = "\\w+@\\w+\\.[a-z]+(\\.[a-z]+)?";
        return Pattern.matches(regex, email);
    }

    public static boolean checkIdCard(String idCard) {
        String regex = "[1-9]\\d{13,16}[a-zA-Z0-9]{1}";
        return Pattern.matches(regex, idCard);
    }

    public static boolean checkMobile(String mobile) {
        String regex = "(\\+\\d+)?1[23456789]\\d{9}$";
        return Pattern.matches(regex, mobile);
    }

    public static boolean checkPhone(String phone) {
        String regex = "(\\+\\d+)?(\\d{3,4}\\-?)?\\d{7,8}$";
        return Pattern.matches(regex, phone);
    }

    public static boolean checkDigit(String digit) {
        String regex = "\\-?[1-9]\\d+";
        return Pattern.matches(regex, digit);
    }

    public static boolean checkDecimals(String decimals) {
        String regex = "\\-?[1-9]\\d+(\\.\\d+)?";
        return Pattern.matches(regex, decimals);
    }

    public static boolean checkBlankSpace(String blankSpace) {
        String regex = "\\s+";
        return Pattern.matches(regex, blankSpace);
    }

    public static boolean checkChinese(String chinese) {
        String regex = "^[\u4e00-\u9fa5]+$";
        return Pattern.matches(regex, chinese);
    }

    public static boolean checkBirthday(String birthday) {
        String regex = "[1-9]{4}([-./])\\d{1,2}\\1\\d{1,2}";
        return Pattern.matches(regex, birthday);
    }

    public static boolean checkURL(String url) {
        String regex = "(https?://(w{3}\\.)?)?\\w+\\.\\w+(\\.[a-zA-Z]+)*(:\\d{1,5})?(/\\w*)*(\\??(.+=.*)?(&.+=.*)?)?";
        return Pattern.matches(regex, url);
    }

    public static String getDomain(String url) {
        Pattern p = Pattern.compile("(?<=http://|\\.)[^.]*?\\.(com|cn|net|org|biz|info|cc|tv)", 2);
        Matcher matcher = p.matcher(url);
        matcher.find();
        return matcher.group();
    }

    public static boolean checkPostcode(String postcode) {
        String regex = "[1-9]\\d{5}";
        return Pattern.matches(regex, postcode);
    }

    public static boolean checkIpAddress(String ipAddress) {
        String regex = "[1-9](\\d{1,2})?\\.(0|([1-9](\\d{1,2})?))\\.(0|([1-9](\\d{1,2})?))\\.(0|([1-9](\\d{1,2})?))";
        return Pattern.matches(regex, ipAddress);
    }

    public static Boolean match_Aa_6_20(String password) {
        if (password != null && password.matches("^(?=.*[A-Z])(?=.*[a-z])[a-zA-Z0-9]{6,20}$")) {
            return true;
        }
        return false;
    }

    public static Boolean match_a_6_20(String password) {
        if (password != null && password.matches("^(?=.*[A-Za-z])(?=.*[0-9])[A-Za-z0-9\\d$@!%*?&#.,;]{6,20}$")) {
            return true;
        }
        return false;
    }

    public static Boolean match_Aa(String password) {
        if (password != null && password.matches("^(?=.*[a-z])(?=.*[A-Z])[A-Za-z\\d$@!%*?&#.,;]{2,}$")) {
            return true;
        }
        return false;
    }

    public static boolean match_Aa_8_20(String password) {
        if (StringUtils.isNotEmpty((CharSequence)password)) {
            return password.matches("^(?![A-Za-z0-9]+$)(?![a-z0-9\\W]+$)(?![A-Za-z\\W]+$)(?![A-Z0-9\\W]+$)[a-zA-Z0-9\\W]{8,}$");
        }
        return false;
    }

    public static boolean match_a_8_20(String password) {
        if (StringUtils.isNotEmpty((CharSequence)password)) {
            return password.matches("(?=.*\\d)(?=.*[a-zA-Z]).{8,20}");
        }
        return false;
    }

    public static void main(String[] args) {
        System.out.println(RegexUtils.match_Aa_8_20((String)"Addd7987\u3002"));
        System.out.println(RegexUtils.match_Aa_8_20((String)"Addd7987\uff0c\u3001"));
        System.out.println(RegexUtils.match_Aa_8_20((String)"Addd7987\u6c49\u5b57"));
        System.out.println(RegexUtils.match_Aa_8_20((String)"Addd7987\uff01@\uffe5%&*"));
        System.out.println(RegexUtils.match_Aa_8_20((String)"Addd7987@#\uffe5%"));
        System.out.println(RegexUtils.match_Aa_8_20((String)"Ad7...!@#$%^&*"));
        System.out.println(RegexUtils.match_Aa_8_20((String)"Addd7987)("));
        System.out.println(RegexUtils.match_Aa_8_20((String)"Addd7987|"));
        System.out.println(RegexUtils.match_Aa_8_20((String)"Addd7987?"));
        System.out.println(RegexUtils.match_a_8_20((String)"ddWd27987`\u3002\uff1b\uff1b\u3001"));
        System.out.println(RegexUtils.match_a_8_20((String)"222222987"));
    }
}

