/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayConfig;
import com.alipay.api.AlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.request.AlipaySystemOauthTokenRequest;
import com.alipay.api.request.AlipayUserInfoShareRequest;
import com.alipay.api.response.AlipaySystemOauthTokenResponse;
import com.alipay.api.response.AlipayUserInfoShareResponse;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.server.pojo.entity.UcAlipayAuthEntity;
import com.ebaiyihui.server.pojo.entity.UcAlipayConfigEntity;
import com.ebaiyihui.server.pojo.vo.AlipayAuthReqVO;
import com.ebaiyihui.server.repository.AlipayAuthMapper;
import com.ebaiyihui.server.service.AlipayAuthService;
import com.ebaiyihui.server.service.AlipayConfigService;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AlipayAuthServiceImpl
implements AlipayAuthService {
    private static final Logger log = LoggerFactory.getLogger(AlipayAuthServiceImpl.class);
    @Autowired
    private AlipayConfigService alipayConfigService;
    @Autowired
    private AlipayAuthMapper alipayAuthMapper;
    private static final String GRANTYPE = "authorization_code";
    private static final String SIGN_TYPE = "RSA2";

    public BaseResponse<AlipayUserInfoShareResponse> alipayAuth(AlipayAuthReqVO alipayAuthReqVO) {
        UcAlipayConfigEntity entity = this.alipayConfigService.getByAppCode(alipayAuthReqVO.getAppCode());
        if (Objects.isNull(entity)) {
            return BaseResponse.error((String)"\u652f\u4ed8\u5b9d\u5c0f\u7a0b\u5e8f\u914d\u7f6e\u53c2\u6570\u4e0d\u5b58\u5728");
        }
        AlipayConfig alipayConfig = new AlipayConfig();
        alipayConfig.setAppId(entity.getAppId());
        alipayConfig.setPrivateKey(entity.getPrimaryKey());
        alipayConfig.setAlipayPublicKey(entity.getPublicKey());
        DefaultAlipayClient alipayClient = new DefaultAlipayClient(alipayConfig.getServerUrl(), entity.getAppId(), entity.getPrimaryKey(), alipayConfig.getFormat(), alipayConfig.getCharset(), entity.getPublicKey(), SIGN_TYPE);
        AlipaySystemOauthTokenRequest request = new AlipaySystemOauthTokenRequest();
        request.setGrantType(GRANTYPE);
        request.setCode(alipayAuthReqVO.getCode());
        log.info("\u652f\u4ed8\u5b9d\u6388\u6743\u5165\u53c2{}", (Object)JSON.toJSONString((Object)request));
        AlipaySystemOauthTokenResponse response = null;
        try {
            response = (AlipaySystemOauthTokenResponse)alipayClient.execute((AlipayRequest)request);
            log.info("\u652f\u4ed8\u5b9d\u6388\u6743\u8fd4\u56de\u7ed3\u679c{}", (Object)JSON.toJSONString((Object)response));
        }
        catch (AlipayApiException e) {
            log.error("\u51fa\u73b0\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
            return BaseResponse.error((String)"\u652f\u4ed8\u5b9d\u6388\u6743\u5931\u8d25\uff0c\u8bf7\u6c42\u652f\u4ed8\u5b9d\u63a5\u53e3\u9519\u8bef");
        }
        if (response.isSuccess()) {
            AlipayUserInfoShareRequest userInfoShareRequest = new AlipayUserInfoShareRequest();
            AlipayUserInfoShareResponse userInfoShareResponse = null;
            try {
                userInfoShareResponse = (AlipayUserInfoShareResponse)alipayClient.execute((AlipayRequest)userInfoShareRequest, response.getAccessToken());
            }
            catch (AlipayApiException e) {
                log.error("\u51fa\u73b0\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
                return BaseResponse.error((String)"\u652f\u4ed8\u5b9d\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
            }
            if (userInfoShareResponse.isSuccess()) {
                return BaseResponse.success((Object)userInfoShareResponse);
            }
        }
        return BaseResponse.error((String)"\u652f\u4ed8\u5b9d\u6388\u6743\u5931\u8d25");
    }

    public Optional<UcAlipayAuthEntity> findByAlipayUserIdAndUserTypeAndAppCodeAndStatus(String alipayUserId, Integer userType, String appCode, Integer status) {
        Optional optional = this.alipayAuthMapper.findByAlipayUserIdAndUserTypeAndAppCodeAndStatus(alipayUserId, userType, appCode, status);
        return optional;
    }

    public Optional<UcAlipayAuthEntity> findByUserIdAndUserType(String userId, Integer userType) {
        Optional optional = this.alipayAuthMapper.findByUserIdAndUserType(userId, userType);
        return optional;
    }

    public BaseResponse<AlipaySystemOauthTokenResponse> alipayUserId(AlipayAuthReqVO alipayAuthReqVO) {
        UcAlipayConfigEntity entity = this.alipayConfigService.getByAppCode(alipayAuthReqVO.getAppCode());
        if (Objects.isNull(entity)) {
            return BaseResponse.error((String)"\u652f\u4ed8\u5b9d\u5c0f\u7a0b\u5e8f\u914d\u7f6e\u53c2\u6570\u4e0d\u5b58\u5728");
        }
        AlipayConfig alipayConfig = new AlipayConfig();
        alipayConfig.setAppId(entity.getAppId());
        alipayConfig.setPrivateKey(entity.getPrimaryKey());
        alipayConfig.setAlipayPublicKey(entity.getPublicKey());
        DefaultAlipayClient alipayClient = new DefaultAlipayClient(alipayConfig.getServerUrl(), entity.getAppId(), entity.getPrimaryKey(), alipayConfig.getFormat(), alipayConfig.getCharset(), entity.getPublicKey(), SIGN_TYPE);
        AlipaySystemOauthTokenRequest request = new AlipaySystemOauthTokenRequest();
        request.setGrantType(GRANTYPE);
        request.setCode(alipayAuthReqVO.getCode());
        log.info("\u652f\u4ed8\u5b9d\u6388\u6743\u5165\u53c2{}", (Object)JSON.toJSONString((Object)request));
        AlipaySystemOauthTokenResponse response = null;
        try {
            response = (AlipaySystemOauthTokenResponse)alipayClient.execute((AlipayRequest)request);
            log.info("\u652f\u4ed8\u5b9d\u6388\u6743\u8fd4\u56de\u7ed3\u679c{}", (Object)JSON.toJSONString((Object)response));
        }
        catch (AlipayApiException e) {
            log.error("\u51fa\u73b0\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
            return BaseResponse.error((String)"\u652f\u4ed8\u5b9d\u6388\u6743\u5931\u8d25\uff0c\u8bf7\u6c42\u652f\u4ed8\u5b9d\u63a5\u53e3\u9519\u8bef");
        }
        return BaseResponse.success((Object)response);
    }
}

