/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.common.enums.ErrorEnum;
import com.ebaiyihui.common.pojo.login.UcWxAuthReqVo;
import com.ebaiyihui.common.pojo.login.UcWxAuthRespVo;
import com.ebaiyihui.common.pojo.login.WechatRespVO;
import com.ebaiyihui.common.pojo.login.WxBindingReqVo;
import com.ebaiyihui.common.pojo.vo.GetWxOpenidReqVO;
import com.ebaiyihui.common.pojo.vo.GetWxOpenidRespVO;
import com.ebaiyihui.common.pojo.vo.OperateWxInfoSomeReqVo;
import com.ebaiyihui.common.pojo.vo.OperateWxInfoSomeRespVo;
import com.ebaiyihui.common.pojo.vo.WxApiEntryReqVO;
import com.ebaiyihui.common.pojo.vo.WxAppletReqVO;
import com.ebaiyihui.common.pojo.wxauth.WxUnbindingReqVo;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import com.ebaiyihui.framework.utils.GetPhoneNumberUtil;
import com.ebaiyihui.framework.utils.HttpUtils;
import com.ebaiyihui.server.enums.WxAuthEnums;
import com.ebaiyihui.server.pojo.entity.UcWxAppletConfigEntity;
import com.ebaiyihui.server.pojo.entity.UcWxAuthEntity;
import com.ebaiyihui.server.pojo.vo.GetWxAccessTokenRespVo;
import com.ebaiyihui.server.repository.UcWxAppletConfigMapper;
import com.ebaiyihui.server.service.BaseService;
import com.ebaiyihui.server.service.IUcWxAuthService;
import com.ebaiyihui.server.util.RedisUtil;
import com.ebaiyihui.server.util.RestTemplateUtils;
import com.ebaiyihui.server.util.WXLabelUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class UcWxAuthServiceImpl
extends BaseService
implements IUcWxAuthService {
    private static final Logger log = LoggerFactory.getLogger(UcWxAuthServiceImpl.class);
    @Autowired
    private UcWxAppletConfigMapper ucWxAppletConfigMapper;
    @Autowired
    private RedisUtil redisUtil;
    private static boolean RETRY_FLAG = false;

    public BaseResponse<UcWxAuthRespVo> getWxAuthByCondition(UcWxAuthReqVo ucWxAuthReqVo) {
        log.info("getWxAuth \u6839\u636e\u8d26\u6237\u7684userID\u67e5\u8be2\u5fae\u4fe1\u6388\u6743\u4fe1\u606f [\u5165\u53c2]{}", (Object)JSON.toJSONString((Object)ucWxAuthReqVo));
        Optional entityOptional = this.ucWxAuthMapper.findByUserIdAndUserType(ucWxAuthReqVo.getUserId(), ucWxAuthReqVo.getUserType());
        if (!entityOptional.isPresent()) {
            log.info("getWxAuth \u6839\u636e\u8d26\u6237\u7684userID\u67e5\u8be2\u5fae\u4fe1\u6388\u6743\u4fe1\u606f,\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a,userId={},userType={}", (Object)ucWxAuthReqVo.getUserId(), (Object)ucWxAuthReqVo.getUserType());
            return BaseResponse.success();
        }
        UcWxAuthEntity ucWxAuthEntity = (UcWxAuthEntity)entityOptional.get();
        return BaseResponse.success((Object)this.buildWxBaseRespVo(ucWxAuthEntity));
    }

    public BaseResponse<String> getPhoneNumber(String encrypdata, String ivdata, String sessionId) {
        log.info("\u83b7\u53d6\u5fae\u4fe1\u624b\u673a\u53f7 [\u5165\u53c2]encrypdata: {}, ivdata: {}, sessionId: {}", new Object[]{encrypdata, ivdata, sessionId});
        if (org.springframework.util.StringUtils.isEmpty((Object)encrypdata) || org.springframework.util.StringUtils.isEmpty((Object)ivdata) || org.springframework.util.StringUtils.isEmpty((Object)sessionId)) {
            return BaseResponse.error((IError)ErrorEnum.INVALID_PARAMETER);
        }
        String sessionkey = null;
        try {
            sessionkey = this.redisUtil.get(sessionId).toString();
        }
        catch (Exception e) {
            log.error("\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6sessionkey \u5f02\u5e38:{}", (Throwable)e);
            return BaseResponse.error((IError)IError.DATA_NOT_EXIST, (String)"sessionkey\u5df2\u5931\u6548");
        }
        try {
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)sessionkey)) {
                return BaseResponse.error((IError)IError.DATA_NOT_EXIST, (String)"sessionkey\u5df2\u5931\u6548");
            }
            JSONObject jsonObject = GetPhoneNumberUtil.getPhoneNumber((String)sessionkey, (String)encrypdata, (String)ivdata);
            log.info("jsonObject\u89e3\u6790:[" + jsonObject + "]");
            String phone = "phoneNumber";
            if (jsonObject == null || jsonObject.isEmpty() || jsonObject.get((Object)phone) == null) {
                log.info("\u83b7\u53d6\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u624b\u673a\u53f7 jsonObject.isEmpty");
                return BaseResponse.error((IError)ErrorEnum.WX_GET_PHONE_FAILED);
            }
            String phoneNumber = (String)jsonObject.get((Object)phone);
            return BaseResponse.success((Object)phoneNumber);
        }
        catch (Exception e) {
            log.info("\u83b7\u53d6\u5fae\u4fe1\u624b\u673a\u53f7\u5931\u8d25 {}", (Throwable)e);
            return BaseResponse.error((IError)ErrorEnum.WX_GET_PHONE_FAILED);
        }
    }

    public BaseResponse<OperateWxInfoSomeRespVo> operateWxInfoSome(OperateWxInfoSomeReqVo operateWxInfoSomeReqVo) {
        log.error("\u66f4\u65b0\u5fae\u4fe1\u7ed1\u5b9a\u4fe1\u606f operateWxInfoSomeReqVo:{}", (Object)operateWxInfoSomeReqVo);
        Optional optional = this.ucWxAuthMapper.findByUserIdAndUserType(operateWxInfoSomeReqVo.getUserId(), operateWxInfoSomeReqVo.getUserType());
        if (optional.isPresent()) {
            UcWxAuthEntity wxAuthEntity = (UcWxAuthEntity)optional.get();
            if (WxAuthEnums.WxAuthOperationEnum.INSERT_WXINFO.getValue().equals(operateWxInfoSomeReqVo.getOperateType())) {
                log.error("\u66f4\u65b0\u5fae\u4fe1\u7ed1\u5b9a\u4fe1\u606f \u6dfb\u52a0\u4fe1\u606f");
                wxAuthEntity.setHeadPortrait(operateWxInfoSomeReqVo.getHeadPortrait());
                wxAuthEntity.setNickname(operateWxInfoSomeReqVo.getNickname());
                wxAuthEntity.setUpdateTime(new Date());
                this.ucWxAuthMapper.updateByPrimaryKeySelective(wxAuthEntity);
            } else if (WxAuthEnums.WxAuthOperationEnum.DEL_WXINFO.getValue().equals(operateWxInfoSomeReqVo.getOperateType())) {
                log.error("\u66f4\u65b0\u5fae\u4fe1\u7ed1\u5b9a\u4fe1\u606f \u6e05\u695a\u4fe1\u606f");
                wxAuthEntity.setHeadPortrait("");
                wxAuthEntity.setNickname("");
                wxAuthEntity.setUpdateTime(new Date());
                this.ucWxAuthMapper.updateByPrimaryKeySelective(wxAuthEntity);
            }
            OperateWxInfoSomeRespVo vo = new OperateWxInfoSomeRespVo();
            BeanUtils.copyProperties((Object)wxAuthEntity, (Object)vo);
            return BaseResponse.success((Object)vo);
        }
        log.error("\u66f4\u65b0\u5fae\u4fe1\u7ed1\u5b9a\u4fe1\u606f \u5931\u8d25openId:{}", (Object)operateWxInfoSomeReqVo.getWxOpenid());
        return BaseResponse.error((IError)ErrorEnum.WX_MSG_EMPTY);
    }

    public BaseResponse<UcWxAuthRespVo> wxBinding(WxBindingReqVo wxBindingReqVo) {
        log.info("\u5fae\u4fe1\u8d26\u53f7\u7ed1\u5b9a  \u5173\u6ce8\u5fae\u4fe1\u516c\u4f17\u53f7  \u8bf7\u6c42\u53c2\u6570{}", (Object)wxBindingReqVo);
        new Thread(() -> WXLabelUtil.accessToken((RestTemplate)this.restTemplate, (RedisUtil)this.redisUtil, (String)this.projProperties.getWxAppid(), (String)this.projProperties.getWxSecret(), (String)wxBindingReqVo.getWxOpenid(), (String)"\u7528\u6237")).start();
        log.info("\u5fae\u4fe1\u8d26\u53f7\u7ed1\u5b9a \u5165\u53c2\uff1awxBindingReqVo\uff1a{}", (Object)wxBindingReqVo);
        Optional wxopenIdOptional = this.ucWxAuthMapper.findByWxOpenidAndSubordinateTypeAndAppIdTypeAndStatus(wxBindingReqVo.getWxOpenid(), wxBindingReqVo.getSubordinateType(), wxBindingReqVo.getAppIdType(), WxAuthEnums.WxAuthStatusEnum.NORMAL.getValue());
        Optional userOptional = this.ucWxAuthMapper.findByUserIdAndUserType(wxBindingReqVo.getUserId(), wxBindingReqVo.getUserType());
        boolean userIdExist = userOptional.isPresent();
        boolean openIdExist = wxopenIdOptional.isPresent();
        log.info("\u5fae\u4fe1\u8d26\u53f7\u7ed1\u5b9a userIdExist:{},openIdExist:{}", (Object)userIdExist, (Object)openIdExist);
        if (userIdExist || openIdExist) {
            if (openIdExist && userIdExist) {
                if (((UcWxAuthEntity)userOptional.get()).getAccountId().equals(((UcWxAuthEntity)wxopenIdOptional.get()).getAccountId())) {
                    log.info("\u5fae\u4fe1\u8d26\u53f7\u7ed1\u5b9a \u540c\u4e00\u6761\u8bb0\u5f55 \u6210\u529f {}", wxopenIdOptional.get());
                    return BaseResponse.success((Object)this.buildWxBaseRespVo((UcWxAuthEntity)wxopenIdOptional.get()));
                }
                UcWxAuthEntity openidWxAuth = (UcWxAuthEntity)wxopenIdOptional.get();
                openidWxAuth.setStatus(WxAuthEnums.WxAuthStatusEnum.UNBIND.getValue());
                this.ucWxAuthMapper.updateByPrimaryKeySelective(openidWxAuth);
                UcWxAuthEntity userIdWxAuth = (UcWxAuthEntity)userOptional.get();
                BeanUtils.copyProperties((Object)wxBindingReqVo, (Object)userIdWxAuth);
                userIdWxAuth.setStatus(WxAuthEnums.WxAuthStatusEnum.NORMAL.getValue());
                userIdWxAuth.setUpdateTime(new Date());
                this.ucWxAuthMapper.updateByPrimaryKeySelective(userIdWxAuth);
                log.info("openid,userid\u5747\u5df2\u5b58\u5728\uff0c\u4e24\u6761\u8bb0\u5f55\uff0c\u5148\u89e3\u7ed1\u518d\u66f4\u65b0\u7ed1\u5b9a--\u300b{}", (Object)JSON.toJSONString((Object)userIdWxAuth));
                return BaseResponse.success((Object)this.buildWxBaseRespVo(userIdWxAuth));
            }
            if (openIdExist) {
                UcWxAuthEntity openidWxAuth = (UcWxAuthEntity)wxopenIdOptional.get();
                openidWxAuth.setStatus(WxAuthEnums.WxAuthStatusEnum.UNBIND.getValue());
                this.ucWxAuthMapper.updateByPrimaryKeySelective(openidWxAuth);
                log.info("openid\u5df2\u5b58\u5728\uff0c\u5148\u89e3\u7ed1--\u300b{}", (Object)openidWxAuth.getAccountId());
                UcWxAuthEntity userIdWxAuth = new UcWxAuthEntity();
                BeanUtils.copyProperties((Object)wxBindingReqVo, (Object)userIdWxAuth);
                userIdWxAuth.setStatus(WxAuthEnums.WxAuthStatusEnum.NORMAL.getValue());
                userIdWxAuth.setCreateTime(new Date());
                log.info("openid\u5df2\u5b58\u5728\uff0c\u518d\u6dfb\u52a0\u7ed1\u5b9a--\u300b{}", (Object)JSON.toJSONString((Object)userIdWxAuth));
                this.ucWxAuthMapper.insertSelective(userIdWxAuth);
                return BaseResponse.success((Object)this.buildWxBaseRespVo(userIdWxAuth));
            }
            UcWxAuthEntity wxAuthEntity = (UcWxAuthEntity)userOptional.get();
            BeanUtils.copyProperties((Object)wxBindingReqVo, (Object)wxAuthEntity);
            wxAuthEntity.setStatus(WxAuthEnums.WxAuthStatusEnum.NORMAL.getValue());
            wxAuthEntity.setUpdateTime(new Date());
            this.ucWxAuthMapper.updateByPrimaryKeySelective(wxAuthEntity);
            log.info("\u5fae\u4fe1\u8d26\u53f7\u7ed1\u5b9a userId\u5b58\u5728 \u6210\u529f {}", (Object)wxAuthEntity);
            return BaseResponse.success((Object)this.buildWxBaseRespVo(wxAuthEntity));
        }
        UcWxAuthEntity wxAuth = new UcWxAuthEntity();
        BeanUtils.copyProperties((Object)wxBindingReqVo, (Object)wxAuth);
        wxAuth.setCreateTime(new Date());
        wxAuth.setUpdateTime(new Date());
        wxAuth.setStatus(WxAuthEnums.WxAuthStatusEnum.NORMAL.getValue());
        this.ucWxAuthMapper.save(wxAuth);
        log.info("\u5fae\u4fe1\u8d26\u53f7\u7ed1\u5b9a \u65b0\u589e \u6210\u529f {}", (Object)wxAuth);
        return BaseResponse.success((Object)this.buildWxBaseRespVo(wxAuth));
    }

    public BaseResponse<UcWxAuthRespVo> wxUnbinding(WxUnbindingReqVo reqVo) {
        Optional wxAuthEntityOptional = this.ucWxAuthMapper.findByUserIdAndUserType(reqVo.getUserId(), reqVo.getUserType());
        if (wxAuthEntityOptional.isPresent()) {
            UcWxAuthEntity wxAuthEntity = (UcWxAuthEntity)wxAuthEntityOptional.get();
            wxAuthEntity.setStatus(WxAuthEnums.WxAuthStatusEnum.UNBIND.getValue());
            this.ucWxAuthMapper.updateByPrimaryKeySelective(wxAuthEntity);
            return BaseResponse.success();
        }
        log.info("\u7528\u6237userId[{}]\u5fae\u4fe1\u4fe1\u606f\u4e3a\u7a7a", (Object)reqVo.getUserId());
        return BaseResponse.error((IError)ErrorEnum.WX_MSG_EMPTY);
    }

    @Async
    public int saveWxAuth(String openid, Short subordinateType, String unionid, String appIdType) {
        log.info("\u4fdd\u5b58\u5fae\u4fe1\u4fe1\u606f openid:{},subordinateType:{},appIdType:{}", new Object[]{openid, subordinateType, appIdType});
        List list = this.ucWxAuthMapper.findByOpenIdAndSubordinateTypeAndAppIdType(openid, subordinateType, appIdType);
        if (list == null || list.isEmpty()) {
            UcWxAuthEntity ucWxAuthEntity = new UcWxAuthEntity();
            ucWxAuthEntity.setAppIdType(appIdType);
            ucWxAuthEntity.setCreateTime(new Date());
            ucWxAuthEntity.setStatus(WxAuthEnums.WxAuthStatusEnum.UNRELATED.getValue());
            ucWxAuthEntity.setSubordinateType(subordinateType);
            ucWxAuthEntity.setWxOpenid(openid);
            ucWxAuthEntity.setWxUnionid(unionid);
            return this.ucWxAuthMapper.insertSelective(ucWxAuthEntity);
        }
        return 0;
    }

    public BaseResponse<GetWxOpenidRespVO> getWxOpenid(GetWxOpenidReqVO getWxOpenidVO) {
        GetWxOpenidRespVO getWxOpenidRespVO = new GetWxOpenidRespVO();
        String appIdType = getWxOpenidVO.getAppIdType();
        UcWxAppletConfigEntity wxAppletConfig = this.getWxAppletConfig(appIdType);
        String wxAppid = wxAppletConfig.getAppletId();
        String wxSecret = wxAppletConfig.getAppletSecret();
        String wxcode = getWxOpenidVO.getCode();
        Short subordinateType = getWxOpenidVO.getSubordinateType();
        if (subordinateType == null) {
            subordinateType = WxAuthEnums.WxSubordinateTypeEnum.MINI_PROGRAM.getValue();
            if (appIdType.endsWith("_APP")) {
                subordinateType = WxAuthEnums.WxSubordinateTypeEnum.APP.getValue();
            }
        }
        try {
            String result;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("appid", (Object)wxAppid);
            jsonObject.put("secret", (Object)wxSecret);
            jsonObject.put("grant_type", (Object)"authorization_code");
            if (WxAuthEnums.WxSubordinateTypeEnum.MINI_PROGRAM.getValue().equals(subordinateType)) {
                String openidUrl = this.projProperties.getWxChatOpenIdDomain();
                jsonObject.put("js_code", (Object)wxcode);
                result = RestTemplateUtils.get((String)openidUrl, (JSONObject)jsonObject);
                log.info("\u5c0f\u7a0b\u5e8f==\u83b7\u53d6\u5fae\u4fe1openId==openidUrl:{},==result:{}", (Object)openidUrl, (Object)result);
            } else if (WxAuthEnums.WxSubordinateTypeEnum.APP.getValue().equals(subordinateType)) {
                String openidUrl = this.projProperties.getAppOpenIdDomain();
                jsonObject.put("code", (Object)wxcode);
                result = RestTemplateUtils.get((String)openidUrl, (JSONObject)jsonObject);
                log.info("APP==\u83b7\u53d6\u5fae\u4fe1openId==openidUrl:{},==result:{}", (Object)openidUrl, (Object)result);
            } else {
                return BaseResponse.error((IError)ErrorEnum.INVALID_PARAMETER);
            }
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)result)) {
                log.info("\u83b7\u53d6\u5f53\u524d\u5fae\u4fe1\u7528\u6237openId \u5f02\u5e38,\u8fd4\u56de:{}", (Object)result);
                return BaseResponse.error((IError)ErrorEnum.SYSTEM_BUSY);
            }
            JSONObject session = JSONObject.parseObject((String)result);
            String errcode = session.getString("errcode");
            String errmsg = session.getString("errmsg");
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)errcode) && !"0".equalsIgnoreCase(errcode)) {
                switch (errcode) {
                    case "-1": {
                        return BaseResponse.error((IError)ErrorEnum.WX_SYSTEM_BUSY, (String)errmsg);
                    }
                    case "40029": {
                        return BaseResponse.error((IError)ErrorEnum.WX_CODE_INVALID, (String)errmsg);
                    }
                    case "45011": {
                        return BaseResponse.error((IError)ErrorEnum.WX_FREQUENCY_LIMIT, (String)errmsg);
                    }
                    case "41008": {
                        return BaseResponse.error((IError)ErrorEnum.WX_CODE_INVALID, (String)errmsg);
                    }
                }
                return BaseResponse.error((IError)ErrorEnum.WX_SYSTEM_BUSY, (String)errmsg);
            }
            String openId = session.getString("openid");
            String unionId = session.getString("unionid");
            if (WxAuthEnums.WxSubordinateTypeEnum.APP.getValue().equals(subordinateType)) {
                String accessToken = session.getString("access_token");
                String expiresIn = session.getString("expires_in");
                String refreshToken = session.getString("refresh_token");
                String scope = session.getString("scope");
                getWxOpenidRespVO.setAccessToken(accessToken);
                getWxOpenidRespVO.setExpiresIn(expiresIn);
                getWxOpenidRespVO.setScope(scope);
                getWxOpenidRespVO.setRefreshToken(refreshToken);
            } else if (WxAuthEnums.WxSubordinateTypeEnum.MINI_PROGRAM.getValue().equals(subordinateType)) {
                String sessionkey = session.getString("session_key");
                getWxOpenidRespVO.setSessionId(this.cacheService.cacheWxSessionKey(sessionkey, openId));
            }
            getWxOpenidRespVO.setCode(wxcode);
            getWxOpenidRespVO.setOpenid(openId);
            getWxOpenidRespVO.setUnionid(unionId);
            this.saveWxAuth(openId, subordinateType, unionId, appIdType);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5f53\u524d\u5fae\u4fe1\u7528\u6237openId\u5931\u8d25,Message:{},{}", (Object)e.getMessage(), (Object)e);
            return BaseResponse.error((String)("\u83b7\u53d6\u5f53\u524d\u5fae\u4fe1\u7528\u6237openId\u5931\u8d25" + e.getMessage()));
        }
        return BaseResponse.success((Object)getWxOpenidRespVO);
    }

    public BaseResponse<WechatRespVO> getWxApplet(WxAppletReqVO wxAppletReqVO) {
        GetWxOpenidReqVO reqVO = new GetWxOpenidReqVO(wxAppletReqVO);
        BaseResponse wxOpenidresp = this.getWxOpenid(reqVO);
        WechatRespVO outputVo = new WechatRespVO();
        if (!wxOpenidresp.isSuccess() || wxOpenidresp.getData() == null) {
            return BaseResponse.error((IError)ErrorEnum.WX_AUTHORIZATION_FAILED);
        }
        Optional optional = this.ucWxAuthMapper.findByUserIdAndUserType(wxAppletReqVO.getUserId(), wxAppletReqVO.getUserType());
        UcWxAuthEntity ucWxAuthEntity = new UcWxAuthEntity();
        ucWxAuthEntity.setAccountId(wxAppletReqVO.getAccountId());
        ucWxAuthEntity.setUserId(wxAppletReqVO.getUserId());
        ucWxAuthEntity.setWxOpenid(((GetWxOpenidRespVO)wxOpenidresp.getData()).getOpenid());
        ucWxAuthEntity.setWxUnionid(((GetWxOpenidRespVO)wxOpenidresp.getData()).getUnionid());
        ucWxAuthEntity.setUserType(wxAppletReqVO.getUserType());
        ucWxAuthEntity.setSubordinateType(wxAppletReqVO.getSubordinateType());
        ucWxAuthEntity.setAppIdType(wxAppletReqVO.getAppIdType());
        ucWxAuthEntity.setStatus(WxAuthEnums.WxAuthStatusEnum.NORMAL.getValue());
        ucWxAuthEntity.setUpdateTime(new Date());
        if (optional.isPresent()) {
            ucWxAuthEntity.setId(((UcWxAuthEntity)optional.get()).getId());
        } else {
            ucWxAuthEntity.setCreateTime(new Date());
        }
        WxBindingReqVo wxBindingReqVo = new WxBindingReqVo();
        BeanUtils.copyProperties((Object)ucWxAuthEntity, (Object)wxBindingReqVo);
        this.wxBinding(wxBindingReqVo);
        outputVo.setOpenId(((GetWxOpenidRespVO)wxOpenidresp.getData()).getOpenid());
        outputVo.setUnionId(((GetWxOpenidRespVO)wxOpenidresp.getData()).getUnionid());
        return BaseResponse.success((Object)outputVo);
    }

    public BaseResponse getWxApiEntry(WxApiEntryReqVO reqVO) {
        String wxAccessToken = this.getWxAccessToken(reqVO.getAppCode());
        String body = JSON.toJSONString((Object)reqVO.getParams());
        log.info("\u8c03\u7528\u7684\u5730\u5740\u4e3a:{}", (Object)reqVO.getUrl());
        log.info("\u8bf7\u6c42\u7684\u53c2\u6570\u4e3a:{}", (Object)body);
        try {
            String ret = HttpUtils.post((String)(reqVO.getUrl() + "?access_token=" + wxAccessToken), (String)body);
            log.info("\u8bf7\u6c42\u7684\u8fd4\u56de\u7ed3\u679c\u4e3a:{}", (Object)ret);
            Map resMap = (Map)JSON.parse((String)ret);
            if (0 == (Integer)resMap.get("errcode")) {
                BaseResponse baseResponse = BaseResponse.success((Object)resMap);
                return baseResponse;
            }
            if (40001 == (Integer)resMap.get("errcode") && !RETRY_FLAG) {
                this.redisUtil.del(new String[]{"wx_access_token_key_" + reqVO.getAppCode()});
                RETRY_FLAG = true;
                log.info("\u8fdb\u5165\u8bf7\u6c42\u91cd\u8bd5");
                BaseResponse baseResponse = this.getWxApiEntry(reqVO);
                return baseResponse;
            }
            BaseResponse responseError = BaseResponse.error((String)((String)resMap.get("errmsg")));
            responseError.setErrCode(resMap.get("errcode").toString());
            BaseResponse baseResponse = responseError;
            return baseResponse;
        }
        catch (Exception e) {
            throw new RuntimeException("\u8c03\u7528\u5c0f\u7a0b\u5e8fapi\u5f02\u5e38", e);
        }
        finally {
            RETRY_FLAG = false;
        }
    }

    private String getWxAccessToken(String appCode) {
        Optional ucWxAppletConfigEntity1;
        String accessToken = (String)this.redisUtil.get("wx_access_token_key_" + appCode);
        if (StringUtils.isEmpty((String)accessToken) && (ucWxAppletConfigEntity1 = this.ucWxAppletConfigMapper.selectByAppIdType(appCode)).isPresent()) {
            UcWxAppletConfigEntity ucWxAppletConfigEntity = (UcWxAppletConfigEntity)ucWxAppletConfigEntity1.get();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("grant_type", "client_credential");
            map.put("appid", ucWxAppletConfigEntity.getAppletId());
            map.put("secret", ucWxAppletConfigEntity.getAppletSecret());
            String ret = HttpUtils.get((String)"https://api.weixin.qq.com/cgi-bin/token", map);
            log.info("\u83b7\u53d6\u5fae\u4fe1token\u8fd4\u56de\u7ed3\u679c:{}", (Object)ret);
            if (StringUtils.isEmpty((String)ret)) {
                return accessToken;
            }
            GetWxAccessTokenRespVo getWxAccessTokenRespVo = (GetWxAccessTokenRespVo)JSON.parseObject((String)ret, GetWxAccessTokenRespVo.class);
            if (getWxAccessTokenRespVo.getErrcode() != 0) {
                log.error("\u83b7\u53d6\u5fae\u4fe1token\u5931\u8d25:{}", (Object)getWxAccessTokenRespVo.getErrmsg());
                return accessToken;
            }
            accessToken = getWxAccessTokenRespVo.getAccess_token();
        }
        return accessToken;
    }

    private UcWxAuthRespVo buildWxBaseRespVo(UcWxAuthEntity ucWxAuthEntity) {
        UcWxAuthRespVo ucWxAuthRespVo = new UcWxAuthRespVo();
        BeanUtils.copyProperties((Object)ucWxAuthEntity, (Object)ucWxAuthRespVo);
        if (StringUtils.isEmpty((String)ucWxAuthEntity.getNickname()) && StringUtils.isEmpty((String)ucWxAuthEntity.getHeadPortrait())) {
            ucWxAuthRespVo.setIsPerfect(Boolean.valueOf(false));
        } else {
            ucWxAuthRespVo.setIsPerfect(Boolean.valueOf(true));
        }
        log.info("\u5fae\u4fe1\u6388\u6743\u4fe1\u606f==>{}", (Object)JSON.toJSONString((Object)ucWxAuthRespVo));
        return ucWxAuthRespVo;
    }
}

