/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.config;

import com.ebaiyihui.common.enums.ErrorEnum;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import com.ebaiyihui.server.exception.BusinessException;
import com.ebaiyihui.server.exception.UserCenterRuntimeException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@ControllerAdvice
public class GlobalDefaultExceptionHandler {
    private static final Logger logger = LoggerFactory.getLogger(GlobalDefaultExceptionHandler.class);

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public BaseResponse<String> handleException(HttpServletRequest req, Exception ex) {
        logger.error("\u7cfb\u7edf\u9519\u8bef\uff01uri:{},\u9519\u8bef\u4fe1\u606f:{}", (Object)req.getRequestURI(), (Object)ex);
        return BaseResponse.error((IError)ErrorEnum.SYSYTEM_UNKNOW);
    }

    @ExceptionHandler(value={BusinessException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public BaseResponse<String> handleBusinessException(HttpServletRequest req, BusinessException ex) {
        logger.error("\u4e1a\u52a1\u5f02\u5e38\uff01uri:[{}],\u9519\u8bef\u4fe1\u606f:[{}]", (Object)req.getRequestURI(), (Object)ex.getMessage());
        return BaseResponse.error((IError)ErrorEnum.getEnum((String)ex.getErrorCode()), (String)ex.getMessage());
    }

    @ExceptionHandler(value={UserCenterRuntimeException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public BaseResponse<String> handleRUserCenterExcepition(HttpServletRequest req, UserCenterRuntimeException ex) {
        logger.error("\u7528\u6237\u4e2d\u5fc3\u81ea\u5b9a\u4e49\u8fd0\u884c\u671f\u5f02\u5e38\uff01uri:[{}],\u9519\u8bef\u4fe1\u606f:[{}{}]", new Object[]{req.getRequestURI(), ex.getErrorEnum(), ex.getMessage()});
        return BaseResponse.error((IError)ex.getErrorEnum(), (String)ex.getMessage());
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public BaseResponse<String> handlerMissingParameterExcepition(HttpServletRequest req, MissingServletRequestParameterException ex) {
        logger.error("\u53c2\u6570\u7f3a\u5931\u5f02\u5e38\uff01uri:[{}],\u9519\u8bef\u4fe1\u606f:[{}]", (Object)req.getRequestURI(), (Object)ex.getMessage());
        return BaseResponse.error((IError)ErrorEnum.MISSING_PARAMETER, (String)ex.getMessage());
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public BaseResponse<String> handleParamCheckExcepion(HttpServletRequest req, MethodArgumentNotValidException ex) {
        BindingResult bindingResult = ex.getBindingResult();
        StringBuilder paramErrorMsg = new StringBuilder();
        if (bindingResult.hasErrors()) {
            List allErrors = bindingResult.getAllErrors();
            for (ObjectError objectError : allErrors) {
                String msg = objectError.getDefaultMessage();
                if (paramErrorMsg.length() == 0) {
                    paramErrorMsg.append(msg);
                    continue;
                }
                paramErrorMsg.append(',');
                paramErrorMsg.append(msg);
            }
        }
        logger.error("\u53c2\u6570\u6821\u9a8c\u5931\u8d25! uri:{},\u9519\u8bef\u4fe1\u606f:{}", (Object)req.getRequestURI(), (Object)paramErrorMsg.toString());
        return BaseResponse.error((IError)IError.PARAM_CHECK_FAILD, (String)paramErrorMsg.toString());
    }
}

