/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlinebooking.controller;

import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.onlinebooking.model.OnlineBookingOrderEntity;
import com.ebaiyihui.onlinebooking.service.OnlineBookingOrderService;
import com.ebaiyihui.onlinebooking.service.OrderItemRelationService;
import com.ebaiyihui.onlinebooking.vo.SearchBookOrderDetailsResponseVo;
import com.ebaiyihui.onlinebooking.vo.SearchBookOrderListResponseVo;
import com.ebaiyihui.onlinebooking.vo.SearchBookingOrderRequestVo;
import com.ebaiyihui.onlinebooking.vo.UpdateOrderStateVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5728\u7ebf\u9884\u7ea6\u8ba2\u5355\u63a5\u53e3"})
@RequestMapping(value={"/api/v1/booking_order"})
public class OnlineBookingOrderController {
    private static final Logger log = LoggerFactory.getLogger(OnlineBookingOrderController.class);
    @Autowired
    private OnlineBookingOrderService onlineBookingOrderService;
    @Autowired
    private OrderItemRelationService orderItemRelationService;

    @GetMapping(value={"/get_page_booking_order_by_search_param"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u8ba2\u5355\u5217\u8868\u6761\u4ef6")
    public BaseResponse<PageResult<SearchBookOrderListResponseVo>> getPageBookingOrderBySearParam(@Valid SearchBookingOrderRequestVo searchBookingOrderRequestVo, BindingResult bindingResult) {
        if (bindingResult.hasFieldErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        PageResult pageResult = this.onlineBookingOrderService.getPageBookingOrderBySearParam(searchBookingOrderRequestVo);
        log.info("response: {}", (Object)pageResult.toString());
        return BaseResponse.success((Object)pageResult);
    }

    @ApiOperation(value="\u67e5\u8be2\u8ba2\u5355\u8be6\u60c5")
    @GetMapping(value={"/get_detail_booking_order_by_id"})
    public BaseResponse<SearchBookOrderDetailsResponseVo> getDetailBookingOrderById(@RequestParam(value="id") Long id) {
        SearchBookOrderDetailsResponseVo bookOrderDetailsResponseVo = this.onlineBookingOrderService.getDetailBookingOrderById(id);
        return BaseResponse.success((Object)bookOrderDetailsResponseVo);
    }

    @ApiOperation(value="\u4fee\u6539\u8ba2\u5355\u72b6\u6001")
    @PostMapping(value={"/update_order_state_by_id"})
    public BaseResponse updateOrderStateById(@Valid @RequestBody UpdateOrderStateVo updateOrderStateVo, BindingResult bindingResult) {
        if (bindingResult.hasFieldErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        this.onlineBookingOrderService.updateOrderStateById(updateOrderStateVo);
        return BaseResponse.success();
    }

    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u8ba2\u5355")
    @GetMapping(value={"getById"})
    public BaseResponse<OnlineBookingOrderEntity> getById(@RequestParam(value="id") Long id) {
        OnlineBookingOrderEntity onlineBookingOrder = this.onlineBookingOrderService.getById(id);
        return BaseResponse.success((Object)onlineBookingOrder);
    }

    @ApiOperation(value="\u4fdd\u5b58\u9884\u7ea6\u8ba2\u5355")
    @PostMapping(value={"save"})
    public BaseResponse<Long> save(@RequestBody OnlineBookingOrderEntity onlineBookingOrder, @RequestParam String ids) {
        Long id = this.onlineBookingOrderService.save(onlineBookingOrder);
        this.orderItemRelationService.save(id, ids);
        return BaseResponse.success((Object)id);
    }

    @ApiOperation(value="\u66f4\u65b0\u9884\u7ea6\u8ba2\u5355")
    @PostMapping(value={"update"})
    public BaseResponse<Long> update(@RequestBody OnlineBookingOrderEntity onlineBookingOrder) {
        this.onlineBookingOrderService.update(onlineBookingOrder);
        return BaseResponse.success();
    }
}

