/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlinebooking.service.impl;

import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.utils.IdCardUtil;
import com.ebaiyihui.framework.utils.UUIDUtils;
import com.ebaiyihui.onlinebooking.dao.OnlineBookingItemMapper;
import com.ebaiyihui.onlinebooking.dao.OnlineBookingOrderMapper;
import com.ebaiyihui.onlinebooking.model.OnlineBookingOrderEntity;
import com.ebaiyihui.onlinebooking.service.OnlineBookingOrderService;
import com.ebaiyihui.onlinebooking.vo.SearchBookOrderDetailsResponseVo;
import com.ebaiyihui.onlinebooking.vo.SearchBookOrderListResponseVo;
import com.ebaiyihui.onlinebooking.vo.SearchBookingOrderRequestVo;
import com.ebaiyihui.onlinebooking.vo.UpdateOrderStateVo;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class OnlineBookingOrderServiceImpl
implements OnlineBookingOrderService {
    @Autowired
    private OnlineBookingOrderMapper onlineBookingOrderMapper;
    @Autowired
    private OnlineBookingItemMapper onlineBookingItemMapper;

    public PageResult<SearchBookOrderListResponseVo> getPageBookingOrderBySearParam(SearchBookingOrderRequestVo searchBookingOrderRequestVo) {
        PageResult pageResult = new PageResult();
        PageHelper.startPage((int)searchBookingOrderRequestVo.getPageNum(), (int)searchBookingOrderRequestVo.getPageSize());
        Page page = this.onlineBookingOrderMapper.getPageBookingOrderBySearParam(searchBookingOrderRequestVo);
        List onlineBookingOrderList = page.getResult();
        if (CollectionUtils.isEmpty((Collection)onlineBookingOrderList)) {
            return pageResult;
        }
        List bookOrderListResponseVoList = this.convertOnlineBookingEntity(onlineBookingOrderList);
        pageResult.setContent(bookOrderListResponseVoList);
        Long total = page.getTotal();
        pageResult.setTotal(total.intValue());
        return pageResult;
    }

    private List<SearchBookOrderListResponseVo> convertOnlineBookingEntity(List<OnlineBookingOrderEntity> onlineBookingOrderList) {
        List<SearchBookOrderListResponseVo> bookOrderListResponseVoList = onlineBookingOrderList.stream().map(onlineBookingOrder -> {
            SearchBookOrderListResponseVo bookOrderListResponseVo = new SearchBookOrderListResponseVo();
            BeanUtils.copyProperties((Object)onlineBookingOrder, (Object)bookOrderListResponseVo);
            List bookingItemEntityList = this.onlineBookingItemMapper.getBookingItemByOrderId(onlineBookingOrder.getId());
            if (!CollectionUtils.isEmpty((Collection)bookingItemEntityList)) {
                List bookItemNameList = bookingItemEntityList.stream().map(bookingItemEntity -> bookingItemEntity.getName()).collect(Collectors.toList());
                String bookItemName = String.join((CharSequence)"\u3001 ", bookItemNameList);
                bookOrderListResponseVo.setBookingItemName(bookItemName);
            }
            if (StringUtils.isNotBlank((CharSequence)bookOrderListResponseVo.getPatientCardNo())) {
                Integer age = IdCardUtil.getAgeByIdCard((String)bookOrderListResponseVo.getPatientCardNo());
                bookOrderListResponseVo.setPatientAge(age);
                Integer gender = IdCardUtil.getGenderByIdCard((String)bookOrderListResponseVo.getPatientCardNo()) == "M" ? 1 : 2;
                bookOrderListResponseVo.setPatientGender(gender);
            }
            return bookOrderListResponseVo;
        }).collect(Collectors.toList());
        return bookOrderListResponseVoList;
    }

    public OnlineBookingOrderEntity getById(Long id) {
        return this.onlineBookingOrderMapper.getById(id);
    }

    public Long save(OnlineBookingOrderEntity onlineBookingOrder) {
        onlineBookingOrder.setStatus(Integer.valueOf(1));
        onlineBookingOrder.setViewId(UUIDUtils.getUUID());
        onlineBookingOrder.setOutTradeNo(System.currentTimeMillis() + "");
        this.onlineBookingOrderMapper.save(onlineBookingOrder);
        return onlineBookingOrder.getId();
    }

    public void update(OnlineBookingOrderEntity onlineBookingOrder) {
        this.onlineBookingOrderMapper.update(onlineBookingOrder);
    }

    public SearchBookOrderDetailsResponseVo getDetailBookingOrderById(Long id) {
        OnlineBookingOrderEntity onlineBookingOrderEntity = this.onlineBookingOrderMapper.getById(id);
        SearchBookOrderDetailsResponseVo bookOrderDetailsResponseVo = new SearchBookOrderDetailsResponseVo();
        BeanUtils.copyProperties((Object)onlineBookingOrderEntity, (Object)bookOrderDetailsResponseVo);
        String patientIdCard = bookOrderDetailsResponseVo.getPatientCardNo();
        if (StringUtils.isNotBlank((CharSequence)patientIdCard)) {
            Integer age = IdCardUtil.getAgeByIdCard((String)patientIdCard);
            bookOrderDetailsResponseVo.setPatientAge(age);
            Integer gender = IdCardUtil.getGenderByIdCard((String)patientIdCard) == "M" ? 1 : 2;
            bookOrderDetailsResponseVo.setPatientGender(gender);
        }
        List bookingItemEntityList = this.onlineBookingItemMapper.getBookingItemByOrderId(id);
        bookOrderDetailsResponseVo.setBookingItemEntityList(bookingItemEntityList);
        return bookOrderDetailsResponseVo;
    }

    public void updateOrderStateById(UpdateOrderStateVo updateOrderStateVo) {
        this.onlineBookingOrderMapper.updateOrderStateById(updateOrderStateVo);
    }
}

