/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.nst.server.config;

import java.util.HashMap;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.CustomExchange;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.Queue;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MQConfig {
    public static final String DEFAULT_EXCHANGE = "TXJH-DEFAULT-EXCHANGE";
    public static final String NEW_ORDER_QUEUE_NAME = "new.txorder.queue";
    public static final String CABINET_PWD_QUEUE_NAME = "cabinet.pwd.queue";
    public static final String NEW_ORDER_ROUTING_KEY = "new.txorder.queue.routing_key";
    public static final String CABINET_PWD_ROUTING_KEY = "cabinet.pwd.queue.routing_key";

    @Bean
    public Queue newOrderQueue() {
        return new Queue(NEW_ORDER_QUEUE_NAME);
    }

    @Bean
    public Queue cabinetPwdQueue() {
        return new Queue(CABINET_PWD_QUEUE_NAME);
    }

    @Bean
    Binding doctorNotOperation() {
        return BindingBuilder.bind((Queue)this.newOrderQueue()).to((Exchange)this.customExchange()).with(NEW_ORDER_ROUTING_KEY).noargs();
    }

    @Bean
    Binding cabinetPwd() {
        return BindingBuilder.bind((Queue)this.cabinetPwdQueue()).to((Exchange)this.customExchange()).with(CABINET_PWD_ROUTING_KEY).noargs();
    }

    @Bean
    CustomExchange customExchange() {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("x-delayed-type", "direct");
        return new CustomExchange(DEFAULT_EXCHANGE, "x-delayed-message", true, false, args);
    }
}

