/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.nst.server.config;

import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPoolConfig;

@Configuration
public class RedisConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisConfiguration.class);
    private static JedisCluster jedisCluster = null;
    @Value(value="${spring.redis.clusterNodes}")
    private String clusterNodes;
    @Value(value="${spring.redis.timeout}")
    private int timeout;
    @Value(value="${spring.redis.jedis.pool.max-idle}")
    private int maxIdle;
    @Value(value="${spring.redis.jedis.pool.max-wait}")
    private long maxWaitMillis;
    @Value(value="${spring.redis.jedis.pool.max-active}")
    private int maxActive;
    @Value(value="${spring.redis.jedis.pool.min-idle}")
    private int minIdle;

    @Bean
    public RedisClusterConfiguration redisClusterConfiguration() {
        RedisClusterConfiguration redisClusterConfiguration = new RedisClusterConfiguration();
        String[] hosts = this.clusterNodes.split(",");
        HashSet<RedisNode> nodeList = new HashSet<RedisNode>();
        for (String hostAndPort : hosts) {
            String[] hostOrPort = hostAndPort.split(":");
            nodeList.add(new RedisNode(hostOrPort[0], Integer.parseInt(hostOrPort[1])));
        }
        redisClusterConfiguration.setClusterNodes(nodeList);
        return redisClusterConfiguration;
    }

    @Bean
    public JedisPoolConfig jedisPoolConfig() {
        JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
        jedisPoolConfig.setMaxIdle(this.maxIdle);
        jedisPoolConfig.setMaxWaitMillis(this.maxWaitMillis);
        jedisPoolConfig.setMinIdle(this.minIdle);
        jedisPoolConfig.setMaxTotal(this.maxActive);
        return jedisPoolConfig;
    }

    @Bean(value={"myJedisConnectionFactory"})
    public JedisConnectionFactory jedisConnectionFactory(RedisClusterConfiguration redisClusterConfiguration, JedisPoolConfig jedisPoolConfig) {
        JedisConnectionFactory jedisConnectionFactory = new JedisConnectionFactory(redisClusterConfiguration, jedisPoolConfig);
        return jedisConnectionFactory;
    }
}

