/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.nst.server.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.nst.server.enums.OrderEnum;
import com.ebaiyihui.nst.server.mapper.TOrderMapper;
import com.ebaiyihui.nst.server.pojo.dto.OrderDetailDto;
import com.ebaiyihui.nst.server.pojo.dto.OrderExcelListDtoLy;
import com.ebaiyihui.nst.server.pojo.dto.OrderListDto;
import com.ebaiyihui.nst.server.pojo.dto.OrderListPageDto;
import com.ebaiyihui.nst.server.pojo.dto.SmallProgamOrderDto;
import com.ebaiyihui.nst.server.pojo.entity.ServicePayBill;
import com.ebaiyihui.nst.server.pojo.entity.TEquipBack;
import com.ebaiyihui.nst.server.pojo.entity.TOrder;
import com.ebaiyihui.nst.server.pojo.vo.OrderListPageVo;
import com.ebaiyihui.nst.server.pojo.vo.OrderListVo;
import com.ebaiyihui.nst.server.pojo.vo.PayBillVo;
import com.ebaiyihui.nst.server.pojo.vo.SaveOrderVo;
import com.ebaiyihui.nst.server.service.ServicePayBillService;
import com.ebaiyihui.nst.server.service.TEquipBackService;
import com.ebaiyihui.nst.server.service.TOrderService;
import com.ebaiyihui.nst.server.util.RabbitUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class TOrderServiceImpl
extends ServiceImpl<TOrderMapper, TOrder>
implements TOrderService {
    private static final Logger log = LoggerFactory.getLogger(TOrderServiceImpl.class);
    private static final String ORDER_NO_EXIST = "\u8ba2\u5355\u4e0d\u5b58\u5728";
    @Resource
    private RabbitTemplate rabbitTemplate;
    @Resource
    private TEquipBackService equipBackService;
    @Resource
    private TOrderMapper orderMapper;
    @Resource
    private TOrderService orderService;
    @Resource
    private ServicePayBillService servicePayBillService;

    public BaseResponse<String> newOrder(SaveOrderVo saveOrderVo) {
        log.info("\u65b0\u589e\u8ba2\u5355\u5165\u53c2{}", (Object)JSONObject.toJSONString((Object)saveOrderVo));
        TOrder tOrder = new TOrder();
        BeanUtils.copyProperties((Object)saveOrderVo, (Object)tOrder);
        tOrder.setStatus(OrderEnum.UN_PAD.getStatus());
        this.save((Object)tOrder);
        int delayTime = 900;
        RabbitUtils.newOrderToPay((RabbitTemplate)this.rabbitTemplate, (String)tOrder.getId(), (Integer)delayTime);
        return BaseResponse.success((Object)tOrder.getId());
    }

    public BaseResponse<OrderDetailDto> orderDetail(String id) {
        TOrder order = (TOrder)this.getById((Serializable)((Object)id));
        if (ObjectUtils.isEmpty((Object)order)) {
            return BaseResponse.error((String)ORDER_NO_EXIST);
        }
        OrderDetailDto orderDetailDto = new OrderDetailDto();
        BeanUtils.copyProperties((Object)order, (Object)orderDetailDto);
        TEquipBack equipBack = (TEquipBack)this.equipBackService.getOne((Wrapper)new LambdaUpdateWrapper().eq(TEquipBack::getOrderId, (Object)id));
        orderDetailDto.setEquipBack(equipBack);
        ServicePayBill servicePayBill = (ServicePayBill)this.servicePayBillService.getOne((Wrapper)new LambdaUpdateWrapper().eq(ServicePayBill::getOutTradeNo, (Object)id));
        if (servicePayBill != null) {
            PayBillVo payBillVo = new PayBillVo();
            payBillVo.setOrderId(servicePayBill.getOutTradeNo());
            payBillVo.setTradeTime(servicePayBill.getTradeTime());
            payBillVo.setTradeNo(servicePayBill.getTradeNo());
            orderDetailDto.setPayBillVo(payBillVo);
        }
        return BaseResponse.success((Object)orderDetailDto);
    }

    public BaseResponse<List<SmallProgamOrderDto>> orderListBySmallProgram(OrderListVo orderListVo) {
        List orderDtoList = this.orderMapper.orderListBySmallProgram(orderListVo);
        return BaseResponse.success((Object)orderDtoList);
    }

    public BaseResponse<OrderListPageDto> orderListByManager(OrderListPageVo orderListPageVo) {
        OrderListPageDto orderListPageDto = new OrderListPageDto();
        Page orderPage = new Page();
        orderPage.setSize((long)orderListPageVo.getPageSize().intValue());
        orderPage.setCurrent((long)orderListPageVo.getPageIndex().intValue());
        String organId = orderListPageVo.getOrganId();
        String id = orderListPageVo.getId();
        String organName = orderListPageVo.getOrganName();
        Integer status = orderListPageVo.getStatus();
        String search = orderListPageVo.getSearch();
        String createTimeBegin = orderListPageVo.getCreateTimeBegin();
        String createTimeEnd = orderListPageVo.getCreateTimeEnd();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"organ_id", (Object)organId);
        if (status != 100) {
            queryWrapper.eq((Object)"status", (Object)orderListPageVo.getStatus());
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)createTimeBegin) && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)createTimeEnd)) {
            queryWrapper.between((Object)"create_time", (Object)(createTimeBegin + " 00:00:00"), (Object)(createTimeEnd + " 23:59:59"));
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)search)) {
            queryWrapper.and(wrapper -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper.like((Object)"patient_name", (Object)search)).or()).like((Object)"patient_phone", (Object)search);
            });
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)organName)) {
            queryWrapper.like((Object)"organ_name", (Object)organName);
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)id)) {
            queryWrapper.like((Object)"id", (Object)id);
        }
        queryWrapper.orderByDesc((Object)"update_time");
        Page page = (Page)this.page((IPage)orderPage, (Wrapper)queryWrapper);
        List orderList = page.getRecords();
        ArrayList orderListDtoList = new ArrayList();
        orderList.forEach(tOrder -> {
            OrderListDto orderListDto = new OrderListDto();
            BeanUtils.copyProperties((Object)tOrder, (Object)orderListDto);
            orderListDtoList.add(orderListDto);
        });
        orderListPageDto.setOrderListDtoList(orderListDtoList);
        orderListPageDto.setPageIndex(orderListPageVo.getPageIndex());
        orderListPageDto.setPageSize(orderListPageVo.getPageSize());
        orderListPageDto.setPageNum(Integer.valueOf((int)page.getPages()));
        orderListPageDto.setTotal(Integer.valueOf((int)page.getTotal()));
        List list = this.list((Wrapper)queryWrapper);
        orderListPageDto.setOrderNum(Integer.valueOf(list.size()));
        return BaseResponse.success((Object)orderListPageDto);
    }

    public List<OrderExcelListDtoLy> getLyExportExcelOrderList(OrderListVo orderListVo) {
        if (StringUtils.isNotEmpty((String)orderListVo.getStartTime())) {
            orderListVo.setStartTime(orderListVo.getStartTime() + " 00:00:00");
        }
        if (StringUtils.isNotEmpty((String)orderListVo.getEndTime())) {
            orderListVo.setEndTime(orderListVo.getEndTime() + " 23:59:59");
        }
        return this.orderMapper.getLyExportExcelOrderList(orderListVo);
    }
}

