/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.ca.server.controller;

import com.doctoruser.api.pojo.dto.BaseDTO;
import com.doctoruser.api.pojo.dto.organization.QueryOrganDetailDTO;
import com.doctoruser.api.pojo.vo.basedata.doctor.DoctorEntityInfoVO;
import com.doctoruser.api.pojo.vo.basedata.organization.QueryOrganDetailVO;
import com.ebaiyihui.ca.server.exception.BusinessException;
import com.ebaiyihui.ca.server.feign.IDoctorApiClient;
import com.ebaiyihui.ca.server.feign.IhospitalApiClient;
import com.ebaiyihui.ca.server.pojo.EmpowerReqVO;
import com.ebaiyihui.ca.server.pojo.entity.HbcaCert;
import com.ebaiyihui.ca.server.pojo.entity.HbcaUserVo;
import com.ebaiyihui.ca.server.pojo.hbca.BaseReponsVo;
import com.ebaiyihui.ca.server.pojo.hbca.GetAuthCodeReq;
import com.ebaiyihui.ca.server.pojo.hbca.SignReq;
import com.ebaiyihui.ca.server.pojo.hbca.UpdatePassReq;
import com.ebaiyihui.ca.server.pojo.mzjh.vo.UserStatusReqVO;
import com.ebaiyihui.ca.server.service.HbcaCertService;
import com.ebaiyihui.ca.server.service.HbcaUserService;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/app/hbca"})
@Api(tags={"\u6cb3\u5317CA\u76f8\u5173API"})
public class HBCAController {
    private static final Logger log = LoggerFactory.getLogger(HBCAController.class);
    @Autowired
    private HbcaUserService hbcaUserService;
    @Autowired
    private HbcaCertService hbcaCertService;
    @Autowired
    private IDoctorApiClient iDoctorApiClient;
    @Autowired
    private IhospitalApiClient ihospitalApiClient;

    @ApiOperation(value="\u6388\u6743\u4fdd\u5b58\u8bc1\u4e66", notes="\u6388\u6743\u4fdd\u5b58\u8bc1\u4e66\u63a5\u53e3")
    @PostMapping(value={"/addAuth"})
    public BaseResponse addAuth(@Validated @RequestBody EmpowerReqVO empowerReqVO) {
        Long organId;
        Long doctorId = empowerReqVO.getDoctorId();
        HbcaCert hbcaUserVo = this.hbcaCertService.getCertByDoctorIdAndOrganId(doctorId, organId = empowerReqVO.getOrganId());
        if (hbcaUserVo != null) {
            throw new BusinessException("\u60a8\u5df2\u6388\u6743\uff0c\u65e0\u9700\u91cd\u590d\u6388\u6743\uff01");
        }
        BaseDTO baseDTO = new BaseDTO();
        baseDTO.setId(Integer.valueOf(doctorId.intValue()));
        BaseResponse doctorEntityInfoVOBaseResponse = this.iDoctorApiClient.endQueryDoctorDetailInfo(baseDTO);
        if (doctorEntityInfoVOBaseResponse == null || doctorEntityInfoVOBaseResponse.getData() == null) {
            throw new BusinessException("\u533b\u751f\u4fe1\u606f\u67e5\u4e0d\u5230\uff01");
        }
        DoctorEntityInfoVO doctorEntityInfoVO = (DoctorEntityInfoVO)doctorEntityInfoVOBaseResponse.getData();
        QueryOrganDetailDTO queryOrganDetailDTO = new QueryOrganDetailDTO();
        queryOrganDetailDTO.setOrganId(Integer.valueOf(organId.intValue()));
        BaseResponse organDetailVOBaseResponse = this.ihospitalApiClient.queryOrganDetail(queryOrganDetailDTO);
        if (organDetailVOBaseResponse == null || organDetailVOBaseResponse.getData() == null) {
            throw new BusinessException("\u533b\u9662\u4fe1\u606f\u67e5\u4e0d\u5230\uff01");
        }
        QueryOrganDetailVO organDetailVO = (QueryOrganDetailVO)organDetailVOBaseResponse.getData();
        String tbOrganId = organDetailVO.getOrganId();
        if (!organId.equals(Long.valueOf(tbOrganId))) {
            log.info("\u7528\u6237\u4e2d\u5fc3\u7684organId{}", (Object)tbOrganId);
            throw new BusinessException("\u533b\u9662\u4fe1\u606f\u4e0d\u5339\u914d\uff01");
        }
        HbcaUserVo hbcaUser = new HbcaUserVo();
        hbcaUser.setOrganId(organId);
        hbcaUser.setDoctorId(doctorId);
        hbcaUser.setOrganName(organDetailVO.getOrganName());
        hbcaUser.setDeptName(doctorEntityInfoVO.getHospitalDeptName());
        hbcaUser.setProfession(doctorEntityInfoVO.getProfession());
        hbcaUser.setAppId(organDetailVO.getAppCode());
        String registerMobile = doctorEntityInfoVO.getRegisterMobile();
        hbcaUser.setIdentityId(registerMobile);
        String name = doctorEntityInfoVO.getName();
        hbcaUser.setUserName(name);
        hbcaUser.setUserStatusCode(UserStatusReqVO.UserStatus.disable.getCode());
        hbcaUser.setUserStatusName(UserStatusReqVO.UserStatus.disable.getName());
        hbcaUser.setIdNoType(Integer.valueOf(1));
        String credNo = doctorEntityInfoVO.getCredNo();
        hbcaUser.setIdNo(credNo);
        hbcaUser.setTelephone(registerMobile);
        this.hbcaUserService.empower(hbcaUser);
        return BaseResponse.success();
    }

    @PostMapping(value={"/getCaCert"})
    @ApiOperation(value="\u83b7\u53d6\u8bc1\u4e66")
    public BaseResponse<HbcaCert> getCaCert(@Validated @RequestBody EmpowerReqVO empowerReqVO) {
        HbcaCert caCert = this.hbcaUserService.getCaCert(empowerReqVO);
        return BaseResponse.success((Object)caCert);
    }

    @PostMapping(value={"/getAuthCode"})
    @ApiOperation(value="\u6821\u9a8c\u8bc1\u4e66\u5bc6\u7801\uff08\u6821\u9a8c\u53e3\u4ee4\u540e\u8fd4\u56de\u7b7e\u8bc1\u6388\u6743\u7801\uff09")
    public BaseResponse<String> getAuthCode(@Validated @RequestBody GetAuthCodeReq getAuthCodeReq) {
        return this.hbcaUserService.getAuthCode(getAuthCodeReq);
    }

    @PostMapping(value={"/verifySign"})
    @ApiOperation(value="\u6570\u5b57\u7b7e\u540d")
    public BaseResponse<String> verifySign(@Validated @RequestBody SignReq verifySignReqVo) {
        BaseReponsVo baseReponsVo = this.hbcaUserService.verifySign(verifySignReqVo);
        return BaseResponse.success((Object)baseReponsVo.getData());
    }

    @GetMapping(value={"/certDelay"})
    @ApiOperation(value="\u8bc1\u4e66\u5ef6\u671f")
    public BaseResponse certDelay(@RequestParam(value="certSubjectId") String certSubjectId, @RequestParam(value="organId") String organId) {
        if (StringUtils.isEmpty((Object)certSubjectId)) {
            return BaseResponse.error((String)"certSubjectId\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)organId)) {
            return BaseResponse.error((String)"organId\u4e0d\u53ef\u4e3a\u7a7a");
        }
        this.hbcaUserService.certDelay(certSubjectId, organId);
        return BaseResponse.success();
    }

    @ApiOperation(value="\u8bbe\u7f6e\u7b7e\u7ae0")
    @GetMapping(value={"/saveSign"})
    public BaseResponse saveSign(@RequestParam(value="doctorId") String doctorId, @RequestParam(value="signUrl") String signUrl) {
        if (StringUtils.isEmpty((Object)doctorId)) {
            return BaseResponse.error((String)"doctorId\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)signUrl)) {
            return BaseResponse.error((String)"signUrl\u4e0d\u53ef\u4e3a\u7a7a");
        }
        this.hbcaUserService.saveSign(doctorId, signUrl);
        return BaseResponse.success();
    }

    @ApiOperation(value="\u4fee\u6539\u5bc6\u7801")
    @PostMapping(value={"/updatePassWord"})
    public BaseResponse updatePassWord(@RequestBody @Validated UpdatePassReq updatePassReq) {
        this.hbcaUserService.updatePassWord(updatePassReq.getOrganId(), updatePassReq.getDoctorId(), updatePassReq.getPassWord());
        return BaseResponse.success();
    }
}

