/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.ca.server.controller.app;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.ebaiyihui.ca.server.exception.BusinessException;
import com.ebaiyihui.ca.server.pojo.MzjhCertRespVO;
import com.ebaiyihui.ca.server.pojo.SaveCertReqVO;
import com.ebaiyihui.ca.server.pojo.entity.MzjhCert;
import com.ebaiyihui.ca.server.pojo.entity.MzjhUser;
import com.ebaiyihui.ca.server.service.MzjhCertService;
import com.ebaiyihui.ca.server.service.MzjhUserService;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/app/mzjh/cert"})
@Api(tags={"\u7f8e\u4e2d\u5609\u548capp\u7aef\u8bc1\u4e66\u76f8\u5173\u63a5\u53e3"})
public class AppMzjhCertController {
    private static final Logger log = LoggerFactory.getLogger(AppMzjhCertController.class);
    @Autowired
    private MzjhUserService mzjhUserService;
    @Autowired
    private MzjhCertService mzjhCertService;

    @ApiOperation(value="\u4fdd\u5b58\u8bc1\u4e66\uff08app\u7aef\u8c03\u7528\u63a5\u53e3\uff09", notes="\u4fdd\u5b58\u8bc1\u4e66\uff08app\u7aef\u8c03\u7528\u63a5\u53e3\uff09")
    @PostMapping(value={"/save"})
    public BaseResponse saveCert(@Validated @RequestBody SaveCertReqVO saveCertReqVO) {
        Long organId;
        Long doctorId = saveCertReqVO.getDoctorId();
        MzjhUser mzjhUser = this.mzjhUserService.getUserInfoByDoctorIdAndOrganId(doctorId, organId = saveCertReqVO.getOrganId());
        if (mzjhUser == null) {
            throw new BusinessException("\u7528\u6237\u5c1a\u672a\u6388\u6743");
        }
        MzjhCert mzjhCert = new MzjhCert();
        mzjhCert.setMzjhUserId(mzjhUser.getId());
        mzjhCert.setCertSubject(saveCertReqVO.getCertSubject());
        mzjhCert.setCert(saveCertReqVO.getCert());
        mzjhCert.setCertIssuer(saveCertReqVO.getCertIssuer());
        mzjhCert.setStartDate(saveCertReqVO.getStartDate());
        mzjhCert.setEndDate(saveCertReqVO.getEndDate());
        mzjhCert.setCertSn(saveCertReqVO.getCertSn());
        this.mzjhCertService.addCert(mzjhCert);
        return BaseResponse.success();
    }

    @ApiOperation(value="\u67e5\u8be2\u8bc1\u4e66\uff08app\u7aef\u8c03\u7528\u63a5\u53e3\uff09", notes="\u67e5\u8be2\u8bc1\u4e66\uff08app\u7aef\u8c03\u7528\u63a5\u53e3\uff09")
    @GetMapping(value={"/get"})
    public BaseResponse<MzjhCertRespVO> getCert(@RequestParam(value="doctorId") Long doctorId, @RequestParam(value="organId") Long organId) {
        MzjhCert mzjhCert = this.mzjhCertService.getCertByDoctorIdAndOrganId(doctorId, organId);
        if (mzjhCert == null) {
            throw new BusinessException("\u8bc1\u4e66\u4e0d\u5b58\u5728");
        }
        MzjhCertRespVO mzjhCertRespVO = new MzjhCertRespVO();
        BeanUtils.copyProperties((Object)mzjhCert, (Object)mzjhCertRespVO);
        String endDate = mzjhCert.getEndDate();
        DateTime parseEndDate = DateUtil.parse((String)endDate);
        Date currentDate = new Date();
        long effectiveDays = DateUtil.betweenDay((Date)currentDate, (Date)parseEndDate, (boolean)true);
        if (parseEndDate.isBefore(currentDate)) {
            effectiveDays = -effectiveDays;
        }
        mzjhCertRespVO.setEffectiveDays(Long.valueOf(effectiveDays));
        return BaseResponse.success((Object)mzjhCertRespVO);
    }
}

