/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.ca.server.controller.app;

import cn.hutool.core.util.XmlUtil;
import com.ebaiyihui.ca.server.config.MzCaConfig;
import com.ebaiyihui.ca.server.exception.BusinessException;
import com.ebaiyihui.ca.server.pojo.SignRecordReqVO;
import com.ebaiyihui.ca.server.pojo.entity.MzjhCert;
import com.ebaiyihui.ca.server.pojo.entity.MzjhSignRecords;
import com.ebaiyihui.ca.server.pojo.entity.MzjhUser;
import com.ebaiyihui.ca.server.service.MzjhCertService;
import com.ebaiyihui.ca.server.service.MzjhSignRecordsService;
import com.ebaiyihui.ca.server.service.MzjhUserService;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.rmi.RemoteException;
import java.util.Map;
import javax.xml.rpc.ServiceException;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@RestController
@RequestMapping(value={"/app/sign/records"})
@Api(tags={"\u7f8e\u4e2d\u5609\u548c\u7b7e\u540d\u8bb0\u5f55\u76f8\u5173\u63a5\u53e3"})
public class AppMzjhSignRecordsController {
    private static final Logger log = LoggerFactory.getLogger(AppMzjhSignRecordsController.class);
    @Autowired
    private MzjhSignRecordsService mzjhSignRecordsService;
    @Autowired
    private MzjhUserService mzjhUserService;
    @Autowired
    private MzjhCertService mzjhCertService;
    @Autowired
    private MzCaConfig mzCaConfig;

    @ApiOperation(value="\u4fdd\u5b58\u7b7e\u540d\u8bb0\u5f55\uff08app\u7aef\u8c03\u7528\u63a5\u53e3\uff09", notes="\u4fdd\u5b58\u7b7e\u540d\u8bb0\u5f55\uff08app\u7aef\u8c03\u7528\u63a5\u53e3\uff09")
    @PostMapping(value={"/save"})
    public BaseResponse saveSignRecord(@Validated @RequestBody SignRecordReqVO signRecordReqVO) {
        Long organId;
        Long doctorId = signRecordReqVO.getDoctorId();
        MzjhUser mzjhUser = this.mzjhUserService.getUserInfoByDoctorIdAndOrganId(doctorId, organId = signRecordReqVO.getOrganId());
        if (mzjhUser == null) {
            throw new BusinessException("\u7528\u6237\u4e0d\u5b58\u5728\uff01");
        }
        MzjhCert mzjhCert = this.mzjhCertService.getCertByDoctorIdAndOrganId(doctorId, organId);
        if (mzjhCert == null) {
            throw new BusinessException("\u8bc1\u4e66\u4e0d\u5b58\u5728\uff01");
        }
        MzjhSignRecords mzjhSignRecords = new MzjhSignRecords();
        mzjhSignRecords.setMzjhUserId(mzjhUser.getId());
        mzjhSignRecords.setBase64ElecDoc(signRecordReqVO.getBase64ElecDoc());
        mzjhSignRecords.setMsg(signRecordReqVO.getMsg());
        mzjhSignRecords.setCertSn(mzjhCert.getCertSn());
        mzjhSignRecords.setCert(mzjhCert.getCert());
        mzjhSignRecords.setSignValue(signRecordReqVO.getSignValue());
        String validTimestamp = null;
        try {
            validTimestamp = this.getValidTimestamp(signRecordReqVO.getMsg());
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u6709\u6548\u65f6\u95f4\u6233\u62a5\u9519", (Throwable)e);
            throw new BusinessException("\u83b7\u53d6\u6709\u6548\u65f6\u95f4\u6233\u62a5\u9519\uff0c\u7b7e\u540d\u5931\u8d25\uff0c\u6e05\u5237\u65b0\u540e\u91cd\u65b0\u64cd\u4f5c\uff01");
        }
        mzjhSignRecords.setValidTimestamp(validTimestamp);
        this.mzjhSignRecordsService.save(mzjhSignRecords);
        return BaseResponse.success();
    }

    private String getValidTimestamp(String msg) throws RemoteException, ServiceException {
        String stRequestXml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?><Root><AppCode>" + this.mzCaConfig.getValidTimestampAppCode() + "</AppCode><AppPWD>" + this.mzCaConfig.getValidTimestampAppPwd() + "</AppPWD><Request><InData>" + new String(Base64.encode((byte[])msg.getBytes())) + "</InData><HashAlg>SHA1</HashAlg><CertReq>false</CertReq></Request></Root>";
        log.info("\u83b7\u53d6\u6709\u6548\u65f6\u95f4\u6233\u53c2\u6570{}", (Object)stRequestXml);
        String stResponseXml = this.invoke(this.mzCaConfig.getValidTimestampUrl(), "generateTimestampByInData", stRequestXml);
        log.info("\u83b7\u53d6\u6709\u6548\u65f6\u95f4\u6233\u7ed3\u679c{}", (Object)stResponseXml);
        if (stResponseXml == null || "".equals(stResponseXml)) {
            throw new BusinessException("\u83b7\u53d6\u6709\u6548\u65f6\u95f4\u6233\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff0c\u7b7e\u540d\u5931\u8d25\uff0c\u6e05\u5237\u65b0\u540e\u91cd\u65b0\u64cd\u4f5c\uff01");
        }
        Document document = XmlUtil.parseXml((String)stResponseXml);
        Element rootElement = XmlUtil.getRootElement((Document)document);
        Element response = XmlUtil.getElement((Element)rootElement, (String)"Response");
        Map xmlToMap = XmlUtil.xmlToMap((Node)response);
        String timeStamp = (String)xmlToMap.get("TimeStamp");
        return timeStamp;
    }

    private String invoke(String url, String method, String stRequestXml) throws RemoteException, ServiceException {
        Service service = new Service();
        Call call = (Call)service.createCall();
        call.setTargetEndpointAddress(url);
        call.setOperationName(method);
        Object[] o = new Object[]{stRequestXml};
        return call.invoke(o).toString();
    }
}

