/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.ca.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.doctoruser.api.pojo.dto.BaseDTO;
import com.doctoruser.api.pojo.dto.organization.QueryOrganDetailDTO;
import com.doctoruser.api.pojo.vo.basedata.doctor.DoctorEntityInfoVO;
import com.doctoruser.api.pojo.vo.basedata.organization.QueryOrganDetailVO;
import com.ebaiyihui.ca.common.dto.DoctorSyncBodyRequestDTO;
import com.ebaiyihui.ca.common.dto.DoctorSyncHeadRequestDTO;
import com.ebaiyihui.ca.common.dto.DoctorSyncResultDTO;
import com.ebaiyihui.ca.server.exception.BusinessException;
import com.ebaiyihui.ca.server.feign.IDoctorApiClient;
import com.ebaiyihui.ca.server.feign.IhospitalApiClient;
import com.ebaiyihui.ca.server.mapper.CaDoctorMapper;
import com.ebaiyihui.ca.server.pojo.SyncDoctorReqVO;
import com.ebaiyihui.ca.server.pojo.entity.CaDoctorEntity;
import com.ebaiyihui.ca.server.pojo.entity.ConfigDic;
import com.ebaiyihui.ca.server.service.CaDoctorService;
import com.ebaiyihui.ca.server.service.ConfigDicService;
import com.ebaiyihui.ca.server.utils.RestTemplateUtils;
import com.ebaiyihui.ca.server.utils.SignUtil;
import com.ebaiyihui.ca.server.utils.ywx.TokenUtil;
import com.ebaiyihui.framework.response.BaseResponse;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CaDoctorServiceImpl
implements CaDoctorService {
    private static final Logger log = LoggerFactory.getLogger(CaDoctorServiceImpl.class);
    @Autowired
    private IDoctorApiClient iDoctorApiClient;
    @Autowired
    private IhospitalApiClient ihospitalApiClient;
    @Autowired
    private TokenUtil tokenUtil;
    @Autowired
    private CaDoctorMapper caDoctorMapper;
    @Autowired
    private ConfigDicService configDicService;

    @Transactional(rollbackFor={BusinessException.class})
    public void syncDoctor(SyncDoctorReqVO syncDoctorReqVO) {
        Long doctorId = syncDoctorReqVO.getDoctorId();
        Long hospitalId = syncDoctorReqVO.getHospitalId();
        String appCode = syncDoctorReqVO.getAppCode();
        CaDoctorEntity doctorEntity = this.caDoctorMapper.getByDoctorIdAndHospitalId(doctorId, hospitalId);
        if (doctorEntity != null) {
            Integer userStatus = doctorEntity.getUserStatus();
            if (userStatus == 4) {
                BaseDTO baseDTO = new BaseDTO();
                baseDTO.setId(Integer.valueOf(doctorId.intValue()));
                BaseResponse doctorEntityInfoVOBaseResponse = this.iDoctorApiClient.endQueryDoctorDetailInfo(baseDTO);
                if (doctorEntityInfoVOBaseResponse == null || doctorEntityInfoVOBaseResponse.getData() == null) {
                    throw new BusinessException("\u533b\u751f\u4fe1\u606f\u67e5\u4e0d\u5230\uff01");
                }
                DoctorEntityInfoVO doctorEntityInfoVO = (DoctorEntityInfoVO)doctorEntityInfoVOBaseResponse.getData();
                QueryOrganDetailDTO queryOrganDetailDTO = new QueryOrganDetailDTO();
                queryOrganDetailDTO.setOrganId(Integer.valueOf(hospitalId.intValue()));
                BaseResponse organDetailVOBaseResponse = this.ihospitalApiClient.queryOrganDetail(queryOrganDetailDTO);
                if (organDetailVOBaseResponse == null || organDetailVOBaseResponse.getData() == null) {
                    throw new BusinessException("\u533b\u9662\u4fe1\u606f\u67e5\u4e0d\u5230\uff01");
                }
                QueryOrganDetailVO organDetailVO = (QueryOrganDetailVO)organDetailVOBaseResponse.getData();
                DoctorSyncBodyRequestDTO bodyTemp = new DoctorSyncBodyRequestDTO();
                bodyTemp.setDoctorId("");
                bodyTemp.setDoctorIdType("QT");
                bodyTemp.setOrgName(organDetailVO.getOrganName());
                bodyTemp.setDoctorName(doctorEntityInfoVO.getName());
                bodyTemp.setUid(doctorEntityInfoVO.getCredNo());
                bodyTemp.setUidCardType("SF");
                bodyTemp.setPhone(doctorEntityInfoVO.getRegisterMobile());
                bodyTemp.setDepartment(doctorEntityInfoVO.getHospitalDeptName());
                ConfigDic configDic = this.configDicService.getByHospitalId(hospitalId);
                if (configDic == null) {
                    throw new BusinessException("\u672c\u9662\u6ca1\u6709\u5f00\u901aCA\u670d\u52a1\uff0c\u8bf7\u8054\u7cfb\u9879\u76ee\u7ba1\u7406\u4eba\u5458\uff01");
                }
                String clientId = configDic.getClientId();
                String secret = configDic.getSecret();
                String url = configDic.getUrl();
                String accessToken = this.tokenUtil.getAccessToken(url + "/device/server/oauth/getAccessToken", clientId, secret);
                DoctorSyncHeadRequestDTO headDTO = new DoctorSyncHeadRequestDTO();
                headDTO.setClientId(clientId);
                headDTO.setAccessToken(accessToken);
                headDTO.setBodySign(SignUtil.getSign((String)JSON.toJSONString((Object)bodyTemp), (String)secret));
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("head", (Object)headDTO);
                jsonObject.put("body", (Object)bodyTemp);
                log.info("\u4fee\u6539-\u540c\u6b65\u533b\u5e08\u4fe1\u606f\u63a5\u53e3\u4f20\u9012\u4fe1\u606f\uff1a" + jsonObject.toJSONString());
                String doctorSynResult = null;
                try {
                    doctorSynResult = RestTemplateUtils.post((String)(url + "/am/v2/doctor/syn"), (JSONObject)jsonObject, (MediaType)MediaType.APPLICATION_JSON_UTF8, (String)"");
                }
                catch (Exception e) {
                    throw new BusinessException("\u540c\u6b65\u533b\u5e08\u4fe1\u606f\u5f02\u5e38 \u7f51\u7edc\u9519\u8bef\u6216\u8bf7\u6c42\u8d85\u65f6" + e.getMessage());
                }
                if (doctorSynResult == null) {
                    throw new BusinessException("\u540c\u6b65\u533b\u5e08\u4fe1\u606f\u8c03\u7528\u4e09\u65b9\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a\uff0c\u4e09\u65b9\u6216\u8005\u7f51\u7edc\u9519\u8bef\uff01");
                }
                DoctorSyncResultDTO resultDTO = (DoctorSyncResultDTO)JSON.parseObject((String)doctorSynResult, DoctorSyncResultDTO.class);
                if (!"0".equals(resultDTO.getStatus())) {
                    throw new BusinessException("\u540c\u6b65\u533b\u5e08\u4fe1\u606f\u8c03\u7528\u9519\u8bef\uff1a" + resultDTO.getMessage() + "\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u4fee\u6539\u4fe1\u606f\u540e\u518d\u6b21\u6388\u6743\uff01");
                }
                doctorEntity.setOpenId(resultDTO.getData().getOpenId());
                doctorEntity.setDoctorId(doctorId.toString());
                doctorEntity.setUserStatus(Integer.valueOf(-1));
                doctorEntity.setStatusTime(new Date());
                doctorEntity.setDoctorName(doctorEntityInfoVO.getName());
                doctorEntity.setDepartment(doctorEntityInfoVO.getHospitalDeptName());
                doctorEntity.setOrgName(organDetailVO.getOrganName());
                doctorEntity.setUid(doctorEntityInfoVO.getCredNo());
                doctorEntity.setUidCardType("SF");
                doctorEntity.setPhone(doctorEntityInfoVO.getRegisterMobile());
                doctorEntity.setDepartment(doctorEntityInfoVO.getHospitalDeptName());
                doctorEntity.setDepartmentSecond(doctorEntityInfoVO.getStdSecondDeptName());
                doctorEntity.setDoctorType("QT");
                doctorEntity.setTitle(doctorEntityInfoVO.getProfession());
                doctorEntity.setIssueOrg("\u5317\u4eac\u6570\u5b57\u533b\u4fe1\u79d1\u6280\u6709\u9650\u516c\u53f8");
                doctorEntity.setOrganCode(appCode);
                doctorEntity.setHospitalId(hospitalId);
                this.caDoctorMapper.updateByPrimaryKeySelective(doctorEntity);
            }
        } else {
            BaseDTO baseDTO = new BaseDTO();
            baseDTO.setId(Integer.valueOf(doctorId.intValue()));
            BaseResponse doctorEntityInfoVOBaseResponse = this.iDoctorApiClient.endQueryDoctorDetailInfo(baseDTO);
            if (doctorEntityInfoVOBaseResponse == null || doctorEntityInfoVOBaseResponse.getData() == null) {
                throw new BusinessException("\u533b\u751f\u4fe1\u606f\u67e5\u4e0d\u5230\uff01");
            }
            DoctorEntityInfoVO doctorEntityInfoVO = (DoctorEntityInfoVO)doctorEntityInfoVOBaseResponse.getData();
            QueryOrganDetailDTO queryOrganDetailDTO = new QueryOrganDetailDTO();
            queryOrganDetailDTO.setOrganId(Integer.valueOf(hospitalId.intValue()));
            BaseResponse organDetailVOBaseResponse = this.ihospitalApiClient.queryOrganDetail(queryOrganDetailDTO);
            if (organDetailVOBaseResponse == null || organDetailVOBaseResponse.getData() == null) {
                throw new BusinessException("\u533b\u9662\u4fe1\u606f\u67e5\u4e0d\u5230\uff01");
            }
            QueryOrganDetailVO organDetailVO = (QueryOrganDetailVO)organDetailVOBaseResponse.getData();
            DoctorSyncBodyRequestDTO bodyTemp = new DoctorSyncBodyRequestDTO();
            bodyTemp.setDoctorId("");
            bodyTemp.setDoctorIdType("QT");
            bodyTemp.setOrgName(organDetailVO.getOrganName());
            bodyTemp.setDoctorName(doctorEntityInfoVO.getName());
            bodyTemp.setUid(doctorEntityInfoVO.getCredNo());
            bodyTemp.setUidCardType("SF");
            bodyTemp.setPhone(doctorEntityInfoVO.getRegisterMobile());
            bodyTemp.setDepartment(doctorEntityInfoVO.getHospitalDeptName());
            ConfigDic configDic = this.configDicService.getByHospitalId(hospitalId);
            if (configDic == null) {
                throw new BusinessException("\u672c\u9662\u6ca1\u6709\u5f00\u901aCA\u670d\u52a1\uff0c\u8bf7\u8054\u7cfb\u9879\u76ee\u7ba1\u7406\u4eba\u5458\uff01");
            }
            String clientId = configDic.getClientId();
            String secret = configDic.getSecret();
            String url = configDic.getUrl();
            String accessToken = this.tokenUtil.getAccessToken(url + "/device/server/oauth/getAccessToken", clientId, secret);
            DoctorSyncHeadRequestDTO headDTO = new DoctorSyncHeadRequestDTO();
            headDTO.setClientId(clientId);
            headDTO.setAccessToken(accessToken);
            headDTO.setBodySign(SignUtil.getSign((String)JSON.toJSONString((Object)bodyTemp), (String)secret));
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("head", (Object)headDTO);
            jsonObject.put("body", (Object)bodyTemp);
            log.info("\u65b0\u589e-\u540c\u6b65\u533b\u5e08\u4fe1\u606f\u63a5\u53e3\u4f20\u9012\u4fe1\u606f\uff1a" + jsonObject.toJSONString());
            String doctorSynResult = null;
            try {
                doctorSynResult = RestTemplateUtils.post((String)(url + "/am/v2/doctor/syn"), (JSONObject)jsonObject, (MediaType)MediaType.APPLICATION_JSON_UTF8, (String)"");
            }
            catch (Exception e) {
                throw new BusinessException("\u540c\u6b65\u533b\u5e08\u4fe1\u606f\u5f02\u5e38 \u7f51\u7edc\u9519\u8bef\u6216\u8bf7\u6c42\u8d85\u65f6" + e.getMessage());
            }
            if (doctorSynResult == null) {
                throw new BusinessException("\u540c\u6b65\u533b\u5e08\u4fe1\u606f\u8c03\u7528\u4e09\u65b9\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a\uff0c\u4e09\u65b9\u6216\u8005\u7f51\u7edc\u9519\u8bef\uff01");
            }
            DoctorSyncResultDTO resultDTO = (DoctorSyncResultDTO)JSON.parseObject((String)doctorSynResult, DoctorSyncResultDTO.class);
            if (!"0".equals(resultDTO.getStatus())) {
                throw new BusinessException("\u540c\u6b65\u533b\u5e08\u4fe1\u606f\u8c03\u7528\u9519\u8bef\uff1a" + resultDTO.getMessage() + "\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\uff01");
            }
            CaDoctorEntity caDoctorEntity = new CaDoctorEntity();
            caDoctorEntity.setOpenId(resultDTO.getData().getOpenId());
            caDoctorEntity.setDoctorId(doctorId.toString());
            caDoctorEntity.setUserStatus(Integer.valueOf(-1));
            caDoctorEntity.setStatusTime(new Date());
            caDoctorEntity.setDoctorName(doctorEntityInfoVO.getName());
            caDoctorEntity.setDepartment(doctorEntityInfoVO.getHospitalDeptName());
            caDoctorEntity.setOrgName(organDetailVO.getOrganName());
            caDoctorEntity.setUid(doctorEntityInfoVO.getCredNo());
            caDoctorEntity.setUidCardType("SF");
            caDoctorEntity.setPhone(doctorEntityInfoVO.getRegisterMobile());
            caDoctorEntity.setDepartment(doctorEntityInfoVO.getHospitalDeptName());
            caDoctorEntity.setDepartmentSecond(doctorEntityInfoVO.getStdSecondDeptName());
            caDoctorEntity.setDoctorType("QT");
            caDoctorEntity.setTitle(doctorEntityInfoVO.getProfession());
            caDoctorEntity.setIssueOrg("\u5317\u4eac\u6570\u5b57\u533b\u4fe1\u79d1\u6280\u6709\u9650\u516c\u53f8");
            caDoctorEntity.setOrganCode(appCode);
            caDoctorEntity.setHospitalId(hospitalId);
            this.caDoctorMapper.save(caDoctorEntity);
        }
    }

    public CaDoctorEntity getByDoctorIdAndHospitalId(Long doctorId, Long hospitalId) {
        CaDoctorEntity caDoctorEntity = this.caDoctorMapper.getByDoctorIdAndHospitalId(doctorId, hospitalId);
        return caDoctorEntity;
    }
}

