/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.ca.server.service.impl;

import com.doctoruser.api.pojo.vo.OssFileVO;
import com.ebaiyihui.ca.server.exception.BusinessException;
import com.ebaiyihui.ca.server.feign.IOssApi;
import com.ebaiyihui.ca.server.mapper.CaDoctorMapper;
import com.ebaiyihui.ca.server.pojo.entity.CaDoctorEntity;
import com.ebaiyihui.ca.server.service.Nd2Service;
import com.ebaiyihui.ca.server.third.HTCACossHelper;
import com.ebaiyihui.framework.response.BaseResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class Nd2ServiceImpl
implements Nd2Service {
    @Autowired
    private CaDoctorMapper caDoctorMapper;
    @Autowired
    private HTCACossHelper htcaCossHelper;
    @Autowired
    private IOssApi ossApi;

    public String getNd2Stamp(String doctorId, String appCode) {
        CaDoctorEntity doctorEntity = this.caDoctorMapper.getByDoctorIdAndAppCode(doctorId, appCode, null);
        if (doctorEntity == null || doctorEntity.getOpenId() == null || "".equals(doctorEntity.getOpenId())) {
            throw new BusinessException("\u8be5\u7528\u6237\u6ca1\u6709\u901a\u8fc7CA\u8ba4\u8bc1\uff0c\u65e0\u6cd5\u67e5\u8be2CA\u7b7e\u7ae0\uff01");
        }
        if (doctorEntity.getStamp() != null && !"".equals(doctorEntity.getStamp())) {
            return doctorEntity.getStamp();
        }
        String base64Image = this.htcaCossHelper.getBase64ImageByUserId(doctorEntity.getOpenId());
        BaseResponse ossFileVOBaseResponse = this.ossApi.saveBase64Image(base64Image);
        OssFileVO data = (OssFileVO)ossFileVOBaseResponse.getData();
        String url = data.getUrl();
        doctorEntity.setStamp(url);
        this.caDoctorMapper.updateByPrimaryKeySelective(doctorEntity);
        return url;
    }
}

