/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.ca.server.third;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.ca.server.common.properties.HTProperties;
import com.ebaiyihui.ca.server.exception.BusinessException;
import com.ebaiyihui.ca.server.pojo.vo.ht.ActivationCodeVO;
import com.ebaiyihui.ca.server.pojo.vo.ht.req.AutoSignReqVO;
import com.ebaiyihui.ca.server.pojo.vo.ht.req.VerifySignReqVO;
import com.ebaiyihui.ca.server.pojo.vo.ht.resp.AutoSignRespVO;
import com.ebaiyihui.ca.server.pojo.vo.ht.resp.EndAutoSignRespVO;
import com.ebaiyihui.ca.server.pojo.vo.ht.resp.QueryUserInfoRespVO;
import com.ebaiyihui.ca.server.pojo.vo.ht.resp.StartAutoSignRespVO;
import com.ebaiyihui.ca.server.utils.ht.HTTPUtils;
import com.ebaiyihui.ca.server.utils.ht.RequestUtils;
import com.ebaiyihui.ca.server.utils.ht.StringUtils;
import java.util.HashMap;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HTCACossHelper {
    private static final Logger log = LoggerFactory.getLogger(HTCACossHelper.class);
    private static final Integer SUCCESS_CODE = 200;
    @Autowired
    private HTProperties htProperties;

    public QueryUserInfoRespVO queryUserInfoByIdNumber(String idNumber) {
        HashMap<String, String> request = new HashMap<String, String>(16);
        request.put("version", this.htProperties.getCossVersion());
        request.put("appId", this.htProperties.getCossAppId());
        request.put("signAlgo", this.htProperties.getCossSignAlgo());
        request.put("idType", "SF");
        request.put("idNumber", idNumber);
        String queryUserInfoReq = null;
        try {
            queryUserInfoReq = RequestUtils.generateRequestJson(request, (String)this.htProperties.getCossKey());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u4e09\u65b9\u8bf7\u6c42\u53c2\u6570\u8f6c\u6362\u5f02\u5e38\uff01");
        }
        String queryUserInfoResp = null;
        try {
            log.info(this.htProperties.getCossReqDomain() + "/queryUserInfo");
            queryUserInfoResp = HTTPUtils.post((String)(this.htProperties.getCossReqDomain() + "/queryUserInfo"), (String)queryUserInfoReq);
            log.info("queryUserInfoResp = " + queryUserInfoResp);
            if (queryUserInfoResp == null || "".equals(queryUserInfoResp)) {
                throw new BusinessException("\u4e09\u65b9\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff01");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u4e09\u65b9\u8bf7\u6c42\u8c03\u7528\u5f02\u5e38\uff01");
        }
        JSONObject jsonObject = JSON.parseObject((String)queryUserInfoResp);
        Integer status = jsonObject.getInteger("status");
        if (!SUCCESS_CODE.equals(status)) {
            String message = jsonObject.getString("message");
            throw new BusinessException("\u4e09\u65b9\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c\u5f02\u5e38\uff1a" + message);
        }
        JSONObject dataObject = jsonObject.getJSONObject("data");
        QueryUserInfoRespVO queryUserInfoRespVO = new QueryUserInfoRespVO();
        queryUserInfoRespVO.setUserId(dataObject.getString("userId"));
        queryUserInfoRespVO.setUserName(dataObject.getString("userName"));
        queryUserInfoRespVO.setOrgId(dataObject.getString("orgId"));
        return queryUserInfoRespVO;
    }

    public ActivationCodeVO getActivationCode(String userId) {
        HashMap<String, String> request = new HashMap<String, String>(16);
        request.put("version", this.htProperties.getCossVersion());
        request.put("appId", this.htProperties.getCossAppId());
        request.put("signAlgo", this.htProperties.getCossSignAlgo());
        request.put("transId", UUID.randomUUID().toString());
        request.put("userId", userId);
        String requestStr = null;
        try {
            requestStr = RequestUtils.generateRequestJson(request, (String)this.htProperties.getCossKey());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u4e09\u65b9\u8bf7\u6c42\u53c2\u6570\u8f6c\u6362\u5f02\u5e38\uff01");
        }
        String getAuthCodeResp = null;
        try {
            log.info(this.htProperties.getCossReqDomain() + "/getAuthCode");
            getAuthCodeResp = HTTPUtils.post((String)(this.htProperties.getCossReqDomain() + "/getAuthCode"), (String)requestStr);
            log.info("getAuthCodeResp = " + getAuthCodeResp);
            if (getAuthCodeResp == null || "".equals(getAuthCodeResp)) {
                throw new BusinessException("\u4e09\u65b9\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff01");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u4e09\u65b9\u8bf7\u6c42\u8c03\u7528\u5f02\u5e38\uff01");
        }
        JSONObject jsonObject = JSON.parseObject((String)getAuthCodeResp);
        Integer status = jsonObject.getInteger("status");
        if (!SUCCESS_CODE.equals(status)) {
            String message = jsonObject.getString("message");
            throw new BusinessException("\u4e09\u65b9\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c\u5f02\u5e38\uff1a" + message);
        }
        JSONObject dataObject = jsonObject.getJSONObject("data");
        ActivationCodeVO activationCodeVO = new ActivationCodeVO();
        activationCodeVO.setAuthCode(dataObject.getString("authCode"));
        activationCodeVO.setCode(dataObject.getString("code"));
        return activationCodeVO;
    }

    public String addSignJobAndGetSignResult(String data) {
        HashMap<String, String> request = new HashMap<String, String>(16);
        request.put("version", this.htProperties.getCossVersion());
        request.put("appId", this.htProperties.getCossAppId());
        request.put("signAlgo", this.htProperties.getCossSignAlgo());
        request.put("algo", "SM3withSM2");
        String base64Encode = StringUtils.base64Encode((byte[])data.getBytes());
        request.put("data", base64Encode);
        request.put("dataType", "DATA");
        request.put("description", "\u7b7e\u540d\u4efb\u52a1\u63cf\u8ff0");
        log.info("request = " + ((Object)request).toString());
        String addSignJobReq = null;
        try {
            addSignJobReq = RequestUtils.generateRequestJson(request, (String)this.htProperties.getCossKey());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u4e09\u65b9\u8bf7\u6c42\u53c2\u6570\u8f6c\u6362\u5f02\u5e38\uff01");
        }
        String addSignJobResp = null;
        try {
            log.info(this.htProperties.getCossReqDomain() + "/addSignJob");
            addSignJobResp = HTTPUtils.post((String)(this.htProperties.getCossReqDomain() + "/addSignJob"), (String)addSignJobReq);
            log.info("addSignJobResp = " + addSignJobResp);
            if (addSignJobResp == null || "".equals(addSignJobResp)) {
                throw new BusinessException("\u4e09\u65b9\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff01");
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new BusinessException("\u4e09\u65b9\u8bf7\u6c42\u8c03\u7528\u5f02\u5e38\uff01");
        }
        log.info("addSignJobResp -->{} ", (Object)addSignJobResp);
        JSONObject jsonObject = JSON.parseObject((String)addSignJobResp);
        Integer status = jsonObject.getInteger("status");
        if (!SUCCESS_CODE.equals(status)) {
            String message = jsonObject.getString("message");
            throw new BusinessException("\u4e09\u65b9\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c\u5f02\u5e38\uff1a" + message);
        }
        JSONObject dataObject = jsonObject.getJSONObject("data");
        String signDataId = dataObject.getString("signDataId");
        return signDataId;
    }

    public String getBase64ImageByUserId(String userId) {
        HashMap<String, String> request = new HashMap<String, String>(16);
        request.put("version", this.htProperties.getCossVersion());
        request.put("appId", this.htProperties.getCossAppId());
        request.put("signAlgo", this.htProperties.getCossSignAlgo());
        request.put("userId", userId);
        String requestStr = null;
        try {
            requestStr = RequestUtils.generateRequestJson(request, (String)this.htProperties.getCossKey());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u4e09\u65b9\u8bf7\u6c42\u53c2\u6570\u8f6c\u6362\u5f02\u5e38\uff01");
        }
        String responseStr = null;
        try {
            responseStr = HTTPUtils.post((String)(this.htProperties.getCossReqDomain() + "/queryImage"), (String)requestStr);
            log.info("responseStr = " + responseStr);
            if (responseStr == null || "".equals(responseStr)) {
                throw new BusinessException("\u4e09\u65b9\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff01");
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new BusinessException("\u4e09\u65b9\u8bf7\u6c42\u8c03\u7528\u5f02\u5e38\uff01");
        }
        JSONObject jsonObject = JSON.parseObject((String)responseStr);
        Integer status = jsonObject.getInteger("status");
        if (!SUCCESS_CODE.equals(status)) {
            String message = jsonObject.getString("message");
            throw new BusinessException("\u4e09\u65b9\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c\u5f02\u5e38\uff1a" + message);
        }
        JSONObject dataObject = jsonObject.getJSONObject("data");
        String base64Image = dataObject.getString("image");
        return base64Image;
    }

    public void verifySign(VerifySignReqVO verifySignReqVO) {
        HashMap<String, String> request = new HashMap<String, String>();
        request.put("version", this.htProperties.getCossVersion());
        request.put("appId", this.htProperties.getCossAppId());
        request.put("signAlgo", this.htProperties.getCossSignAlgo());
        request.put("transId", UUID.randomUUID().toString());
        request.put("signAlg", "SM3withSM2");
        String base64Encode = StringUtils.base64Encode((byte[])verifySignReqVO.getPlain().getBytes());
        request.put("plain", base64Encode);
        request.put("signValue", verifySignReqVO.getSignValue());
        request.put("cert", verifySignReqVO.getCert());
        String requestStr = null;
        try {
            requestStr = RequestUtils.generateRequestJson(request, (String)this.htProperties.getCossKey());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u4e09\u65b9\u8bf7\u6c42\u53c2\u6570\u8f6c\u6362\u5f02\u5e38\uff01");
        }
        String verifySignResp = null;
        try {
            verifySignResp = HTTPUtils.post((String)(this.htProperties.getCossReqDomain() + "/verifySign"), (String)requestStr);
            if (verifySignResp == null || "".equals(verifySignResp)) {
                throw new BusinessException("\u4e09\u65b9\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff01");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u4e09\u65b9\u8bf7\u6c42\u8c03\u7528\u5f02\u5e38\uff01");
        }
        log.info("verifySignResp --> " + verifySignResp);
        JSONObject jsonObject = JSON.parseObject((String)verifySignResp);
        Integer status = jsonObject.getInteger("status");
        if (!SUCCESS_CODE.equals(status)) {
            String message = jsonObject.getString("message");
            throw new BusinessException("\u4e09\u65b9\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c\u5f02\u5e38\uff1a" + message);
        }
    }

    public EndAutoSignRespVO endAutoSign(String msspId) {
        HashMap<String, String> request = new HashMap<String, String>(16);
        request.put("version", this.htProperties.getCossVersion());
        request.put("appId", this.htProperties.getCossAppId());
        request.put("signAlgo", this.htProperties.getCossSignAlgo());
        request.put("userId", msspId);
        String endAutoSignSignReq = null;
        try {
            endAutoSignSignReq = RequestUtils.generateRequestJson(request, (String)this.htProperties.getCossKey());
        }
        catch (Exception e) {
            log.error("\u4e09\u65b9\u8bf7\u6c42\u53c2\u6570\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("\u4e09\u65b9\u8bf7\u6c42\u53c2\u6570\u8f6c\u6362\u5f02\u5e38\uff01" + e.getMessage());
        }
        String endAutoSignSignResp = null;
        try {
            log.info("\u8bf7\u6c42url\uff1a{}", (Object)(this.htProperties.getCossReqDomain() + "/endAutoSign"));
            log.info("\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(request));
            log.info("\u8f6c\u6362\u540e\u7684\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)endAutoSignSignReq);
            endAutoSignSignResp = HTTPUtils.post((String)(this.htProperties.getCossReqDomain() + "/endAutoSign"), (String)endAutoSignSignReq);
            log.info("\u8bf7\u6c42\u7ed3\u679c\uff1a{}", (Object)endAutoSignSignResp);
            if (endAutoSignSignResp == null || "".equals(endAutoSignSignResp)) {
                throw new BusinessException("\u4e09\u65b9\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff01");
            }
        }
        catch (Exception e) {
            log.error("\u4e09\u65b9\u8bf7\u6c42\u8c03\u7528\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("\u4e09\u65b9\u8bf7\u6c42\u8c03\u7528\u5f02\u5e38\uff01" + e.getMessage());
        }
        EndAutoSignRespVO endAutoSignRespVO = (EndAutoSignRespVO)JSON.parseObject((String)endAutoSignSignResp, EndAutoSignRespVO.class);
        return endAutoSignRespVO;
    }

    public AutoSignRespVO autoSign(AutoSignReqVO autoSignReqVO) {
        HashMap<String, String> request = new HashMap<String, String>(16);
        request.put("version", this.htProperties.getCossVersion());
        request.put("appId", this.htProperties.getCossAppId());
        request.put("signAlgo", this.htProperties.getCossSignAlgo());
        request.put("userId", autoSignReqVO.getUserId());
        request.put("dataType", "DATA");
        request.put("algo", "SM3withSM2");
        String data = autoSignReqVO.getToBeSignedData();
        String base64Encode = StringUtils.base64Encode((byte[])data.getBytes());
        request.put("data", base64Encode);
        request.put("signToken", autoSignReqVO.getSignToken());
        String autoSignReq = null;
        try {
            autoSignReq = RequestUtils.generateRequestJson(request, (String)this.htProperties.getCossKey());
        }
        catch (Exception e) {
            log.error("\u4e09\u65b9\u8bf7\u6c42\u53c2\u6570\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("\u4e09\u65b9\u8bf7\u6c42\u53c2\u6570\u8f6c\u6362\u5f02\u5e38\uff01" + e.getMessage());
        }
        String autoSignResp = null;
        try {
            log.info("\u8bf7\u6c42url\uff1a{}", (Object)(this.htProperties.getCossReqDomain() + "/autoSign"));
            log.info("\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(request));
            log.info("\u8f6c\u6362\u540e\u7684\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)autoSignReq);
            autoSignResp = HTTPUtils.post((String)(this.htProperties.getCossReqDomain() + "/autoSign"), (String)autoSignReq);
            log.info("\u8bf7\u6c42\u7ed3\u679c\uff1a{}", (Object)autoSignResp);
            if (autoSignResp == null || "".equals(autoSignResp)) {
                throw new BusinessException("\u4e09\u65b9\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff01");
            }
        }
        catch (Exception e) {
            log.error("\u4e09\u65b9\u8bf7\u6c42\u8c03\u7528\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("\u4e09\u65b9\u8bf7\u6c42\u8c03\u7528\u5f02\u5e38\uff01" + e.getMessage());
        }
        AutoSignRespVO autoSignRespVO = (AutoSignRespVO)JSON.parseObject((String)autoSignResp, AutoSignRespVO.class);
        return autoSignRespVO;
    }

    public StartAutoSignRespVO startAutoSign(String msspId, String timeRegion) {
        HashMap<String, String> request = new HashMap<String, String>(16);
        request.put("version", this.htProperties.getCossVersion());
        request.put("appId", this.htProperties.getCossAppId());
        request.put("signAlgo", this.htProperties.getCossSignAlgo());
        request.put("userId", msspId);
        request.put("timeRegion", timeRegion);
        String startAutoSignReq = null;
        try {
            startAutoSignReq = RequestUtils.generateRequestJson(request, (String)this.htProperties.getCossKey());
        }
        catch (Exception e) {
            log.error("\u4e09\u65b9\u8bf7\u6c42\u53c2\u6570\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("\u4e09\u65b9\u8bf7\u6c42\u53c2\u6570\u8f6c\u6362\u5f02\u5e38\uff01" + e.getMessage());
        }
        String startAutoSignResp = null;
        try {
            log.info("\u8bf7\u6c42url\uff1a{}", (Object)(this.htProperties.getCossReqDomain() + "/startAutoSign"));
            log.info("\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(request));
            log.info("\u8f6c\u6362\u540e\u7684\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)startAutoSignReq);
            startAutoSignResp = HTTPUtils.post((String)(this.htProperties.getCossReqDomain() + "/startAutoSign"), (String)startAutoSignReq);
            log.info("\u8bf7\u6c42\u7ed3\u679c\uff1a{}", (Object)startAutoSignResp);
            if (startAutoSignResp == null || "".equals(startAutoSignResp)) {
                throw new BusinessException("\u4e09\u65b9\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff01");
            }
        }
        catch (Exception e) {
            log.error("\u4e09\u65b9\u8bf7\u6c42\u8c03\u7528\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("\u4e09\u65b9\u8bf7\u6c42\u8c03\u7528\u5f02\u5e38\uff01" + e.getMessage());
        }
        StartAutoSignRespVO startAutoSignRespVO = (StartAutoSignRespVO)JSON.parseObject((String)startAutoSignResp, StartAutoSignRespVO.class);
        return startAutoSignRespVO;
    }
}

