/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.ca.server.utils;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectResult;
import com.ebaiyihui.ca.server.exception.BusinessException;
import com.ebaiyihui.ca.server.utils.BASE64DecodedMultipartFile;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.FileNameMap;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.HashMap;
import java.util.Random;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
public class OSSClientUtil {
    private static final Log log = LogFactory.getLog(OSSClientUtil.class);
    private static String endpoint = "https://oss-cn-beijing.aliyuncs.com";
    private static String accessKeyId = "LTAI4FwMYWcJsdYRTJEuSbya";
    private static String accessKeySecret = "GTKrBOaSbIEaaPBEJU94ETltZ08YuX";
    private static String bucketName = "tupian201805";
    private static ObjectMapper om = new ObjectMapper();

    public static String uploadImg2Oss(MultipartFile file, String path) throws BusinessException {
        if (file.getSize() > 0x100000L) {
            throw new BusinessException("\u4e0a\u4f20\u56fe\u7247\u5927\u5c0f\u4e0d\u80fd\u8d85\u8fc71M\uff01");
        }
        String originalFilename = file.getOriginalFilename();
        String substring = originalFilename.substring(originalFilename.lastIndexOf(46)).toLowerCase();
        Random random = new Random();
        String name = path + random.nextInt(10000) + System.currentTimeMillis() + substring;
        try {
            InputStream inputStream = file.getInputStream();
            OSSClientUtil.uploadFile2OSS((InputStream)inputStream, (String)name);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String uploadFile2OSS(InputStream instream, String fileName) {
        String ret = "";
        OSSClient ossClient = new OSSClient(endpoint, accessKeyId, accessKeySecret);
        try {
            ObjectMetadata objectMetadata = new ObjectMetadata();
            objectMetadata.setContentLength((long)instream.available());
            objectMetadata.setCacheControl("no-cache");
            objectMetadata.setHeader("Pragma", (Object)"no-cache");
            objectMetadata.setContentType(OSSClientUtil.getcontentType((String)fileName));
            objectMetadata.setContentDisposition("inline;filename=" + fileName);
            log.info((Object)instream.available());
            PutObjectResult putResult = ossClient.putObject(bucketName, fileName, instream, objectMetadata);
            ret = putResult.getETag();
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (instream != null) {
                    instream.close();
                }
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            ossClient.shutdown();
        }
        return ret;
    }

    public static String getcontentType(String filenameExtension) {
        FileNameMap fileNameMap = URLConnection.getFileNameMap();
        String type = fileNameMap.getContentTypeFor(filenameExtension);
        if (StringUtils.isBlank((String)type)) {
            return "text/plain";
        }
        return type;
    }

    public static String getUrl(String key) {
        OSSClient ossClient = new OSSClient(endpoint, accessKeyId, accessKeySecret);
        Date expiration = new Date(System.currentTimeMillis() + 315360000000L);
        URL url = ossClient.generatePresignedUrl(bucketName, key, expiration);
        if (url != null) {
            return url.getProtocol() + "://" + url.getHost() + url.getPath();
        }
        ossClient.shutdown();
        return null;
    }

    public static String uploadFile(MultipartFile file, String path) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        try {
            log.info((Object)("------------upload file-------name:" + file.getOriginalFilename() + " size:" + file.getSize()));
            String fileName = OSSClientUtil.uploadImg2Oss((MultipartFile)file, (String)path);
            String url = OSSClientUtil.getUrl((String)fileName);
            resultMap.put("code", 0);
            resultMap.put("msg", "sucess");
            HashMap<String, String> dataMap = new HashMap<String, String>(16);
            dataMap.put("src", url);
            dataMap.put("title", fileName);
            resultMap.put("data", dataMap);
            String content = om.writeValueAsString(resultMap);
            return content;
        }
        catch (Exception e) {
            log.error((Object)"\u4e0a\u4f20\u56fe\u7247\u5931\u8d25", (Throwable)e);
            resultMap.put("code", -1);
            resultMap.put("msg", "imageUploadFailed" + e.getMessage());
            String content = "";
            try {
                content = om.writeValueAsString(resultMap);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            return content;
        }
    }

    public static String getBucketName() {
        return bucketName;
    }

    public static void setBucketName(String bucketName) {
        OSSClientUtil.bucketName = bucketName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createFolder(String objectName) {
        OSSClient client = OSSClientUtil.getNewClient();
        ObjectMetadata objectMeta = new ObjectMetadata();
        byte[] buffer = new byte[]{};
        ByteArrayInputStream in = new ByteArrayInputStream(buffer);
        objectMeta.setContentLength(0L);
        try {
            client.putObject(bucketName, objectName, (InputStream)in, objectMeta);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void deleteFolder(String objectName) {
        OSSClient client = OSSClientUtil.getNewClient();
        boolean isObjectExist = client.doesObjectExist(bucketName, objectName);
        System.out.println("rs:" + isObjectExist);
        if (isObjectExist) {
            System.out.println("\u5b58\u5728,\u53ef\u4ee5\u5220\u9664");
            client.deleteObject(bucketName, objectName);
        } else {
            System.out.println("\u6587\u4ef6\u5939\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u5220\u9664\uff01");
        }
    }

    public static OSSClient getNewClient() {
        return new OSSClient(endpoint, accessKeyId, accessKeySecret);
    }

    public static void main(String[] args) {
        String base64 = "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";
        String fileName = OSSClientUtil.uploadImg2Oss((MultipartFile)BASE64DecodedMultipartFile.base64ToMultipart((String)("data:image/png;base64," + base64)), (String)"ca/stamp/");
        String url = OSSClientUtil.getUrl((String)fileName);
        System.out.println(url);
    }
}

