/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.ca.server.common.database;

import com.ebaiyihui.ca.server.common.database.JdbcTemplateDao;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class JdbcTemplateDaoImpl
implements JdbcTemplateDao {
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public NamedParameterJdbcTemplate getNamedParameterJdbcTemplate() {
        return this.namedParameterJdbcTemplate;
    }

    public <T> T get(String sql, Object[] params, Class<T> clazz) {
        List list = null;
        list = params == null || params.length == 0 ? this.query(sql, (RowMapper)new BeanPropertyRowMapper(clazz)) : this.query(sql, params, (RowMapper)new BeanPropertyRowMapper(clazz));
        return !CollectionUtils.isEmpty((Collection)list) ? (T)list.get(0) : null;
    }

    public <T> List<T> queryList(String sql, Object[] params, Class<T> clazz) {
        List list = null;
        list = params == null || params.length == 0 ? this.query(sql, (RowMapper)new BeanPropertyRowMapper(clazz)) : this.query(sql, params, (RowMapper)new BeanPropertyRowMapper(clazz));
        return list;
    }

    public <T> List<T> queryList(String sql, Class<T> clazz) {
        return this.queryList(sql, null, clazz);
    }

    public int count(String sql, Object[] params) {
        int rowCount = 0;
        try {
            Map resultMap = null;
            resultMap = params == null || params.length == 0 ? this.queryForMap(sql) : this.queryForMap(sql, params);
            if (resultMap == null) {
                return rowCount;
            }
            Iterator it = resultMap.entrySet().iterator();
            if (it.hasNext()) {
                Map.Entry entry = it.next();
                BigDecimal b = new BigDecimal(entry.getValue().toString());
                rowCount = b.intValue();
            }
        }
        catch (EmptyResultDataAccessException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            this.logger.error("Error SQL: " + sql);
            e.printStackTrace();
        }
        return rowCount;
    }

    public int count(String sql) {
        return this.count(sql, null);
    }

    public Map<String, Object> queryForMap(String sql) throws DataAccessException {
        try {
            return this.jdbcTemplate.queryForMap(sql);
        }
        catch (DataAccessException e) {
            this.logger.error("Error SQL: " + sql);
            throw e;
        }
    }

    public Map<String, Object> queryForMap(String sql, Object[] params) throws DataAccessException {
        try {
            return this.jdbcTemplate.queryForMap(sql, params);
        }
        catch (DataAccessException e) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            for (Object p : params) {
                sb.append(p + " | ");
            }
            sb.append("]");
            this.logger.error("Error SQL: " + sql + " Params: " + sb.toString());
            throw e;
        }
    }

    public <T> List<T> query(String sql, RowMapper<T> rowMapper) throws DataAccessException {
        try {
            return this.jdbcTemplate.query(sql, rowMapper);
        }
        catch (DataAccessException e) {
            this.logger.error("Error SQL: " + sql);
            throw e;
        }
    }

    public <T> List<T> query(String sql, Object[] params, RowMapper<T> rowMapper) throws DataAccessException {
        try {
            return this.jdbcTemplate.query(sql, params, rowMapper);
        }
        catch (DataAccessException e) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            for (Object p : params) {
                sb.append(p + " | ");
            }
            sb.append("]");
            this.logger.error("Error SQL: " + sql + " Params: " + sb.toString());
            throw e;
        }
    }

    public int update(String sql, Object[] params) throws DataAccessException {
        return this.jdbcTemplate.update(sql, params);
    }

    public JdbcTemplate getSpringJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public NamedParameterJdbcTemplate getSpringNamedParameterJdbcTemplate() {
        return this.namedParameterJdbcTemplate;
    }

    public int[] updateBatch(String ... sql) {
        return this.jdbcTemplate.batchUpdate(sql);
    }
}

