/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.ca.server.controller;

import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.ca.common.dto.SynDoctorSearchBodyRequestDTO;
import com.ebaiyihui.ca.common.dto.SynDoctorSearchHeadRequestDTO;
import com.ebaiyihui.ca.common.dto.SynDoctorSearchRequestDTO;
import com.ebaiyihui.ca.server.exception.BusinessException;
import com.ebaiyihui.ca.server.pojo.SyncDoctorReqVO;
import com.ebaiyihui.ca.server.pojo.entity.CaDoctorEntity;
import com.ebaiyihui.ca.server.service.CaDoctorService;
import com.ebaiyihui.ca.server.utils.RestTemplateUtils;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u533b\u751f\u76f8\u5173API"})
@RequestMapping(value={"/doctor"})
public class CaDoctorController {
    private static final Logger log = LoggerFactory.getLogger(CaDoctorController.class);
    @Autowired
    private CaDoctorService caDoctorService;

    @ApiOperation(value="\u67e5\u8be2\u533b\u5e08\u4fe1\u606f\u6216\u72b6\u6001\uff08\u533b\u7f51\u4fe1\uff09", notes="\u67e5\u8be2\u533b\u5e08\u4fe1\u606f\u6216\u72b6\u6001\uff08\u533b\u7f51\u4fe1\uff09")
    @RequestMapping(value={"/getByDoctorIdAndHospitalId"}, method={RequestMethod.GET})
    public BaseResponse<CaDoctorEntity> getByDoctorIdAndHospitalId(@RequestParam(value="doctorId") Long doctorId, @RequestParam(value="hospitalId") Long hospitalId) {
        CaDoctorEntity doctorEntity = this.caDoctorService.getByDoctorIdAndHospitalId(doctorId, hospitalId);
        return BaseResponse.success((Object)doctorEntity);
    }

    @ApiOperation(value="\u540c\u6b65\u533b\u5e08\u4fe1\u606f", notes="\u540c\u6b65\u533b\u5e08\u4fe1\u606f")
    @RequestMapping(value={"/syncDoctor"}, method={RequestMethod.POST})
    public BaseResponse syncDoctor(@RequestBody @Valid SyncDoctorReqVO syncDoctorReqVO) {
        this.caDoctorService.syncDoctor(syncDoctorReqVO);
        return BaseResponse.success();
    }

    @ApiOperation(value="\u540c\u6b65\u533b\u5e08\u7ed3\u679c\u67e5\u8be2\u63a5\u53e3", notes="\uff08\u7701\u80f8\u79d1\uff09\u6839\u636e\u7528\u6237\u624b\u673a\u53f7\uff0c\u8bc1\u4ef6\u53f7\uff0c\u540c\u6b65\u533b\u5e08\u7ed3\u679c\u67e5\u8be2\u63a5\u53e3")
    @RequestMapping(value={"synDoctorSearch"}, method={RequestMethod.POST})
    public BaseResponse<Object> synDoctorSearch(@RequestBody @Valid SynDoctorSearchRequestDTO dto) {
        return this.caDoctorService.synDoctorSearch(dto);
    }

    @ApiOperation(value="testCa", notes="testCa")
    @GetMapping(value={"/test_ca"})
    public String testCa(String url, Long doctorId, Long hospitalId, String clientId, String phone, String openId, String userIdcardNum, String employeeNumber) {
        SynDoctorSearchRequestDTO synDoctorSearchRequestDTO = new SynDoctorSearchRequestDTO();
        SynDoctorSearchHeadRequestDTO synDoctorSearchHeadRequestDTO = new SynDoctorSearchHeadRequestDTO();
        synDoctorSearchHeadRequestDTO.setClientId(clientId);
        synDoctorSearchRequestDTO.setHead(synDoctorSearchHeadRequestDTO);
        SynDoctorSearchBodyRequestDTO synDoctorSearchBodyRequestDTO = new SynDoctorSearchBodyRequestDTO();
        synDoctorSearchBodyRequestDTO.setPhone(phone);
        synDoctorSearchBodyRequestDTO.setOpenId(openId);
        synDoctorSearchBodyRequestDTO.setEmployeeNumber(employeeNumber);
        synDoctorSearchBodyRequestDTO.setUserIdcardNum(userIdcardNum);
        synDoctorSearchRequestDTO.setBody(synDoctorSearchBodyRequestDTO);
        synDoctorSearchRequestDTO.setDoctorId(doctorId);
        synDoctorSearchRequestDTO.setHospitalId(hospitalId);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("head", (Object)synDoctorSearchRequestDTO.getHead());
        jsonObject.put("body", (Object)synDoctorSearchRequestDTO.getBody());
        System.out.printf("jsonObject:{}", jsonObject);
        String synDoctorSearchResult = null;
        try {
            synDoctorSearchResult = RestTemplateUtils.post((String)url, (JSONObject)jsonObject, (MediaType)MediaType.APPLICATION_JSON_UTF8, (String)"");
        }
        catch (Exception e) {
            throw new BusinessException("\u67e5\u8be2\u533b\u751f\u540c\u6b65\u4fe1\u606f\u5f02\u5e38 \u7f51\u7edc\u9519\u8bef\u6216\u8bf7\u6c42\u8d85\u65f6" + e.getMessage());
        }
        return synDoctorSearchResult;
    }
}

