/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.ca.server.controller;

import com.ebaiyihui.ca.common.dto.CaDTO;
import com.ebaiyihui.ca.common.dto.DoctorNotifyRequestDTO;
import com.ebaiyihui.ca.common.dto.DoctorStatusRequestDTO;
import com.ebaiyihui.ca.common.dto.DoctorSyncRequestDTO;
import com.ebaiyihui.ca.common.dto.RecipeNotifyRequestDTO;
import com.ebaiyihui.ca.common.dto.RecipeStatusRequestDTO;
import com.ebaiyihui.ca.common.dto.RecipeSyncRequestDTO;
import com.ebaiyihui.ca.server.service.CaService;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
@Api(tags={"\u533b\u7f51\u7b7e\u76f8\u5173API"})
public class CaServerController {
    @Resource
    private CaService caService;

    @ApiOperation(value="\u83b7\u53d6clientId", notes="\u83b7\u53d6clientId")
    @RequestMapping(value={"getClientId"}, method={RequestMethod.GET})
    public BaseResponse<Object> getClientId() {
        return BaseResponse.success();
    }

    @ApiOperation(value="\u540c\u6b65\u533b\u5e08\u4fe1\u606f", notes="\u540c\u6b65\u533b\u5e08\u4fe1\u606f")
    @RequestMapping(value={"syncDoctor"}, method={RequestMethod.POST})
    public BaseResponse<Object> syncDoctor(@RequestBody @Valid DoctorSyncRequestDTO dto) {
        return BaseResponse.success();
    }

    @ApiOperation(value="\u67e5\u8be2\u533b\u5e08\u72b6\u6001", notes="\u67e5\u8be2\u533b\u5e08\u72b6\u6001")
    @RequestMapping(value={"getDocStatus"}, method={RequestMethod.POST})
    public BaseResponse<Object> getDocStatus(@RequestBody @Valid DoctorStatusRequestDTO dto) {
        return this.caService.getDocStatus(dto);
    }

    @ApiOperation(value="\u533b\u5e08\u72b6\u6001\u901a\u77e5", notes="\u533b\u7f51\u7b7e\u56de\u8c03\u63a5\u53e3\uff0c\u901a\u77e5\u533b\u751f\u5ba1\u6838\u72b6\u6001")
    @RequestMapping(value={"notifyDoctor"}, method={RequestMethod.POST})
    public CaDTO notifyDoctor(@RequestBody @Valid DoctorNotifyRequestDTO dto) {
        return this.caService.notifyDoctor(dto);
    }

    @ApiOperation(value="\u540c\u6b65\u5904\u65b9\u4fe1\u606f", notes="\u540c\u6b65\u5904\u65b9\u4fe1\u606f")
    @RequestMapping(value={"syncRecipe"}, method={RequestMethod.POST})
    public BaseResponse<Object> syncRecipe(@RequestBody @Valid RecipeSyncRequestDTO dto) {
        return this.caService.syncRecipe(dto);
    }

    @ApiOperation(value="\u67e5\u8be2\u5904\u65b9\u72b6\u6001", notes="\u67e5\u8be2\u5904\u65b9\u72b6\u6001")
    @RequestMapping(value={"getRecStatus"}, method={RequestMethod.POST})
    public BaseResponse<Object> getRecStatus(@RequestBody @Valid RecipeStatusRequestDTO dto) {
        return this.caService.getRecStatus(dto);
    }

    @ApiOperation(value="\u7b7e\u540d\u72b6\u6001\u901a\u77e5", notes="\u533b\u7f51\u7b7e\u56de\u8c03\u63a5\u53e3\uff0c\u901a\u77e5\u5904\u65b9\u5ba1\u6838\u72b6\u6001")
    @RequestMapping(value={"notifyRecipe"}, method={RequestMethod.POST})
    public CaDTO notifyRecipe(@RequestBody @Valid RecipeNotifyRequestDTO dto) {
        return this.caService.notifyRecipe(dto);
    }

    @ApiOperation(value="\u83b7\u53d6\u672a\u7b7e\u540d\u5904\u65b9", notes="\u6839\u636edoctorId\u67e5\u8be2\u672a\u7b7e\u540d\u5904\u65b9")
    @RequestMapping(value={"getUnsignRecipe"}, method={RequestMethod.POST})
    public BaseResponse<Object> getUnsignRecipe(@RequestBody @Valid DoctorStatusRequestDTO dto) {
        return this.caService.getUnsignRecipe(dto);
    }
}

